/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.auth;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.dockerjava.api.model.AuthConfig;
import com.intellij.docker.agent.auth.DockerAuthProvider;
import com.intellij.docker.agent.auth.DockerAuthProviderKt;
import com.intellij.docker.agent.auth.DockerHelperRunner;
import com.intellij.docker.agent.cli.DockerCliFacade;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001:\u0002\b\tJ\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lcom/intellij/docker/agent/auth/DockerAuthProvider;", "", "getAuthConfig", "Lcom/github/dockerjava/api/model/AuthConfig;", "host", "", "listAllSupportedHosts", "", "Creator", "Default", "intellij.clouds.docker.agent"})
public interface DockerAuthProvider {
    @Nullable
    public AuthConfig getAuthConfig(@NotNull String var1);

    @NotNull
    public List<String> listAllSupportedHosts();

    @FunctionalInterface
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00e7\u0080\u0001\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lcom/intellij/docker/agent/auth/DockerAuthProvider$Creator;", "", "create", "Lcom/intellij/docker/agent/auth/DockerAuthProvider;", "dockerConfigPath", "", "intellij.clouds.docker.agent"})
    public static interface Creator {
        @NotNull
        public DockerAuthProvider create(@Nullable String var1);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\b\u0005\u0018\u0000 \"2\u00020\u0001:\u0002\"#B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0013\u001a\u00020\u0005H\u0016J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\u0010\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u001dH\u0016J\u001c\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u001f2\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J\n\u0010 \u001a\u0004\u0018\u00010\u0019H\u0002J\u001a\u0010!\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005H\u0002R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/docker/agent/auth/DockerAuthProvider$Default;", "Lcom/intellij/docker/agent/auth/DockerAuthProvider;", "cliFacade", "Lcom/intellij/docker/agent/cli/DockerCliFacade;", "configFolderPath", "", "(Lcom/intellij/docker/agent/cli/DockerCliFacade;Ljava/lang/String;)V", "cachedErrorGetOutputs", "", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "objectMapper$delegate", "Lkotlin/Lazy;", "runner", "Lcom/intellij/docker/agent/auth/DockerHelperRunner;", "doLaunchHelperGet", "helperName", "host", "doLaunchHelperList", "getAuthConfig", "Lcom/github/dockerjava/api/model/AuthConfig;", "getAuthFromHelper", "config", "Lcom/fasterxml/jackson/databind/JsonNode;", "getAuthFromStore", "helperExecutable", "listAllSupportedHosts", "", "listSupportedHostsAndUsers", "", "parseDockerConfig", "parseHelperGetOutput", "Companion", "HelperCredentials", "intellij.clouds.docker.agent"})
    @SourceDebugExtension(value={"SMAP\nDockerAuthProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerAuthProvider.kt\ncom/intellij/docker/agent/auth/DockerAuthProvider$Default\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,198:1\n1360#2:199\n1446#2,5:200\n1#3:205\n*S KotlinDebug\n*F\n+ 1 DockerAuthProvider.kt\ncom/intellij/docker/agent/auth/DockerAuthProvider$Default\n*L\n44#1:199\n44#1:200,5\n*E\n"})
    public static final class Default
    implements DockerAuthProvider {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final String configFolderPath;
        @NotNull
        private final List<String> cachedErrorGetOutputs;
        @NotNull
        private final DockerHelperRunner runner;
        @NotNull
        private final Lazy objectMapper$delegate;
        @NotNull
        private static final String CRED_HELPERS_NODE = "credHelpers";
        @NotNull
        private static final String CRED_STORE_NODE_OLD = "credsStore";
        @NotNull
        private static final String CRED_STORE_NODE_NEW = "credStore";

        public Default(@NotNull DockerCliFacade cliFacade, @Nullable String configFolderPath) {
            Intrinsics.checkNotNullParameter((Object)cliFacade, (String)"cliFacade");
            this.configFolderPath = configFolderPath;
            this.cachedErrorGetOutputs = new ArrayList();
            this.runner = new DockerHelperRunner(cliFacade);
            this.objectMapper$delegate = LazyKt.lazy((Function0)objectMapper.2.INSTANCE);
        }

        private final ObjectMapper getObjectMapper() {
            Lazy lazy = this.objectMapper$delegate;
            return (ObjectMapper)lazy.getValue();
        }

        @Override
        @Nullable
        public AuthConfig getAuthConfig(@NotNull String host) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            if (StringsKt.isBlank((CharSequence)host)) {
                return null;
            }
            JsonNode jsonNode = this.parseDockerConfig();
            if (jsonNode == null) {
                return null;
            }
            JsonNode configNode = jsonNode;
            AuthConfig authConfig = this.getAuthFromHelper(configNode, host);
            if (authConfig == null) {
                authConfig = this.getAuthFromStore(configNode, host);
            }
            return authConfig;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<String> listAllSupportedHosts() {
            List list;
            Object object = this.parseDockerConfig();
            if (object != null && (object = Default.Companion.allHelpersAndStores(object)) != null) {
                void $this$flatMapTo$iv$iv;
                Iterable $this$flatMap$iv = (Iterable)object;
                boolean $i$f$flatMap = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    String it = (String)element$iv$iv;
                    boolean bl = false;
                    Iterable list$iv$iv = this.listSupportedHostsAndUsers(it).keySet();
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                list = (List)destination$iv$iv;
            } else {
                list = CollectionsKt.emptyList();
            }
            return list;
        }

        private final AuthConfig getAuthFromHelper(JsonNode config2, String host) {
            String string = Default.Companion.credHelperForHost(config2, host);
            if (string == null) {
                return null;
            }
            String helperForHost = string;
            return this.parseHelperGetOutput(helperForHost, host);
        }

        private final AuthConfig getAuthFromStore(JsonNode config2, String host) {
            String string = Default.Companion.credStore(config2);
            if (string == null) {
                return null;
            }
            String defaultHelperName = string;
            return this.parseHelperGetOutput(defaultHelperName, host);
        }

        private final Map<String, String> listSupportedHostsAndUsers(String helperName) {
            String output = null;
            try {
                output = this.doLaunchHelperList(helperName);
            }
            catch (Exception e) {
                DockerAuthProviderKt.access$getLogger().warn("Can't launch `list` for helper " + helperName, (Throwable)e);
                return MapsKt.emptyMap();
            }
            if (DockerAuthProviderKt.access$getLogger().isTraceEnabled()) {
                DockerAuthProviderKt.access$getLogger().trace("`" + helperName + " list` returned `" + output + "`");
            }
            try {
                Object object = this.getObjectMapper().readValue(output, Map.class);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.String>");
                return (Map)object;
            }
            catch (Exception e) {
                DockerAuthProviderKt.access$getLogger().warn("Can't parse helper `list` response from " + helperName + ": `" + output + "`", (Throwable)e);
                return MapsKt.emptyMap();
            }
        }

        private final AuthConfig parseHelperGetOutput(String helperName, String host) {
            String output = null;
            try {
                output = this.doLaunchHelperGet(helperName, host);
            }
            catch (Exception e) {
                DockerAuthProviderKt.access$getLogger().warn("Can't launch `get` for helper `" + helperName + "` for host: " + host, (Throwable)e);
                return null;
            }
            if (this.cachedErrorGetOutputs.contains(output)) {
                return null;
            }
            if (DockerAuthProviderKt.access$getLogger().isTraceEnabled()) {
                DockerAuthProviderKt.access$getLogger().trace("`" + helperName + " get " + host + "` returned `" + output + "`");
            }
            try {
                HelperCredentials helperCredentials = (HelperCredentials)this.getObjectMapper().readValue(output, HelperCredentials.class);
                return helperCredentials != null ? helperCredentials.toAuthConfig() : null;
            }
            catch (Exception e) {
                DockerAuthProviderKt.access$getLogger().warn("Can't parse helper `get` response from " + helperName + " for host: " + host + ": `" + output + "`", (Throwable)e);
                this.cachedErrorGetOutputs.add(output);
                return null;
            }
        }

        private final String doLaunchHelperGet(String helperName, String host) throws IOException {
            return this.runner.executeCredentialsHelper$intellij_clouds_docker_agent(this.helperExecutable(helperName), CollectionsKt.listOf((Object)"get"), host);
        }

        private final String doLaunchHelperList(String helperName) throws IOException {
            return DockerHelperRunner.executeCredentialsHelper$intellij_clouds_docker_agent$default(this.runner, this.helperExecutable(helperName), CollectionsKt.listOf((Object)"list"), null, 4, null);
        }

        private final String helperExecutable(String helperName) {
            return "docker-credential-" + helperName;
        }

        /*
         * Unable to fully structure code
         */
        private final JsonNode parseDockerConfig() {
            var2_1 = this.configFolderPath;
            if (var2_1 == null) ** GOTO lbl-1000
            it = var2_1;
            $i$a$-let-DockerAuthProvider$Default$parseDockerConfig$configFile$1 = false;
            it = var4_3 = new File(it);
            $i$a$-takeIf-DockerAuthProvider$Default$parseDockerConfig$configFile$2 = false;
            v0 = var3_8 = (it.exists() != false && it.isDirectory() != false) != false ? var4_3 : null;
            if (var3_8 != null) {
                it = var3_8;
                $i$a$-let-DockerAuthProvider$Default$parseDockerConfig$configFile$3 = false;
                it = var5_5 = new File(it, "config.json");
                $i$a$-takeIf-DockerAuthProvider$Default$parseDockerConfig$configFile$4 = false;
                v1 = it.exists() != false && it.isFile() != false ? var5_5 : null;
            } else lbl-1000:
            // 2 sources

            {
                v1 = configFile = null;
            }
            if (configFile == null) {
                DockerAuthProviderKt.access$getLogger().warn("Can't access config file in folder: " + this.configFolderPath);
                return null;
            }
            try {
                return this.getObjectMapper().readTree(configFile);
            }
            catch (IOException e) {
                DockerAuthProviderKt.access$getLogger().warn("Can't read config file at " + configFile, (Throwable)e);
                return null;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b*\u00020\tH\u0002J\u0016\u0010\n\u001a\u0004\u0018\u00010\u0004*\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J\u000e\u0010\f\u001a\u0004\u0018\u00010\u0004*\u00020\tH\u0002J\u000e\u0010\r\u001a\u0004\u0018\u00010\u0004*\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/docker/agent/auth/DockerAuthProvider$Default$Companion;", "", "()V", "CRED_HELPERS_NODE", "", "CRED_STORE_NODE_NEW", "CRED_STORE_NODE_OLD", "allHelpersAndStores", "", "Lcom/fasterxml/jackson/databind/JsonNode;", "credHelperForHost", "host", "credStore", "safeAsText", "intellij.clouds.docker.agent"})
        @SourceDebugExtension(value={"SMAP\nDockerAuthProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerAuthProvider.kt\ncom/intellij/docker/agent/auth/DockerAuthProvider$Default$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,198:1\n1#2:199\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            private final String credHelperForHost(JsonNode $this$credHelperForHost, String host) {
                JsonNode jsonNode = $this$credHelperForHost.get(Default.CRED_HELPERS_NODE);
                return jsonNode != null && (jsonNode = jsonNode.get(host)) != null ? this.safeAsText(jsonNode) : null;
            }

            private final String credStore(JsonNode $this$credStore) {
                JsonNode jsonNode = $this$credStore.get(Default.CRED_STORE_NODE_OLD);
                if (jsonNode == null) {
                    jsonNode = $this$credStore.get(Default.CRED_STORE_NODE_NEW);
                }
                return jsonNode != null ? this.safeAsText(jsonNode) : null;
            }

            private final Set<String> allHelpersAndStores(JsonNode $this$allHelpersAndStores) {
                List result2 = new ArrayList();
                result2.add(this.credStore($this$allHelpersAndStores));
                JsonNode jsonNode = $this$allHelpersAndStores.get(Default.CRED_HELPERS_NODE);
                if (jsonNode != null) {
                    JsonNode groupNode = jsonNode;
                    boolean bl = false;
                    int i2 = 0;
                    int n = groupNode.size();
                    if (i2 <= n) {
                        while (true) {
                            JsonNode jsonNode2;
                            Object object;
                            if ((object = (jsonNode2 = groupNode.get(i2))) != null) {
                                Intrinsics.checkNotNull((Object)object);
                                object = Companion.safeAsText(jsonNode2);
                                if (object != null) {
                                    Object it = object;
                                    boolean bl2 = false;
                                    result2.add(it);
                                }
                            }
                            if (i2 == n) break;
                            ++i2;
                        }
                    }
                }
                return CollectionsKt.toSet((Iterable)CollectionsKt.filterNotNull((Iterable)result2));
            }

            private final String safeAsText(JsonNode $this$safeAsText) {
                JsonNode jsonNode;
                JsonNode it = jsonNode = $this$safeAsText;
                boolean bl = false;
                Object object = !it.isMissingNode() && it.isTextual() ? jsonNode : null;
                return object != null ? object.asText() : null;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000f\u001a\u00020\u0010R \u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR \u0010\t\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR \u0010\f\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u0006\"\u0004\b\u000e\u0010\b\u00a8\u0006\u0011"}, d2={"Lcom/intellij/docker/agent/auth/DockerAuthProvider$Default$HelperCredentials;", "", "()V", "host", "", "getHost", "()Ljava/lang/String;", "setHost", "(Ljava/lang/String;)V", "secret", "getSecret", "setSecret", "username", "getUsername", "setUsername", "toAuthConfig", "Lcom/github/dockerjava/api/model/AuthConfig;", "intellij.clouds.docker.agent"})
        public static final class HelperCredentials {
            @JsonProperty(value="ServerURL")
            @Nullable
            private String host;
            @JsonProperty(value="Username")
            @Nullable
            private String username;
            @JsonProperty(value="Secret")
            @Nullable
            private String secret;

            @Nullable
            public final String getHost() {
                return this.host;
            }

            public final void setHost(@Nullable String string) {
                this.host = string;
            }

            @Nullable
            public final String getUsername() {
                return this.username;
            }

            public final void setUsername(@Nullable String string) {
                this.username = string;
            }

            @Nullable
            public final String getSecret() {
                return this.secret;
            }

            public final void setSecret(@Nullable String string) {
                this.secret = string;
            }

            @NotNull
            public final AuthConfig toAuthConfig() {
                AuthConfig result2 = new AuthConfig().withRegistryAddress(this.host).withUsername(this.username);
                if (Intrinsics.areEqual((Object)this.username, (Object)"<token>")) {
                    result2.withIdentityToken(this.secret);
                } else {
                    result2.withPassword(this.secret);
                }
                Intrinsics.checkNotNull((Object)result2);
                return result2;
            }
        }
    }
}

