/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rhizomedb.impl;

import com.jetbrains.rhizomedb.EntityType;
import com.jetbrains.rhizomedb.impl.EntitiesImplKt;
import com.jetbrains.rhizomedb.impl.EntityTypeProvider;
import fleet.util.logging.KLogger;
import fleet.util.logging.KLoggers;
import java.io.InputStream;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001f\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR%\u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u000f8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/rhizomedb/impl/MetaInfBasedEntityTypeProvider;", "Lcom/jetbrains/rhizomedb/impl/EntityTypeProvider;", "classLoader", "Ljava/lang/ClassLoader;", "resourceLoader", "Lkotlin/Function1;", "", "Ljava/io/InputStream;", "<init>", "(Ljava/lang/ClassLoader;Lkotlin/jvm/functions/Function1;)V", "getClassLoader", "()Ljava/lang/ClassLoader;", "getResourceLoader", "()Lkotlin/jvm/functions/Function1;", "entityTypes", "", "Lcom/jetbrains/rhizomedb/EntityType;", "getEntityTypes", "()Ljava/util/List;", "entityTypes$delegate", "Lkotlin/Lazy;", "logger", "Lfleet/util/logging/KLogger;", "fleet.rhizomedb"})
@SourceDebugExtension(value={"SMAP\nEntitiesImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EntitiesImpl.kt\ncom/jetbrains/rhizomedb/impl/MetaInfBasedEntityTypeProvider\n+ 2 KLoggers.kt\nfleet/util/logging/KLoggersKt\n+ 3 KLogger.kt\nfleet/util/logging/KLogger\n*L\n1#1,438:1\n25#2:439\n42#3,2:440\n*S KotlinDebug\n*F\n+ 1 EntitiesImpl.kt\ncom/jetbrains/rhizomedb/impl/MetaInfBasedEntityTypeProvider\n*L\n435#1:439\n429#1:440,2\n*E\n"})
final class MetaInfBasedEntityTypeProvider
implements EntityTypeProvider {
    @NotNull
    private final ClassLoader classLoader;
    @NotNull
    private final Function1<String, InputStream> resourceLoader;
    @NotNull
    private final Lazy entityTypes$delegate;
    @NotNull
    private final KLogger logger;

    public MetaInfBasedEntityTypeProvider(@NotNull ClassLoader classLoader, @NotNull Function1<? super String, ? extends InputStream> resourceLoader) {
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        Intrinsics.checkNotNullParameter(resourceLoader, (String)"resourceLoader");
        this.classLoader = classLoader;
        this.resourceLoader = resourceLoader;
        this.entityTypes$delegate = LazyKt.lazy(() -> MetaInfBasedEntityTypeProvider.entityTypes_delegate$lambda$2(this));
        boolean $i$f$logger = false;
        this.logger = KLoggers.INSTANCE.logger(Reflection.getOrCreateKotlinClass(MetaInfBasedEntityTypeProvider.class));
    }

    @NotNull
    public final ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @NotNull
    public final Function1<String, InputStream> getResourceLoader() {
        return this.resourceLoader;
    }

    @Override
    @NotNull
    public List<EntityType<?>> getEntityTypes() {
        Lazy lazy = this.entityTypes$delegate;
        return (List)lazy.getValue();
    }

    private static final Iterable entityTypes_delegate$lambda$2$lambda$1(MetaInfBasedEntityTypeProvider this$0, String providerClassName) {
        List<EntityType<?>> list;
        Intrinsics.checkNotNullParameter((Object)providerClassName, (String)"providerClassName");
        try {
            Class<?> providerClass = this$0.classLoader.loadClass(providerClassName);
            Object object = providerClass.getField("INSTANCE").get(null);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.jetbrains.rhizomedb.impl.EntityTypeProvider");
            EntityTypeProvider provider = (EntityTypeProvider)object;
            list = provider.getEntityTypes();
        }
        catch (Exception e) {
            KLogger this_$iv = this$0.logger;
            boolean $i$f$error = false;
            if (this_$iv.isErrorEnabled()) {
                Throwable throwable = e;
                KLogger kLogger = this_$iv;
                boolean bl = false;
                String string = "Couldn't load entity types from " + providerClassName;
                kLogger.error(throwable, (Object)string);
            }
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private static final List entityTypes_delegate$lambda$2(MetaInfBasedEntityTypeProvider this$0) {
        List list;
        Sequence sequence;
        Sequence sequence2;
        InputStream inputStream = (InputStream)this$0.resourceLoader.invoke((Object)"META-INF/com.jetbrains.rhizomedb.impl.EntityTypeProvider.txt");
        return inputStream != null && (sequence2 = EntitiesImplKt.access$metaInfLineSequence(inputStream)) != null && (sequence = SequencesKt.flatMapIterable((Sequence)sequence2, arg_0 -> MetaInfBasedEntityTypeProvider.entityTypes_delegate$lambda$2$lambda$1(this$0, arg_0))) != null && (list = SequencesKt.toList((Sequence)sequence)) != null ? list : CollectionsKt.emptyList();
    }
}

