/*
 * Decompiled with CFR 0.152.
 */
package fleet.ssh.frontend.mina;

import fleet.ssh.frontend.HostConnectionScope;
import fleet.ssh.frontend.mina.FleetHostConfigEntry;
import fleet.ssh.frontend.mina.FleetKeyFilePasswordProvider;
import fleet.ssh.frontend.mina.FleetKnownHostsVerifier;
import fleet.ssh.frontend.mina.FleetSshAgentFactory;
import fleet.ssh.frontend.mina.FleetSshClientKt;
import fleet.ssh.frontend.mina.FleetSshUserInteraction;
import fleet.ssh.frontend.mina.KeysToAgentReporter;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.CoroutineScope;
import org.apache.sshd.agent.SshAgentFactory;
import org.apache.sshd.agent.SshAgentKeyConstraint;
import org.apache.sshd.client.ClientBuilder;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.auth.keyboard.UserInteraction;
import org.apache.sshd.client.auth.pubkey.PublicKeyAuthenticationReporter;
import org.apache.sshd.client.config.hosts.HostConfigEntry;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.future.DefaultConnectFuture;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.helpers.AbstractFactoryManager;
import org.apache.sshd.common.keyprovider.KeyIdentityProvider;
import org.apache.sshd.core.CoreModuleProperties;
import org.apache.sshd.server.forward.ForwardingFilter;
import org.apache.sshd.server.forward.TcpForwardingFilter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J@\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J*\u0010\u0013\u001a\u0010\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00120\u00120\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\t2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0014J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u00a8\u0006\u001c"}, d2={"Lfleet/ssh/frontend/mina/FleetSshClient;", "Lorg/apache/sshd/client/SshClient;", "hostConnectionScope", "Lfleet/ssh/frontend/HostConnectionScope;", "<init>", "(Lfleet/ssh/frontend/HostConnectionScope;)V", "doConnect", "Lorg/apache/sshd/client/future/ConnectFuture;", "username", "", "targetAddress", "Ljava/net/SocketAddress;", "context", "Lorg/apache/sshd/common/AttributeRepository;", "localAddress", "identities", "Lorg/apache/sshd/common/keyprovider/KeyIdentityProvider;", "hostConfig", "Lorg/apache/sshd/client/config/hosts/HostConfigEntry;", "parseProxyJumps", "", "kotlin.jvm.PlatformType", "proxyJump", "clientConfiguration", "", "hostConfigEntry", "Lfleet/ssh/frontend/mina/FleetHostConfigEntry;", "Companion", "fleet.plugins.ssh.frontend"})
@SourceDebugExtension(value={"SMAP\nFleetSshClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FleetSshClient.kt\nfleet/ssh/frontend/mina/FleetSshClient\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Helpers.kt\nfleet/util/HelpersKt\n*L\n1#1,542:1\n1#2:543\n1557#3:544\n1628#3,3:545\n774#3:548\n865#3,2:549\n1557#3:551\n1628#3,2:552\n1630#3:555\n13#4:554\n*S KotlinDebug\n*F\n+ 1 FleetSshClient.kt\nfleet/ssh/frontend/mina/FleetSshClient\n*L\n131#1:544\n131#1:545,3\n136#1:548\n136#1:549,2\n136#1:551\n136#1:552,2\n136#1:555\n142#1:554\n*E\n"})
public final class FleetSshClient
extends SshClient {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private FleetSshClient(HostConnectionScope hostConnectionScope) {
        PropertyResolverUtils.updateProperty((PropertyResolver)((PropertyResolver)this), (String)"fleet-connection-scope", (Object)hostConnectionScope);
        PropertyResolverUtils.updateProperty((PropertyResolver)((PropertyResolver)this), (String)CoreModuleProperties.AUTH_TIMEOUT.getName(), (long)Duration.getInWholeMilliseconds-impl((long)DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.MINUTES)));
        PropertyResolverUtils.updateProperty((PropertyResolver)((PropertyResolver)this), (String)CoreModuleProperties.STOP_WAIT_TIME.getName(), (long)Duration.getInWholeMilliseconds-impl((long)DurationKt.toDuration((int)3, (DurationUnit)DurationUnit.SECONDS)));
        PropertyResolverUtils.updateProperty((PropertyResolver)((PropertyResolver)this), (String)"user-interaction-auto-detect-password-prompt", (boolean)false);
    }

    @NotNull
    protected ConnectFuture doConnect(@Nullable String username, @NotNull SocketAddress targetAddress, @Nullable AttributeRepository context, @Nullable SocketAddress localAddress, @Nullable KeyIdentityProvider identities, @NotNull HostConfigEntry hostConfig) {
        Intrinsics.checkNotNullParameter((Object)targetAddress, (String)"targetAddress");
        Intrinsics.checkNotNullParameter((Object)hostConfig, (String)"hostConfig");
        if (!(hostConfig instanceof FleetHostConfigEntry)) {
            boolean $i$a$-require-FleetSshClient$doConnect$22 = false;
            String $i$a$-require-FleetSshClient$doConnect$22 = "Unexpected HostConfigEntry - " + hostConfig;
            throw new IllegalArgumentException($i$a$-require-FleetSshClient$doConnect$22.toString());
        }
        this.clientConfiguration((FleetHostConfigEntry)hostConfig);
        ConnectFuture innerFuture = super.doConnect(username, targetAddress, context, localAddress, identities, hostConfig);
        DefaultConnectFuture wrapFuture = new DefaultConnectFuture((Object)(innerFuture.getId() + "-wrapped"), null);
        innerFuture.addListener(arg_0 -> FleetSshClient.doConnect$lambda$3(wrapFuture, this, hostConfig, arg_0));
        return (ConnectFuture)wrapFuture;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected List<HostConfigEntry> parseProxyJumps(@Nullable String proxyJump, @Nullable AttributeRepository context) {
        List list;
        if (proxyJump == null) {
            list = new ArrayList();
        } else {
            Iterable $this$filterTo$iv$iv;
            String it;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            char[] cArray = new char[]{','};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)proxyJump, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((Object)StringsKt.trim((CharSequence)(FleetSshClientKt.access$getOPENSSH_IPV4_FORMAT_REGEX$p().containsMatchIn((CharSequence)it) ? StringsKt.replace$default((String)StringsKt.replace$default((String)it, (String)"[", (String)"", (boolean)false, (int)4, null), (String)"]", (String)"", (boolean)false, (int)4, null) : it))).toString());
            }
            Iterable $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl = false;
                boolean bl2 = !StringsKt.isBlank((CharSequence)it);
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                HostConfigEntry hostConfigEntry;
                void jump;
                it = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                if (!StringsKt.contains$default((CharSequence)((CharSequence)jump), (CharSequence)"//", (boolean)false, (int)2, null)) {
                    Integer port;
                    Pair pair;
                    CharSequence charSequence;
                    CharSequence charSequence2 = StringsKt.substringBeforeLast((String)jump, (char)'@', (String)"");
                    if (StringsKt.isBlank((CharSequence)charSequence2)) {
                        boolean bl3 = false;
                        charSequence = null;
                    } else {
                        charSequence = charSequence2;
                    }
                    String userInfo = (String)charSequence;
                    hostAndPort = StringsKt.substringAfterLast$default((String)jump, (char)'@', null, (int)2, null);
                    if (((String)hostAndPort).charAt(0) == '[') {
                        String string;
                        Integer port2 = StringsKt.toIntOrNull((String)StringsKt.substringAfter((String)hostAndPort, (String)"]:", (String)""));
                        var16_19 = hostAndPort;
                        boolean condition$iv = StringsKt.last((CharSequence)hostAndPort) != ']';
                        boolean $i$f$letIf = false;
                        if (condition$iv) {
                            void it2 = $this$letIf$iv;
                            boolean bl4 = false;
                            string = StringsKt.substringBeforeLast$default((String)hostAndPort, (String)":", null, (int)2, null);
                        } else {
                            string = $this$letIf$iv;
                        }
                        void host2 = string;
                        pair = TuplesKt.to((Object)host2, (Object)port2);
                    } else {
                        pair = TuplesKt.to((Object)StringsKt.substringBefore$default((String)hostAndPort, (char)':', null, (int)2, null), (Object)StringsKt.toIntOrNull((String)StringsKt.substringAfter((String)hostAndPort, (char)':', (String)"")));
                    }
                    Pair bl3 = pair;
                    String host3 = (String)bl3.component1();
                    Integer n = port = (Integer)bl3.component2();
                    hostConfigEntry = this.resolveHost(userInfo, host3, n != null ? n : 0, context, null);
                } else {
                    URI uri = URI.create((String)jump);
                    hostAndPort = uri.getScheme();
                    if (!(hostAndPort == null || StringsKt.isBlank((CharSequence)hostAndPort)) && !Intrinsics.areEqual((Object)"ssh", (Object)uri.getScheme())) {
                        throw new IllegalStateException(("Unsupported scheme for proxy jump: " + (String)jump).toString());
                    }
                    String string = uri.getHost();
                    if (string == null) {
                        string = StringsKt.substringBeforeLast$default((String)StringsKt.substringAfterLast$default((String)jump, (char)'@', null, (int)2, null), (char)':', null, (int)2, null);
                    }
                    String host4 = string;
                    int port = uri.getPort();
                    String string2 = uri.getUserInfo();
                    if (string2 == null) {
                        CharSequence charSequence;
                        var16_19 = StringsKt.substringBeforeLast((String)jump, (char)'@', (String)"");
                        if (StringsKt.isBlank((CharSequence)var16_19)) {
                            boolean bl5 = false;
                            charSequence = null;
                        } else {
                            charSequence = var16_19;
                        }
                        string2 = (String)charSequence;
                    }
                    String userInfo = string2;
                    hostConfigEntry = this.resolveHost(userInfo, host4, port, context, null);
                }
                collection.add(hostConfigEntry);
            }
            list = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        }
        return list;
    }

    private final void clientConfiguration(FleetHostConfigEntry hostConfigEntry) {
        PropertyResolverUtils.updateProperty((PropertyResolver)((PropertyResolver)this), (String)CoreModuleProperties.IO_CONNECT_TIMEOUT.getName(), (long)Duration.getInWholeMilliseconds-impl((long)hostConfigEntry.getDurationProperty-JjQYPqc("ConnectTimeout", DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.SECONDS), FleetSshClientKt.getHostConnectionScope((PropertyResolver)this))));
        PropertyResolverUtils.updateProperty((PropertyResolver)((PropertyResolver)this), (String)"fleet-host-config-entry", (Object)((Object)hostConfigEntry));
        long heartbeatInterval = hostConfigEntry.getDurationProperty-JjQYPqc("ServerAliveInterval", DurationKt.toDuration((int)30, (DurationUnit)DurationUnit.SECONDS), FleetSshClientKt.getHostConnectionScope((PropertyResolver)this));
        PropertyResolverUtils.updateProperty((PropertyResolver)((PropertyResolver)this), (String)CoreModuleProperties.HEARTBEAT_INTERVAL.getName(), (long)Duration.getInWholeMilliseconds-impl((long)heartbeatInterval));
        Object object = hostConfigEntry.getProperty("ServerAliveCountMax");
        long heartbeatReplyWait = Duration.times-UwyO8pc((long)heartbeatInterval, (int)(object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? RangesKt.coerceAtLeast((int)((Integer)object), (int)1) : 3));
        PropertyResolverUtils.updateProperty((PropertyResolver)((PropertyResolver)this), (String)CoreModuleProperties.HEARTBEAT_REPLY_WAIT.getName(), (long)Duration.getInWholeMilliseconds-impl((long)heartbeatReplyWait));
        Object object2 = hostConfigEntry.getProperty("NumberOfPasswordPrompts");
        int maxPasswordPrompts = object2 != null && (object2 = StringsKt.toIntOrNull((String)object2)) != null ? RangesKt.coerceAtLeast((int)((Integer)object2), (int)1) : 3;
        PropertyResolverUtils.updateProperty((PropertyResolver)((PropertyResolver)this), (String)CoreModuleProperties.PASSWORD_PROMPTS.getName(), (int)(maxPasswordPrompts + 1));
        PropertyResolverUtils.updateProperty((PropertyResolver)((PropertyResolver)this), (String)"fleet-connection-string", (Object)FleetSshClientKt.access$getConnectionString(hostConfigEntry));
        String string = hostConfigEntry.getProperty("StrictHostKeyChecking", "true");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        if (!PropertyResolverUtils.FALSE_VALUES.contains(string2)) {
            this.setServerKeyVerifier((ServerKeyVerifier)new FleetKnownHostsVerifier(FleetSshClientKt.getHostConnectionScope((PropertyResolver)this), hostConfigEntry, false, 4, null));
        }
        FleetSshClientKt.getHostConnectionScope((PropertyResolver)this).blockingAsync((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, hostConfigEntry, null){
            Object L$0;
            Object L$1;
            Object L$2;
            int label;
            final /* synthetic */ FleetSshClient this$0;
            final /* synthetic */ FleetHostConfigEntry $hostConfigEntry;
            {
                this.this$0 = $receiver;
                this.$hostConfigEntry = $hostConfigEntry;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = FleetSshClientKt.access$configureAuthentications(this.this$0, this.$hostConfigEntry, (Continuation)this);
                        if (v0 == var9_2) {
                            return var9_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        v1 = (var2_3 = this.this$0.getServerKeyVerifier()) instanceof FleetKnownHostsVerifier != false ? (FleetKnownHostsVerifier)var2_3 : null;
                        this.label = 2;
                        v2 = FleetSshClientKt.access$configureSecurityFactories(this.this$0, v1, this.$hostConfigEntry, (Continuation)this);
                        if (v2 == var9_2) {
                            return var9_2;
                        }
                        ** GOTO lbl22
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl22:
                        // 2 sources

                        var2_3 = this.this$0;
                        hostConfigEntry$iv = this.$hostConfigEntry;
                        $i$f$configureAgent = false;
                        var5_7 = $this$configureAgent$iv;
                        this.L$0 = $this$configureAgent$iv;
                        this.L$1 = hostConfigEntry$iv;
                        this.L$2 = var5_7;
                        this.label = 3;
                        v3 = FleetSshAgentFactory.Companion.create(hostConfigEntry$iv.getIdentityAgent(), hostConfigEntry$iv.isIdentitiesOnly(), (Continuation<? super FleetSshAgentFactory>)((Continuation)this));
                        if (v3 == var9_2) {
                            return var9_2;
                        }
                        ** GOTO lbl41
                    }
                    case 3: {
                        $i$f$configureAgent = false;
                        var5_7 = (SshClient)this.L$2;
                        hostConfigEntry$iv = (FleetHostConfigEntry)this.L$1;
                        $this$configureAgent$iv = (SshClient)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl41:
                        // 2 sources

                        var5_7.setAgentFactory((SshAgentFactory)v3);
                        var6_8 = FleetHostConfigEntry.getAddKeysToAgent$default(hostConfigEntry$iv, null, FleetSshClientKt.getHostConnectionScope((PropertyResolver)$this$configureAgent$iv), 1, null);
                        addKeysToAgent$iv = (Boolean)var6_8.component1();
                        constraints$iv = (SshAgentKeyConstraint[])var6_8.component2();
                        if (addKeysToAgent$iv) {
                            $this$configureAgent$iv.setPublicKeyAuthenticationReporter((PublicKeyAuthenticationReporter)new KeysToAgentReporter(constraints$iv));
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    private static final void doConnect$lambda$3(DefaultConnectFuture $wrapFuture, FleetSshClient this$0, HostConfigEntry $hostConfig, ConnectFuture c) {
        if (c.isCanceled()) {
            $wrapFuture.cancel();
        } else {
            Object object;
            if (c instanceof DefaultConnectFuture) {
                object = ((DefaultConnectFuture)c).getValue();
            } else {
                Object $this$doConnect_u24lambda_u243_u24lambda_u241;
                FleetSshClient fleetSshClient = this$0;
                try {
                    $this$doConnect_u24lambda_u243_u24lambda_u241 = fleetSshClient;
                    boolean bl = false;
                    $this$doConnect_u24lambda_u243_u24lambda_u241 = Result.constructor-impl((Object)((ClientSession)c.getSession()));
                }
                catch (Throwable bl) {
                    $this$doConnect_u24lambda_u243_u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                }
                fleetSshClient = $this$doConnect_u24lambda_u243_u24lambda_u241;
                Throwable throwable = Result.exceptionOrNull-impl((Object)((Object)fleetSshClient));
                if (throwable == null) {
                    object = fleetSshClient;
                } else {
                    Throwable it = throwable;
                    boolean bl = false;
                    object = it;
                }
            }
            Object result2 = object;
            if (result2 instanceof ClientSession) {
                PropertyResolverUtils.updateProperty((PropertyResolver)((PropertyResolver)result2), (String)"fleet-host-config-entry", (Object)$hostConfig);
                FleetSshClientKt.access$copyClientConfig((ClientSession)result2, this$0);
            }
            $wrapFuture.setValue(result2);
        }
    }

    public /* synthetic */ FleetSshClient(HostConnectionScope hostConnectionScope, DefaultConstructorMarker $constructor_marker) {
        this(hostConnectionScope);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lfleet/ssh/frontend/mina/FleetSshClient$Companion;", "", "<init>", "()V", "create", "Lorg/apache/sshd/client/SshClient;", "hostConnectionScope", "Lfleet/ssh/frontend/HostConnectionScope;", "fleet.plugins.ssh.frontend"})
    @SourceDebugExtension(value={"SMAP\nFleetSshClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FleetSshClient.kt\nfleet/ssh/frontend/mina/FleetSshClient$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,542:1\n1#2:543\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SshClient create(@NotNull HostConnectionScope hostConnectionScope) {
            Intrinsics.checkNotNullParameter((Object)hostConnectionScope, (String)"hostConnectionScope");
            AbstractFactoryManager abstractFactoryManager = ((ClientBuilder)((ClientBuilder)ClientBuilder.builder().factory(() -> Companion.create$lambda$0(hostConnectionScope))).filePasswordProvider((FilePasswordProvider)new FleetKeyFilePasswordProvider(hostConnectionScope)).forwardingFilter(ForwardingFilter.asForwardingFilter(null, null, (TcpForwardingFilter)TcpForwardingFilter.DEFAULT))).build();
            SshClient it = (SshClient)abstractFactoryManager;
            boolean bl = false;
            it.setUserInteraction((UserInteraction)new FleetSshUserInteraction(hostConnectionScope));
            AbstractFactoryManager abstractFactoryManager2 = abstractFactoryManager;
            Intrinsics.checkNotNullExpressionValue((Object)abstractFactoryManager2, (String)"also(...)");
            return (SshClient)abstractFactoryManager2;
        }

        private static final SshClient create$lambda$0(HostConnectionScope $hostConnectionScope) {
            return new FleetSshClient($hostConnectionScope, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

