/*
 * Decompiled with CFR 0.152.
 */
package noria.ui.components.editor;

import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.text.FontRasterizationSettings;
import androidx.compose.ui.unit.Density;
import fleet.compose.theme.text.FontCache;
import fleet.compose.theme.text.FontCacheKt;
import fleet.compose.theme.text.NoriaParagraphStyle;
import fleet.compose.theme.text.ParagraphKt;
import fleet.compose.theme.text.TextSpec;
import fleet.compose.theme.text.TextSpecKt;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import noria.ui.components.editor.LogicalCharacter;
import noria.ui.components.editor.PositionWithinViewport;
import noria.ui.components.editor.SpansKt;
import noria.ui.components.editor.TextSpanContent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.Font;
import org.jetbrains.skia.paragraph.FontCollection;
import org.jetbrains.skia.paragraph.Paragraph;
import org.jetbrains.skia.paragraph.ParagraphBuilder;
import org.jetbrains.skia.paragraph.TextStyle;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\b\u0018\u0000 12\u00020\u0001:\u00011B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\n\u0010\u0007\u001a\u00060\bj\u0002`\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\r\u0010\u001e\u001a\u00060\bj\u0002`\tH\u00c6\u0003J\u0016\u0010\u001f\u001a\u00020\u000bH\u00c6\u0003\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b \u0010\u000eJ\u001c\u0010!\u001a\u00020\"2\n\u0010#\u001a\u00060\bj\u0002`\t2\u0006\u0010$\u001a\u00020\u0013H\u0016JE\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\b\u0002\u0010\u0007\u001a\u00060\bj\u0002`\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b&\u0010'J\u0013\u0010(\u001a\u00020\u00132\b\u0010)\u001a\u0004\u0018\u00010*H\u00d6\u0003J\t\u0010+\u001a\u00020,H\u00d6\u0001J\u0014\u0010-\u001a\u00060\bj\u0002`\t2\u0006\u0010.\u001a\u00020/H\u0016J\t\u00100\u001a\u00020\u0003H\u00d6\u0001R\u0019\u0010\n\u001a\u00020\u000b\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0015\u0010\u0007\u001a\u00060\bj\u0002`\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0017\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u00062"}, d2={"Lnoria/ui/components/editor/GridAlignedTextSpanContent;", "Lnoria/ui/components/editor/TextSpanContent;", "text", "", "logicalChars", "", "Lnoria/ui/components/editor/LogicalCharacter;", "symbolWidth", "", "Lnoria/ui/components/editor/FractionalPx;", "color", "Landroidx/compose/ui/graphics/Color;", "(Ljava/lang/String;Ljava/util/List;FJLkotlin/jvm/internal/DefaultConstructorMarker;)V", "getColor-0d7_KjU", "()J", "J", "getLogicalChars", "()Ljava/util/List;", "rtl", "", "getRtl", "()Z", "getSymbolWidth", "()F", "getText", "()Ljava/lang/String;", "width", "getWidth", "component1", "component2", "component3", "component4", "component4-0d7_KjU", "coordToOffset", "Lnoria/ui/components/editor/PositionWithinViewport;", "coord", "snapToLeft", "copy", "copy-g2O1Hgs", "(Ljava/lang/String;Ljava/util/List;FJ)Lnoria/ui/components/editor/GridAlignedTextSpanContent;", "equals", "other", "", "hashCode", "", "offsetToCoord", "offset", "", "toString", "Companion", "fleet.noria.ui"})
public final class GridAlignedTextSpanContent
extends TextSpanContent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String text;
    @NotNull
    private final List<LogicalCharacter> logicalChars;
    private final float symbolWidth;
    private final long color;
    private final float width;
    @NotNull
    private static final HashMap<Companion.LogicalCharacterCacheKey, WeakReference<LogicalCharacter>> logicalCharacterCache = new HashMap();

    private GridAlignedTextSpanContent(String text2, List<LogicalCharacter> logicalChars, float symbolWidth, long color2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter(logicalChars, (String)"logicalChars");
        super(null);
        this.text = text2;
        this.logicalChars = logicalChars;
        this.symbolWidth = symbolWidth;
        this.color = color2;
        this.width = (float)((int)SpansKt.doubleWidthAwareLength(this.text)) * this.symbolWidth;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @NotNull
    public final List<LogicalCharacter> getLogicalChars() {
        return this.logicalChars;
    }

    public final float getSymbolWidth() {
        return this.symbolWidth;
    }

    public final long getColor-0d7_KjU() {
        return this.color;
    }

    @Override
    @NotNull
    public PositionWithinViewport coordToOffset(float coord, boolean snapToLeft) {
        if (coord < 0.0f) {
            return new PositionWithinViewport(0L, false);
        }
        long offset = 0L;
        float glyphStartsAtPixel = 0.0f;
        for (LogicalCharacter logicalChar : this.logicalChars) {
            float border2;
            float f = border2 = snapToLeft ? glyphStartsAtPixel + logicalChar.getWidth() : glyphStartsAtPixel + logicalChar.getWidth() * 0.5f;
            if (coord < border2) {
                return new PositionWithinViewport(offset, true);
            }
            glyphStartsAtPixel += logicalChar.getWidth();
            ++offset;
        }
        return new PositionWithinViewport(this.text.length(), coord <= this.getWidth());
    }

    @Override
    public float offsetToCoord(long offset) {
        float f;
        if (offset >= (long)this.text.length()) {
            f = this.getWidth();
        } else {
            float result2;
            String string = this.text.substring(0, (int)offset);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            long l = SpansKt.doubleWidthAwareLength(string);
            f = result2 = (float)((int)l) * this.symbolWidth;
        }
        return f;
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    @Override
    public boolean getRtl() {
        return false;
    }

    @NotNull
    public final String component1() {
        return this.text;
    }

    @NotNull
    public final List<LogicalCharacter> component2() {
        return this.logicalChars;
    }

    public final float component3() {
        return this.symbolWidth;
    }

    public final long component4-0d7_KjU() {
        return this.color;
    }

    @NotNull
    public final GridAlignedTextSpanContent copy-g2O1Hgs(@NotNull String text2, @NotNull List<LogicalCharacter> logicalChars, float symbolWidth, long color2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter(logicalChars, (String)"logicalChars");
        return new GridAlignedTextSpanContent(text2, logicalChars, symbolWidth, color2, null);
    }

    public static /* synthetic */ GridAlignedTextSpanContent copy-g2O1Hgs$default(GridAlignedTextSpanContent gridAlignedTextSpanContent, String string, List list, float f, long l, int n, Object object) {
        if ((n & 1) != 0) {
            string = gridAlignedTextSpanContent.text;
        }
        if ((n & 2) != 0) {
            list = gridAlignedTextSpanContent.logicalChars;
        }
        if ((n & 4) != 0) {
            f = gridAlignedTextSpanContent.symbolWidth;
        }
        if ((n & 8) != 0) {
            l = gridAlignedTextSpanContent.color;
        }
        return gridAlignedTextSpanContent.copy-g2O1Hgs(string, list, f, l);
    }

    @NotNull
    public String toString() {
        return "GridAlignedTextSpanContent(text=" + this.text + ", logicalChars=" + this.logicalChars + ", symbolWidth=" + this.symbolWidth + ", color=" + Color.toString-impl(this.color) + ")";
    }

    public int hashCode() {
        int result2 = this.text.hashCode();
        result2 = result2 * 31 + ((Object)this.logicalChars).hashCode();
        result2 = result2 * 31 + Float.hashCode(this.symbolWidth);
        result2 = result2 * 31 + Color.hashCode-impl(this.color);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GridAlignedTextSpanContent)) {
            return false;
        }
        GridAlignedTextSpanContent gridAlignedTextSpanContent = (GridAlignedTextSpanContent)other;
        if (!Intrinsics.areEqual((Object)this.text, (Object)gridAlignedTextSpanContent.text)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.logicalChars, gridAlignedTextSpanContent.logicalChars)) {
            return false;
        }
        if (Float.compare(this.symbolWidth, gridAlignedTextSpanContent.symbolWidth) != 0) {
            return false;
        }
        return Color.equals-impl0(this.color, gridAlignedTextSpanContent.color);
    }

    public /* synthetic */ GridAlignedTextSpanContent(String text2, List logicalChars, float symbolWidth, long color2, DefaultConstructorMarker $constructor_marker) {
        this(text2, logicalChars, symbolWidth, color2);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\"B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J@\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0017\u0010\u0018JJ\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001fH\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b \u0010!R6\u0010\u0003\u001a*\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004j\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006#"}, d2={"Lnoria/ui/components/editor/GridAlignedTextSpanContent$Companion;", "", "()V", "logicalCharacterCache", "Ljava/util/HashMap;", "Lnoria/ui/components/editor/GridAlignedTextSpanContent$Companion$LogicalCharacterCacheKey;", "Ljava/lang/ref/WeakReference;", "Lnoria/ui/components/editor/LogicalCharacter;", "Lkotlin/collections/HashMap;", "create", "Lnoria/ui/components/editor/GridAlignedTextSpanContent;", "text", "", "textSpec", "Lfleet/compose/theme/text/TextSpec;", "foreground", "Landroidx/compose/ui/graphics/Color;", "pixelDensity", "Landroidx/compose/ui/unit/Density;", "fontCache", "Lfleet/compose/theme/text/FontCache;", "fontRasterSettings", "Landroidx/compose/ui/text/FontRasterizationSettings;", "create-FNF3uiM", "(Ljava/lang/String;Lfleet/compose/theme/text/TextSpec;JLandroidx/compose/ui/unit/Density;Lfleet/compose/theme/text/FontCache;Landroidx/compose/ui/text/FontRasterizationSettings;)Lnoria/ui/components/editor/GridAlignedTextSpanContent;", "createLogicalChar", "codePoint", "", "fontCollection", "Lorg/jetbrains/skia/paragraph/FontCollection;", "singleSymbolWidth", "", "createLogicalChar-ww6aTOc", "(ILfleet/compose/theme/text/TextSpec;Landroidx/compose/ui/unit/Density;JLorg/jetbrains/skia/paragraph/FontCollection;Landroidx/compose/ui/text/FontRasterizationSettings;F)Lnoria/ui/components/editor/LogicalCharacter;", "LogicalCharacterCacheKey", "fleet.noria.ui"})
    public static final class Companion {
        private Companion() {
        }

        private final LogicalCharacter createLogicalChar-ww6aTOc(int codePoint, TextSpec textSpec, Density pixelDensity, long foreground, FontCollection fontCollection, FontRasterizationSettings fontRasterSettings, float singleSymbolWidth) {
            LogicalCharacter res = null;
            while (res == null) {
                WeakReference weakReference = logicalCharacterCache.compute(new LogicalCharacterCacheKey(codePoint, textSpec, pixelDensity.getDensity(), pixelDensity.getFontScale(), foreground, System.identityHashCode(fontCollection), System.identityHashCode(fontRasterSettings), singleSymbolWidth, null), (arg_0, arg_1) -> Companion.createLogicalChar_ww6aTOc$lambda$0((Function2)new Function2<LogicalCharacterCacheKey, WeakReference<LogicalCharacter>, WeakReference<LogicalCharacter>>(codePoint, singleSymbolWidth, textSpec, pixelDensity, foreground, fontCollection, fontRasterSettings){
                    final /* synthetic */ int $codePoint;
                    final /* synthetic */ float $singleSymbolWidth;
                    final /* synthetic */ TextSpec $textSpec;
                    final /* synthetic */ Density $pixelDensity;
                    final /* synthetic */ long $foreground;
                    final /* synthetic */ FontCollection $fontCollection;
                    final /* synthetic */ FontRasterizationSettings $fontRasterSettings;
                    {
                        this.$codePoint = $codePoint;
                        this.$singleSymbolWidth = $singleSymbolWidth;
                        this.$textSpec = $textSpec;
                        this.$pixelDensity = $pixelDensity;
                        this.$foreground = $foreground;
                        this.$fontCollection = $fontCollection;
                        this.$fontRasterSettings = $fontRasterSettings;
                        super(2);
                    }

                    @Nullable
                    public final WeakReference<LogicalCharacter> invoke(@NotNull LogicalCharacterCacheKey k, @Nullable WeakReference<LogicalCharacter> v) {
                        WeakReference<LogicalCharacter> weakReference;
                        Intrinsics.checkNotNullParameter((Object)k, (String)"k");
                        WeakReference<LogicalCharacter> weakReference2 = v;
                        if ((weakReference2 != null ? (LogicalCharacter)weakReference2.get() : null) == null) {
                            float width2 = (float)((int)SpansKt.access$codePointWidth(this.$codePoint)) * this.$singleSymbolWidth;
                            TextStyle textStyle = TextSpecKt.toSkTextStyle-cLQcjuY$default(this.$textSpec, this.$pixelDensity, Color.box-impl(this.$foreground), null, null, this.$fontCollection, 12, null);
                            String s = Character.toString(this.$codePoint);
                            Paragraph textLine2 = ParagraphKt.buildParagraph$default(NoriaParagraphStyle.Companion.getOneLine(), null, this.$fontCollection, this.$fontRasterSettings, (Function1)new Function1<ParagraphBuilder, Unit>(s, textStyle){
                                final /* synthetic */ String $s;
                                final /* synthetic */ TextStyle $textStyle;
                                {
                                    this.$s = $s;
                                    this.$textStyle = $textStyle;
                                    super(1);
                                }

                                public final void invoke(@NotNull ParagraphBuilder $this$buildParagraph) {
                                    Intrinsics.checkNotNullParameter((Object)$this$buildParagraph, (String)"$this$buildParagraph");
                                    String string = this.$s;
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"$s");
                                    ParagraphKt.styledText($this$buildParagraph, string, this.$textStyle);
                                }
                            }, 2, null);
                            textLine2.layout(Float.MAX_VALUE);
                            Intrinsics.checkNotNull((Object)s);
                            weakReference = new WeakReference<LogicalCharacter>(new LogicalCharacter(textLine2, StringsKt.isBlank((CharSequence)s), width2));
                        } else {
                            weakReference = v;
                        }
                        return weakReference;
                    }
                }, arg_0, arg_1));
                Intrinsics.checkNotNull((Object)weakReference);
                res = (LogicalCharacter)weakReference.get();
            }
            return res;
        }

        @NotNull
        public final GridAlignedTextSpanContent create-FNF3uiM(@NotNull String text2, @NotNull TextSpec textSpec, long foreground, @NotNull Density pixelDensity, @NotNull FontCache fontCache, @NotNull FontRasterizationSettings fontRasterSettings) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            Intrinsics.checkNotNullParameter((Object)textSpec, (String)"textSpec");
            Intrinsics.checkNotNullParameter((Object)pixelDensity, (String)"pixelDensity");
            Intrinsics.checkNotNullParameter((Object)fontCache, (String)"fontCache");
            Intrinsics.checkNotNullParameter((Object)fontRasterSettings, (String)"fontRasterSettings");
            Font font = fontCache.findFont(textSpec.getFontSpec(), pixelDensity, fontRasterSettings);
            List logicalChars = new ArrayList();
            float symbolWidth = FontCacheKt.getCachedMetrics(font).getSymbolWidth();
            text2.codePoints().forEachOrdered(arg_0 -> Companion.create_FNF3uiM$lambda$1(fontCache, logicalChars, textSpec, pixelDensity, foreground, fontRasterSettings, symbolWidth, arg_0));
            return new GridAlignedTextSpanContent(text2, logicalChars, symbolWidth, foreground, null);
        }

        private static final WeakReference createLogicalChar_ww6aTOc$lambda$0(Function2 $tmp0, Object p0, Object p1) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (WeakReference)$tmp0.invoke(p0, p1);
        }

        private static final void create_FNF3uiM$lambda$1(FontCache $fontCache, List $logicalChars, TextSpec $textSpec, Density $pixelDensity, long $foreground, FontRasterizationSettings $fontRasterSettings, float $symbolWidth, int codePoint) {
            Intrinsics.checkNotNullParameter((Object)$fontCache, (String)"$fontCache");
            Intrinsics.checkNotNullParameter((Object)$logicalChars, (String)"$logicalChars");
            Intrinsics.checkNotNullParameter((Object)$textSpec, (String)"$textSpec");
            Intrinsics.checkNotNullParameter((Object)$pixelDensity, (String)"$pixelDensity");
            Intrinsics.checkNotNullParameter((Object)$fontRasterSettings, (String)"$fontRasterSettings");
            FontCollection fontCollection = $fontCache.getFontCollection();
            $logicalChars.add(Companion.createLogicalChar-ww6aTOc(codePoint, $textSpec, $pixelDensity, $foreground, fontCollection, $fontRasterSettings, $symbolWidth));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001e\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\u0006\u0010\f\u001a\u00020\u0003\u0012\u0006\u0010\r\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0007H\u00c6\u0003J\u0016\u0010 \u001a\u00020\nH\u00c6\u0003\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b!\u0010\u0017J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\t\u0010#\u001a\u00020\u0003H\u00c6\u0003J\t\u0010$\u001a\u00020\u0007H\u00c6\u0003Jc\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\u00032\b\b\u0002\u0010\f\u001a\u00020\u00032\b\b\u0002\u0010\r\u001a\u00020\u0007H\u00c6\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b&\u0010'J\u0013\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010+\u001a\u00020\u0003H\u00d6\u0001J\t\u0010,\u001a\u00020-H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0019\u0010\t\u001a\u00020\n\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u0018\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\r\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006."}, d2={"Lnoria/ui/components/editor/GridAlignedTextSpanContent$Companion$LogicalCharacterCacheKey;", "", "codePoint", "", "textSpec", "Lfleet/compose/theme/text/TextSpec;", "density", "", "fontScale", "foreground", "Landroidx/compose/ui/graphics/Color;", "fontCollectionId", "fontRasterSettingsId", "singleSymbolWidth", "(ILfleet/compose/theme/text/TextSpec;FFJIIFLkotlin/jvm/internal/DefaultConstructorMarker;)V", "getCodePoint", "()I", "getDensity", "()F", "getFontCollectionId", "getFontRasterSettingsId", "getFontScale", "getForeground-0d7_KjU", "()J", "J", "getSingleSymbolWidth", "getTextSpec", "()Lfleet/compose/theme/text/TextSpec;", "component1", "component2", "component3", "component4", "component5", "component5-0d7_KjU", "component6", "component7", "component8", "copy", "copy-yrwZFoE", "(ILfleet/compose/theme/text/TextSpec;FFJIIF)Lnoria/ui/components/editor/GridAlignedTextSpanContent$Companion$LogicalCharacterCacheKey;", "equals", "", "other", "hashCode", "toString", "", "fleet.noria.ui"})
        private static final class LogicalCharacterCacheKey {
            private final int codePoint;
            @NotNull
            private final TextSpec textSpec;
            private final float density;
            private final float fontScale;
            private final long foreground;
            private final int fontCollectionId;
            private final int fontRasterSettingsId;
            private final float singleSymbolWidth;

            private LogicalCharacterCacheKey(int codePoint, TextSpec textSpec, float density, float fontScale, long foreground, int fontCollectionId, int fontRasterSettingsId, float singleSymbolWidth) {
                Intrinsics.checkNotNullParameter((Object)textSpec, (String)"textSpec");
                this.codePoint = codePoint;
                this.textSpec = textSpec;
                this.density = density;
                this.fontScale = fontScale;
                this.foreground = foreground;
                this.fontCollectionId = fontCollectionId;
                this.fontRasterSettingsId = fontRasterSettingsId;
                this.singleSymbolWidth = singleSymbolWidth;
            }

            public final int getCodePoint() {
                return this.codePoint;
            }

            @NotNull
            public final TextSpec getTextSpec() {
                return this.textSpec;
            }

            public final float getDensity() {
                return this.density;
            }

            public final float getFontScale() {
                return this.fontScale;
            }

            public final long getForeground-0d7_KjU() {
                return this.foreground;
            }

            public final int getFontCollectionId() {
                return this.fontCollectionId;
            }

            public final int getFontRasterSettingsId() {
                return this.fontRasterSettingsId;
            }

            public final float getSingleSymbolWidth() {
                return this.singleSymbolWidth;
            }

            public final int component1() {
                return this.codePoint;
            }

            @NotNull
            public final TextSpec component2() {
                return this.textSpec;
            }

            public final float component3() {
                return this.density;
            }

            public final float component4() {
                return this.fontScale;
            }

            public final long component5-0d7_KjU() {
                return this.foreground;
            }

            public final int component6() {
                return this.fontCollectionId;
            }

            public final int component7() {
                return this.fontRasterSettingsId;
            }

            public final float component8() {
                return this.singleSymbolWidth;
            }

            @NotNull
            public final LogicalCharacterCacheKey copy-yrwZFoE(int codePoint, @NotNull TextSpec textSpec, float density, float fontScale, long foreground, int fontCollectionId, int fontRasterSettingsId, float singleSymbolWidth) {
                Intrinsics.checkNotNullParameter((Object)textSpec, (String)"textSpec");
                return new LogicalCharacterCacheKey(codePoint, textSpec, density, fontScale, foreground, fontCollectionId, fontRasterSettingsId, singleSymbolWidth, null);
            }

            public static /* synthetic */ LogicalCharacterCacheKey copy-yrwZFoE$default(LogicalCharacterCacheKey logicalCharacterCacheKey, int n, TextSpec textSpec, float f, float f2, long l, int n2, int n3, float f3, int n4, Object object) {
                if ((n4 & 1) != 0) {
                    n = logicalCharacterCacheKey.codePoint;
                }
                if ((n4 & 2) != 0) {
                    textSpec = logicalCharacterCacheKey.textSpec;
                }
                if ((n4 & 4) != 0) {
                    f = logicalCharacterCacheKey.density;
                }
                if ((n4 & 8) != 0) {
                    f2 = logicalCharacterCacheKey.fontScale;
                }
                if ((n4 & 0x10) != 0) {
                    l = logicalCharacterCacheKey.foreground;
                }
                if ((n4 & 0x20) != 0) {
                    n2 = logicalCharacterCacheKey.fontCollectionId;
                }
                if ((n4 & 0x40) != 0) {
                    n3 = logicalCharacterCacheKey.fontRasterSettingsId;
                }
                if ((n4 & 0x80) != 0) {
                    f3 = logicalCharacterCacheKey.singleSymbolWidth;
                }
                return logicalCharacterCacheKey.copy-yrwZFoE(n, textSpec, f, f2, l, n2, n3, f3);
            }

            @NotNull
            public String toString() {
                return "LogicalCharacterCacheKey(codePoint=" + this.codePoint + ", textSpec=" + this.textSpec + ", density=" + this.density + ", fontScale=" + this.fontScale + ", foreground=" + Color.toString-impl(this.foreground) + ", fontCollectionId=" + this.fontCollectionId + ", fontRasterSettingsId=" + this.fontRasterSettingsId + ", singleSymbolWidth=" + this.singleSymbolWidth + ")";
            }

            public int hashCode() {
                int result2 = Integer.hashCode(this.codePoint);
                result2 = result2 * 31 + this.textSpec.hashCode();
                result2 = result2 * 31 + Float.hashCode(this.density);
                result2 = result2 * 31 + Float.hashCode(this.fontScale);
                result2 = result2 * 31 + Color.hashCode-impl(this.foreground);
                result2 = result2 * 31 + Integer.hashCode(this.fontCollectionId);
                result2 = result2 * 31 + Integer.hashCode(this.fontRasterSettingsId);
                result2 = result2 * 31 + Float.hashCode(this.singleSymbolWidth);
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof LogicalCharacterCacheKey)) {
                    return false;
                }
                LogicalCharacterCacheKey logicalCharacterCacheKey = (LogicalCharacterCacheKey)other;
                if (this.codePoint != logicalCharacterCacheKey.codePoint) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.textSpec, (Object)logicalCharacterCacheKey.textSpec)) {
                    return false;
                }
                if (Float.compare(this.density, logicalCharacterCacheKey.density) != 0) {
                    return false;
                }
                if (Float.compare(this.fontScale, logicalCharacterCacheKey.fontScale) != 0) {
                    return false;
                }
                if (!Color.equals-impl0(this.foreground, logicalCharacterCacheKey.foreground)) {
                    return false;
                }
                if (this.fontCollectionId != logicalCharacterCacheKey.fontCollectionId) {
                    return false;
                }
                if (this.fontRasterSettingsId != logicalCharacterCacheKey.fontRasterSettingsId) {
                    return false;
                }
                return Float.compare(this.singleSymbolWidth, logicalCharacterCacheKey.singleSymbolWidth) == 0;
            }

            public /* synthetic */ LogicalCharacterCacheKey(int codePoint, TextSpec textSpec, float density, float fontScale, long foreground, int fontCollectionId, int fontRasterSettingsId, float singleSymbolWidth, DefaultConstructorMarker $constructor_marker) {
                this(codePoint, textSpec, density, fontScale, foreground, fontCollectionId, fontRasterSettingsId, singleSymbolWidth);
            }
        }
    }
}

