/*
 * Decompiled with CFR 0.152.
 */
package noria.ui.components.editor;

import androidx.compose.ui.graphics.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import noria.ui.components.editor.Background;
import noria.ui.components.editor.RoundedBackgroundKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0000\u0018\u00002.\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00020\u0001j\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0002`\u0005B\u0013\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007\u00a2\u0006\u0002\u0010\bJ4\u0010\u001b\u001a\u00020\u00032\u0014\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00022\u0014\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0002H\u0016J(\u0010\u001e\u001a\u00020\u001f2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00030!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00100#R\u001a\u0010\t\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR6\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00020\u0010\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0003\u0012\b\u0012\u00060\u0011j\u0002`\u00120\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R2\u0010\u0019\u001a&\u0012\u0004\u0012\u00020\u0003\u0012\u001c\u0012\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u001a0\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lnoria/ui/components/editor/BackgroundIds;", "Ljava/util/Comparator;", "Lkotlin/Pair;", "", "Landroidx/compose/ui/graphics/Color;", "Lkotlin/Comparator;", "selectionColors", "", "(Ljava/util/Set;)V", "idCounter", "getIdCounter", "()I", "setIdCounter", "(I)V", "ongoingBackgrounds", "", "Lnoria/ui/components/editor/Background;", "", "Landel/text/CharOffset;", "getOngoingBackgrounds", "()Ljava/util/Map;", "setOngoingBackgrounds", "(Ljava/util/Map;)V", "getSelectionColors", "()Ljava/util/Set;", "zIndexMap", "", "compare", "idToColor1", "idToColor2", "recordZIndex", "", "backgroundToId", "", "backgroundStack", "", "fleet.noria.ui"})
@SourceDebugExtension(value={"SMAP\nRoundedBackground.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RoundedBackground.kt\nnoria/ui/components/editor/BackgroundIds\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,471:1\n1603#2,9:472\n1855#2:481\n1856#2:483\n1612#2:484\n1603#2,9:485\n1855#2:494\n1856#2:496\n1612#2:497\n1#3:482\n1#3:495\n*S KotlinDebug\n*F\n+ 1 RoundedBackground.kt\nnoria/ui/components/editor/BackgroundIds\n*L\n133#1:472,9\n133#1:481\n133#1:483\n133#1:484\n134#1:485,9\n134#1:494\n134#1:496\n134#1:497\n133#1:482\n134#1:495\n*E\n"})
public final class BackgroundIds
implements Comparator<Pair<? extends Integer, ? extends Color>> {
    @NotNull
    private final Set<Color> selectionColors;
    private int idCounter;
    @NotNull
    private Map<Background, Pair<Integer, Long>> ongoingBackgrounds;
    @NotNull
    private final Map<Integer, Pair<Set<Integer>, Set<Integer>>> zIndexMap;

    public BackgroundIds(@NotNull Set<Color> selectionColors) {
        Intrinsics.checkNotNullParameter(selectionColors, (String)"selectionColors");
        this.selectionColors = selectionColors;
        this.ongoingBackgrounds = new LinkedHashMap();
        this.zIndexMap = new LinkedHashMap();
    }

    @NotNull
    public final Set<Color> getSelectionColors() {
        return this.selectionColors;
    }

    public final int getIdCounter() {
        return this.idCounter;
    }

    public final void setIdCounter(int n) {
        this.idCounter = n;
    }

    @NotNull
    public final Map<Background, Pair<Integer, Long>> getOngoingBackgrounds() {
        return this.ongoingBackgrounds;
    }

    public final void setOngoingBackgrounds(@NotNull Map<Background, Pair<Integer, Long>> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.ongoingBackgrounds = map;
    }

    /*
     * WARNING - void declaration
     */
    public final void recordZIndex(@NotNull Map<Background, Integer> backgroundToId, @NotNull List<Background> backgroundStack) {
        Intrinsics.checkNotNullParameter(backgroundToId, (String)"backgroundToId");
        Intrinsics.checkNotNullParameter(backgroundStack, (String)"backgroundStack");
        for (Map.Entry<Background, Integer> entry : backgroundToId.entrySet()) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNullTo$iv$iv2;
            Background background = entry.getKey();
            int id = ((Number)entry.getValue()).intValue();
            if (!backgroundStack.contains(background)) continue;
            Pair<List<Background>, List<Background>> pair = RoundedBackgroundKt.splitByElement(backgroundStack, background);
            List lowerBg = (List)pair.component1();
            List upperBg = (List)pair.component2();
            Iterable $this$mapNotNull$iv = lowerBg;
            boolean $i$f$mapNotNull = false;
            Object object = $this$mapNotNull$iv;
            Iterable<Integer> destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Integer it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                Background it = (Background)element$iv$iv;
                boolean bl2 = false;
                if (backgroundToId.get(it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List lowerBgIds = (List)destination$iv$iv;
            Iterable $this$mapNotNull$iv2 = upperBg;
            boolean $i$f$mapNotNull2 = false;
            destination$iv$iv = $this$mapNotNull$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo2 = false;
            void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach2 = false;
            Iterator iterator3 = $this$forEach$iv$iv$iv2.iterator();
            while (iterator3.hasNext()) {
                Integer it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator3.next();
                boolean bl = false;
                Background it = (Background)element$iv$iv;
                boolean bl4 = false;
                if (backgroundToId.get(it) == null) continue;
                boolean bl5 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List upperBgIds = (List)destination$iv$iv2;
            object = id;
            if (this.zIndexMap.containsKey(object)) {
                Pair<Set<Integer>, Set<Integer>> pair2 = this.zIndexMap.get(id);
                Intrinsics.checkNotNull(pair2);
                ((Set)pair2.getFirst()).addAll(lowerBgIds);
                Pair<Set<Integer>, Set<Integer>> pair3 = this.zIndexMap.get(id);
                Intrinsics.checkNotNull(pair3);
                ((Set)pair3.getSecond()).addAll(upperBgIds);
                continue;
            }
            object = id;
            this.zIndexMap.put((Integer)object, (Pair<Set<Integer>, Set<Integer>>)new Pair((Object)CollectionsKt.toMutableSet((Iterable)lowerBgIds), (Object)CollectionsKt.toMutableSet((Iterable)upperBgIds)));
        }
    }

    @Override
    public int compare(@NotNull Pair<Integer, Color> idToColor1, @NotNull Pair<Integer, Color> idToColor2) {
        Set higherSet;
        Object lowerSet;
        Pair<Set<Integer>, Set<Integer>> pair;
        Intrinsics.checkNotNullParameter(idToColor1, (String)"idToColor1");
        Intrinsics.checkNotNullParameter(idToColor2, (String)"idToColor2");
        int id1 = ((Number)idToColor1.component1()).intValue();
        Color color1 = (Color)idToColor1.component2();
        int id2 = ((Number)idToColor2.component1()).intValue();
        Color color2 = (Color)idToColor2.component2();
        Integer n = id1;
        if (this.zIndexMap.containsKey(n)) {
            Pair<Set<Integer>, Set<Integer>> pair2 = this.zIndexMap.get(id1);
            Intrinsics.checkNotNull(pair2);
            pair = pair2;
            lowerSet = (Set)pair.component1();
            higherSet = (Set)pair.component2();
            if (lowerSet.contains(id2)) {
                return 1;
            }
            if (higherSet.contains(id2)) {
                return -1;
            }
        }
        if (this.zIndexMap.containsKey(lowerSet = Integer.valueOf(id2))) {
            Pair<Set<Integer>, Set<Integer>> pair3 = this.zIndexMap.get(id2);
            Intrinsics.checkNotNull(pair3);
            pair = pair3;
            lowerSet = (Set)pair.component1();
            higherSet = (Set)pair.component2();
            if (lowerSet.contains(id1)) {
                return -1;
            }
            if (higherSet.contains(id1)) {
                return 1;
            }
        }
        if (CollectionsKt.contains((Iterable)this.selectionColors, (Object)color1)) {
            return 1;
        }
        if (CollectionsKt.contains((Iterable)this.selectionColors, (Object)color2)) {
            return -1;
        }
        return String.valueOf(color1).compareTo(String.valueOf(color2));
    }
}

