/*
 * Decompiled with CFR 0.152.
 */
package noria.ui.components;

import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.graphics.CanvasKt;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.FilterQuality;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.IntOffset;
import androidx.compose.ui.unit.IntRectKt;
import androidx.compose.ui.unit.IntSize;
import androidx.compose.ui.unit.IntSizeKt;
import fleet.compose.theme.SkijaKt;
import fleet.compose.theme.components.IconKt;
import fleet.compose.theme.util.MathHelpersKt;
import fleet.compose.theme.util.RoundingKt;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.ExecutorsKt;
import noria.ui.components.ImageDescriptor;
import noria.ui.components.ImageScaling;
import noria.ui.core.NoriaLogger;
import noria.ui.core.RenderContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.Canvas;
import org.jetbrains.skia.CubicResampler;
import org.jetbrains.skia.Data;
import org.jetbrains.skia.FilterMipmap;
import org.jetbrains.skia.FilterMode;
import org.jetbrains.skia.Image;
import org.jetbrains.skia.MipmapMode;
import org.jetbrains.skia.Picture;
import org.jetbrains.skia.PictureRecorder;
import org.jetbrains.skia.Rect;
import org.jetbrains.skia.SamplingMode;
import org.jetbrains.skia.impl.Managed;
import org.jetbrains.skia.svg.SVGDOM;
import org.jetbrains.skia.svg.SVGSVG;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0016\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00062\u0006\u0010\u0013\u001a\u00020\u0005J\u0016\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00062\u0006\u0010\u0013\u001a\u00020\u0005J\u0018\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0006\u0010\u001b\u001a\u00020\u001cJ\u0016\u0010\u001d\u001a\u00020\u001e*\u00020\u001fH\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b \u0010!R\"\u0010\u0003\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\""}, d2={"Lnoria/ui/components/ImageStore;", "", "()V", "cache", "Ljava/util/concurrent/ConcurrentHashMap;", "Lnoria/ui/components/ImageDescriptor;", "Ljava/util/concurrent/CompletableFuture;", "Lorg/jetbrains/skia/Picture;", "getDestinationSize", "Landroidx/compose/ui/unit/IntSize;", "sourceWidth", "", "sourceHeight", "requestedSize", "scaling", "Lnoria/ui/components/ImageScaling;", "getDestinationSize-EatjwtY", "(IIJLnoria/ui/components/ImageScaling;)J", "loadImage", "descriptor", "loadImageCached", "loadImageSync", "byteArray", "", "loadSVGSync", "svg", "", "purgeCache", "", "toSkia", "Lorg/jetbrains/skia/SamplingMode;", "Landroidx/compose/ui/graphics/FilterQuality;", "toSkia-vDHp3xo", "(I)Lorg/jetbrains/skia/SamplingMode;", "fleet.noria.ui"})
@SourceDebugExtension(value={"SMAP\nImage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Image.kt\nnoria/ui/components/ImageStore\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Managed.kt\norg/jetbrains/skia/impl/ManagedKt\n+ 5 RenderContext.kt\nnoria/ui/core/RenderContextKt\n+ 6 RenderContext.kt\nnoria/ui/core/RenderContext\n*L\n1#1,420:1\n72#2,2:421\n1#3:423\n22#4,5:424\n22#4,2:430\n25#4,2:475\n22#4,2:478\n25#4,2:523\n88#5:429\n89#5,3:432\n92#5:474\n88#5:477\n89#5,3:480\n92#5:522\n49#6:435\n42#6:436\n29#6,3:437\n43#6,8:440\n25#6,2:448\n51#6:450\n45#6:451\n37#6,2:452\n33#6,20:454\n49#6:483\n42#6:484\n29#6,3:485\n43#6,8:488\n25#6,2:496\n51#6:498\n45#6:499\n37#6,2:500\n33#6,20:502\n*S KotlinDebug\n*F\n+ 1 Image.kt\nnoria/ui/components/ImageStore\n*L\n135#1:421,2\n135#1:423\n156#1:424,5\n160#1:430,2\n160#1:475,2\n209#1:478,2\n209#1:523,2\n160#1:429\n160#1:432,3\n160#1:474\n209#1:477\n209#1:480,3\n209#1:522\n161#1:435\n161#1:436\n161#1:437,3\n161#1:440,8\n161#1:448,2\n161#1:450\n161#1:451\n161#1:452,2\n161#1:454,20\n210#1:483\n210#1:484\n210#1:485,3\n210#1:488,8\n210#1:496,2\n210#1:498\n210#1:499\n210#1:500,2\n210#1:502,20\n*E\n"})
public final class ImageStore {
    @NotNull
    private final ConcurrentHashMap<ImageDescriptor, CompletableFuture<Picture>> cache = new ConcurrentHashMap();

    public final void purgeCache() {
        this.cache.clear();
    }

    @NotNull
    public final CompletableFuture<Picture> loadImage(@NotNull ImageDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        CompletableFuture<Picture> result2 = new CompletableFuture<Picture>();
        ExecutorsKt.asExecutor((CoroutineDispatcher)Dispatchers.getIO()).execute(() -> ImageStore.loadImage$lambda$0(descriptor, this, result2));
        return result2;
    }

    @NotNull
    public final CompletableFuture<Picture> loadImageCached(@NotNull ImageDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        ConcurrentMap $this$getOrPut$iv = this.cache;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(descriptor);
        if (object == null) {
            boolean bl = false;
            CompletableFuture<Picture> default$iv = this.loadImage(descriptor);
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(descriptor, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Intrinsics.checkNotNullExpressionValue(object, (String)"getOrPut(...)");
        return (CompletableFuture)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Picture loadSVGSync(ImageDescriptor descriptor, String svg) {
        Picture picture;
        Data data2;
        String colored;
        String string;
        if (descriptor.getPalette() != null) {
            Map<String, Color> map = descriptor.getPalette();
            Intrinsics.checkNotNull(map);
            string = IconKt.substitutePaletteKeys(svg, map);
        } else {
            string = svg;
        }
        String string2 = colored = string;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        boolean $i$f$use = false;
        try (Managed $this$use$iv = (Managed)Data.Companion.makeFromBytes$default((Data.Companion)Data.Companion, (byte[])byArray, (int)0, (int)0, (int)6, null);){
            data2 = (Data)$this$use$iv;
            boolean bl = false;
            data2 = new SVGDOM(data2);
        }
        Data dom = data2;
        SVGSVG sVGSVG = dom.getRoot();
        Intrinsics.checkNotNull((Object)sVGSVG);
        int n = (int)sVGSVG.getWidth().getValue();
        SVGSVG sVGSVG2 = dom.getRoot();
        Intrinsics.checkNotNull((Object)sVGSVG2);
        long destinationSize = this.getDestinationSize-EatjwtY(n, (int)sVGSVG2.getHeight().getValue(), descriptor.getSize-YbymL2g(), descriptor.getScaling());
        Density density$iv = descriptor.getPixelDensity();
        boolean bl = false;
        boolean $i$f$use2 = false;
        try (Managed $this$use$iv$iv = (Managed)new PictureRecorder();){
            PictureRecorder rec$iv = (PictureRecorder)$this$use$iv$iv;
            boolean bl2 = false;
            Canvas skCanvas$iv = PictureRecorder.beginRecording$default((PictureRecorder)rec$iv, (Rect)SkijaKt.toSkija(IntRectKt.IntRect-VbeCjmY(IntOffset.Companion.getZero-nOcc-ac(), destinationSize)), null, (int)2, null);
            RenderContext context$iv = new RenderContext(skCanvas$iv, density$iv, 0L, 4, null);
            androidx.compose.ui.graphics.Canvas canvas = context$iv.get_canvas();
            RenderContext $this$loadSVGSync_u24lambda_u244 = context$iv;
            boolean bl3 = false;
            RenderContext this_$iv = $this$loadSVGSync_u24lambda_u244;
            boolean $i$f$withCanvas = false;
            RenderContext this_$iv$iv = this_$iv;
            boolean $i$f$withCanvasTranslated = false;
            RenderContext this_$iv$iv$iv = this_$iv$iv;
            boolean $i$f$restore = false;
            this_$iv$iv$iv.get_canvas().save();
            try {
                void canvas2;
                void this_$iv$iv2;
                boolean bl4 = false;
                this_$iv$iv.get_canvas().translateToOrigin();
                androidx.compose.ui.graphics.Canvas it$iv = this_$iv$iv.get_canvas();
                boolean bl5 = false;
                RenderContext renderContext = this_$iv;
                long origin$iv$iv = Offset.Companion.getZero-F1C5BW0();
                boolean bl6 = false;
                androidx.compose.ui.graphics.Canvas canvas3 = this_$iv$iv2.get_canvas();
                RenderContext $this$loadSVGSync_u24lambda_u244_u24lambda_u243 = new RenderContext(this_$iv$iv2.get_canvas().getSkia(), this_$iv$iv2.getDensityImpl(), origin$iv$iv, null);
                boolean bl7 = false;
                canvas2.save();
                float dx = MathHelpersKt.middle(IntSize.getWidth-impl(descriptor.getSize-YbymL2g()) - IntSize.getWidth-impl(destinationSize));
                float dy = MathHelpersKt.middle(IntSize.getHeight-impl(descriptor.getSize-YbymL2g()) - IntSize.getHeight-impl(destinationSize));
                canvas2.translate(dx, dy);
                canvas2.scale((float)IntSize.getWidth-impl(destinationSize) / dom.getContainerSize().getX(), (float)IntSize.getHeight-impl(destinationSize) / dom.getContainerSize().getY());
                dom.render(CanvasKt.getNativeCanvas((androidx.compose.ui.graphics.Canvas)canvas2));
                canvas2.restore();
            }
            catch (Throwable x$iv$iv$iv) {
                NoriaLogger.INSTANCE.getLogger().error(x$iv$iv$iv, (Object)"error on render");
            }
            finally {
                this_$iv$iv$iv.get_canvas().restore();
            }
            picture = rec$iv.finishRecordingAsPicture();
        }
        return picture;
    }

    private final SamplingMode toSkia-vDHp3xo(int $this$toSkia_u2dvDHp3xo) {
        int n = $this$toSkia_u2dvDHp3xo;
        return FilterQuality.equals-impl0(n, FilterQuality.Companion.getLow-f-v9h1I()) ? (SamplingMode)new FilterMipmap(FilterMode.LINEAR, MipmapMode.NONE) : (FilterQuality.equals-impl0(n, FilterQuality.Companion.getMedium-f-v9h1I()) ? (SamplingMode)new FilterMipmap(FilterMode.LINEAR, MipmapMode.NEAREST) : (FilterQuality.equals-impl0(n, FilterQuality.Companion.getHigh-f-v9h1I()) ? (SamplingMode)new CubicResampler(0.33333334f, 0.33333334f) : (SamplingMode)new FilterMipmap(FilterMode.NEAREST, MipmapMode.NONE)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Picture loadImageSync(ImageDescriptor descriptor, byte[] byteArray) {
        Picture picture;
        if (Intrinsics.areEqual((Object)descriptor.getType(), (Object)"svg")) {
            return this.loadSVGSync(descriptor, new String(byteArray, Charsets.UTF_8));
        }
        Image image2 = Image.Companion.makeFromEncoded(byteArray);
        long destinationSize = this.getDestinationSize-EatjwtY(image2.getWidth(), image2.getHeight(), descriptor.getSize-YbymL2g(), descriptor.getScaling());
        Rect destination = Rect.Companion.makeWH((float)IntSize.getWidth-impl(destinationSize), (float)IntSize.getHeight-impl(destinationSize));
        Rect source = Rect.Companion.makeWH((float)image2.getWidth(), (float)image2.getHeight());
        int filterQuality = source.getWidth() == destination.getWidth() && source.getHeight() == destination.getHeight() ? FilterQuality.Companion.getNone-f-v9h1I() : ((float)image2.getWidth() <= destination.getWidth() && (float)image2.getHeight() <= destination.getHeight() ? FilterQuality.Companion.getMedium-f-v9h1I() : FilterQuality.Companion.getHigh-f-v9h1I());
        Density density$iv = descriptor.getPixelDensity();
        boolean bl = false;
        boolean $i$f$use = false;
        try (Managed $this$use$iv$iv = (Managed)new PictureRecorder();){
            PictureRecorder rec$iv = (PictureRecorder)$this$use$iv$iv;
            boolean bl2 = false;
            Canvas skCanvas$iv = PictureRecorder.beginRecording$default((PictureRecorder)rec$iv, (Rect)SkijaKt.toSkija(IntRectKt.IntRect-VbeCjmY(IntOffset.Companion.getZero-nOcc-ac(), destinationSize)), null, (int)2, null);
            RenderContext context$iv = new RenderContext(skCanvas$iv, density$iv, 0L, 4, null);
            androidx.compose.ui.graphics.Canvas canvas = context$iv.get_canvas();
            RenderContext $this$loadImageSync_u24lambda_u246 = context$iv;
            boolean bl3 = false;
            RenderContext this_$iv = $this$loadImageSync_u24lambda_u246;
            boolean $i$f$withCanvas = false;
            RenderContext this_$iv$iv = this_$iv;
            boolean $i$f$withCanvasTranslated = false;
            RenderContext this_$iv$iv$iv = this_$iv$iv;
            boolean $i$f$restore = false;
            this_$iv$iv$iv.get_canvas().save();
            try {
                void canvas2;
                void this_$iv$iv2;
                boolean bl4 = false;
                this_$iv$iv.get_canvas().translateToOrigin();
                androidx.compose.ui.graphics.Canvas it$iv = this_$iv$iv.get_canvas();
                boolean bl5 = false;
                RenderContext renderContext = this_$iv;
                long origin$iv$iv = Offset.Companion.getZero-F1C5BW0();
                boolean bl6 = false;
                androidx.compose.ui.graphics.Canvas canvas3 = this_$iv$iv2.get_canvas();
                RenderContext $this$loadImageSync_u24lambda_u246_u24lambda_u245 = new RenderContext(this_$iv$iv2.get_canvas().getSkia(), this_$iv$iv2.getDensityImpl(), origin$iv$iv, null);
                boolean bl7 = false;
                canvas2.save();
                float dx = MathHelpersKt.middle(IntSize.getWidth-impl(descriptor.getSize-YbymL2g()) - IntSize.getWidth-impl(destinationSize));
                float dy = MathHelpersKt.middle(IntSize.getHeight-impl(descriptor.getSize-YbymL2g()) - IntSize.getHeight-impl(destinationSize));
                canvas2.translate(dx, dy);
                CanvasKt.getNativeCanvas((androidx.compose.ui.graphics.Canvas)canvas2).drawImageRect(image2, source, destination, this.toSkia-vDHp3xo(filterQuality), null, true);
                canvas2.restore();
            }
            catch (Throwable x$iv$iv$iv) {
                NoriaLogger.INSTANCE.getLogger().error(x$iv$iv$iv, (Object)"error on render");
            }
            finally {
                this_$iv$iv$iv.get_canvas().restore();
            }
            picture = rec$iv.finishRecordingAsPicture();
        }
        return picture;
    }

    private final long getDestinationSize-EatjwtY(int sourceWidth, int sourceHeight, long requestedSize, ImageScaling scaling) {
        switch (WhenMappings.$EnumSwitchMapping$0[scaling.ordinal()]) {
            case 1: {
                if ((float)sourceWidth < (float)IntSize.getWidth-impl(requestedSize) && (float)sourceHeight < (float)IntSize.getHeight-impl(requestedSize)) {
                    return IntSizeKt.IntSize(sourceWidth, sourceHeight);
                }
                float sourceRatio = (float)sourceWidth / (float)sourceHeight;
                float requestRatio = (float)IntSize.getWidth-impl(requestedSize) / (float)IntSize.getHeight-impl(requestedSize);
                long destinationSize = sourceRatio <= requestRatio ? IntSizeKt.IntSize(RoundingKt.round$default((float)IntSize.getHeight-impl(requestedSize) * sourceRatio, null, 1, null), IntSize.getHeight-impl(requestedSize)) : IntSizeKt.IntSize(IntSize.getWidth-impl(requestedSize), RoundingKt.round$default((float)IntSize.getWidth-impl(requestedSize) / sourceRatio, null, 1, null));
                return destinationSize;
            }
            case 2: {
                float ratio = (float)sourceWidth / (float)sourceHeight;
                float destinationHeight = (float)IntSize.getWidth-impl(requestedSize) / ratio;
                if (destinationHeight <= (float)IntSize.getHeight-impl(requestedSize)) {
                    return IntSizeKt.IntSize(IntSize.getWidth-impl(requestedSize), RoundingKt.round$default(destinationHeight, null, 1, null));
                }
                float destinationWidth = (float)IntSize.getHeight-impl(requestedSize) * ratio;
                return IntSizeKt.IntSize(RoundingKt.round$default(destinationWidth, null, 1, null), IntSize.getHeight-impl(requestedSize));
            }
            case 3: {
                return requestedSize;
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    private static final void loadImage$lambda$0(ImageDescriptor $descriptor, ImageStore this$0, CompletableFuture $result) {
        block5: {
            Intrinsics.checkNotNullParameter((Object)$descriptor, (String)"$descriptor");
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
            try {
                byte[] byteArray = $descriptor.getContent();
                if (byteArray != null) {
                    Picture picture;
                    try {
                        picture = this$0.loadImageSync($descriptor, byteArray);
                    }
                    catch (Throwable x) {
                        picture = null;
                    }
                    Picture image2 = picture;
                    $result.complete(image2);
                    break block5;
                }
                $result.complete(null);
            }
            catch (Throwable t) {
                $result.completeExceptionally(t);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ImageScaling.values().length];
            try {
                nArray[ImageScaling.CONTAINED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ImageScaling.STRETCHED_PROPORTIONALLY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ImageScaling.STRETCHED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

