/*
 * Decompiled with CFR 0.152.
 */
package fleet.compose.theme.layout;

import androidx.compose.ui.layout.IntrinsicMeasurable;
import androidx.compose.ui.layout.IntrinsicMeasureScope;
import androidx.compose.ui.layout.Measurable;
import androidx.compose.ui.layout.MeasurePolicy;
import androidx.compose.ui.layout.MeasureResult;
import androidx.compose.ui.layout.MeasureScope;
import androidx.compose.ui.layout.Placeable;
import androidx.compose.ui.unit.Constraints;
import androidx.compose.ui.unit.UnpackedConstraintsKt;
import fleet.compose.theme.layout.PriorityElements;
import fleet.compose.theme.layout.PriorityRowKt;
import java.util.Comparator;
import java.util.List;
import java.util.SortedMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lfleet/compose/theme/layout/PriorityRowMeasurePolicy;", "Landroidx/compose/ui/layout/MeasurePolicy;", "()V", "measure", "Landroidx/compose/ui/layout/MeasureResult;", "Landroidx/compose/ui/layout/MeasureScope;", "measurables", "", "Landroidx/compose/ui/layout/Measurable;", "constraints", "Landroidx/compose/ui/unit/Constraints;", "fleet.noria.ui"})
@SourceDebugExtension(value={"SMAP\nPriorityRow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PriorityRow.kt\nfleet/compose/theme/layout/PriorityRowMeasurePolicy\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n*L\n1#1,125:1\n69#2,6:126\n*S KotlinDebug\n*F\n+ 1 PriorityRow.kt\nfleet/compose/theme/layout/PriorityRowMeasurePolicy\n*L\n50#1:126,6\n*E\n"})
final class PriorityRowMeasurePolicy
implements MeasurePolicy {
    @NotNull
    public static final PriorityRowMeasurePolicy INSTANCE = new PriorityRowMeasurePolicy();

    private PriorityRowMeasurePolicy() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public MeasureResult measure(@NotNull MeasureScope $this$measure, @NotNull List<? extends Measurable> measurables, @NotNull Constraints constraints) {
        int maxIntrinsicWidth2;
        Intrinsics.checkNotNullParameter((Object)$this$measure, (String)"<this>");
        Intrinsics.checkNotNullParameter(measurables, (String)"measurables");
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        Placeable[] placeables = new Placeable[measurables.size()];
        SortedMap priorities = MapsKt.sortedMapOf((Comparator)ComparisonsKt.reverseOrder(), (Pair[])new Pair[0]);
        List<? extends Measurable> $this$fastForEachIndexed$iv = measurables;
        boolean $i$f$fastForEachIndexed = false;
        int index$iv = 0;
        int n = $this$fastForEachIndexed$iv.size();
        while (index$iv < n) {
            void measurable;
            Measurable item$iv;
            Measurable measurable2 = item$iv = $this$fastForEachIndexed$iv.get(index$iv);
            int index2 = index$iv++;
            boolean bl = false;
            int layoutPriority = PriorityRowKt.access$getLayoutPriority((Measurable)measurable);
            maxIntrinsicWidth2 = measurable.maxIntrinsicWidth(constraints.getMaxHeight());
            priorities.compute(layoutPriority, (arg_0, arg_1) -> PriorityRowMeasurePolicy.measure$lambda$1$lambda$0((Function2)new Function2<Integer, PriorityElements, PriorityElements>(index2, maxIntrinsicWidth2){
                final /* synthetic */ int $index;
                final /* synthetic */ int $maxIntrinsicWidth;
                {
                    this.$index = $index;
                    this.$maxIntrinsicWidth = $maxIntrinsicWidth;
                    super(2);
                }

                @Nullable
                public final PriorityElements invoke(Integer key, @Nullable PriorityElements value2) {
                    PriorityElements priorityElements;
                    PriorityElements priorityElements2 = value2;
                    if (priorityElements2 != null) {
                        PriorityElements priorityElements3 = priorityElements2;
                        int n = this.$index;
                        int n2 = this.$maxIntrinsicWidth;
                        PriorityElements it = priorityElements3;
                        boolean bl = false;
                        it.extend(n, n2);
                        priorityElements = priorityElements3;
                    } else {
                        priorityElements = new PriorityElements(this.$index, this.$maxIntrinsicWidth);
                    }
                    return priorityElements;
                }
            }, arg_0, arg_1));
        }
        Constraints targetConstraints = Constraints.copy$default(constraints, 0, 0, 0, 0, 14, null);
        int remainingWidth = constraints.getMaxWidth();
        for (PriorityElements priorityElements : priorities.values()) {
            if (remainingWidth <= 0) break;
            float ratio = RangesKt.coerceIn((float)((float)remainingWidth / (float)priorityElements.getMaxIntrinsicWidth()), (float)0.0f, (float)1.0f);
            boolean fits = priorityElements.getMaxIntrinsicWidth() <= remainingWidth;
            for (Pair<Integer, Integer> pair : priorityElements.getElements()) {
                Placeable placeable;
                int index3 = ((Number)pair.component1()).intValue();
                maxIntrinsicWidth2 = ((Number)pair.component2()).intValue();
                int maxWidth = fits ? remainingWidth : (int)((float)maxIntrinsicWidth2 * ratio);
                Measurable measurable = measurables.get(index3);
                placeables[index3] = placeable = measurable.measure(UnpackedConstraintsKt.constrain(targetConstraints, new Constraints(0, maxWidth, 0, 0, 13, null)));
                remainingWidth -= placeable.getWidth();
            }
        }
        return MeasureScope.DefaultImpls.layout$default($this$measure, constraints.getMaxWidth(), constraints.getMaxHeight(), null, (Function1)new Function1<Placeable.PlacementScope, Unit>(placeables){
            final /* synthetic */ Placeable[] $placeables;
            {
                this.$placeables = $placeables;
                super(1);
            }

            public final void invoke(@NotNull Placeable.PlacementScope $this$layout) {
                Intrinsics.checkNotNullParameter((Object)$this$layout, (String)"$this$layout");
                int x = 0;
                for (Placeable placeable : this.$placeables) {
                    if (placeable == null) continue;
                    Placeable.PlacementScope.place$default($this$layout, placeable, x, 0, 0.0f, 4, null);
                    x += placeable.getWidth();
                }
            }
        }, 4, null);
    }

    @Override
    public int minIntrinsicWidth(@NotNull IntrinsicMeasureScope $this$minIntrinsicWidth, @NotNull List<? extends IntrinsicMeasurable> measurables, int height2) {
        return MeasurePolicy.DefaultImpls.minIntrinsicWidth(this, $this$minIntrinsicWidth, measurables, height2);
    }

    @Override
    public int minIntrinsicHeight(@NotNull IntrinsicMeasureScope $this$minIntrinsicHeight, @NotNull List<? extends IntrinsicMeasurable> measurables, int width2) {
        return MeasurePolicy.DefaultImpls.minIntrinsicHeight(this, $this$minIntrinsicHeight, measurables, width2);
    }

    @Override
    public int maxIntrinsicWidth(@NotNull IntrinsicMeasureScope $this$maxIntrinsicWidth, @NotNull List<? extends IntrinsicMeasurable> measurables, int height2) {
        return MeasurePolicy.DefaultImpls.maxIntrinsicWidth(this, $this$maxIntrinsicWidth, measurables, height2);
    }

    @Override
    public int maxIntrinsicHeight(@NotNull IntrinsicMeasureScope $this$maxIntrinsicHeight, @NotNull List<? extends IntrinsicMeasurable> measurables, int width2) {
        return MeasurePolicy.DefaultImpls.maxIntrinsicHeight(this, $this$maxIntrinsicHeight, measurables, width2);
    }

    private static final PriorityElements measure$lambda$1$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (PriorityElements)$tmp0.invoke(p0, p1);
    }
}

