/*
 * Decompiled with CFR 0.152.
 */
package fleet.compose.theme.components;

import androidx.compose.ui.graphics.painter.Painter;
import androidx.compose.ui.res.DesktopSvgResources_desktopKt;
import fleet.compose.theme.components.IconData;
import fleet.compose.theme.components.IconKt;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.ExecutorsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\u0005J\u0016\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00062\u0006\u0010\t\u001a\u00020\u0005J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\u0005H\u0002R\"\u0010\u0003\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lfleet/compose/theme/components/SvgIconStore;", "", "()V", "cache", "Ljava/util/concurrent/ConcurrentHashMap;", "Lfleet/compose/theme/components/IconData;", "Lkotlinx/coroutines/CompletableDeferred;", "Landroidx/compose/ui/graphics/painter/Painter;", "fromCache", "iconData", "loadIconPainter", "loadPainterIconSync", "fleet.noria.ui"})
@SourceDebugExtension(value={"SMAP\nIcon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Icon.kt\nfleet/compose/theme/components/SvgIconStore\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,230:1\n72#2,2:231\n1#3:233\n*S KotlinDebug\n*F\n+ 1 Icon.kt\nfleet/compose/theme/components/SvgIconStore\n*L\n187#1:231,2\n187#1:233\n*E\n"})
final class SvgIconStore {
    @NotNull
    private final ConcurrentHashMap<IconData, CompletableDeferred<Painter>> cache = new ConcurrentHashMap();

    @Nullable
    public final Painter fromCache(@NotNull IconData iconData) {
        Intrinsics.checkNotNullParameter((Object)iconData, (String)"iconData");
        CompletableDeferred<Painter> completableDeferred = this.cache.get(iconData);
        if (completableDeferred == null) {
            return null;
        }
        CompletableDeferred<Painter> deferred = completableDeferred;
        return deferred.isCompleted() && !deferred.isCancelled() ? (Painter)deferred.getCompleted() : null;
    }

    @NotNull
    public final CompletableDeferred<Painter> loadIconPainter(@NotNull IconData iconData) {
        Intrinsics.checkNotNullParameter((Object)iconData, (String)"iconData");
        ConcurrentMap $this$getOrPut$iv = this.cache;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(iconData);
        if (object == null) {
            boolean bl = false;
            CompletableDeferred result2 = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
            ExecutorsKt.asExecutor((CoroutineDispatcher)Dispatchers.getIO()).execute(() -> SvgIconStore.loadIconPainter$lambda$1$lambda$0(iconData, this, result2));
            CompletableDeferred default$iv = result2;
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(iconData, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Intrinsics.checkNotNullExpressionValue(object, (String)"getOrPut(...)");
        return (CompletableDeferred)object;
    }

    private final Painter loadPainterIconSync(IconData iconData) {
        String colored;
        InputStream inputStream = iconData.getResourceReader().read(iconData.getPath());
        Object object = inputStream != null ? inputStream.readAllBytes() : null;
        if (object == null) {
            return null;
        }
        byte[] bytes = object;
        String svg = new String(bytes, Charsets.UTF_8);
        String string = colored = iconData.getPalette() != null ? IconKt.substitutePaletteKeys(svg, iconData.getPalette()) : svg;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return DesktopSvgResources_desktopKt.loadSvgPainter(new ByteArrayInputStream(byArray), iconData.getDensity());
    }

    private static final void loadIconPainter$lambda$1$lambda$0(IconData $iconData, SvgIconStore this$0, CompletableDeferred $result) {
        Intrinsics.checkNotNullParameter((Object)$iconData, (String)"$iconData");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        try {
            Painter painter2;
            try {
                Painter lowDpiIconPainter;
                Painter painter3;
                Painter painter4;
                if ($iconData.getDensity().getDensity() <= 1.0f) {
                    String lowDpiIconPath = StringsKt.replaceFirst$default((String)StringsKt.replaceFirst$default((String)$iconData.getPath(), (String)"dark", (String)"dark-low-dpi", (boolean)false, (int)4, null), (String)"light", (String)"light-low-dpi", (boolean)false, (int)4, null);
                    painter4 = this$0.loadPainterIconSync(IconData.copy$default($iconData, null, lowDpiIconPath, null, null, 13, null));
                } else {
                    painter4 = null;
                }
                if ((painter3 = (lowDpiIconPainter = painter4)) == null) {
                    painter3 = this$0.loadPainterIconSync($iconData);
                }
                painter2 = painter3;
            }
            catch (Throwable throwable) {
                painter2 = null;
            }
            Painter icon2 = painter2;
            $result.complete(icon2);
        }
        catch (Throwable t) {
            $result.completeExceptionally(t);
        }
    }
}

