/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.input.pointer.util;

import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.input.pointer.HistoricalChange;
import androidx.compose.ui.input.pointer.PointerEventKt;
import androidx.compose.ui.input.pointer.PointerInputChange;
import androidx.compose.ui.input.pointer.util.DataPointAtTime;
import androidx.compose.ui.input.pointer.util.Matrix;
import androidx.compose.ui.input.pointer.util.Vector;
import androidx.compose.ui.input.pointer.util.VelocityTracker;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\u001a,\u0010\u0006\u001a\u00020\u00032\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003H\u0002\u001a2\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\b2\u0006\u0010\u0011\u001a\u00020\u0001H\u0000\u001a\u0012\u0010\u0012\u001a\u00020\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016\u001a1\u0010\u0017\u001a\u00020\u0013*\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\u001d\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"AssumePointerMoveStoppedMilliseconds", "", "DefaultWeight", "", "HistorySize", "HorizonMilliseconds", "calculateImpulseVelocity", "dataPoints", "", "time", "isDataDifferential", "", "kineticEnergyToVelocity", "kineticEnergy", "polyFitLeastSquares", "x", "y", "degree", "addPointerInputChange", "", "Landroidx/compose/ui/input/pointer/util/VelocityTracker;", "event", "Landroidx/compose/ui/input/pointer/PointerInputChange;", "set", "", "Landroidx/compose/ui/input/pointer/util/DataPointAtTime;", "index", "", "dataPoint", "([Landroidx/compose/ui/input/pointer/util/DataPointAtTime;IJF)V", "fleet.noria.ui"})
@SourceDebugExtension(value={"SMAP\nVelocityTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VelocityTracker.kt\nandroidx/compose/ui/input/pointer/util/VelocityTrackerKt\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,598:1\n33#2,6:599\n1#3:605\n*S KotlinDebug\n*F\n+ 1 VelocityTracker.kt\nandroidx/compose/ui/input/pointer/util/VelocityTrackerKt\n*L\n296#1:599,6\n*E\n"})
public final class VelocityTrackerKt {
    private static final int AssumePointerMoveStoppedMilliseconds = 40;
    private static final int HistorySize = 20;
    private static final int HorizonMilliseconds = 100;
    private static final float DefaultWeight = 1.0f;

    private static final void set(DataPointAtTime[] $this$set, int index2, long time, float dataPoint) {
        DataPointAtTime currentEntry = $this$set[index2];
        if (currentEntry == null) {
            $this$set[index2] = new DataPointAtTime(time, dataPoint);
        } else {
            currentEntry.setTime(time);
            currentEntry.setDataPoint(dataPoint);
        }
    }

    public static final void addPointerInputChange(@NotNull VelocityTracker $this$addPointerInputChange, @NotNull PointerInputChange event) {
        Intrinsics.checkNotNullParameter((Object)$this$addPointerInputChange, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (PointerEventKt.changedToDownIgnoreConsumed(event)) {
            $this$addPointerInputChange.setCurrentPointerPositionAccumulator-k-4lQ0M$fleet_noria_ui(event.getPosition-F1C5BW0());
            $this$addPointerInputChange.resetTracking();
        }
        long previousPointerPosition = 0L;
        previousPointerPosition = event.getPreviousPosition-F1C5BW0();
        List<HistoricalChange> $this$fastForEach$iv = event.getHistorical();
        boolean $i$f$fastForEach = false;
        int n = $this$fastForEach$iv.size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            HistoricalChange item$iv;
            HistoricalChange it = item$iv = $this$fastForEach$iv.get(index$iv);
            boolean bl = false;
            long historicalDelta = Offset.minus-MK-Hz9U(it.getPosition-F1C5BW0(), previousPointerPosition);
            previousPointerPosition = it.getPosition-F1C5BW0();
            $this$addPointerInputChange.setCurrentPointerPositionAccumulator-k-4lQ0M$fleet_noria_ui(Offset.plus-MK-Hz9U($this$addPointerInputChange.getCurrentPointerPositionAccumulator-F1C5BW0$fleet_noria_ui(), historicalDelta));
            $this$addPointerInputChange.addPosition-Uv8p0NA(it.getUptimeMillis(), $this$addPointerInputChange.getCurrentPointerPositionAccumulator-F1C5BW0$fleet_noria_ui());
        }
        long delta = Offset.minus-MK-Hz9U(event.getPosition-F1C5BW0(), previousPointerPosition);
        $this$addPointerInputChange.setCurrentPointerPositionAccumulator-k-4lQ0M$fleet_noria_ui(Offset.plus-MK-Hz9U($this$addPointerInputChange.getCurrentPointerPositionAccumulator-F1C5BW0$fleet_noria_ui(), delta));
        $this$addPointerInputChange.addPosition-Uv8p0NA(event.getUptimeMillis(), $this$addPointerInputChange.getCurrentPointerPositionAccumulator-F1C5BW0$fleet_noria_ui());
    }

    @NotNull
    public static final List<Float> polyFitLeastSquares(@NotNull List<Float> x, @NotNull List<Float> y, int degree) {
        Intrinsics.checkNotNullParameter(x, (String)"x");
        Intrinsics.checkNotNullParameter(y, (String)"y");
        if (degree < 1) {
            throw new IllegalArgumentException("The degree must be at positive integer");
        }
        if (x.size() != y.size()) {
            throw new IllegalArgumentException("x and y must be the same length");
        }
        if (x.isEmpty()) {
            throw new IllegalArgumentException("At least one point must be provided");
        }
        int truncatedDegree = degree >= x.size() ? x.size() - 1 : degree;
        int n = degree + 1;
        ArrayList<Float> arrayList = new ArrayList<Float>(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4 = n3 = n2++;
            ArrayList<Float> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(Float.valueOf(0.0f));
        }
        List coefficients = arrayList;
        int m = x.size();
        int n5 = truncatedDegree + 1;
        Matrix a = new Matrix(n5, m);
        for (int h = 0; h < m; ++h) {
            a.set(0, h, 1.0f);
            for (int i = 1; i < n5; ++i) {
                a.set(i, h, a.get(i - 1, h) * ((Number)x.get(h)).floatValue());
            }
        }
        Matrix q = new Matrix(n5, m);
        Matrix r = new Matrix(n5, n5);
        for (int j = 0; j < n5; ++j) {
            int h;
            for (int h2 = 0; h2 < m; ++h2) {
                q.set(j, h2, a.get(j, h2));
            }
            for (int i = 0; i < j; ++i) {
                float dot = q.getRow(j).times(q.getRow(i));
                for (h = 0; h < m; ++h) {
                    q.set(j, h, q.get(j, h) - dot * q.get(i, h));
                }
            }
            float norm = q.getRow(j).norm();
            if ((double)norm < 1.0E-6) {
                throw new IllegalArgumentException("Vectors are linearly dependent or zero so no solution. TODO(shepshapard), actually determine what this means");
            }
            float inverseNorm = 1.0f / norm;
            for (h = 0; h < m; ++h) {
                q.set(j, h, q.get(j, h) * inverseNorm);
            }
            for (int i = 0; i < n5; ++i) {
                r.set(j, i, i < j ? 0.0f : q.getRow(j).times(a.getRow(i)));
            }
        }
        Vector wy = new Vector(m);
        for (int h = 0; h < m; ++h) {
            wy.set(h, ((Number)y.get(h)).floatValue() * 1.0f);
        }
        for (int i = n5 - 1; -1 < i; --i) {
            coefficients.set(i, Float.valueOf(q.getRow(i).times(wy)));
            int j = n5 - 1;
            int n6 = i + 1;
            if (n6 <= j) {
                while (true) {
                    int n7 = i;
                    coefficients.set(n7, Float.valueOf(((Number)coefficients.get(n7)).floatValue() - r.get(i, j) * ((Number)coefficients.get(j)).floatValue()));
                    if (j == n6) break;
                    --j;
                }
            }
            int n8 = i;
            coefficients.set(n8, Float.valueOf(((Number)coefficients.get(n8)).floatValue() / r.get(i, i)));
        }
        return coefficients;
    }

    private static final float calculateImpulseVelocity(List<Float> dataPoints, List<Float> time, boolean isDataDifferential) {
        int numDataPoints = dataPoints.size();
        if (numDataPoints < 2) {
            return 0.0f;
        }
        if (numDataPoints == 2) {
            if (((Number)time.get(0)).floatValue() == ((Number)time.get(1)).floatValue()) {
                return 0.0f;
            }
            float dataPointsDelta = isDataDifferential ? ((Number)dataPoints.get(0)).floatValue() : ((Number)dataPoints.get(0)).floatValue() - ((Number)dataPoints.get(1)).floatValue();
            return dataPointsDelta / (((Number)time.get(0)).floatValue() - ((Number)time.get(1)).floatValue());
        }
        float work = 0.0f;
        for (int i = numDataPoints - 1; 0 < i; --i) {
            if (((Number)time.get(i)).floatValue() == ((Number)time.get(i - 1)).floatValue()) continue;
            float vPrev = VelocityTrackerKt.kineticEnergyToVelocity(work);
            float dataPointsDelta = isDataDifferential ? -((Number)dataPoints.get(i - 1)).floatValue() : ((Number)dataPoints.get(i)).floatValue() - ((Number)dataPoints.get(i - 1)).floatValue();
            float vCurr = dataPointsDelta / (((Number)time.get(i)).floatValue() - ((Number)time.get(i - 1)).floatValue());
            work += (vCurr - vPrev) * Math.abs(vCurr);
            if (i != numDataPoints - 1) continue;
            work *= 0.5f;
        }
        return VelocityTrackerKt.kineticEnergyToVelocity(work);
    }

    private static final float kineticEnergyToVelocity(float kineticEnergy) {
        return Math.signum(kineticEnergy) * (float)Math.sqrt((float)2 * Math.abs(kineticEnergy));
    }

    public static final /* synthetic */ void access$set(DataPointAtTime[] $receiver, int index2, long time, float dataPoint) {
        VelocityTrackerKt.set($receiver, index2, time, dataPoint);
    }

    public static final /* synthetic */ float access$calculateImpulseVelocity(List dataPoints, List time, boolean isDataDifferential) {
        return VelocityTrackerKt.calculateImpulseVelocity(dataPoints, time, isDataDifferential);
    }
}

