/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics.colorspace;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0018\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003JO\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020!H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\f\u00a8\u0006\""}, d2={"Landroidx/compose/ui/graphics/colorspace/TransferParameters;", "", "gamma", "", "a", "b", "c", "d", "e", "f", "(DDDDDDD)V", "getA", "()D", "getB", "getC", "getD", "getE", "getF", "getGamma", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "hashCode", "", "toString", "", "fleet.noria.ui"})
public final class TransferParameters {
    private final double gamma;
    private final double a;
    private final double b;
    private final double c;
    private final double d;
    private final double e;
    private final double f;

    public TransferParameters(double gamma, double a, double b, double c, double d, double e, double f) {
        this.gamma = gamma;
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
        this.e = e;
        this.f = f;
        if (Double.isNaN(this.a) || Double.isNaN(this.b) || Double.isNaN(this.c) || Double.isNaN(this.d) || Double.isNaN(this.e) || Double.isNaN(this.f) || Double.isNaN(this.gamma)) {
            throw new IllegalArgumentException("Parameters cannot be NaN");
        }
        if (!(this.d >= 0.0) || !(this.d <= 1.0)) {
            throw new IllegalArgumentException("Parameter d must be in the range [0..1], was " + this.d);
        }
        if (this.d == 0.0 && (this.a == 0.0 || this.gamma == 0.0)) {
            throw new IllegalArgumentException("Parameter a or g is zero, the transfer function is constant");
        }
        if (this.d >= 1.0 && this.c == 0.0) {
            throw new IllegalArgumentException("Parameter c is zero, the transfer function is constant");
        }
        if ((this.a == 0.0 || this.gamma == 0.0) && this.c == 0.0) {
            throw new IllegalArgumentException("Parameter a or g is zero, and c is zero, the transfer function is constant");
        }
        if (this.c < 0.0) {
            throw new IllegalArgumentException("The transfer function must be increasing");
        }
        if (this.a < 0.0 || this.gamma < 0.0) {
            throw new IllegalArgumentException("The transfer function must be positive or increasing");
        }
    }

    public /* synthetic */ TransferParameters(double d, double d2, double d3, double d4, double d5, double d6, double d7, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            d6 = 0.0;
        }
        if ((n & 0x40) != 0) {
            d7 = 0.0;
        }
        this(d, d2, d3, d4, d5, d6, d7);
    }

    public final double getGamma() {
        return this.gamma;
    }

    public final double getA() {
        return this.a;
    }

    public final double getB() {
        return this.b;
    }

    public final double getC() {
        return this.c;
    }

    public final double getD() {
        return this.d;
    }

    public final double getE() {
        return this.e;
    }

    public final double getF() {
        return this.f;
    }

    public final double component1() {
        return this.gamma;
    }

    public final double component2() {
        return this.a;
    }

    public final double component3() {
        return this.b;
    }

    public final double component4() {
        return this.c;
    }

    public final double component5() {
        return this.d;
    }

    public final double component6() {
        return this.e;
    }

    public final double component7() {
        return this.f;
    }

    @NotNull
    public final TransferParameters copy(double gamma, double a, double b, double c, double d, double e, double f) {
        return new TransferParameters(gamma, a, b, c, d, e, f);
    }

    public static /* synthetic */ TransferParameters copy$default(TransferParameters transferParameters, double d, double d2, double d3, double d4, double d5, double d6, double d7, int n, Object object) {
        if ((n & 1) != 0) {
            d = transferParameters.gamma;
        }
        if ((n & 2) != 0) {
            d2 = transferParameters.a;
        }
        if ((n & 4) != 0) {
            d3 = transferParameters.b;
        }
        if ((n & 8) != 0) {
            d4 = transferParameters.c;
        }
        if ((n & 0x10) != 0) {
            d5 = transferParameters.d;
        }
        if ((n & 0x20) != 0) {
            d6 = transferParameters.e;
        }
        if ((n & 0x40) != 0) {
            d7 = transferParameters.f;
        }
        return transferParameters.copy(d, d2, d3, d4, d5, d6, d7);
    }

    @NotNull
    public String toString() {
        return "TransferParameters(gamma=" + this.gamma + ", a=" + this.a + ", b=" + this.b + ", c=" + this.c + ", d=" + this.d + ", e=" + this.e + ", f=" + this.f + ")";
    }

    public int hashCode() {
        int result2 = Double.hashCode(this.gamma);
        result2 = result2 * 31 + Double.hashCode(this.a);
        result2 = result2 * 31 + Double.hashCode(this.b);
        result2 = result2 * 31 + Double.hashCode(this.c);
        result2 = result2 * 31 + Double.hashCode(this.d);
        result2 = result2 * 31 + Double.hashCode(this.e);
        result2 = result2 * 31 + Double.hashCode(this.f);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TransferParameters)) {
            return false;
        }
        TransferParameters transferParameters = (TransferParameters)other;
        if (Double.compare(this.gamma, transferParameters.gamma) != 0) {
            return false;
        }
        if (Double.compare(this.a, transferParameters.a) != 0) {
            return false;
        }
        if (Double.compare(this.b, transferParameters.b) != 0) {
            return false;
        }
        if (Double.compare(this.c, transferParameters.c) != 0) {
            return false;
        }
        if (Double.compare(this.d, transferParameters.d) != 0) {
            return false;
        }
        if (Double.compare(this.e, transferParameters.e) != 0) {
            return false;
        }
        return Double.compare(this.f, transferParameters.f) == 0;
    }
}

