/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text;

import androidx.compose.ui.text.TextRangeKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.BreakIterator;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001c\u0010\u0000\u001a\u00060\u0001j\u0002`\u0002*\u00060\u0001j\u0002`\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0014\u0010\u0005\u001a\u00020\u0004*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0000\u001a\u0014\u0010\b\u001a\u00020\u0004*\u00020\t2\u0006\u0010\n\u001a\u00020\u0004H\u0000\u001a\u0014\u0010\u000b\u001a\u00020\u0004*\u00020\t2\u0006\u0010\n\u001a\u00020\u0004H\u0000\u001a\u0014\u0010\f\u001a\u00020\u0004*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0000\u001a\u0019\u0010\r\u001a\u00020\u000e*\u00020\t2\u0006\u0010\u0007\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"appendCodePointX", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "codePoint", "", "findFollowingBreak", "", "index", "findParagraphEnd", "", "startIndex", "findParagraphStart", "findPrecedingBreak", "getParagraphBoundary", "Landroidx/compose/ui/text/TextRange;", "(Ljava/lang/CharSequence;I)J", "fleet.noria.ui"})
public final class StringHelpersKt {
    @NotNull
    public static final StringBuilder appendCodePointX(@NotNull StringBuilder $this$appendCodePointX, int codePoint) {
        Intrinsics.checkNotNullParameter((Object)$this$appendCodePointX, (String)"<this>");
        StringBuilder stringBuilder = $this$appendCodePointX.appendCodePoint(codePoint);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"appendCodePoint(...)");
        return stringBuilder;
    }

    public static final int findPrecedingBreak(@NotNull String $this$findPrecedingBreak, int index2) {
        Intrinsics.checkNotNullParameter((Object)$this$findPrecedingBreak, (String)"<this>");
        BreakIterator it = BreakIterator.Companion.makeCharacterInstance$default((BreakIterator.Companion)BreakIterator.Companion, null, (int)1, null);
        it.setText($this$findPrecedingBreak);
        return it.preceding(index2);
    }

    public static final int findFollowingBreak(@NotNull String $this$findFollowingBreak, int index2) {
        Intrinsics.checkNotNullParameter((Object)$this$findFollowingBreak, (String)"<this>");
        BreakIterator it = BreakIterator.Companion.makeCharacterInstance$default((BreakIterator.Companion)BreakIterator.Companion, null, (int)1, null);
        it.setText($this$findFollowingBreak);
        return it.following(index2);
    }

    public static final int findParagraphStart(@NotNull CharSequence $this$findParagraphStart, int startIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$findParagraphStart, (String)"<this>");
        for (int index2 = startIndex; 0 < index2; --index2) {
            if ($this$findParagraphStart.charAt(index2 - 1) != '\n') continue;
            return index2;
        }
        return 0;
    }

    public static final int findParagraphEnd(@NotNull CharSequence $this$findParagraphEnd, int startIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$findParagraphEnd, (String)"<this>");
        int n = $this$findParagraphEnd.length();
        for (int index2 = startIndex; index2 < n; ++index2) {
            if ($this$findParagraphEnd.charAt(index2) != '\n') continue;
            return index2;
        }
        return $this$findParagraphEnd.length();
    }

    public static final long getParagraphBoundary(@NotNull CharSequence $this$getParagraphBoundary, int index2) {
        Intrinsics.checkNotNullParameter((Object)$this$getParagraphBoundary, (String)"<this>");
        return TextRangeKt.TextRange(StringHelpersKt.findParagraphStart($this$getParagraphBoundary, index2), StringHelpersKt.findParagraphEnd($this$getParagraphBoundary, index2));
    }
}

