/*
 * Decompiled with CFR 0.152.
 */
package fleet.plugins.misc.frontend.editor;

import androidx.compose.runtime.Composable;
import androidx.compose.runtime.CompositionLocal;
import com.jetbrains.rhizomedb.Attributes;
import com.jetbrains.rhizomedb.ChangeScope;
import com.jetbrains.rhizomedb.Entity;
import fleet.api.DetectedCharset;
import fleet.common.document.DocumentEntity;
import fleet.common.document.DocumentEntityKt;
import fleet.common.document.DocumentFileEntity;
import fleet.common.document.EditorEntity;
import fleet.common.document.UnsharedHackKt;
import fleet.frontend.KernelExtKt;
import fleet.frontend.actions.FleetDataKeysKt;
import fleet.frontend.editor.actions.EditorActionId;
import fleet.frontend.layout.AlertDialogEntityKt;
import fleet.frontend.layout.WindowEntity;
import fleet.frontend.ui.gotoPanel.GotoProviderFactory;
import fleet.frontend.ui.gotoPanel.GotoProviderSearchOption;
import fleet.frontend.ui.gotoPanel.GotoProviderWithListResult;
import fleet.frontend.ui.gotoPanel.GotoProviderWithSimpleList;
import fleet.kernel.SagaKt;
import fleet.kernel.SharedChangeScope;
import fleet.kernel.TransactorKt;
import fleet.kernel.plugins.PluginScope;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import noria.NoriaContext;
import noria.ReadScope;
import noria.model.ActionContext;
import noria.model.Trigger;
import noria.ui.core.AlertDialogAction;
import noria.ui.core.AlertDialogActionType;
import noria.ui.core.AlertDialogResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 #2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001#B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\b\u0010\u0013\u001a\u00020\u0011H\u0016J>\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u00112\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\n0\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0096@\u00a2\u0006\u0002\u0010\u001dJ\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0010\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00020\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lfleet/plugins/misc/frontend/editor/ChangeEncodingGotoProvider;", "Lfleet/frontend/ui/gotoPanel/GotoProviderWithSimpleList;", "Ljava/nio/charset/Charset;", "docFile", "Lfleet/common/document/DocumentFileEntity;", "pluginScope", "Lfleet/kernel/plugins/PluginScope;", "<init>", "(Lfleet/common/document/DocumentFileEntity;Lfleet/kernel/plugins/PluginScope;)V", "reactive", "", "getReactive", "()Z", "allCharsets", "", "kotlin.jvm.PlatformType", "itemName", "", "item", "emptyText", "search", "Lkotlinx/coroutines/flow/Flow;", "Lfleet/frontend/ui/gotoPanel/GotoProviderWithListResult;", "queryText", "options", "", "Lfleet/frontend/ui/gotoPanel/GotoProviderSearchOption;", "limit", "", "(Ljava/lang/String;Ljava/util/Map;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "onConfirm", "", "actionContext", "Lnoria/model/ActionContext;", "confirmedItem", "Companion", "fleet.plugins.misc.frontend"})
@SourceDebugExtension(value={"SMAP\nChangeEncodingGotoProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangeEncodingGotoProvider.kt\nfleet/plugins/misc/frontend/editor/ChangeEncodingGotoProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,112:1\n1053#2:113\n*S KotlinDebug\n*F\n+ 1 ChangeEncodingGotoProvider.kt\nfleet/plugins/misc/frontend/editor/ChangeEncodingGotoProvider\n*L\n70#1:113\n*E\n"})
final class ChangeEncodingGotoProvider
extends GotoProviderWithSimpleList<Charset> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DocumentFileEntity docFile;
    @NotNull
    private final PluginScope pluginScope;
    @NotNull
    private final List<Charset> allCharsets;

    public ChangeEncodingGotoProvider(@NotNull DocumentFileEntity docFile, @NotNull PluginScope pluginScope) {
        Intrinsics.checkNotNullParameter((Object)docFile, (String)"docFile");
        Intrinsics.checkNotNullParameter((Object)pluginScope, (String)"pluginScope");
        this.docFile = docFile;
        this.pluginScope = pluginScope;
        Collection<Charset> collection = Charset.availableCharsets().values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$sortedBy$iv = collection;
        boolean $i$f$sortedBy = false;
        this.allCharsets = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Charset it = (Charset)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.name());
                it = (Charset)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.name())));
            }
        });
    }

    public boolean getReactive() {
        return super.getReactive();
    }

    @NotNull
    public String itemName(@NotNull Charset item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        String string = item.name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
        return string;
    }

    @NotNull
    public String emptyText() {
        return "No encodings available found";
    }

    @Nullable
    public Object search(@NotNull String queryText, @NotNull Map<GotoProviderSearchOption, Boolean> options, int limit, @NotNull Continuation<? super Flow<GotoProviderWithListResult<Charset>>> $completion) {
        return FlowKt.flow((Function2)((Function2)new Function2<FlowCollector<? super GotoProviderWithListResult<Charset>>, Continuation<? super Unit>, Object>(this, queryText, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ ChangeEncodingGotoProvider this$0;
            final /* synthetic */ String $queryText;
            {
                this.this$0 = $receiver;
                this.$queryText = $queryText;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        FlowCollector $this$flow = (FlowCollector)this.L$0;
                        this.label = 1;
                        Object object3 = $this$flow.emit((Object)new GotoProviderWithListResult(ChangeEncodingGotoProvider.access$getAllCharsets$p(this.this$0), this.$queryText, null), (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(FlowCollector<? super GotoProviderWithListResult<Charset>> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    public void onConfirm(@NotNull ActionContext actionContext, @NotNull Charset confirmedItem) {
        Intrinsics.checkNotNullParameter((Object)actionContext, (String)"actionContext");
        Intrinsics.checkNotNullParameter((Object)confirmedItem, (String)"confirmedItem");
        String message = StringsKt.trimMargin$default((String)("Reloading will preserve the file contents and update preview in the editor using the " + confirmedItem.displayName() + " encoding. \n                    |Converting will update the file. The conversion cannot be undone.\n                    "), null, (int)1, null);
        SagaKt.saga$default((CoroutineScope)((CoroutineScope)this.pluginScope), (Entity[])new Entity[0], null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(message, actionContext, this, confirmedItem, null){
            int label;
            final /* synthetic */ String $message;
            final /* synthetic */ ActionContext $actionContext;
            final /* synthetic */ ChangeEncodingGotoProvider this$0;
            final /* synthetic */ Charset $confirmedItem;
            {
                this.$message = $message;
                this.$actionContext = $actionContext;
                this.this$0 = $receiver;
                this.$confirmedItem = $confirmedItem;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        var3_3 = new AlertDialogAction[]{new AlertDialogAction.Confirm("Convert", true, false, 4, null), new AlertDialogAction.Custom("Reload"), new AlertDialogAction.Cancel("Cancel")};
                        this.label = 1;
                        v0 = AlertDialogEntityKt.showAlertDialog$default((String)"Reload or Convert File", (String)this.$message, (WindowEntity)FleetDataKeysKt.getWindowEntity((ActionContext)this.$actionContext), (AlertDialogAction[])var3_3, null, (Continuation)((Continuation)this), (int)16, null);
                        if (v0 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl14
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl14:
                        // 2 sources

                        decision = ((AlertDialogResult)v0).getType();
                        this.label = 2;
                        v1 = TransactorKt.change((Function1)((Function1)new Function1<ChangeScope, Unit>(decision, this.this$0, this.$confirmedItem){
                            final /* synthetic */ AlertDialogActionType $decision;
                            final /* synthetic */ ChangeEncodingGotoProvider this$0;
                            final /* synthetic */ Charset $confirmedItem;
                            {
                                this.$decision = $decision;
                                this.this$0 = $receiver;
                                this.$confirmedItem = $confirmedItem;
                                super(1);
                            }

                            public final void invoke(ChangeScope $this$change) {
                                Intrinsics.checkNotNullParameter((Object)$this$change, (String)"$this$change");
                                AlertDialogActionType alertDialogActionType = this.$decision;
                                if (!(alertDialogActionType instanceof AlertDialogActionType.Cancel)) {
                                    if (alertDialogActionType instanceof AlertDialogActionType.Confirm) {
                                        UnsharedHackKt.maybeShared((ChangeScope)$this$change, (Entity)((Entity)ChangeEncodingGotoProvider.access$getDocFile$p(this.this$0)), (Function1)((Function1)new Function1<SharedChangeScope, Unit>(this.this$0, this.$confirmedItem){
                                            final /* synthetic */ ChangeEncodingGotoProvider this$0;
                                            final /* synthetic */ Charset $confirmedItem;
                                            {
                                                this.this$0 = $receiver;
                                                this.$confirmedItem = $confirmedItem;
                                                super(1);
                                            }

                                            public final void invoke(SharedChangeScope $this$maybeShared) {
                                                Intrinsics.checkNotNullParameter((Object)$this$maybeShared, (String)"$this$maybeShared");
                                                Entity entity = (Entity)ChangeEncodingGotoProvider.access$getDocFile$p(this.this$0);
                                                Attributes.Required required = DocumentFileEntity.Companion.getWriteCharsetAttr();
                                                String string = this.$confirmedItem.name();
                                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
                                                $this$maybeShared.set(entity, required, (Object)new DetectedCharset.Charset(string));
                                            }
                                        }));
                                    } else if (alertDialogActionType instanceof AlertDialogActionType.Custom) {
                                        UnsharedHackKt.maybeShared((ChangeScope)$this$change, (Entity)((Entity)ChangeEncodingGotoProvider.access$getDocFile$p(this.this$0)), (Function1)((Function1)new Function1<SharedChangeScope, Unit>(this.this$0, this.$confirmedItem){
                                            final /* synthetic */ ChangeEncodingGotoProvider this$0;
                                            final /* synthetic */ Charset $confirmedItem;
                                            {
                                                this.this$0 = $receiver;
                                                this.$confirmedItem = $confirmedItem;
                                                super(1);
                                            }

                                            public final void invoke(SharedChangeScope $this$maybeShared) {
                                                Intrinsics.checkNotNullParameter((Object)$this$maybeShared, (String)"$this$maybeShared");
                                                Entity entity = (Entity)ChangeEncodingGotoProvider.access$getDocFile$p(this.this$0);
                                                Attributes.Required required = DocumentFileEntity.Companion.getReadCharsetAttr();
                                                String string = this.$confirmedItem.name();
                                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
                                                $this$maybeShared.set(entity, required, (Object)new DetectedCharset.Charset(string));
                                            }
                                        }));
                                    } else {
                                        throw new NoWhenBranchMatchedException();
                                    }
                                }
                            }
                        }), (Continuation)((Continuation)this));
                        if (v1 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl23
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl23:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)6, null);
    }

    public static final /* synthetic */ List access$getAllCharsets$p(ChangeEncodingGotoProvider $this) {
        return $this.allCharsets;
    }

    public static final /* synthetic */ DocumentFileEntity access$getDocFile$p(ChangeEncodingGotoProvider $this) {
        return $this.docFile;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0018\u001a\u00020\u0019*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0017R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0018\u0010\u0014\u001a\u00020\u0007*\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001d"}, d2={"Lfleet/plugins/misc/frontend/editor/ChangeEncodingGotoProvider$Companion;", "Lfleet/frontend/ui/gotoPanel/GotoProviderFactory;", "Lfleet/frontend/ui/gotoPanel/GotoProviderWithListResult;", "Ljava/nio/charset/Charset;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "plaqueText", "getPlaqueText", "trigger", "Lnoria/model/Trigger;", "getTrigger", "()Lnoria/model/Trigger;", "useSelectionForInitialQuery", "", "getUseSelectionForInitialQuery", "()Z", "placeholderText", "Lnoria/ReadScope;", "getPlaceholderText", "(Lnoria/ReadScope;)Ljava/lang/String;", "createProvider", "Lfleet/plugins/misc/frontend/editor/ChangeEncodingGotoProvider;", "Lnoria/NoriaContext;", "actionContext", "Lnoria/model/ActionContext;", "fleet.plugins.misc.frontend"})
    public static final class Companion
    implements GotoProviderFactory<GotoProviderWithListResult<Charset>> {
        private Companion() {
        }

        @NotNull
        public String getName() {
            return "Change Encoding";
        }

        @NotNull
        public String getPlaqueText() {
            return "Encoding";
        }

        @NotNull
        public Trigger getTrigger() {
            return (Trigger)EditorActionId.ShowEncodingSelector.getId();
        }

        public boolean getUseSelectionForInitialQuery() {
            return false;
        }

        @NotNull
        public String getPlaceholderText(@NotNull ReadScope $this$placeholderText) {
            Intrinsics.checkNotNullParameter((Object)$this$placeholderText, (String)"<this>");
            return "Select encoding";
        }

        @Composable
        @NotNull
        public ChangeEncodingGotoProvider createProvider(@NotNull NoriaContext $this$createProvider, @NotNull ActionContext actionContext) {
            Intrinsics.checkNotNullParameter((Object)$this$createProvider, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)actionContext, (String)"actionContext");
            EditorEntity editorEntity = FleetDataKeysKt.getLastEditorEntity((ActionContext)actionContext);
            Intrinsics.checkNotNull((Object)editorEntity);
            DocumentFileEntity documentFileEntity = DocumentEntityKt.getDocumentFileEntity((DocumentEntity)editorEntity.getDocument());
            Intrinsics.checkNotNull((Object)documentFileEntity);
            return new ChangeEncodingGotoProvider(documentFileEntity, (PluginScope)$this$createProvider.getCurrent((CompositionLocal)KernelExtKt.getLocalPluginScope()));
        }

        @Composable
        @Nullable
        public String queryHint(@NotNull NoriaContext $this$queryHint) {
            return GotoProviderFactory.DefaultImpls.queryHint((GotoProviderFactory)this, (NoriaContext)$this$queryHint);
        }

        public boolean getReuseQueryFromOtherProviders() {
            return GotoProviderFactory.DefaultImpls.getReuseQueryFromOtherProviders((GotoProviderFactory)this);
        }

        @NotNull
        public List<GotoProviderFactory.ID> getChildScopes() {
            return GotoProviderFactory.DefaultImpls.getChildScopes((GotoProviderFactory)this);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

