/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic.vfs;

import org.clang.basic.vfs.File;
import org.clang.basic.vfs.FileSystem;
import org.clang.basic.vfs.Status;
import org.clang.basic.vfs.VfsGlobals;
import org.clang.basic.vfs.detail.DirIterImpl;
import org.clang.basic.vfs.detail.impl.InMemoryDirectory;
import org.clang.basic.vfs.detail.impl.InMemoryFile;
import org.clang.basic.vfs.detail.impl.InMemoryFileAdaptor;
import org.clang.basic.vfs.detail.impl.InMemoryNode;
import org.clang.basic.vfs.directory_iterator;
import org.clang.basic.vfs.impl.InMemoryDirIterator;
import org.clang.basic.vfs.impl.VfsStatics;
import org.clank.java.std;
import org.clank.java.std_errors;
import org.clank.java.std_ptr;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.abstract_iterator;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.support.ErrorOr;
import org.llvm.support.MemoryBuffer;
import org.llvm.support.llvm;
import org.llvm.support.sys.TimeValue;
import org.llvm.support.sys.fs;
import org.llvm.support.sys.path;

public class InMemoryFileSystem
extends FileSystem
implements Destructors.ClassWithDestructor {
    private std_ptr.unique_ptr<InMemoryDirectory> Root = new std_ptr.unique_ptr((Object)new InMemoryDirectory(new Status(new StringRef(NativePointer.$EMPTY), VfsGlobals.getNextVirtualUniqueID(), TimeValue.MinTime(), 0, 0, 0L, fs.file_type.directory_file, 511)));
    private std.string WorkingDirectory = new std.string();
    private boolean UseNormalizedPaths;

    public InMemoryFileSystem() {
        this(true);
    }

    public InMemoryFileSystem(boolean UseNormalizedPaths) {
        this.UseNormalizedPaths = UseNormalizedPaths;
    }

    @Override
    public void $destroy() {
        this.WorkingDirectory.$destroy();
        this.Root.$destroy();
        super.$destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addFile(Twine P2, long ModificationTime, std_ptr.unique_ptr<MemoryBuffer> Buffer2) {
        InMemoryNode Node2;
        SmallString Path = new SmallString(128);
        P2.toVector(Path);
        std_errors.error_code EC = this.makeAbsolute(Path);
        assert (!EC.$bool());
        if (this.useNormalizedPaths()) {
            path.remove_dots((SmallString)Path, (boolean)true);
        }
        if (Path.empty()) {
            return false;
        }
        InMemoryDirectory Dir = (InMemoryDirectory)this.Root.get();
        path.const_iterator I = path.begin((StringRef)Path.$StringRef());
        path.const_iterator E = path.end((StringRef)Path.$StringRef());
        while (true) {
            StringRef Name = new StringRef(I.$star());
            Node2 = Dir.getChild(new StringRef(Name));
            I.$preInc();
            if (Node2 == null) {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    Status Stat;
                    if (I.$eq((Object)E)) {
                        Stat = new Status(new StringRef(P2.str()), VfsGlobals.getNextVirtualUniqueID(), new TimeValue(ModificationTime, 0), 0, 0, Unsigned.$uint2ulong((int)((MemoryBuffer)Buffer2.$arrow()).getBufferSize()), fs.file_type.regular_file, 511);
                        $c$.clean((Object)Dir.addChild(new StringRef(Name), (std_ptr.unique_ptr<InMemoryNode>)$c$.track(new std_ptr.unique_ptr($c$.track(llvm.make_unique((Object)new InMemoryFile((Status)std.move((Object)Stat), (std_ptr.unique_ptr<MemoryBuffer>)((std_ptr.unique_ptr)std.move(Buffer2)))))))));
                        boolean bl = true;
                        return bl;
                    }
                    Stat = new Status(new StringRef(Path.str().begin(), Name.end().$sub((abstract_iterator)Path.str().begin())), VfsGlobals.getNextVirtualUniqueID(), new TimeValue(ModificationTime, 0), 0, 0, Unsigned.$uint2ulong((int)((MemoryBuffer)Buffer2.$arrow()).getBufferSize()), fs.file_type.directory_file, 511);
                    Dir = (InMemoryDirectory)llvm.cast(InMemoryDirectory.class, (Object)Dir.addChild(new StringRef(Name), (std_ptr.unique_ptr<InMemoryNode>)$c$.track(new std_ptr.unique_ptr($c$.track(llvm.make_unique((Object)new InMemoryDirectory((Status)std.move((Object)Stat))))))));
                    $c$.clean((Object)Dir);
                }
                finally {
                    $c$.$destroy();
                }
                continue;
            }
            InMemoryDirectory NewDir = (InMemoryDirectory)llvm.dyn_cast(InMemoryDirectory.class, (Object)Node2);
            if (NewDir == null) break;
            Dir = NewDir;
        }
        assert (llvm.isa(InMemoryFile.class, (Object)Node2)) : "Must be either file or directory!";
        if (I.$noteq((Object)E)) {
            return false;
        }
        return llvm.$eq_StringRef((StringRef)((InMemoryFile)llvm.cast(InMemoryFile.class, (Object)Node2)).getBuffer().getBuffer(), (StringRef)((MemoryBuffer)Buffer2.$arrow()).getBuffer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addFileNoOwn(Twine P2, long ModificationTime, MemoryBuffer Buffer2) {
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            boolean bl = $c$.clean(this.addFile(P2, ModificationTime, (std_ptr.unique_ptr<MemoryBuffer>)$c$.track(MemoryBuffer.getMemBuffer((StringRef)Buffer2.getBuffer(), (StringRef)new StringRef(Buffer2.getBufferIdentifier())))));
            return bl;
        }
        finally {
            $c$.$destroy();
        }
    }

    public std.string __toString() {
        return ((InMemoryDirectory)this.Root.$arrow()).__toString(0);
    }

    public boolean useNormalizedPaths() {
        return this.UseNormalizedPaths;
    }

    @Override
    public ErrorOr<Status> status(Twine Path) {
        ErrorOr<InMemoryNode> Node2 = VfsStatics.lookupInMemoryNode(this, (InMemoryDirectory)this.Root.get(), Path);
        if (Node2.$bool()) {
            return new ErrorOr((Object)new Status(((InMemoryNode)Node2.$star()).getStatus()));
        }
        return new ErrorOr(Node2.getError());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ErrorOr<std_ptr.unique_ptr<File>> openFileForRead(Twine Path) {
        ErrorOr<InMemoryNode> Node2 = VfsStatics.lookupInMemoryNode(this, (InMemoryDirectory)this.Root.get(), Path);
        if (!Node2.$bool()) {
            return new ErrorOr(Node2.getError());
        }
        InMemoryFile F = (InMemoryFile)llvm.dyn_cast(InMemoryFile.class, (Object)((InMemoryNode)Node2.$star()));
        if (F != null) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                ErrorOr errorOr = (ErrorOr)$c$.clean((Object)new ErrorOr((Object)$c$.track(new std_ptr.unique_ptr((Object)new InMemoryFileAdaptor((InMemoryFile)Native.$Deref((Object)F))))));
                return errorOr;
            }
            finally {
                $c$.$destroy();
            }
        }
        return new ErrorOr(llvm.make_error_code((std_errors.errc)std_errors.errc.invalid_argument));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public directory_iterator dir_begin(Twine Dir, std_errors.error_code EC) {
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            ErrorOr<InMemoryNode> Node2 = VfsStatics.lookupInMemoryNode(this, (InMemoryDirectory)this.Root.get(), Dir);
            if (!Node2.$bool()) {
                EC.$assignMove(Node2.getError());
                directory_iterator directory_iterator2 = (directory_iterator)$c$.clean(new directory_iterator((std_ptr.shared_ptr<DirIterImpl>)std.make_shared((Object)new InMemoryDirIterator())));
                return directory_iterator2;
            }
            InMemoryDirectory DirNode = (InMemoryDirectory)llvm.dyn_cast(InMemoryDirectory.class, (Object)((InMemoryNode)Node2.$star()));
            if (DirNode != null) {
                directory_iterator directory_iterator3 = (directory_iterator)$c$.clean(new directory_iterator((std_ptr.shared_ptr<DirIterImpl>)std.make_shared((Object)new InMemoryDirIterator((InMemoryDirectory)Native.$Deref((Object)DirNode)))));
                return directory_iterator3;
            }
            EC.$assignMove(llvm.make_error_code((std_errors.errc)std_errors.errc.not_a_directory));
            directory_iterator directory_iterator4 = (directory_iterator)$c$.clean(new directory_iterator((std_ptr.shared_ptr<DirIterImpl>)((std_ptr.shared_ptr)$c$.track((Object)new std_ptr.shared_ptr((std_ptr.shared_ptr)$c$.track((Object)std.make_shared((Object)new InMemoryDirIterator())))))));
            return directory_iterator4;
        }
        finally {
            $c$.$destroy();
        }
    }

    @Override
    public ErrorOr<std.string> getCurrentWorkingDirectory() {
        return new ErrorOr((Object)new std.string(this.WorkingDirectory));
    }

    @Override
    public std_errors.error_code setCurrentWorkingDirectory(Twine P2) {
        SmallString Path = new SmallString(128);
        P2.toVector(Path);
        std_errors.error_code EC = this.makeAbsolute(Path);
        assert (!EC.$bool());
        if (this.useNormalizedPaths()) {
            path.remove_dots((SmallString)Path, (boolean)true);
        }
        if (!Path.empty()) {
            this.WorkingDirectory.$assignMove(Path.str().$string());
        }
        return new std_errors.error_code();
    }

    @Override
    public String toString() {
        return "Root=" + this.Root + ", WorkingDirectory=" + this.WorkingDirectory + ", UseNormalizedPaths=" + this.UseNormalizedPaths + super.toString();
    }
}

