/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic.target.impl;

import org.clang.basic.BasicClangGlobals;
import org.clang.basic.Builtin;
import org.clang.basic.CallingConv;
import org.clang.basic.DiagnosticBuilder;
import org.clang.basic.DiagnosticsEngine;
import org.clang.basic.LangOptions;
import org.clang.basic.MacroBuilder;
import org.clang.basic.target.TargetInfo;
import org.clang.basic.target.TargetOptions;
import org.clang.basic.target.impl.TargetInfo;
import org.clang.basic.target.impl.TargetsStatics;
import org.clank.java.std;
import org.clank.java.stdimpl.aliases.StdVectorString;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.llvm.adt.APFloat;
import org.llvm.adt.StringRef;
import org.llvm.adt.StringSwitch;
import org.llvm.adt.StringSwitchBool;
import org.llvm.adt.Triple;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.ArrayRefInt;
import org.llvm.adt.aliases.StringMapBool;
import org.llvm.adt.aliases.StringMapConstIteratorBool;
import org.llvm.adt.aliases.StringMapIteratorBool;
import org.llvm.support.fltSemantics;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;

public abstract class X86TargetInfo
extends TargetInfo
implements Destructors.ClassWithDestructor {
    private X86SSEEnum SSELevel = X86SSEEnum.NoSSE;
    private MMX3DNowEnum MMX3DNowLevel = MMX3DNowEnum.NoMMX3DNow;
    private XOPEnum XOPLevel = XOPEnum.NoXOP;
    private boolean HasAES = false;
    private boolean HasPCLMUL = false;
    private boolean HasLZCNT = false;
    private boolean HasRDRND = false;
    private boolean HasFSGSBASE = false;
    private boolean HasBMI = false;
    private boolean HasBMI2 = false;
    private boolean HasPOPCNT = false;
    private boolean HasRTM = false;
    private boolean HasPRFCHW = false;
    private boolean HasRDSEED = false;
    private boolean HasADX = false;
    private boolean HasTBM = false;
    private boolean HasFMA = false;
    private boolean HasF16C = false;
    private boolean HasAVX512CD = false;
    private boolean HasAVX512ER = false;
    private boolean HasAVX512PF = false;
    private boolean HasAVX512DQ = false;
    private boolean HasAVX512BW = false;
    private boolean HasAVX512VL = false;
    private boolean HasAVX512VBMI = false;
    private boolean HasAVX512IFMA = false;
    private boolean HasSHA = false;
    private boolean HasMPX = false;
    private boolean HasSGX = false;
    private boolean HasCX16 = false;
    private boolean HasFXSR = false;
    private boolean HasXSAVE = false;
    private boolean HasXSAVEOPT = false;
    private boolean HasXSAVEC = false;
    private boolean HasXSAVES = false;
    private boolean HasMWAITX = false;
    private boolean HasPKU = false;
    private boolean HasCLFLUSHOPT = false;
    private boolean HasPCOMMIT = false;
    private boolean HasCLWB = false;
    private boolean HasUMIP = false;
    private boolean HasMOVBE = false;
    private boolean HasPREFETCHWT1 = false;
    private CPUKind CPU = CPUKind.CK_Generic;
    private FPMathKind FPMath = FPMathKind.FP_Default;

    private CPUKind getCPUKind(StringRef CPU) {
        return (CPUKind)((Object)new StringSwitch(CPU).Case("i386", (Object)CPUKind.CK_i386).Case("i486", (Object)CPUKind.CK_i486).Case("winchip-c6", (Object)CPUKind.CK_WinChipC6).Case("winchip2", (Object)CPUKind.CK_WinChip2).Case("c3", (Object)CPUKind.CK_C3).Case("i586", (Object)CPUKind.CK_i586).Case("pentium", (Object)CPUKind.CK_Pentium).Case("pentium-mmx", (Object)CPUKind.CK_PentiumMMX).Case("i686", (Object)CPUKind.CK_i686).Case("pentiumpro", (Object)CPUKind.CK_PentiumPro).Case("pentium2", (Object)CPUKind.CK_Pentium2).Case("pentium3", (Object)CPUKind.CK_Pentium3).Case("pentium3m", (Object)CPUKind.CK_Pentium3M).Case("pentium-m", (Object)CPUKind.CK_PentiumM).Case("c3-2", (Object)CPUKind.CK_C3_2).Case("yonah", (Object)CPUKind.CK_Yonah).Case("pentium4", (Object)CPUKind.CK_Pentium4).Case("pentium4m", (Object)CPUKind.CK_Pentium4M).Case("prescott", (Object)CPUKind.CK_Prescott).Case("nocona", (Object)CPUKind.CK_Nocona).Case("core2", (Object)CPUKind.CK_Core2).Case("penryn", (Object)CPUKind.CK_Penryn).Case("bonnell", (Object)CPUKind.CK_Bonnell).Case("atom", (Object)CPUKind.CK_Bonnell).Case("silvermont", (Object)CPUKind.CK_Silvermont).Case("slm", (Object)CPUKind.CK_Silvermont).Case("nehalem", (Object)CPUKind.CK_Nehalem).Case("corei7", (Object)CPUKind.CK_Nehalem).Case("westmere", (Object)CPUKind.CK_Westmere).Case("sandybridge", (Object)CPUKind.CK_SandyBridge).Case("corei7-avx", (Object)CPUKind.CK_SandyBridge).Case("ivybridge", (Object)CPUKind.CK_IvyBridge).Case("core-avx-i", (Object)CPUKind.CK_IvyBridge).Case("haswell", (Object)CPUKind.CK_Haswell).Case("core-avx2", (Object)CPUKind.CK_Haswell).Case("broadwell", (Object)CPUKind.CK_Broadwell).Case("skylake", (Object)CPUKind.CK_SkylakeClient).Case("skylake-avx512", (Object)CPUKind.CK_SkylakeServer).Case("skx", (Object)CPUKind.CK_SkylakeServer).Case("cannonlake", (Object)CPUKind.CK_Cannonlake).Case("knl", (Object)CPUKind.CK_KNL).Case("lakemont", (Object)CPUKind.CK_Lakemont).Case("k6", (Object)CPUKind.CK_K6).Case("k6-2", (Object)CPUKind.CK_K6_2).Case("k6-3", (Object)CPUKind.CK_K6_3).Case("athlon", (Object)CPUKind.CK_Athlon).Case("athlon-tbird", (Object)CPUKind.CK_AthlonThunderbird).Case("athlon-4", (Object)CPUKind.CK_Athlon4).Case("athlon-xp", (Object)CPUKind.CK_AthlonXP).Case("athlon-mp", (Object)CPUKind.CK_AthlonMP).Case("athlon64", (Object)CPUKind.CK_Athlon64).Case("athlon64-sse3", (Object)CPUKind.CK_Athlon64SSE3).Case("athlon-fx", (Object)CPUKind.CK_AthlonFX).Case("k8", (Object)CPUKind.CK_K8).Case("k8-sse3", (Object)CPUKind.CK_K8SSE3).Case("opteron", (Object)CPUKind.CK_Opteron).Case("opteron-sse3", (Object)CPUKind.CK_OpteronSSE3).Case("barcelona", (Object)CPUKind.CK_AMDFAM10).Case("amdfam10", (Object)CPUKind.CK_AMDFAM10).Case("btver1", (Object)CPUKind.CK_BTVER1).Case("btver2", (Object)CPUKind.CK_BTVER2).Case("bdver1", (Object)CPUKind.CK_BDVER1).Case("bdver2", (Object)CPUKind.CK_BDVER2).Case("bdver3", (Object)CPUKind.CK_BDVER3).Case("bdver4", (Object)CPUKind.CK_BDVER4).Case("x86-64", (Object)CPUKind.CK_x86_64).Case("geode", (Object)CPUKind.CK_Geode).Default((Object)CPUKind.CK_Generic));
    }

    public X86TargetInfo(Triple Triple2, TargetOptions $Prm1) {
        super(Triple2);
        this.BigEndian = false;
        this.LongDoubleFormat = (fltSemantics)Native.$AddrOf((Object)APFloat.x87DoubleExtended);
    }

    @Override
    public int getFloatEvalMethod() {
        return this.SSELevel == X86SSEEnum.NoSSE ? 2 : 0;
    }

    @Override
    public ArrayRef<Builtin.Info> getTargetBuiltins() {
        return llvm.makeArrayRef((Object[])TargetsStatics.BuiltinInfo$Clang$Targets, (int)(2925 - Builtin.ID.FirstTSBuiltin.getValue()));
    }

    @Override
    public ArrayRef<char.ptr> getGCCRegNames() {
        return llvm.makeArrayRef((Object[])TargetsStatics.GCCRegNames);
    }

    @Override
    public ArrayRef<TargetInfo.GCCRegAlias> getGCCRegAliases() {
        return ArrayRef.None();
    }

    @Override
    public ArrayRef<TargetInfo.AddlRegName> getGCCAddlRegNames() {
        return llvm.makeArrayRef((Object[])TargetsStatics.AddlRegNames);
    }

    @Override
    public boolean validateCpuSupports(StringRef FeatureStr) {
        return new StringSwitchBool(FeatureStr).Case("cmov", true).Case("mmx", true).Case("popcnt", true).Case("sse", true).Case("sse2", true).Case("sse3", true).Case("ssse3", true).Case("sse4.1", true).Case("sse4.2", true).Case("avx", true).Case("avx2", true).Case("sse4a", true).Case("fma4", true).Case("xop", true).Case("fma", true).Case("avx512f", true).Case("bmi", true).Case("bmi2", true).Case("aes", true).Case("pclmul", true).Case("avx512vl", true).Case("avx512bw", true).Case("avx512dq", true).Case("avx512cd", true).Case("avx512er", true).Case("avx512pf", true).Case("avx512vbmi", true).Case("avx512ifma", true).Default(false);
    }

    @Override
    public boolean validateAsmConstraint(char.ptr Name, TargetInfo.ConstraintInfo Info2) {
        switch (Name.$star()) {
            default: {
                return false;
            }
            case 90: 
            case 101: 
            case 115: {
                Info2.setRequiresImmediate();
                return true;
            }
            case 73: {
                Info2.setRequiresImmediate(0, 31);
                return true;
            }
            case 74: {
                Info2.setRequiresImmediate(0, 63);
                return true;
            }
            case 75: {
                Info2.setRequiresImmediate(-128, 127);
                return true;
            }
            case 76: {
                Info2.setRequiresImmediate(new ArrayRefInt(NativePointer.new$int((int)3, (int[])new int[]{255, 65535, -1})));
                return true;
            }
            case 77: {
                Info2.setRequiresImmediate(0, 3);
                return true;
            }
            case 78: {
                Info2.setRequiresImmediate(0, 255);
                return true;
            }
            case 79: {
                Info2.setRequiresImmediate(0, 127);
                return true;
            }
            case 89: {
                Name.$postInc();
                switch (Name.$star()) {
                    default: {
                        return false;
                    }
                    case 48: 
                    case 105: 
                    case 109: 
                    case 116: 
                }
                Info2.setAllowsRegister();
                return true;
            }
            case 102: {
                if (Info2.ConstraintStr.$at(0) == 61) {
                    return false;
                }
                Info2.setAllowsRegister();
                return true;
            }
            case 65: 
            case 68: 
            case 81: 
            case 82: 
            case 83: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 108: 
            case 113: 
            case 116: 
            case 117: 
            case 120: 
            case 121: {
                Info2.setAllowsRegister();
                return true;
            }
            case 67: 
            case 71: 
        }
        return true;
    }

    @Override
    public boolean validateGlobalRegisterVariable(StringRef RegName, int RegSize, bool.ref HasSizeMismatch) {
        if (RegName.equals("esp") || RegName.equals("ebp")) {
            HasSizeMismatch.$set(RegSize != 32);
            return true;
        }
        return false;
    }

    @Override
    public boolean validateOutputSize(StringRef Constraint, int Size) {
        while (Constraint.$at(0) == 61 || Constraint.$at(0) == 43 || Constraint.$at(0) == 38) {
            Constraint.$assignMove(Constraint.substr(1));
        }
        return this.validateOperandSize(Constraint, Size);
    }

    @Override
    public boolean validateInputSize(StringRef Constraint, int Size) {
        return this.validateOperandSize(Constraint, Size);
    }

    public boolean validateOperandSize(StringRef Constraint, int Size) {
        block0 : switch (Constraint.$at(0)) {
            default: {
                break;
            }
            case 121: {
                return Unsigned.$lesseq_uint((int)Size, (int)64);
            }
            case 102: 
            case 116: 
            case 117: {
                return Unsigned.$lesseq_uint((int)Size, (int)128);
            }
            case 120: {
                if (this.SSELevel.getValue() >= X86SSEEnum.AVX512F.getValue()) {
                    return Unsigned.$lesseq_uint((int)Size, (int)512);
                }
                if (this.SSELevel.getValue() >= X86SSEEnum.AVX.getValue()) {
                    return Unsigned.$lesseq_uint((int)Size, (int)256);
                }
                return Unsigned.$lesseq_uint((int)Size, (int)128);
            }
            case 89: {
                switch (Constraint.$at(1)) {
                    default: {
                        break block0;
                    }
                    case 109: {
                        return Unsigned.$lesseq_uint((int)Size, (int)64);
                    }
                    case 105: 
                    case 116: 
                }
                if (this.SSELevel.getValue() >= X86SSEEnum.AVX512F.getValue()) {
                    return Unsigned.$lesseq_uint((int)Size, (int)512);
                }
                if (this.SSELevel.getValue() >= X86SSEEnum.AVX.getValue()) {
                    return Unsigned.$lesseq_uint((int)Size, (int)256);
                }
                return this.SSELevel.getValue() >= X86SSEEnum.SSE2.getValue() && Unsigned.$lesseq_uint((int)Size, (int)128);
            }
        }
        return true;
    }

    @Override
    public std.string convertConstraint(char.ptr Constraint) {
        switch (Constraint.$star()) {
            case 97: {
                return new std.string((CharSequence)"{ax}");
            }
            case 98: {
                return new std.string((CharSequence)"{bx}");
            }
            case 99: {
                return new std.string((CharSequence)"{cx}");
            }
            case 100: {
                return new std.string((CharSequence)"{dx}");
            }
            case 83: {
                return new std.string((CharSequence)"{si}");
            }
            case 68: {
                return new std.string((CharSequence)"{di}");
            }
            case 112: {
                return new std.string((CharSequence)"im");
            }
            case 116: {
                return new std.string((CharSequence)"{st}");
            }
            case 117: {
                return new std.string((CharSequence)"{st(1)}");
            }
        }
        return new std.string(1, Constraint.$star());
    }

    @Override
    public char.ptr getClobbers() {
        return NativePointer.$((String)"~{dirflag},~{fpsr},~{flags}");
    }

    @Override
    public void getTargetDefines(LangOptions Opts, MacroBuilder Builder2) {
        if (this.getTriple().getArch() == Triple.ArchType.x86_64) {
            Builder2.defineMacro(new Twine("__amd64__"));
            Builder2.defineMacro(new Twine("__amd64"));
            Builder2.defineMacro(new Twine("__x86_64"));
            Builder2.defineMacro(new Twine("__x86_64__"));
            if (llvm.$eq_StringRef((StringRef)this.getTriple().getArchName(), (String)"x86_64h")) {
                Builder2.defineMacro(new Twine("__x86_64h"));
                Builder2.defineMacro(new Twine("__x86_64h__"));
            }
        } else {
            TargetsStatics.DefineStd(Builder2, new StringRef("i386"), Opts);
        }
        switch (this.CPU) {
            case CK_Generic: {
                break;
            }
            case CK_i386: {
                Builder2.defineMacro(new Twine("__tune_i386__"));
                break;
            }
            case CK_i486: 
            case CK_WinChipC6: 
            case CK_WinChip2: 
            case CK_C3: {
                TargetsStatics.defineCPUMacros(Builder2, new StringRef("i486"));
                break;
            }
            case CK_PentiumMMX: {
                Builder2.defineMacro(new Twine("__pentium_mmx__"));
                Builder2.defineMacro(new Twine("__tune_pentium_mmx__"));
            }
            case CK_i586: 
            case CK_Pentium: {
                TargetsStatics.defineCPUMacros(Builder2, new StringRef("i586"));
                TargetsStatics.defineCPUMacros(Builder2, new StringRef("pentium"));
                break;
            }
            case CK_Pentium3: 
            case CK_Pentium3M: 
            case CK_PentiumM: {
                Builder2.defineMacro(new Twine("__tune_pentium3__"));
            }
            case CK_Pentium2: 
            case CK_C3_2: {
                Builder2.defineMacro(new Twine("__tune_pentium2__"));
            }
            case CK_PentiumPro: {
                Builder2.defineMacro(new Twine("__tune_i686__"));
                Builder2.defineMacro(new Twine("__tune_pentiumpro__"));
            }
            case CK_i686: {
                Builder2.defineMacro(new Twine("__i686"));
                Builder2.defineMacro(new Twine("__i686__"));
                Builder2.defineMacro(new Twine("__pentiumpro"));
                Builder2.defineMacro(new Twine("__pentiumpro__"));
                break;
            }
            case CK_Pentium4: 
            case CK_Pentium4M: {
                TargetsStatics.defineCPUMacros(Builder2, new StringRef("pentium4"));
                break;
            }
            case CK_Yonah: 
            case CK_Prescott: 
            case CK_Nocona: {
                TargetsStatics.defineCPUMacros(Builder2, new StringRef("nocona"));
                break;
            }
            case CK_Core2: 
            case CK_Penryn: {
                TargetsStatics.defineCPUMacros(Builder2, new StringRef("core2"));
                break;
            }
            case CK_Bonnell: {
                TargetsStatics.defineCPUMacros(Builder2, new StringRef("atom"));
                break;
            }
            case CK_Silvermont: {
                TargetsStatics.defineCPUMacros(Builder2, new StringRef("slm"));
                break;
            }
            case CK_Nehalem: 
            case CK_Westmere: 
            case CK_SandyBridge: 
            case CK_IvyBridge: 
            case CK_Haswell: 
            case CK_Broadwell: 
            case CK_SkylakeClient: {
                TargetsStatics.defineCPUMacros(Builder2, new StringRef("corei7"));
                break;
            }
            case CK_SkylakeServer: {
                TargetsStatics.defineCPUMacros(Builder2, new StringRef("skx"));
                break;
            }
            case CK_Cannonlake: {
                break;
            }
            case CK_KNL: {
                TargetsStatics.defineCPUMacros(Builder2, new StringRef("knl"));
                break;
            }
            case CK_Lakemont: {
                Builder2.defineMacro(new Twine("__tune_lakemont__"));
                break;
            }
            case CK_K6_2: {
                Builder2.defineMacro(new Twine("__k6_2__"));
                Builder2.defineMacro(new Twine("__tune_k6_2__"));
            }
            case CK_K6_3: {
                if (this.CPU != CPUKind.CK_K6_2) {
                    Builder2.defineMacro(new Twine("__k6_3__"));
                    Builder2.defineMacro(new Twine("__tune_k6_3__"));
                }
            }
            case CK_K6: {
                TargetsStatics.defineCPUMacros(Builder2, new StringRef("k6"));
                break;
            }
            case CK_Athlon: 
            case CK_AthlonThunderbird: 
            case CK_Athlon4: 
            case CK_AthlonXP: 
            case CK_AthlonMP: {
                TargetsStatics.defineCPUMacros(Builder2, new StringRef("athlon"));
                if (this.SSELevel == X86SSEEnum.NoSSE) break;
                Builder2.defineMacro(new Twine("__athlon_sse__"));
                Builder2.defineMacro(new Twine("__tune_athlon_sse__"));
                break;
            }
            case CK_K8: 
            case CK_K8SSE3: 
            case CK_x86_64: 
            case CK_Opteron: 
            case CK_OpteronSSE3: 
            case CK_Athlon64: 
            case CK_Athlon64SSE3: 
            case CK_AthlonFX: {
                TargetsStatics.defineCPUMacros(Builder2, new StringRef("k8"));
                break;
            }
            case CK_AMDFAM10: {
                TargetsStatics.defineCPUMacros(Builder2, new StringRef("amdfam10"));
                break;
            }
            case CK_BTVER1: {
                TargetsStatics.defineCPUMacros(Builder2, new StringRef("btver1"));
                break;
            }
            case CK_BTVER2: {
                TargetsStatics.defineCPUMacros(Builder2, new StringRef("btver2"));
                break;
            }
            case CK_BDVER1: {
                TargetsStatics.defineCPUMacros(Builder2, new StringRef("bdver1"));
                break;
            }
            case CK_BDVER2: {
                TargetsStatics.defineCPUMacros(Builder2, new StringRef("bdver2"));
                break;
            }
            case CK_BDVER3: {
                TargetsStatics.defineCPUMacros(Builder2, new StringRef("bdver3"));
                break;
            }
            case CK_BDVER4: {
                TargetsStatics.defineCPUMacros(Builder2, new StringRef("bdver4"));
                break;
            }
            case CK_Geode: {
                TargetsStatics.defineCPUMacros(Builder2, new StringRef("geode"));
            }
        }
        Builder2.defineMacro(new Twine("__REGISTER_PREFIX__"), new Twine(NativePointer.$EMPTY));
        Builder2.defineMacro(new Twine("__NO_MATH_INLINES"));
        if (this.HasAES) {
            Builder2.defineMacro(new Twine("__AES__"));
        }
        if (this.HasPCLMUL) {
            Builder2.defineMacro(new Twine("__PCLMUL__"));
        }
        if (this.HasLZCNT) {
            Builder2.defineMacro(new Twine("__LZCNT__"));
        }
        if (this.HasRDRND) {
            Builder2.defineMacro(new Twine("__RDRND__"));
        }
        if (this.HasFSGSBASE) {
            Builder2.defineMacro(new Twine("__FSGSBASE__"));
        }
        if (this.HasBMI) {
            Builder2.defineMacro(new Twine("__BMI__"));
        }
        if (this.HasBMI2) {
            Builder2.defineMacro(new Twine("__BMI2__"));
        }
        if (this.HasPOPCNT) {
            Builder2.defineMacro(new Twine("__POPCNT__"));
        }
        if (this.HasRTM) {
            Builder2.defineMacro(new Twine("__RTM__"));
        }
        if (this.HasPRFCHW) {
            Builder2.defineMacro(new Twine("__PRFCHW__"));
        }
        if (this.HasRDSEED) {
            Builder2.defineMacro(new Twine("__RDSEED__"));
        }
        if (this.HasADX) {
            Builder2.defineMacro(new Twine("__ADX__"));
        }
        if (this.HasTBM) {
            Builder2.defineMacro(new Twine("__TBM__"));
        }
        if (this.HasMWAITX) {
            Builder2.defineMacro(new Twine("__MWAITX__"));
        }
        switch (this.XOPLevel) {
            case XOP: {
                Builder2.defineMacro(new Twine("__XOP__"));
            }
            case FMA4: {
                Builder2.defineMacro(new Twine("__FMA4__"));
            }
            case SSE4A: {
                Builder2.defineMacro(new Twine("__SSE4A__"));
            }
        }
        if (this.HasFMA) {
            Builder2.defineMacro(new Twine("__FMA__"));
        }
        if (this.HasF16C) {
            Builder2.defineMacro(new Twine("__F16C__"));
        }
        if (this.HasAVX512CD) {
            Builder2.defineMacro(new Twine("__AVX512CD__"));
        }
        if (this.HasAVX512ER) {
            Builder2.defineMacro(new Twine("__AVX512ER__"));
        }
        if (this.HasAVX512PF) {
            Builder2.defineMacro(new Twine("__AVX512PF__"));
        }
        if (this.HasAVX512DQ) {
            Builder2.defineMacro(new Twine("__AVX512DQ__"));
        }
        if (this.HasAVX512BW) {
            Builder2.defineMacro(new Twine("__AVX512BW__"));
        }
        if (this.HasAVX512VL) {
            Builder2.defineMacro(new Twine("__AVX512VL__"));
        }
        if (this.HasAVX512VBMI) {
            Builder2.defineMacro(new Twine("__AVX512VBMI__"));
        }
        if (this.HasAVX512IFMA) {
            Builder2.defineMacro(new Twine("__AVX512IFMA__"));
        }
        if (this.HasSHA) {
            Builder2.defineMacro(new Twine("__SHA__"));
        }
        if (this.HasFXSR) {
            Builder2.defineMacro(new Twine("__FXSR__"));
        }
        if (this.HasXSAVE) {
            Builder2.defineMacro(new Twine("__XSAVE__"));
        }
        if (this.HasXSAVEOPT) {
            Builder2.defineMacro(new Twine("__XSAVEOPT__"));
        }
        if (this.HasXSAVEC) {
            Builder2.defineMacro(new Twine("__XSAVEC__"));
        }
        if (this.HasXSAVES) {
            Builder2.defineMacro(new Twine("__XSAVES__"));
        }
        if (this.HasPKU) {
            Builder2.defineMacro(new Twine("__PKU__"));
        }
        if (this.HasCX16) {
            Builder2.defineMacro(new Twine("__GCC_HAVE_SYNC_COMPARE_AND_SWAP_16"));
        }
        switch (this.SSELevel) {
            case AVX512F: {
                Builder2.defineMacro(new Twine("__AVX512F__"));
            }
            case AVX2: {
                Builder2.defineMacro(new Twine("__AVX2__"));
            }
            case AVX: {
                Builder2.defineMacro(new Twine("__AVX__"));
            }
            case SSE42: {
                Builder2.defineMacro(new Twine("__SSE4_2__"));
            }
            case SSE41: {
                Builder2.defineMacro(new Twine("__SSE4_1__"));
            }
            case SSSE3: {
                Builder2.defineMacro(new Twine("__SSSE3__"));
            }
            case SSE3: {
                Builder2.defineMacro(new Twine("__SSE3__"));
            }
            case SSE2: {
                Builder2.defineMacro(new Twine("__SSE2__"));
                Builder2.defineMacro(new Twine("__SSE2_MATH__"));
            }
            case SSE1: {
                Builder2.defineMacro(new Twine("__SSE__"));
                Builder2.defineMacro(new Twine("__SSE_MATH__"));
            }
        }
        if (Opts.MicrosoftExt && this.getTriple().getArch() == Triple.ArchType.x86) {
            switch (this.SSELevel) {
                case AVX512F: 
                case AVX2: 
                case AVX: 
                case SSE42: 
                case SSE41: 
                case SSSE3: 
                case SSE3: 
                case SSE2: {
                    Builder2.defineMacro(new Twine("_M_IX86_FP"), new Twine(JavaDifferentiators.JD$Int.INSTANCE, 2));
                    break;
                }
                case SSE1: {
                    Builder2.defineMacro(new Twine("_M_IX86_FP"), new Twine(JavaDifferentiators.JD$Int.INSTANCE, 1));
                    break;
                }
                default: {
                    Builder2.defineMacro(new Twine("_M_IX86_FP"), new Twine(JavaDifferentiators.JD$Int.INSTANCE, 0));
                }
            }
        }
        switch (this.MMX3DNowLevel) {
            case AMD3DNowAthlon: {
                Builder2.defineMacro(new Twine("__3dNOW_A__"));
            }
            case AMD3DNow: {
                Builder2.defineMacro(new Twine("__3dNOW__"));
            }
            case MMX: {
                Builder2.defineMacro(new Twine("__MMX__"));
            }
        }
        if (this.CPU.getValue() >= CPUKind.CK_i486.getValue()) {
            Builder2.defineMacro(new Twine("__GCC_HAVE_SYNC_COMPARE_AND_SWAP_1"));
            Builder2.defineMacro(new Twine("__GCC_HAVE_SYNC_COMPARE_AND_SWAP_2"));
            Builder2.defineMacro(new Twine("__GCC_HAVE_SYNC_COMPARE_AND_SWAP_4"));
        }
        if (this.CPU.getValue() >= CPUKind.CK_i586.getValue()) {
            Builder2.defineMacro(new Twine("__GCC_HAVE_SYNC_COMPARE_AND_SWAP_8"));
        }
    }

    public static void setSSELevel(StringMapBool Features, X86SSEEnum Level2, boolean Enabled) {
        if (Enabled) {
            switch (Level2) {
                case AVX512F: {
                    Features.$set("avx512f", true);
                }
                case AVX2: {
                    Features.$set("avx2", true);
                }
                case AVX: {
                    Features.$set("avx", true);
                    Features.$set("xsave", true);
                }
                case SSE42: {
                    Features.$set("sse4.2", true);
                }
                case SSE41: {
                    Features.$set("sse4.1", true);
                }
                case SSSE3: {
                    Features.$set("ssse3", true);
                }
                case SSE3: {
                    Features.$set("sse3", true);
                }
                case SSE2: {
                    Features.$set("sse2", true);
                }
                case SSE1: {
                    Features.$set("sse", true);
                }
            }
            return;
        }
        switch (Level2) {
            case SSE1: 
            case NoSSE: {
                Features.$set("sse", false);
            }
            case SSE2: {
                Features.$set("sse2", false);
                Features.$set("pclmul", false);
                Features.$set("aes", false);
                Features.$set("sha", false);
            }
            case SSE3: {
                Features.$set("sse3", false);
                X86TargetInfo.setXOPLevel(Features, XOPEnum.NoXOP, false);
            }
            case SSSE3: {
                Features.$set("ssse3", false);
            }
            case SSE41: {
                Features.$set("sse4.1", false);
            }
            case SSE42: {
                Features.$set("sse4.2", false);
            }
            case AVX: {
                Features.$set("fma", false);
                Features.$set("avx", false);
                Features.$set("f16c", false);
                Features.$set("xsave", false);
                Features.$set("xsaveopt", false);
                X86TargetInfo.setXOPLevel(Features, XOPEnum.FMA4, false);
            }
            case AVX2: {
                Features.$set("avx2", false);
            }
            case AVX512F: {
                Features.$set("avx512f", false);
                Features.$set("avx512cd", false);
                Features.$set("avx512er", false);
                Features.$set("avx512pf", false);
                Features.$set("avx512dq", false);
                Features.$set("avx512bw", false);
                Features.$set("avx512vl", false);
                Features.$set("avx512vbmi", false);
                Features.$set("avx512ifma", false);
            }
        }
    }

    public static void setMMXLevel(StringMapBool Features, MMX3DNowEnum Level2, boolean Enabled) {
        if (Enabled) {
            switch (Level2) {
                case AMD3DNowAthlon: {
                    Features.$set("3dnowa", true);
                }
                case AMD3DNow: {
                    Features.$set("3dnow", true);
                }
                case MMX: {
                    Features.$set("mmx", true);
                }
            }
            return;
        }
        switch (Level2) {
            case MMX: 
            case NoMMX3DNow: {
                Features.$set("mmx", false);
            }
            case AMD3DNow: {
                Features.$set("3dnow", false);
            }
            case AMD3DNowAthlon: {
                Features.$set("3dnowa", false);
            }
        }
    }

    public static void setXOPLevel(StringMapBool Features, XOPEnum Level2, boolean Enabled) {
        if (Enabled) {
            switch (Level2) {
                case XOP: {
                    Features.$set("xop", true);
                }
                case FMA4: {
                    Features.$set("fma4", true);
                    X86TargetInfo.setSSELevel(Features, X86SSEEnum.AVX, true);
                }
                case SSE4A: {
                    Features.$set("sse4a", true);
                    X86TargetInfo.setSSELevel(Features, X86SSEEnum.SSE3, true);
                }
            }
            return;
        }
        switch (Level2) {
            case SSE4A: 
            case NoXOP: {
                Features.$set("sse4a", false);
            }
            case FMA4: {
                Features.$set("fma4", false);
            }
            case XOP: {
                Features.$set("xop", false);
            }
        }
    }

    @Override
    public void setFeatureEnabled(StringMapBool Features, StringRef Name, boolean Enabled) {
        X86TargetInfo.setFeatureEnabledImpl(Features, Name, Enabled);
    }

    public static void setFeatureEnabledImpl(StringMapBool Features, StringRef Name, boolean Enabled) {
        if (llvm.$noteq_StringRef((StringRef)Name, (String)"sse4")) {
            Features.$set(Name, Enabled);
        }
        if (llvm.$eq_StringRef((StringRef)Name, (String)"mmx")) {
            X86TargetInfo.setMMXLevel(Features, MMX3DNowEnum.MMX, Enabled);
        } else if (llvm.$eq_StringRef((StringRef)Name, (String)"sse")) {
            X86TargetInfo.setSSELevel(Features, X86SSEEnum.SSE1, Enabled);
        } else if (llvm.$eq_StringRef((StringRef)Name, (String)"sse2")) {
            X86TargetInfo.setSSELevel(Features, X86SSEEnum.SSE2, Enabled);
        } else if (llvm.$eq_StringRef((StringRef)Name, (String)"sse3")) {
            X86TargetInfo.setSSELevel(Features, X86SSEEnum.SSE3, Enabled);
        } else if (llvm.$eq_StringRef((StringRef)Name, (String)"ssse3")) {
            X86TargetInfo.setSSELevel(Features, X86SSEEnum.SSSE3, Enabled);
        } else if (llvm.$eq_StringRef((StringRef)Name, (String)"sse4.2")) {
            X86TargetInfo.setSSELevel(Features, X86SSEEnum.SSE42, Enabled);
        } else if (llvm.$eq_StringRef((StringRef)Name, (String)"sse4.1")) {
            X86TargetInfo.setSSELevel(Features, X86SSEEnum.SSE41, Enabled);
        } else if (llvm.$eq_StringRef((StringRef)Name, (String)"3dnow")) {
            X86TargetInfo.setMMXLevel(Features, MMX3DNowEnum.AMD3DNow, Enabled);
        } else if (llvm.$eq_StringRef((StringRef)Name, (String)"3dnowa")) {
            X86TargetInfo.setMMXLevel(Features, MMX3DNowEnum.AMD3DNowAthlon, Enabled);
        } else if (llvm.$eq_StringRef((StringRef)Name, (String)"aes")) {
            if (Enabled) {
                X86TargetInfo.setSSELevel(Features, X86SSEEnum.SSE2, Enabled);
            }
        } else if (llvm.$eq_StringRef((StringRef)Name, (String)"pclmul")) {
            if (Enabled) {
                X86TargetInfo.setSSELevel(Features, X86SSEEnum.SSE2, Enabled);
            }
        } else if (llvm.$eq_StringRef((StringRef)Name, (String)"avx")) {
            X86TargetInfo.setSSELevel(Features, X86SSEEnum.AVX, Enabled);
        } else if (llvm.$eq_StringRef((StringRef)Name, (String)"avx2")) {
            X86TargetInfo.setSSELevel(Features, X86SSEEnum.AVX2, Enabled);
        } else if (llvm.$eq_StringRef((StringRef)Name, (String)"avx512f")) {
            X86TargetInfo.setSSELevel(Features, X86SSEEnum.AVX512F, Enabled);
        } else if (llvm.$eq_StringRef((StringRef)Name, (String)"avx512cd") || llvm.$eq_StringRef((StringRef)Name, (String)"avx512er") || llvm.$eq_StringRef((StringRef)Name, (String)"avx512pf") || llvm.$eq_StringRef((StringRef)Name, (String)"avx512dq") || llvm.$eq_StringRef((StringRef)Name, (String)"avx512bw") || llvm.$eq_StringRef((StringRef)Name, (String)"avx512vl") || llvm.$eq_StringRef((StringRef)Name, (String)"avx512vbmi") || llvm.$eq_StringRef((StringRef)Name, (String)"avx512ifma")) {
            if (Enabled) {
                X86TargetInfo.setSSELevel(Features, X86SSEEnum.AVX512F, Enabled);
            }
        } else if (llvm.$eq_StringRef((StringRef)Name, (String)"fma")) {
            if (Enabled) {
                X86TargetInfo.setSSELevel(Features, X86SSEEnum.AVX, Enabled);
            }
        } else if (llvm.$eq_StringRef((StringRef)Name, (String)"fma4")) {
            X86TargetInfo.setXOPLevel(Features, XOPEnum.FMA4, Enabled);
        } else if (llvm.$eq_StringRef((StringRef)Name, (String)"xop")) {
            X86TargetInfo.setXOPLevel(Features, XOPEnum.XOP, Enabled);
        } else if (llvm.$eq_StringRef((StringRef)Name, (String)"sse4a")) {
            X86TargetInfo.setXOPLevel(Features, XOPEnum.SSE4A, Enabled);
        } else if (llvm.$eq_StringRef((StringRef)Name, (String)"f16c")) {
            if (Enabled) {
                X86TargetInfo.setSSELevel(Features, X86SSEEnum.AVX, Enabled);
            }
        } else if (llvm.$eq_StringRef((StringRef)Name, (String)"sha")) {
            if (Enabled) {
                X86TargetInfo.setSSELevel(Features, X86SSEEnum.SSE2, Enabled);
            }
        } else if (llvm.$eq_StringRef((StringRef)Name, (String)"sse4")) {
            if (Enabled) {
                X86TargetInfo.setSSELevel(Features, X86SSEEnum.SSE42, Enabled);
            } else {
                X86TargetInfo.setSSELevel(Features, X86SSEEnum.SSE41, Enabled);
            }
        } else if (llvm.$eq_StringRef((StringRef)Name, (String)"xsave")) {
            if (!Enabled) {
                Features.$set("xsaveopt", false);
            }
        } else if ((llvm.$eq_StringRef((StringRef)Name, (String)"xsaveopt") || llvm.$eq_StringRef((StringRef)Name, (String)"xsavec") || llvm.$eq_StringRef((StringRef)Name, (String)"xsaves")) && Enabled) {
            Features.$set("xsave", true);
        }
    }

    @Override
    public boolean initFeatureMap(StringMapBool Features, DiagnosticsEngine Diags, StringRef CPU, std.vectorString FeaturesVec) {
        CPUKind Kind2;
        if (this.getTriple().getArch() == Triple.ArchType.x86_64) {
            X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("sse2"), true);
        }
        if ((Kind2 = this.getCPUKind(CPU)) != CPUKind.CK_Lakemont) {
            X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("x87"), true);
        }
        switch (Kind2) {
            case CK_Generic: 
            case CK_i386: 
            case CK_i486: 
            case CK_i586: 
            case CK_Pentium: 
            case CK_PentiumPro: 
            case CK_i686: 
            case CK_Lakemont: {
                break;
            }
            case CK_WinChipC6: 
            case CK_PentiumMMX: 
            case CK_Pentium2: 
            case CK_K6: {
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("mmx"), true);
                break;
            }
            case CK_Pentium3: 
            case CK_Pentium3M: 
            case CK_C3_2: {
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("sse"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("fxsr"), true);
                break;
            }
            case CK_PentiumM: 
            case CK_Pentium4: 
            case CK_Pentium4M: 
            case CK_x86_64: {
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("sse2"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("fxsr"), true);
                break;
            }
            case CK_Yonah: 
            case CK_Prescott: 
            case CK_Nocona: {
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("sse3"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("fxsr"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("cx16"), true);
                break;
            }
            case CK_Core2: 
            case CK_Bonnell: {
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("ssse3"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("fxsr"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("cx16"), true);
                break;
            }
            case CK_Penryn: {
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("sse4.1"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("fxsr"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("cx16"), true);
                break;
            }
            case CK_Cannonlake: {
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("avx512ifma"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("avx512vbmi"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("sha"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("umip"), true);
            }
            case CK_SkylakeServer: {
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("avx512f"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("avx512cd"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("avx512dq"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("avx512bw"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("avx512vl"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("pku"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("pcommit"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("clwb"), true);
            }
            case CK_SkylakeClient: {
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("xsavec"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("xsaves"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("mpx"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("sgx"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("clflushopt"), true);
            }
            case CK_Broadwell: {
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("rdseed"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("adx"), true);
            }
            case CK_Haswell: {
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("avx2"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("lzcnt"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("bmi"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("bmi2"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("rtm"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("fma"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("movbe"), true);
            }
            case CK_IvyBridge: {
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("rdrnd"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("f16c"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("fsgsbase"), true);
            }
            case CK_SandyBridge: {
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("avx"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("xsave"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("xsaveopt"), true);
            }
            case CK_Silvermont: 
            case CK_Westmere: {
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("aes"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("pclmul"), true);
            }
            case CK_Nehalem: {
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("sse4.2"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("fxsr"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("cx16"), true);
                break;
            }
            case CK_KNL: {
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("avx512f"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("avx512cd"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("avx512er"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("avx512pf"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("prefetchwt1"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("fxsr"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("rdseed"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("adx"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("lzcnt"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("bmi"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("bmi2"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("rtm"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("fma"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("rdrnd"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("f16c"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("fsgsbase"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("aes"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("pclmul"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("cx16"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("xsaveopt"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("xsave"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("movbe"), true);
                break;
            }
            case CK_WinChip2: 
            case CK_C3: 
            case CK_K6_2: 
            case CK_K6_3: {
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("3dnow"), true);
                break;
            }
            case CK_Athlon: 
            case CK_AthlonThunderbird: 
            case CK_Geode: {
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("3dnowa"), true);
                break;
            }
            case CK_Athlon4: 
            case CK_AthlonXP: 
            case CK_AthlonMP: {
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("sse"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("3dnowa"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("fxsr"), true);
                break;
            }
            case CK_K8: 
            case CK_Opteron: 
            case CK_Athlon64: 
            case CK_AthlonFX: {
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("sse2"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("3dnowa"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("fxsr"), true);
                break;
            }
            case CK_AMDFAM10: {
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("sse4a"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("lzcnt"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("popcnt"), true);
            }
            case CK_K8SSE3: 
            case CK_OpteronSSE3: 
            case CK_Athlon64SSE3: {
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("sse3"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("3dnowa"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("fxsr"), true);
                break;
            }
            case CK_BTVER2: {
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("avx"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("aes"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("pclmul"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("bmi"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("f16c"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("xsaveopt"), true);
            }
            case CK_BTVER1: {
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("ssse3"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("sse4a"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("lzcnt"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("popcnt"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("prfchw"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("cx16"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("fxsr"), true);
                break;
            }
            case CK_BDVER4: {
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("avx2"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("bmi2"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("mwaitx"), true);
            }
            case CK_BDVER3: {
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("fsgsbase"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("xsaveopt"), true);
            }
            case CK_BDVER2: {
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("bmi"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("fma"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("f16c"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("tbm"), true);
            }
            case CK_BDVER1: {
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("xop"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("lzcnt"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("aes"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("pclmul"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("prfchw"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("cx16"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("fxsr"), true);
                X86TargetInfo.setFeatureEnabledImpl(Features, new StringRef("xsave"), true);
            }
        }
        if (!super.initFeatureMap(Features, Diags, CPU, FeaturesVec)) {
            return false;
        }
        StringMapIteratorBool I = Features.find("sse4.2");
        if (I.$noteq((StringMapConstIteratorBool)Features.end()) && I.$arrow().getValue() && std.$eq___normal_iterator$C((StdVectorString.iterator)((StdVectorString.iterator)std.find((type.iterator)FeaturesVec.begin(), (type.iterator)FeaturesVec.end(), (Object)"-popcnt")), (StdVectorString.iterator)FeaturesVec.end())) {
            Features.$set("popcnt", true);
        }
        I.$assignMove(Features.find("3dnow"));
        if (I.$noteq((StringMapConstIteratorBool)Features.end()) && I.$arrow().getValue() && std.$eq___normal_iterator$C((StdVectorString.iterator)((StdVectorString.iterator)std.find((type.iterator)FeaturesVec.begin(), (type.iterator)FeaturesVec.end(), (Object)"-prfchw")), (StdVectorString.iterator)FeaturesVec.end())) {
            Features.$set("prfchw", true);
        }
        I.$assignMove(Features.find("sse"));
        if (I.$noteq((StringMapConstIteratorBool)Features.end()) && I.$arrow().getValue() && std.$eq___normal_iterator$C((StdVectorString.iterator)((StdVectorString.iterator)std.find((type.iterator)FeaturesVec.begin(), (type.iterator)FeaturesVec.end(), (Object)"-mmx")), (StdVectorString.iterator)FeaturesVec.end())) {
            Features.$set("mmx", true);
        }
        return true;
    }

    @Override
    public boolean hasFeature(StringRef Feature2) {
        return new StringSwitchBool(Feature2).Case("aes", this.HasAES).Case("avx", this.SSELevel.getValue() >= X86SSEEnum.AVX.getValue()).Case("avx2", this.SSELevel.getValue() >= X86SSEEnum.AVX2.getValue()).Case("avx512f", this.SSELevel.getValue() >= X86SSEEnum.AVX512F.getValue()).Case("avx512cd", this.HasAVX512CD).Case("avx512er", this.HasAVX512ER).Case("avx512pf", this.HasAVX512PF).Case("avx512dq", this.HasAVX512DQ).Case("avx512bw", this.HasAVX512BW).Case("avx512vl", this.HasAVX512VL).Case("avx512vbmi", this.HasAVX512VBMI).Case("avx512ifma", this.HasAVX512IFMA).Case("bmi", this.HasBMI).Case("bmi2", this.HasBMI2).Case("clflushopt", this.HasCLFLUSHOPT).Case("clwb", this.HasCLWB).Case("cx16", this.HasCX16).Case("f16c", this.HasF16C).Case("fma", this.HasFMA).Case("fma4", this.XOPLevel.getValue() >= XOPEnum.FMA4.getValue()).Case("fsgsbase", this.HasFSGSBASE).Case("fxsr", this.HasFXSR).Case("lzcnt", this.HasLZCNT).Case("mm3dnow", this.MMX3DNowLevel.getValue() >= MMX3DNowEnum.AMD3DNow.getValue()).Case("mm3dnowa", this.MMX3DNowLevel.getValue() >= MMX3DNowEnum.AMD3DNowAthlon.getValue()).Case("mmx", this.MMX3DNowLevel.getValue() >= MMX3DNowEnum.MMX.getValue()).Case("movbe", this.HasMOVBE).Case("mpx", this.HasMPX).Case("pclmul", this.HasPCLMUL).Case("pcommit", this.HasPCOMMIT).Case("pku", this.HasPKU).Case("popcnt", this.HasPOPCNT).Case("prefetchwt1", this.HasPREFETCHWT1).Case("prfchw", this.HasPRFCHW).Case("rdrnd", this.HasRDRND).Case("rdseed", this.HasRDSEED).Case("rtm", this.HasRTM).Case("sgx", this.HasSGX).Case("sha", this.HasSHA).Case("sse", this.SSELevel.getValue() >= X86SSEEnum.SSE1.getValue()).Case("sse2", this.SSELevel.getValue() >= X86SSEEnum.SSE2.getValue()).Case("sse3", this.SSELevel.getValue() >= X86SSEEnum.SSE3.getValue()).Case("ssse3", this.SSELevel.getValue() >= X86SSEEnum.SSSE3.getValue()).Case("sse4.1", this.SSELevel.getValue() >= X86SSEEnum.SSE41.getValue()).Case("sse4.2", this.SSELevel.getValue() >= X86SSEEnum.SSE42.getValue()).Case("sse4a", this.XOPLevel.getValue() >= XOPEnum.SSE4A.getValue()).Case("tbm", this.HasTBM).Case("umip", this.HasUMIP).Case("x86", true).Case("x86_32", this.getTriple().getArch() == Triple.ArchType.x86).Case("x86_64", this.getTriple().getArch() == Triple.ArchType.x86_64).Case("xop", this.XOPLevel.getValue() >= XOPEnum.XOP.getValue()).Case("xsave", this.HasXSAVE).Case("xsavec", this.HasXSAVEC).Case("xsaves", this.HasXSAVES).Case("xsaveopt", this.HasXSAVEOPT).Default(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleTargetFeatures(std.vectorString Features, DiagnosticsEngine Diags) {
        for (std.string Feature2 : Features) {
            if (Feature2.$at(0) != 43) continue;
            if (std.$eq_string$C_T((std.string)Feature2, (String)"+aes")) {
                this.HasAES = true;
            } else if (std.$eq_string$C_T((std.string)Feature2, (String)"+pclmul")) {
                this.HasPCLMUL = true;
            } else if (std.$eq_string$C_T((std.string)Feature2, (String)"+lzcnt")) {
                this.HasLZCNT = true;
            } else if (std.$eq_string$C_T((std.string)Feature2, (String)"+rdrnd")) {
                this.HasRDRND = true;
            } else if (std.$eq_string$C_T((std.string)Feature2, (String)"+fsgsbase")) {
                this.HasFSGSBASE = true;
            } else if (std.$eq_string$C_T((std.string)Feature2, (String)"+bmi")) {
                this.HasBMI = true;
            } else if (std.$eq_string$C_T((std.string)Feature2, (String)"+bmi2")) {
                this.HasBMI2 = true;
            } else if (std.$eq_string$C_T((std.string)Feature2, (String)"+popcnt")) {
                this.HasPOPCNT = true;
            } else if (std.$eq_string$C_T((std.string)Feature2, (String)"+rtm")) {
                this.HasRTM = true;
            } else if (std.$eq_string$C_T((std.string)Feature2, (String)"+prfchw")) {
                this.HasPRFCHW = true;
            } else if (std.$eq_string$C_T((std.string)Feature2, (String)"+rdseed")) {
                this.HasRDSEED = true;
            } else if (std.$eq_string$C_T((std.string)Feature2, (String)"+adx")) {
                this.HasADX = true;
            } else if (std.$eq_string$C_T((std.string)Feature2, (String)"+tbm")) {
                this.HasTBM = true;
            } else if (std.$eq_string$C_T((std.string)Feature2, (String)"+fma")) {
                this.HasFMA = true;
            } else if (std.$eq_string$C_T((std.string)Feature2, (String)"+f16c")) {
                this.HasF16C = true;
            } else if (std.$eq_string$C_T((std.string)Feature2, (String)"+avx512cd")) {
                this.HasAVX512CD = true;
            } else if (std.$eq_string$C_T((std.string)Feature2, (String)"+avx512er")) {
                this.HasAVX512ER = true;
            } else if (std.$eq_string$C_T((std.string)Feature2, (String)"+avx512pf")) {
                this.HasAVX512PF = true;
            } else if (std.$eq_string$C_T((std.string)Feature2, (String)"+avx512dq")) {
                this.HasAVX512DQ = true;
            } else if (std.$eq_string$C_T((std.string)Feature2, (String)"+avx512bw")) {
                this.HasAVX512BW = true;
            } else if (std.$eq_string$C_T((std.string)Feature2, (String)"+avx512vl")) {
                this.HasAVX512VL = true;
            } else if (std.$eq_string$C_T((std.string)Feature2, (String)"+avx512vbmi")) {
                this.HasAVX512VBMI = true;
            } else if (std.$eq_string$C_T((std.string)Feature2, (String)"+avx512ifma")) {
                this.HasAVX512IFMA = true;
            } else if (std.$eq_string$C_T((std.string)Feature2, (String)"+sha")) {
                this.HasSHA = true;
            } else if (std.$eq_string$C_T((std.string)Feature2, (String)"+mpx")) {
                this.HasMPX = true;
            } else if (std.$eq_string$C_T((std.string)Feature2, (String)"+movbe")) {
                this.HasMOVBE = true;
            } else if (std.$eq_string$C_T((std.string)Feature2, (String)"+sgx")) {
                this.HasSGX = true;
            } else if (std.$eq_string$C_T((std.string)Feature2, (String)"+cx16")) {
                this.HasCX16 = true;
            } else if (std.$eq_string$C_T((std.string)Feature2, (String)"+fxsr")) {
                this.HasFXSR = true;
            } else if (std.$eq_string$C_T((std.string)Feature2, (String)"+xsave")) {
                this.HasXSAVE = true;
            } else if (std.$eq_string$C_T((std.string)Feature2, (String)"+xsaveopt")) {
                this.HasXSAVEOPT = true;
            } else if (std.$eq_string$C_T((std.string)Feature2, (String)"+xsavec")) {
                this.HasXSAVEC = true;
            } else if (std.$eq_string$C_T((std.string)Feature2, (String)"+xsaves")) {
                this.HasXSAVES = true;
            } else if (std.$eq_string$C_T((std.string)Feature2, (String)"+mwaitx")) {
                this.HasMWAITX = true;
            } else if (std.$eq_string$C_T((std.string)Feature2, (String)"+pku")) {
                this.HasPKU = true;
            } else if (std.$eq_string$C_T((std.string)Feature2, (String)"+clflushopt")) {
                this.HasCLFLUSHOPT = true;
            } else if (std.$eq_string$C_T((std.string)Feature2, (String)"+pcommit")) {
                this.HasPCOMMIT = true;
            } else if (std.$eq_string$C_T((std.string)Feature2, (String)"+clwb")) {
                this.HasCLWB = true;
            } else if (std.$eq_string$C_T((std.string)Feature2, (String)"+umip")) {
                this.HasUMIP = true;
            } else if (std.$eq_string$C_T((std.string)Feature2, (String)"+prefetchwt1")) {
                this.HasPREFETCHWT1 = true;
            }
            X86SSEEnum Level2 = (X86SSEEnum)((Object)new StringSwitch(new StringRef(Feature2)).Case("+avx512f", (Object)X86SSEEnum.AVX512F).Case("+avx2", (Object)X86SSEEnum.AVX2).Case("+avx", (Object)X86SSEEnum.AVX).Case("+sse4.2", (Object)X86SSEEnum.SSE42).Case("+sse4.1", (Object)X86SSEEnum.SSE41).Case("+ssse3", (Object)X86SSEEnum.SSSE3).Case("+sse3", (Object)X86SSEEnum.SSE3).Case("+sse2", (Object)X86SSEEnum.SSE2).Case("+sse", (Object)X86SSEEnum.SSE1).Default((Object)X86SSEEnum.NoSSE));
            this.SSELevel = (X86SSEEnum)std.max((Native.ComparableLower)this.SSELevel, (Native.ComparableLower)Level2);
            MMX3DNowEnum ThreeDNowLevel = (MMX3DNowEnum)((Object)new StringSwitch(new StringRef(Feature2)).Case("+3dnowa", (Object)MMX3DNowEnum.AMD3DNowAthlon).Case("+3dnow", (Object)MMX3DNowEnum.AMD3DNow).Case("+mmx", (Object)MMX3DNowEnum.MMX).Default((Object)MMX3DNowEnum.NoMMX3DNow));
            this.MMX3DNowLevel = (MMX3DNowEnum)std.max((Native.ComparableLower)this.MMX3DNowLevel, (Native.ComparableLower)ThreeDNowLevel);
            XOPEnum XLevel = (XOPEnum)((Object)new StringSwitch(new StringRef(Feature2)).Case("+xop", (Object)XOPEnum.XOP).Case("+fma4", (Object)XOPEnum.FMA4).Case("+sse4a", (Object)XOPEnum.SSE4A).Default((Object)XOPEnum.NoXOP));
            this.XOPLevel = (XOPEnum)std.max((Native.ComparableLower)this.XOPLevel, (Native.ComparableLower)XLevel);
        }
        if (this.FPMath == FPMathKind.FP_SSE && this.SSELevel.getValue() < X86SSEEnum.SSE1.getValue() || this.FPMath == FPMathKind.FP_387 && this.SSELevel.getValue() >= X86SSEEnum.SSE1.getValue()) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder$C_char$ptr$C((DiagnosticBuilder)$c$.track((Object)Diags.Report(43)), this.FPMath == FPMathKind.FP_SSE ? NativePointer.$((String)"sse") : NativePointer.$((String)"387")));
                boolean bl = false;
                return bl;
            }
            finally {
                $c$.$destroy();
            }
        }
        this.SimdDefaultAlign = Unsigned.$int2ushort((int)(this.hasFeature(new StringRef("avx512f")) ? 512 : (this.hasFeature(new StringRef("avx")) ? 256 : 128)));
        return true;
    }

    @Override
    public StringRef getABI() {
        if (this.getTriple().getArch() == Triple.ArchType.x86_64 && this.SSELevel.getValue() >= X86SSEEnum.AVX512F.getValue()) {
            return new StringRef("avx512");
        }
        if (this.getTriple().getArch() == Triple.ArchType.x86_64 && this.SSELevel.getValue() >= X86SSEEnum.AVX.getValue()) {
            return new StringRef("avx");
        }
        if (this.getTriple().getArch() == Triple.ArchType.x86 && this.MMX3DNowLevel == MMX3DNowEnum.NoMMX3DNow) {
            return new StringRef("no-mmx");
        }
        return new StringRef(NativePointer.$EMPTY);
    }

    @Override
    public boolean setCPU(std.string Name) {
        this.CPU = this.getCPUKind(new StringRef(Name));
        switch (this.CPU) {
            case CK_Generic: {
                return false;
            }
            case CK_i386: 
            case CK_i486: 
            case CK_WinChipC6: 
            case CK_WinChip2: 
            case CK_C3: 
            case CK_PentiumMMX: 
            case CK_i586: 
            case CK_Pentium: 
            case CK_Pentium3: 
            case CK_Pentium3M: 
            case CK_PentiumM: 
            case CK_Pentium2: 
            case CK_C3_2: 
            case CK_PentiumPro: 
            case CK_i686: 
            case CK_Pentium4: 
            case CK_Pentium4M: 
            case CK_Yonah: 
            case CK_Prescott: 
            case CK_Lakemont: 
            case CK_K6_2: 
            case CK_K6_3: 
            case CK_K6: 
            case CK_Athlon: 
            case CK_AthlonThunderbird: 
            case CK_Athlon4: 
            case CK_AthlonXP: 
            case CK_AthlonMP: 
            case CK_Geode: {
                if (this.getTriple().getArch() != Triple.ArchType.x86) {
                    return false;
                }
            }
            case CK_Nocona: 
            case CK_Core2: 
            case CK_Penryn: 
            case CK_Bonnell: 
            case CK_Silvermont: 
            case CK_Nehalem: 
            case CK_Westmere: 
            case CK_SandyBridge: 
            case CK_IvyBridge: 
            case CK_Haswell: 
            case CK_Broadwell: 
            case CK_SkylakeClient: 
            case CK_SkylakeServer: 
            case CK_Cannonlake: 
            case CK_KNL: 
            case CK_K8: 
            case CK_K8SSE3: 
            case CK_x86_64: 
            case CK_Opteron: 
            case CK_OpteronSSE3: 
            case CK_Athlon64: 
            case CK_Athlon64SSE3: 
            case CK_AthlonFX: 
            case CK_AMDFAM10: 
            case CK_BTVER1: 
            case CK_BTVER2: 
            case CK_BDVER1: 
            case CK_BDVER2: 
            case CK_BDVER3: 
            case CK_BDVER4: {
                return true;
            }
        }
        throw new llvm_unreachable("Unhandled CPU kind");
    }

    @Override
    public boolean setFPMath(StringRef Name) {
        if (llvm.$eq_StringRef((StringRef)Name, (String)"387")) {
            this.FPMath = FPMathKind.FP_387;
            return true;
        }
        if (llvm.$eq_StringRef((StringRef)Name, (String)"sse")) {
            this.FPMath = FPMathKind.FP_SSE;
            return true;
        }
        return false;
    }

    @Override
    public TargetInfo.CallingConvCheckResult checkCallingConvention(CallingConv CC) {
        switch (CC) {
            case CC_X86ThisCall: 
            case CC_X86FastCall: 
            case CC_X86StdCall: 
            case CC_X86VectorCall: 
            case CC_C: 
            case CC_Swift: 
            case CC_X86Pascal: 
            case CC_IntelOclBicc: {
                return TargetInfo.CallingConvCheckResult.CCCR_OK;
            }
        }
        return TargetInfo.CallingConvCheckResult.CCCR_Warning;
    }

    @Override
    public CallingConv getDefaultCallingConv(TargetInfo.CallingConvMethodType MT) {
        return MT == TargetInfo.CallingConvMethodType.CCMT_Member ? CallingConv.CC_X86ThisCall : CallingConv.CC_C;
    }

    @Override
    public boolean hasSjLjLowering() {
        return true;
    }

    @Override
    public void setSupportedOpenCLOpts() {
        this.getSupportedOpenCLOpts().setAll();
    }

    @Override
    public void $destroy() {
        super.$destroy();
    }

    @Override
    public String toString() {
        return "SSELevel=" + (Object)((Object)this.SSELevel) + ", MMX3DNowLevel=" + (Object)((Object)this.MMX3DNowLevel) + ", XOPLevel=" + (Object)((Object)this.XOPLevel) + ", HasAES=" + this.HasAES + ", HasPCLMUL=" + this.HasPCLMUL + ", HasLZCNT=" + this.HasLZCNT + ", HasRDRND=" + this.HasRDRND + ", HasFSGSBASE=" + this.HasFSGSBASE + ", HasBMI=" + this.HasBMI + ", HasBMI2=" + this.HasBMI2 + ", HasPOPCNT=" + this.HasPOPCNT + ", HasRTM=" + this.HasRTM + ", HasPRFCHW=" + this.HasPRFCHW + ", HasRDSEED=" + this.HasRDSEED + ", HasADX=" + this.HasADX + ", HasTBM=" + this.HasTBM + ", HasFMA=" + this.HasFMA + ", HasF16C=" + this.HasF16C + ", HasAVX512CD=" + this.HasAVX512CD + ", HasAVX512ER=" + this.HasAVX512ER + ", HasAVX512PF=" + this.HasAVX512PF + ", HasAVX512DQ=" + this.HasAVX512DQ + ", HasAVX512BW=" + this.HasAVX512BW + ", HasAVX512VL=" + this.HasAVX512VL + ", HasAVX512VBMI=" + this.HasAVX512VBMI + ", HasAVX512IFMA=" + this.HasAVX512IFMA + ", HasSHA=" + this.HasSHA + ", HasMPX=" + this.HasMPX + ", HasSGX=" + this.HasSGX + ", HasCX16=" + this.HasCX16 + ", HasFXSR=" + this.HasFXSR + ", HasXSAVE=" + this.HasXSAVE + ", HasXSAVEOPT=" + this.HasXSAVEOPT + ", HasXSAVEC=" + this.HasXSAVEC + ", HasXSAVES=" + this.HasXSAVES + ", HasMWAITX=" + this.HasMWAITX + ", HasPKU=" + this.HasPKU + ", HasCLFLUSHOPT=" + this.HasCLFLUSHOPT + ", HasPCOMMIT=" + this.HasPCOMMIT + ", HasCLWB=" + this.HasCLWB + ", HasUMIP=" + this.HasUMIP + ", HasMOVBE=" + this.HasMOVBE + ", HasPREFETCHWT1=" + this.HasPREFETCHWT1 + ", CPU=" + (Object)((Object)this.CPU) + ", FPMath=" + (Object)((Object)this.FPMath) + super.toString();
    }

    private static final class FPMathKind
    extends Enum<FPMathKind>
    implements Native.ComparableLower {
        public static final /* enum */ FPMathKind FP_Default = new FPMathKind(0);
        public static final /* enum */ FPMathKind FP_SSE = new FPMathKind(FP_Default.getValue() + 1);
        public static final /* enum */ FPMathKind FP_387 = new FPMathKind(FP_SSE.getValue() + 1);
        private final int value;
        private static final /* synthetic */ FPMathKind[] $VALUES;

        public static FPMathKind[] values() {
            return (FPMathKind[])$VALUES.clone();
        }

        public static FPMathKind valueOf(String name) {
            return Enum.valueOf(FPMathKind.class, name);
        }

        public static FPMathKind valueOf(int val) {
            FPMathKind out;
            FPMathKind fPMathKind = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private FPMathKind(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        public boolean $less(Object obj) {
            return Unsigned.$less_uint((int)this.value, (int)((FPMathKind)((Object)obj)).value);
        }

        public boolean $lesseq(Object obj) {
            return Unsigned.$lesseq_uint((int)this.value, (int)((FPMathKind)((Object)obj)).value);
        }

        static {
            $VALUES = new FPMathKind[]{FP_Default, FP_SSE, FP_387};
        }

        private static final class Values {
            private static final FPMathKind[] VALUES;
            private static final FPMathKind[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (FPMathKind kind : FPMathKind.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new FPMathKind[min < 0 ? 1 - min : 0];
                VALUES = new FPMathKind[max >= 0 ? 1 + max : 0];
                for (FPMathKind kind : FPMathKind.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((FPMathKind)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((FPMathKind)kind).value] = kind;
                }
            }
        }
    }

    private static final class CPUKind
    extends Enum<CPUKind>
    implements Native.ComparableLower {
        public static final /* enum */ CPUKind CK_Generic = new CPUKind(0);
        public static final /* enum */ CPUKind CK_i386 = new CPUKind(CK_Generic.getValue() + 1);
        public static final /* enum */ CPUKind CK_i486 = new CPUKind(CK_i386.getValue() + 1);
        public static final /* enum */ CPUKind CK_WinChipC6 = new CPUKind(CK_i486.getValue() + 1);
        public static final /* enum */ CPUKind CK_WinChip2 = new CPUKind(CK_WinChipC6.getValue() + 1);
        public static final /* enum */ CPUKind CK_C3 = new CPUKind(CK_WinChip2.getValue() + 1);
        public static final /* enum */ CPUKind CK_i586 = new CPUKind(CK_C3.getValue() + 1);
        public static final /* enum */ CPUKind CK_Pentium = new CPUKind(CK_i586.getValue() + 1);
        public static final /* enum */ CPUKind CK_PentiumMMX = new CPUKind(CK_Pentium.getValue() + 1);
        public static final /* enum */ CPUKind CK_i686 = new CPUKind(CK_PentiumMMX.getValue() + 1);
        public static final /* enum */ CPUKind CK_PentiumPro = new CPUKind(CK_i686.getValue() + 1);
        public static final /* enum */ CPUKind CK_Pentium2 = new CPUKind(CK_PentiumPro.getValue() + 1);
        public static final /* enum */ CPUKind CK_Pentium3 = new CPUKind(CK_Pentium2.getValue() + 1);
        public static final /* enum */ CPUKind CK_Pentium3M = new CPUKind(CK_Pentium3.getValue() + 1);
        public static final /* enum */ CPUKind CK_PentiumM = new CPUKind(CK_Pentium3M.getValue() + 1);
        public static final /* enum */ CPUKind CK_C3_2 = new CPUKind(CK_PentiumM.getValue() + 1);
        public static final /* enum */ CPUKind CK_Yonah = new CPUKind(CK_C3_2.getValue() + 1);
        public static final /* enum */ CPUKind CK_Pentium4 = new CPUKind(CK_Yonah.getValue() + 1);
        public static final /* enum */ CPUKind CK_Pentium4M = new CPUKind(CK_Pentium4.getValue() + 1);
        public static final /* enum */ CPUKind CK_Prescott = new CPUKind(CK_Pentium4M.getValue() + 1);
        public static final /* enum */ CPUKind CK_Nocona = new CPUKind(CK_Prescott.getValue() + 1);
        public static final /* enum */ CPUKind CK_Core2 = new CPUKind(CK_Nocona.getValue() + 1);
        public static final /* enum */ CPUKind CK_Penryn = new CPUKind(CK_Core2.getValue() + 1);
        public static final /* enum */ CPUKind CK_Bonnell = new CPUKind(CK_Penryn.getValue() + 1);
        public static final /* enum */ CPUKind CK_Silvermont = new CPUKind(CK_Bonnell.getValue() + 1);
        public static final /* enum */ CPUKind CK_Nehalem = new CPUKind(CK_Silvermont.getValue() + 1);
        public static final /* enum */ CPUKind CK_Westmere = new CPUKind(CK_Nehalem.getValue() + 1);
        public static final /* enum */ CPUKind CK_SandyBridge = new CPUKind(CK_Westmere.getValue() + 1);
        public static final /* enum */ CPUKind CK_IvyBridge = new CPUKind(CK_SandyBridge.getValue() + 1);
        public static final /* enum */ CPUKind CK_Haswell = new CPUKind(CK_IvyBridge.getValue() + 1);
        public static final /* enum */ CPUKind CK_Broadwell = new CPUKind(CK_Haswell.getValue() + 1);
        public static final /* enum */ CPUKind CK_SkylakeClient = new CPUKind(CK_Broadwell.getValue() + 1);
        public static final /* enum */ CPUKind CK_SkylakeServer = new CPUKind(CK_SkylakeClient.getValue() + 1);
        public static final /* enum */ CPUKind CK_Cannonlake = new CPUKind(CK_SkylakeServer.getValue() + 1);
        public static final /* enum */ CPUKind CK_KNL = new CPUKind(CK_Cannonlake.getValue() + 1);
        public static final /* enum */ CPUKind CK_Lakemont = new CPUKind(CK_KNL.getValue() + 1);
        public static final /* enum */ CPUKind CK_K6 = new CPUKind(CK_Lakemont.getValue() + 1);
        public static final /* enum */ CPUKind CK_K6_2 = new CPUKind(CK_K6.getValue() + 1);
        public static final /* enum */ CPUKind CK_K6_3 = new CPUKind(CK_K6_2.getValue() + 1);
        public static final /* enum */ CPUKind CK_Athlon = new CPUKind(CK_K6_3.getValue() + 1);
        public static final /* enum */ CPUKind CK_AthlonThunderbird = new CPUKind(CK_Athlon.getValue() + 1);
        public static final /* enum */ CPUKind CK_Athlon4 = new CPUKind(CK_AthlonThunderbird.getValue() + 1);
        public static final /* enum */ CPUKind CK_AthlonXP = new CPUKind(CK_Athlon4.getValue() + 1);
        public static final /* enum */ CPUKind CK_AthlonMP = new CPUKind(CK_AthlonXP.getValue() + 1);
        public static final /* enum */ CPUKind CK_Athlon64 = new CPUKind(CK_AthlonMP.getValue() + 1);
        public static final /* enum */ CPUKind CK_Athlon64SSE3 = new CPUKind(CK_Athlon64.getValue() + 1);
        public static final /* enum */ CPUKind CK_AthlonFX = new CPUKind(CK_Athlon64SSE3.getValue() + 1);
        public static final /* enum */ CPUKind CK_K8 = new CPUKind(CK_AthlonFX.getValue() + 1);
        public static final /* enum */ CPUKind CK_K8SSE3 = new CPUKind(CK_K8.getValue() + 1);
        public static final /* enum */ CPUKind CK_Opteron = new CPUKind(CK_K8SSE3.getValue() + 1);
        public static final /* enum */ CPUKind CK_OpteronSSE3 = new CPUKind(CK_Opteron.getValue() + 1);
        public static final /* enum */ CPUKind CK_AMDFAM10 = new CPUKind(CK_OpteronSSE3.getValue() + 1);
        public static final /* enum */ CPUKind CK_BTVER1 = new CPUKind(CK_AMDFAM10.getValue() + 1);
        public static final /* enum */ CPUKind CK_BTVER2 = new CPUKind(CK_BTVER1.getValue() + 1);
        public static final /* enum */ CPUKind CK_BDVER1 = new CPUKind(CK_BTVER2.getValue() + 1);
        public static final /* enum */ CPUKind CK_BDVER2 = new CPUKind(CK_BDVER1.getValue() + 1);
        public static final /* enum */ CPUKind CK_BDVER3 = new CPUKind(CK_BDVER2.getValue() + 1);
        public static final /* enum */ CPUKind CK_BDVER4 = new CPUKind(CK_BDVER3.getValue() + 1);
        public static final /* enum */ CPUKind CK_x86_64 = new CPUKind(CK_BDVER4.getValue() + 1);
        public static final /* enum */ CPUKind CK_Geode = new CPUKind(CK_x86_64.getValue() + 1);
        private final int value;
        private static final /* synthetic */ CPUKind[] $VALUES;

        public static CPUKind[] values() {
            return (CPUKind[])$VALUES.clone();
        }

        public static CPUKind valueOf(String name) {
            return Enum.valueOf(CPUKind.class, name);
        }

        public static CPUKind valueOf(int val) {
            CPUKind out;
            CPUKind cPUKind = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private CPUKind(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        public boolean $less(Object obj) {
            return Unsigned.$less_uint((int)this.value, (int)((CPUKind)((Object)obj)).value);
        }

        public boolean $lesseq(Object obj) {
            return Unsigned.$lesseq_uint((int)this.value, (int)((CPUKind)((Object)obj)).value);
        }

        static {
            $VALUES = new CPUKind[]{CK_Generic, CK_i386, CK_i486, CK_WinChipC6, CK_WinChip2, CK_C3, CK_i586, CK_Pentium, CK_PentiumMMX, CK_i686, CK_PentiumPro, CK_Pentium2, CK_Pentium3, CK_Pentium3M, CK_PentiumM, CK_C3_2, CK_Yonah, CK_Pentium4, CK_Pentium4M, CK_Prescott, CK_Nocona, CK_Core2, CK_Penryn, CK_Bonnell, CK_Silvermont, CK_Nehalem, CK_Westmere, CK_SandyBridge, CK_IvyBridge, CK_Haswell, CK_Broadwell, CK_SkylakeClient, CK_SkylakeServer, CK_Cannonlake, CK_KNL, CK_Lakemont, CK_K6, CK_K6_2, CK_K6_3, CK_Athlon, CK_AthlonThunderbird, CK_Athlon4, CK_AthlonXP, CK_AthlonMP, CK_Athlon64, CK_Athlon64SSE3, CK_AthlonFX, CK_K8, CK_K8SSE3, CK_Opteron, CK_OpteronSSE3, CK_AMDFAM10, CK_BTVER1, CK_BTVER2, CK_BDVER1, CK_BDVER2, CK_BDVER3, CK_BDVER4, CK_x86_64, CK_Geode};
        }

        private static final class Values {
            private static final CPUKind[] VALUES;
            private static final CPUKind[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (CPUKind kind : CPUKind.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new CPUKind[min < 0 ? 1 - min : 0];
                VALUES = new CPUKind[max >= 0 ? 1 + max : 0];
                for (CPUKind kind : CPUKind.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((CPUKind)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((CPUKind)kind).value] = kind;
                }
            }
        }
    }

    private static final class XOPEnum
    extends Enum<XOPEnum>
    implements Native.ComparableLower {
        public static final /* enum */ XOPEnum NoXOP = new XOPEnum(0);
        public static final /* enum */ XOPEnum SSE4A = new XOPEnum(NoXOP.getValue() + 1);
        public static final /* enum */ XOPEnum FMA4 = new XOPEnum(SSE4A.getValue() + 1);
        public static final /* enum */ XOPEnum XOP = new XOPEnum(FMA4.getValue() + 1);
        private final int value;
        private static final /* synthetic */ XOPEnum[] $VALUES;

        public static XOPEnum[] values() {
            return (XOPEnum[])$VALUES.clone();
        }

        public static XOPEnum valueOf(String name) {
            return Enum.valueOf(XOPEnum.class, name);
        }

        public static XOPEnum valueOf(int val) {
            XOPEnum out;
            XOPEnum xOPEnum = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private XOPEnum(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        public boolean $less(Object obj) {
            return Unsigned.$less_uint((int)this.value, (int)((XOPEnum)((Object)obj)).value);
        }

        public boolean $lesseq(Object obj) {
            return Unsigned.$lesseq_uint((int)this.value, (int)((XOPEnum)((Object)obj)).value);
        }

        static {
            $VALUES = new XOPEnum[]{NoXOP, SSE4A, FMA4, XOP};
        }

        private static final class Values {
            private static final XOPEnum[] VALUES;
            private static final XOPEnum[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (XOPEnum kind : XOPEnum.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new XOPEnum[min < 0 ? 1 - min : 0];
                VALUES = new XOPEnum[max >= 0 ? 1 + max : 0];
                for (XOPEnum kind : XOPEnum.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((XOPEnum)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((XOPEnum)kind).value] = kind;
                }
            }
        }
    }

    private static final class MMX3DNowEnum
    extends Enum<MMX3DNowEnum>
    implements Native.ComparableLower {
        public static final /* enum */ MMX3DNowEnum NoMMX3DNow = new MMX3DNowEnum(0);
        public static final /* enum */ MMX3DNowEnum MMX = new MMX3DNowEnum(NoMMX3DNow.getValue() + 1);
        public static final /* enum */ MMX3DNowEnum AMD3DNow = new MMX3DNowEnum(MMX.getValue() + 1);
        public static final /* enum */ MMX3DNowEnum AMD3DNowAthlon = new MMX3DNowEnum(AMD3DNow.getValue() + 1);
        private final int value;
        private static final /* synthetic */ MMX3DNowEnum[] $VALUES;

        public static MMX3DNowEnum[] values() {
            return (MMX3DNowEnum[])$VALUES.clone();
        }

        public static MMX3DNowEnum valueOf(String name) {
            return Enum.valueOf(MMX3DNowEnum.class, name);
        }

        public static MMX3DNowEnum valueOf(int val) {
            MMX3DNowEnum out;
            MMX3DNowEnum mMX3DNowEnum = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private MMX3DNowEnum(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        public boolean $less(Object obj) {
            return Unsigned.$less_uint((int)this.value, (int)((MMX3DNowEnum)((Object)obj)).value);
        }

        public boolean $lesseq(Object obj) {
            return Unsigned.$lesseq_uint((int)this.value, (int)((MMX3DNowEnum)((Object)obj)).value);
        }

        static {
            $VALUES = new MMX3DNowEnum[]{NoMMX3DNow, MMX, AMD3DNow, AMD3DNowAthlon};
        }

        private static final class Values {
            private static final MMX3DNowEnum[] VALUES;
            private static final MMX3DNowEnum[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (MMX3DNowEnum kind : MMX3DNowEnum.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new MMX3DNowEnum[min < 0 ? 1 - min : 0];
                VALUES = new MMX3DNowEnum[max >= 0 ? 1 + max : 0];
                for (MMX3DNowEnum kind : MMX3DNowEnum.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((MMX3DNowEnum)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((MMX3DNowEnum)kind).value] = kind;
                }
            }
        }
    }

    private static final class X86SSEEnum
    extends Enum<X86SSEEnum>
    implements Native.ComparableLower {
        public static final /* enum */ X86SSEEnum NoSSE = new X86SSEEnum(0);
        public static final /* enum */ X86SSEEnum SSE1 = new X86SSEEnum(NoSSE.getValue() + 1);
        public static final /* enum */ X86SSEEnum SSE2 = new X86SSEEnum(SSE1.getValue() + 1);
        public static final /* enum */ X86SSEEnum SSE3 = new X86SSEEnum(SSE2.getValue() + 1);
        public static final /* enum */ X86SSEEnum SSSE3 = new X86SSEEnum(SSE3.getValue() + 1);
        public static final /* enum */ X86SSEEnum SSE41 = new X86SSEEnum(SSSE3.getValue() + 1);
        public static final /* enum */ X86SSEEnum SSE42 = new X86SSEEnum(SSE41.getValue() + 1);
        public static final /* enum */ X86SSEEnum AVX = new X86SSEEnum(SSE42.getValue() + 1);
        public static final /* enum */ X86SSEEnum AVX2 = new X86SSEEnum(AVX.getValue() + 1);
        public static final /* enum */ X86SSEEnum AVX512F = new X86SSEEnum(AVX2.getValue() + 1);
        private final int value;
        private static final /* synthetic */ X86SSEEnum[] $VALUES;

        public static X86SSEEnum[] values() {
            return (X86SSEEnum[])$VALUES.clone();
        }

        public static X86SSEEnum valueOf(String name) {
            return Enum.valueOf(X86SSEEnum.class, name);
        }

        public static X86SSEEnum valueOf(int val) {
            X86SSEEnum out;
            X86SSEEnum x86SSEEnum = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private X86SSEEnum(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        public boolean $less(Object obj) {
            return Unsigned.$less_uint((int)this.value, (int)((X86SSEEnum)((Object)obj)).value);
        }

        public boolean $lesseq(Object obj) {
            return Unsigned.$lesseq_uint((int)this.value, (int)((X86SSEEnum)((Object)obj)).value);
        }

        static {
            $VALUES = new X86SSEEnum[]{NoSSE, SSE1, SSE2, SSE3, SSSE3, SSE41, SSE42, AVX, AVX2, AVX512F};
        }

        private static final class Values {
            private static final X86SSEEnum[] VALUES;
            private static final X86SSEEnum[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (X86SSEEnum kind : X86SSEEnum.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new X86SSEEnum[min < 0 ? 1 - min : 0];
                VALUES = new X86SSEEnum[max >= 0 ? 1 + max : 0];
                for (X86SSEEnum kind : X86SSEEnum.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((X86SSEEnum)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((X86SSEEnum)kind).value] = kind;
                }
            }
        }
    }
}

