/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic.target.impl;

import org.clang.basic.BasicClangGlobals;
import org.clang.basic.Builtin;
import org.clang.basic.DiagnosticBuilder;
import org.clang.basic.DiagnosticsEngine;
import org.clang.basic.LangOptions;
import org.clang.basic.MacroBuilder;
import org.clang.basic.target.TargetInfo;
import org.clang.basic.target.TargetOptions;
import org.clang.basic.target.impl.TargetInfo;
import org.clang.basic.target.impl.TargetsStatics;
import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.llvm.adt.APFloat;
import org.llvm.adt.StringRef;
import org.llvm.adt.StringSwitchBool;
import org.llvm.adt.Triple;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.StringMapBool;
import org.llvm.support.fltSemantics;
import org.llvm.support.llvm;

public class WebAssemblyTargetInfo
extends TargetInfo
implements Destructors.ClassWithDestructor {
    private static Builtin.Info[] BuiltinInfo = new Builtin.Info[]{new Builtin.Info("__builtin_wasm_current_memory", NativePointer.$z, NativePointer.$n, null, 14, null), new Builtin.Info("__builtin_wasm_grow_memory", "vz", NativePointer.$n, null, 14, null)};
    private SIMDEnum SIMDLevel = SIMDEnum.NoSIMD;

    public WebAssemblyTargetInfo(Triple T2, TargetOptions $Prm1) {
        super(T2);
        this.BigEndian = false;
        this.NoAsmVariants = true;
        this.SuitableAlign = Unsigned.$int2uchar((int)128);
        this.LargeArrayMinWidth = Unsigned.$int2uchar((int)128);
        this.LargeArrayAlign = Unsigned.$int2uchar((int)128);
        this.SimdDefaultAlign = (char)128;
        this.SigAtomicType = TargetInfo.IntType.SignedLong;
        this.LongDoubleWidth = this.LongDoubleAlign = Unsigned.$int2uchar((int)128);
        this.LongDoubleFormat = (fltSemantics)Native.$AddrOf((Object)APFloat.IEEEquad);
    }

    @Override
    public void getTargetDefines(LangOptions Opts, MacroBuilder Builder2) {
        TargetsStatics.defineCPUMacros(Builder2, new StringRef("wasm"), false);
        if (this.SIMDLevel.getValue() >= SIMDEnum.SIMD128.getValue()) {
            Builder2.defineMacro(new Twine("__wasm_simd128__"));
        }
    }

    @Override
    public boolean initFeatureMap(StringMapBool Features, DiagnosticsEngine Diags, StringRef CPU, std.vectorString FeaturesVec) {
        if (llvm.$eq_StringRef((StringRef)CPU, (String)"bleeding-edge")) {
            Features.$set("simd128", true);
        }
        return super.initFeatureMap(Features, Diags, CPU, FeaturesVec);
    }

    @Override
    public final boolean hasFeature(StringRef Feature2) {
        return new StringSwitchBool(Feature2).Case("simd128", this.SIMDLevel.getValue() >= SIMDEnum.SIMD128.getValue()).Default(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean handleTargetFeatures(std.vectorString Features, DiagnosticsEngine Diags) {
        for (std.string Feature2 : Features) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                if (std.$eq_string$C_T((std.string)Feature2, (String)"+simd128")) {
                    this.SIMDLevel = (SIMDEnum)std.max((Native.ComparableLower)this.SIMDLevel, (Native.ComparableLower)SIMDEnum.SIMD128);
                    continue;
                }
                if (std.$eq_string$C_T((std.string)Feature2, (String)"-simd128")) {
                    this.SIMDLevel = SIMDEnum.valueOf(std.min((int)this.SIMDLevel.getValue(), (int)(SIMDEnum.SIMD128.getValue() - 1)));
                    continue;
                }
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder$C_char$ptr$C(BasicClangGlobals.$out_DiagnosticBuilder$C_StringRef((DiagnosticBuilder)$c$.track((Object)Diags.Report(31)), new StringRef(Feature2)), "-target-feature"));
                boolean bl = false;
                return bl;
            }
            finally {
                $c$.$destroy();
            }
        }
        return true;
    }

    @Override
    public final boolean setCPU(std.string Name) {
        return new StringSwitchBool(Name).Case("mvp", true).Case("bleeding-edge", true).Case("generic", true).Default(false);
    }

    @Override
    public final ArrayRef<Builtin.Info> getTargetBuiltins() {
        return llvm.makeArrayRef((Object[])BuiltinInfo, (int)(972 - Builtin.ID.FirstTSBuiltin.getValue()));
    }

    @Override
    public final TargetInfo.BuiltinVaListKind getBuiltinVaListKind() {
        return TargetInfo.BuiltinVaListKind.VoidPtrBuiltinVaList;
    }

    @Override
    protected final ArrayRef<char.ptr> getGCCRegNames() {
        return ArrayRef.None();
    }

    @Override
    protected final ArrayRef<TargetInfo.GCCRegAlias> getGCCRegAliases() {
        return ArrayRef.None();
    }

    @Override
    public final boolean validateAsmConstraint(char.ptr Name, TargetInfo.ConstraintInfo Info2) {
        return false;
    }

    @Override
    public final char.ptr getClobbers() {
        return NativePointer.$EMPTY;
    }

    @Override
    public final boolean isCLZForZeroUndef() {
        return false;
    }

    @Override
    public final boolean hasInt128Type() {
        return true;
    }

    @Override
    public final TargetInfo.IntType getIntTypeByWidth(int BitWidth, boolean IsSigned) {
        return BitWidth == 64 ? (IsSigned ? TargetInfo.IntType.SignedLongLong : TargetInfo.IntType.UnsignedLongLong) : super.getIntTypeByWidth(BitWidth, IsSigned);
    }

    @Override
    public final TargetInfo.IntType getLeastIntTypeByWidth(int BitWidth, boolean IsSigned) {
        return BitWidth == 64 ? (IsSigned ? TargetInfo.IntType.SignedLongLong : TargetInfo.IntType.UnsignedLongLong) : super.getLeastIntTypeByWidth(BitWidth, IsSigned);
    }

    @Override
    public void $destroy() {
        super.$destroy();
    }

    @Override
    public String toString() {
        return "SIMDLevel=" + (Object)((Object)this.SIMDLevel) + super.toString();
    }

    private static final class SIMDEnum
    extends Enum<SIMDEnum>
    implements Native.ComparableLower {
        public static final /* enum */ SIMDEnum NoSIMD = new SIMDEnum(0);
        public static final /* enum */ SIMDEnum SIMD128 = new SIMDEnum(NoSIMD.getValue() + 1);
        private final int value;
        private static final /* synthetic */ SIMDEnum[] $VALUES;

        public static SIMDEnum[] values() {
            return (SIMDEnum[])$VALUES.clone();
        }

        public static SIMDEnum valueOf(String name) {
            return Enum.valueOf(SIMDEnum.class, name);
        }

        public static SIMDEnum valueOf(int val) {
            SIMDEnum out;
            SIMDEnum sIMDEnum = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private SIMDEnum(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        public boolean $less(Object obj) {
            return Unsigned.$less_uint((int)this.value, (int)((SIMDEnum)((Object)obj)).value);
        }

        public boolean $lesseq(Object obj) {
            return Unsigned.$lesseq_uint((int)this.value, (int)((SIMDEnum)((Object)obj)).value);
        }

        static {
            $VALUES = new SIMDEnum[]{NoSIMD, SIMD128};
        }

        private static final class Values {
            private static final SIMDEnum[] VALUES;
            private static final SIMDEnum[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (SIMDEnum kind : SIMDEnum.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new SIMDEnum[min < 0 ? 1 - min : 0];
                VALUES = new SIMDEnum[max >= 0 ? 1 + max : 0];
                for (SIMDEnum kind : SIMDEnum.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((SIMDEnum)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((SIMDEnum)kind).value] = kind;
                }
            }
        }
    }
}

