/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic.target.impl;

import org.clang.basic.BasicClangGlobals;
import org.clang.basic.Builtin;
import org.clang.basic.CallingConv;
import org.clang.basic.DiagnosticBuilder;
import org.clang.basic.DiagnosticsEngine;
import org.clang.basic.LangAS;
import org.clang.basic.LangOptions;
import org.clang.basic.MacroBuilder;
import org.clang.basic.OpenCLOptions;
import org.clang.basic.VersionTuple;
import org.clang.basic.target.TargetCXXABI;
import org.clang.basic.target.TargetInfo;
import org.clang.basic.target.TargetOptions;
import org.clang.basic.target.impl.TargetInfoImpl;
import org.clang.basic.target.impl.TargetInfoStatics;
import org.clang.basic.target.impl.TargetsStatics;
import org.clank.java.std;
import org.clank.java.std_ptr;
import org.clank.support.JavaCleaner;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.clank.support.aliases.uint;
import org.clank.support.void;
import org.llvm.adt.APFloat;
import org.llvm.adt.MutableArrayRef;
import org.llvm.adt.StringRef;
import org.llvm.adt.Triple;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.StringMapBool;
import org.llvm.adt.aliases.StringMapEntryBool;
import org.llvm.ir.DataLayout;
import org.llvm.support.fltSemantics;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;

public abstract class TargetInfo
extends TargetInfoImpl {
    private std_ptr.shared_ptr<TargetOptions> TargetOpts = new std_ptr.shared_ptr();
    private Triple _Triple;
    protected boolean BigEndian;
    protected boolean TLSSupported;
    protected boolean NoAsmVariants;
    protected boolean HasFloat128;
    protected byte PointerWidth;
    protected byte PointerAlign;
    protected byte BoolWidth;
    protected byte BoolAlign;
    protected byte IntWidth;
    protected byte IntAlign;
    protected byte HalfWidth;
    protected byte HalfAlign;
    protected byte FloatWidth;
    protected byte FloatAlign;
    protected byte DoubleWidth;
    protected byte DoubleAlign;
    protected byte LongDoubleWidth;
    protected byte LongDoubleAlign;
    protected byte Float128Align;
    protected byte LargeArrayMinWidth;
    protected byte LargeArrayAlign;
    protected byte LongWidth;
    protected byte LongAlign;
    protected byte LongLongWidth;
    protected byte LongLongAlign;
    protected byte SuitableAlign;
    protected byte DefaultAlignForAttributeAligned;
    protected byte MinGlobalAlign;
    protected byte MaxAtomicPromoteWidth;
    protected byte MaxAtomicInlineWidth;
    protected char MaxVectorAlign;
    protected char MaxTLSAlign;
    protected char SimdDefaultAlign;
    protected std_ptr.unique_ptr<DataLayout> DataLayout;
    protected char.ptr MCountName;
    protected fltSemantics HalfFormat;
    protected fltSemantics FloatFormat;
    protected fltSemantics DoubleFormat;
    protected fltSemantics LongDoubleFormat;
    protected fltSemantics Float128Format;
    protected byte RegParmMax;
    protected byte SSERegParmMax;
    protected TargetCXXABI TheCXXABI;
    protected LangAS.Map AddrSpaceMap;
    protected StringRef PlatformName;
    protected VersionTuple PlatformMinVersion;
    protected boolean HasAlignMac68kSupport;
    protected byte RealTypeUsesObjCFPRet;
    protected boolean ComplexLongDoubleUsesFP2Ret;
    protected boolean HasBuiltinMSVaList;
    protected TargetInfo.IntType SizeType;
    protected TargetInfo.IntType IntMaxType;
    protected TargetInfo.IntType PtrDiffType;
    protected TargetInfo.IntType IntPtrType;
    protected TargetInfo.IntType WCharType;
    protected TargetInfo.IntType WIntType;
    protected TargetInfo.IntType Char16Type;
    protected TargetInfo.IntType Char32Type;
    protected TargetInfo.IntType Int64Type;
    protected TargetInfo.IntType SigAtomicType;
    protected TargetInfo.IntType ProcessIDType;
    protected boolean UseSignedCharForObjCBool;
    protected boolean UseBitFieldTypeAlignment;
    protected boolean UseZeroLengthBitfieldAlignment;
    protected boolean UseExplicitBitFieldAlignment;
    protected int ZeroLengthBitfieldBoundary;
    protected boolean UseAddrSpaceMapMangling;

    protected TargetInfo(Triple T2) {
        this._Triple = new Triple(T2);
        this.DataLayout = new std_ptr.unique_ptr();
        this.TheCXXABI = new TargetCXXABI();
        this.PlatformName = new StringRef();
        this.PlatformMinVersion = new VersionTuple();
        this.BigEndian = true;
        this.TLSSupported = true;
        this.NoAsmVariants = false;
        this.HasFloat128 = false;
        this.PointerAlign = (byte)32;
        this.PointerWidth = (byte)32;
        this.BoolAlign = (byte)8;
        this.BoolWidth = (byte)8;
        this.IntAlign = (byte)32;
        this.IntWidth = (byte)32;
        this.LongAlign = (byte)32;
        this.LongWidth = (byte)32;
        this.LongLongAlign = (byte)64;
        this.LongLongWidth = (byte)64;
        this.SuitableAlign = (byte)64;
        this.DefaultAlignForAttributeAligned = Unsigned.$int2uchar((int)128);
        this.MinGlobalAlign = 0;
        this.HalfWidth = (byte)16;
        this.HalfAlign = (byte)16;
        this.FloatWidth = (byte)32;
        this.FloatAlign = (byte)32;
        this.DoubleWidth = (byte)64;
        this.DoubleAlign = (byte)64;
        this.LongDoubleWidth = (byte)64;
        this.LongDoubleAlign = (byte)64;
        this.Float128Align = Unsigned.$int2uchar((int)128);
        this.LargeArrayMinWidth = 0;
        this.LargeArrayAlign = 0;
        this.MaxAtomicInlineWidth = 0;
        this.MaxAtomicPromoteWidth = 0;
        this.MaxVectorAlign = '\u0000';
        this.MaxTLSAlign = '\u0000';
        this.SimdDefaultAlign = '\u0000';
        this.SizeType = TargetInfo.IntType.UnsignedLong;
        this.PtrDiffType = TargetInfo.IntType.SignedLong;
        this.IntMaxType = TargetInfo.IntType.SignedLongLong;
        this.IntPtrType = TargetInfo.IntType.SignedLong;
        this.WCharType = TargetInfo.IntType.SignedInt;
        this.WIntType = TargetInfo.IntType.SignedInt;
        this.Char16Type = TargetInfo.IntType.UnsignedShort;
        this.Char32Type = TargetInfo.IntType.UnsignedInt;
        this.Int64Type = TargetInfo.IntType.SignedLongLong;
        this.SigAtomicType = TargetInfo.IntType.SignedInt;
        this.ProcessIDType = TargetInfo.IntType.SignedInt;
        this.UseSignedCharForObjCBool = true;
        this.UseBitFieldTypeAlignment = true;
        this.UseZeroLengthBitfieldAlignment = false;
        this.UseExplicitBitFieldAlignment = true;
        this.ZeroLengthBitfieldBoundary = 0;
        this.HalfFormat = (fltSemantics)Native.$AddrOf((Object)APFloat.IEEEhalf);
        this.FloatFormat = (fltSemantics)Native.$AddrOf((Object)APFloat.IEEEsingle);
        this.DoubleFormat = (fltSemantics)Native.$AddrOf((Object)APFloat.IEEEdouble);
        this.LongDoubleFormat = (fltSemantics)Native.$AddrOf((Object)APFloat.IEEEdouble);
        this.Float128Format = (fltSemantics)Native.$AddrOf((Object)APFloat.IEEEquad);
        this.MCountName = NativePointer.$((String)"mcount");
        this.RegParmMax = 0;
        this.SSERegParmMax = 0;
        this.HasAlignMac68kSupport = false;
        this.HasBuiltinMSVaList = false;
        this.RealTypeUsesObjCFPRet = 0;
        this.ComplexLongDoubleUsesFP2Ret = false;
        this.TheCXXABI.set(this._Triple.isKnownWindowsMSVCEnvironment() ? TargetCXXABI.Kind.Microsoft : TargetCXXABI.Kind.GenericItanium);
        this.AddrSpaceMap = (LangAS.Map)Native.$tryClone((Object)((LangAS.Map)Native.$AddrOf((Object)TargetInfoStatics.DefaultAddrSpaceMap)));
        this.UseAddrSpaceMapMangling = false;
        this.PlatformName.$assign(NativePointer.$unknown);
        this.PlatformMinVersion.$assignMove(new VersionTuple());
    }

    @Override
    protected void resetDataLayout(StringRef DL) {
        this.DataLayout.reset((Object)new DataLayout(new StringRef(DL)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static org.clang.basic.target.TargetInfo CreateTargetInfo(DiagnosticsEngine Diags, std_ptr.shared_ptr<TargetOptions> Opts) {
        std_ptr.unique_ptr Target = null;
        StringMapBool Features = null;
        try {
            Object object;
            Triple Triple2 = new Triple(new Twine(((TargetOptions)Opts.$arrow()).Triple));
            Target = new std_ptr.unique_ptr((Object)TargetsStatics.AllocateTarget(Triple2, (TargetOptions)Opts.$star()));
            if (!Target.$bool()) {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder$C_StringRef((DiagnosticBuilder)$c$.track((Object)Diags.Report(40)), new StringRef(Triple2.str())));
                    org.clang.basic.target.TargetInfo targetInfo = null;
                    return targetInfo;
                }
                finally {
                    $c$.$destroy();
                }
            }
            ((TargetInfoImpl)((Object)Target.$arrow())).$TargetInfo().TargetOpts.$assign(Opts);
            if (!((TargetOptions)Opts.$arrow()).CPU.empty() && !((TargetInfoImpl)((Object)Target.$arrow())).setCPU(((TargetOptions)Opts.$arrow()).CPU)) {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder$C_StringRef((DiagnosticBuilder)$c$.track((Object)Diags.Report(38)), new StringRef(((TargetOptions)Opts.$arrow()).CPU)));
                    org.clang.basic.target.TargetInfo targetInfo = null;
                    return targetInfo;
                }
                finally {
                    $c$.$destroy();
                }
            }
            if (!((TargetOptions)Opts.$arrow()).ABI.empty() && !((TargetInfoImpl)((Object)Target.$arrow())).setABI(((TargetOptions)Opts.$arrow()).ABI)) {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder$C_StringRef((DiagnosticBuilder)$c$.track((Object)Diags.Report(37)), new StringRef(((TargetOptions)Opts.$arrow()).ABI)));
                    org.clang.basic.target.TargetInfo targetInfo = null;
                    return targetInfo;
                }
                finally {
                    $c$.$destroy();
                }
            }
            if (!((TargetOptions)Opts.$arrow()).FPMath.empty() && !((TargetInfoImpl)((Object)Target.$arrow())).setFPMath(new StringRef(((TargetOptions)Opts.$arrow()).FPMath))) {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder$C_StringRef((DiagnosticBuilder)$c$.track((Object)Diags.Report(39)), new StringRef(((TargetOptions)Opts.$arrow()).FPMath)));
                    org.clang.basic.target.TargetInfo targetInfo = null;
                    return targetInfo;
                }
                finally {
                    $c$.$destroy();
                }
            }
            Features = new StringMapBool(false);
            if (!((TargetInfoImpl)((Object)Target.$arrow())).initFeatureMap(Features, Diags, new StringRef(((TargetOptions)Opts.$arrow()).CPU), ((TargetOptions)Opts.$arrow()).FeaturesAsWritten)) {
                org.clang.basic.target.TargetInfo targetInfo = null;
                return targetInfo;
            }
            ((TargetOptions)Opts.$arrow()).Features.clear();
            for (StringMapEntryBool F : Features) {
                ((TargetOptions)Opts.$arrow()).Features.push_back(std.$add_T_str((Object)(F.getValue() ? NativePointer.$PLUS : NativePointer.$MINUS), (std.string)F.getKey().str()));
            }
            if (!((TargetInfoImpl)((Object)Target.$arrow())).handleTargetFeatures(((TargetOptions)Opts.$arrow()).Features, Diags)) {
                object = null;
                return object;
            }
            ((TargetInfoImpl)((Object)Target.$arrow())).setSupportedOpenCLOpts();
            if (!((TargetInfoImpl)((Object)Target.$arrow())).validateTarget(Diags)) {
                object = null;
                return object;
            }
            object = (org.clang.basic.target.TargetInfo)((Object)Target.release());
            return object;
        }
        finally {
            if (Features != null) {
                Features.$destroy();
            }
            if (Target != null) {
                Target.$destroy();
            }
        }
    }

    @Override
    public void $destroy() {
        this.DataLayout.$destroy();
        this._Triple.$destroy();
        this.TargetOpts.$destroy();
        super.$destroy();
    }

    @Override
    public TargetOptions getTargetOpts() {
        assert (this.TargetOpts.$bool()) : "Missing target options";
        return (TargetOptions)this.TargetOpts.$star();
    }

    @Override
    public TargetInfo.IntType getSizeType() {
        return this.SizeType;
    }

    @Override
    public TargetInfo.IntType getIntMaxType() {
        return this.IntMaxType;
    }

    @Override
    public TargetInfo.IntType getUIntMaxType() {
        return TargetInfo.getCorrespondingUnsignedType(this.IntMaxType);
    }

    @Override
    public TargetInfo.IntType getPtrDiffType(int AddrSpace) {
        return AddrSpace == 0 ? this.PtrDiffType : this.getPtrDiffTypeV(AddrSpace);
    }

    @Override
    public TargetInfo.IntType getIntPtrType() {
        return this.IntPtrType;
    }

    @Override
    public TargetInfo.IntType getUIntPtrType() {
        return TargetInfo.getCorrespondingUnsignedType(this.IntPtrType);
    }

    @Override
    public TargetInfo.IntType getWCharType() {
        return this.WCharType;
    }

    @Override
    public TargetInfo.IntType getWIntType() {
        return this.WIntType;
    }

    @Override
    public TargetInfo.IntType getChar16Type() {
        return this.Char16Type;
    }

    @Override
    public TargetInfo.IntType getChar32Type() {
        return this.Char32Type;
    }

    @Override
    public TargetInfo.IntType getInt64Type() {
        return this.Int64Type;
    }

    @Override
    public TargetInfo.IntType getUInt64Type() {
        return TargetInfo.getCorrespondingUnsignedType(this.Int64Type);
    }

    @Override
    public TargetInfo.IntType getSigAtomicType() {
        return this.SigAtomicType;
    }

    @Override
    public TargetInfo.IntType getProcessIDType() {
        return this.ProcessIDType;
    }

    public static TargetInfo.IntType getCorrespondingUnsignedType(TargetInfo.IntType T2) {
        switch (T2) {
            case SignedChar: {
                return TargetInfo.IntType.UnsignedChar;
            }
            case SignedShort: {
                return TargetInfo.IntType.UnsignedShort;
            }
            case SignedInt: {
                return TargetInfo.IntType.UnsignedInt;
            }
            case SignedLong: {
                return TargetInfo.IntType.UnsignedLong;
            }
            case SignedLongLong: {
                return TargetInfo.IntType.UnsignedLongLong;
            }
        }
        throw new llvm_unreachable("Unexpected signed integer type");
    }

    @Override
    public int getTypeWidth(TargetInfo.IntType T2) {
        switch (T2) {
            default: {
                throw new llvm_unreachable("not an integer!");
            }
            case SignedChar: 
            case UnsignedChar: {
                return this.getCharWidth();
            }
            case SignedShort: 
            case UnsignedShort: {
                return this.getShortWidth();
            }
            case SignedInt: 
            case UnsignedInt: {
                return this.getIntWidth();
            }
            case SignedLong: 
            case UnsignedLong: {
                return this.getLongWidth();
            }
            case SignedLongLong: 
            case UnsignedLongLong: 
        }
        return this.getLongLongWidth();
    }

    @Override
    public TargetInfo.IntType getIntTypeByWidth(int BitWidth, boolean IsSigned) {
        if (this.getCharWidth() == BitWidth) {
            return IsSigned ? TargetInfo.IntType.SignedChar : TargetInfo.IntType.UnsignedChar;
        }
        if (this.getShortWidth() == BitWidth) {
            return IsSigned ? TargetInfo.IntType.SignedShort : TargetInfo.IntType.UnsignedShort;
        }
        if (this.getIntWidth() == BitWidth) {
            return IsSigned ? TargetInfo.IntType.SignedInt : TargetInfo.IntType.UnsignedInt;
        }
        if (this.getLongWidth() == BitWidth) {
            return IsSigned ? TargetInfo.IntType.SignedLong : TargetInfo.IntType.UnsignedLong;
        }
        if (this.getLongLongWidth() == BitWidth) {
            return IsSigned ? TargetInfo.IntType.SignedLongLong : TargetInfo.IntType.UnsignedLongLong;
        }
        return TargetInfo.IntType.NoInt;
    }

    @Override
    public TargetInfo.IntType getLeastIntTypeByWidth(int BitWidth, boolean IsSigned) {
        if (Unsigned.$greatereq_uint((int)this.getCharWidth(), (int)BitWidth)) {
            return IsSigned ? TargetInfo.IntType.SignedChar : TargetInfo.IntType.UnsignedChar;
        }
        if (Unsigned.$greatereq_uint((int)this.getShortWidth(), (int)BitWidth)) {
            return IsSigned ? TargetInfo.IntType.SignedShort : TargetInfo.IntType.UnsignedShort;
        }
        if (Unsigned.$greatereq_uint((int)this.getIntWidth(), (int)BitWidth)) {
            return IsSigned ? TargetInfo.IntType.SignedInt : TargetInfo.IntType.UnsignedInt;
        }
        if (Unsigned.$greatereq_uint((int)this.getLongWidth(), (int)BitWidth)) {
            return IsSigned ? TargetInfo.IntType.SignedLong : TargetInfo.IntType.UnsignedLong;
        }
        if (Unsigned.$greatereq_uint((int)this.getLongLongWidth(), (int)BitWidth)) {
            return IsSigned ? TargetInfo.IntType.SignedLongLong : TargetInfo.IntType.UnsignedLongLong;
        }
        return TargetInfo.IntType.NoInt;
    }

    @Override
    public TargetInfo.RealType getRealTypeByWidth(int BitWidth) {
        if (this.getFloatWidth() == BitWidth) {
            return TargetInfo.RealType.Float;
        }
        if (this.getDoubleWidth() == BitWidth) {
            return TargetInfo.RealType.Double;
        }
        switch (BitWidth) {
            case 96: {
                if (Native.$AddrOf((Object)this.getLongDoubleFormat()) != Native.$AddrOf((Object)APFloat.x87DoubleExtended)) break;
                return TargetInfo.RealType.LongDouble;
            }
            case 128: {
                if (Native.$AddrOf((Object)this.getLongDoubleFormat()) == Native.$AddrOf((Object)APFloat.PPCDoubleDouble) || Native.$AddrOf((Object)this.getLongDoubleFormat()) == Native.$AddrOf((Object)APFloat.IEEEquad)) {
                    return TargetInfo.RealType.LongDouble;
                }
                if (!this.hasFloat128Type()) break;
                return TargetInfo.RealType.Float128;
            }
        }
        return TargetInfo.RealType.NoFloat;
    }

    @Override
    public int getTypeAlign(TargetInfo.IntType T2) {
        switch (T2) {
            default: {
                throw new llvm_unreachable("not an integer!");
            }
            case SignedChar: 
            case UnsignedChar: {
                return this.getCharAlign();
            }
            case SignedShort: 
            case UnsignedShort: {
                return this.getShortAlign();
            }
            case SignedInt: 
            case UnsignedInt: {
                return this.getIntAlign();
            }
            case SignedLong: 
            case UnsignedLong: {
                return this.getLongAlign();
            }
            case SignedLongLong: 
            case UnsignedLongLong: 
        }
        return this.getLongLongAlign();
    }

    public static boolean isTypeSigned(TargetInfo.IntType T2) {
        switch (T2) {
            default: {
                throw new llvm_unreachable("not an integer!");
            }
            case SignedChar: 
            case SignedShort: 
            case SignedInt: 
            case SignedLong: 
            case SignedLongLong: {
                return true;
            }
            case UnsignedChar: 
            case UnsignedShort: 
            case UnsignedInt: 
            case UnsignedLong: 
            case UnsignedLongLong: 
        }
        return false;
    }

    @Override
    public long getPointerWidth(int AddrSpace) {
        return AddrSpace == 0 ? Unsigned.$uchar2ullong((byte)this.PointerWidth) : this.getPointerWidthV(AddrSpace);
    }

    @Override
    public long getPointerAlign(int AddrSpace) {
        return AddrSpace == 0 ? Unsigned.$uchar2ullong((byte)this.PointerAlign) : this.getPointerAlignV(AddrSpace);
    }

    @Override
    public int getBoolWidth() {
        return Unsigned.$uchar2uint((byte)this.BoolWidth);
    }

    @Override
    public int getBoolAlign() {
        return Unsigned.$uchar2uint((byte)this.BoolAlign);
    }

    @Override
    public int getCharWidth() {
        return 8;
    }

    @Override
    public int getCharAlign() {
        return 8;
    }

    @Override
    public int getShortWidth() {
        return 16;
    }

    @Override
    public int getShortAlign() {
        return 16;
    }

    @Override
    public int getIntWidth() {
        return Unsigned.$uchar2uint((byte)this.IntWidth);
    }

    @Override
    public int getIntAlign() {
        return Unsigned.$uchar2uint((byte)this.IntAlign);
    }

    @Override
    public int getLongWidth() {
        return Unsigned.$uchar2uint((byte)this.LongWidth);
    }

    @Override
    public int getLongAlign() {
        return Unsigned.$uchar2uint((byte)this.LongAlign);
    }

    @Override
    public int getLongLongWidth() {
        return Unsigned.$uchar2uint((byte)this.LongLongWidth);
    }

    @Override
    public int getLongLongAlign() {
        return Unsigned.$uchar2uint((byte)this.LongLongAlign);
    }

    @Override
    public boolean hasInt128Type() {
        return Unsigned.$greatereq_ulong_ullong((long)this.getPointerWidth(0), (long)64L);
    }

    @Override
    public boolean hasFloat128Type() {
        return this.HasFloat128;
    }

    @Override
    public int getSuitableAlign() {
        return Unsigned.$uchar2uint((byte)this.SuitableAlign);
    }

    @Override
    public int getDefaultAlignForAttributeAligned() {
        return Unsigned.$uchar2uint((byte)this.DefaultAlignForAttributeAligned);
    }

    @Override
    public int getMinGlobalAlign() {
        return Unsigned.$uchar2uint((byte)this.MinGlobalAlign);
    }

    @Override
    public int getWCharWidth() {
        return this.getTypeWidth(this.WCharType);
    }

    @Override
    public int getWCharAlign() {
        return this.getTypeAlign(this.WCharType);
    }

    @Override
    public int getChar16Width() {
        return this.getTypeWidth(this.Char16Type);
    }

    @Override
    public int getChar16Align() {
        return this.getTypeAlign(this.Char16Type);
    }

    @Override
    public int getChar32Width() {
        return this.getTypeWidth(this.Char32Type);
    }

    @Override
    public int getChar32Align() {
        return this.getTypeAlign(this.Char32Type);
    }

    @Override
    public int getHalfWidth() {
        return Unsigned.$uchar2uint((byte)this.HalfWidth);
    }

    @Override
    public int getHalfAlign() {
        return Unsigned.$uchar2uint((byte)this.HalfAlign);
    }

    @Override
    public fltSemantics getHalfFormat() {
        return (fltSemantics)Native.$Deref((Object)this.HalfFormat);
    }

    @Override
    public int getFloatWidth() {
        return Unsigned.$uchar2uint((byte)this.FloatWidth);
    }

    @Override
    public int getFloatAlign() {
        return Unsigned.$uchar2uint((byte)this.FloatAlign);
    }

    @Override
    public fltSemantics getFloatFormat() {
        return (fltSemantics)Native.$Deref((Object)this.FloatFormat);
    }

    @Override
    public int getDoubleWidth() {
        return Unsigned.$uchar2uint((byte)this.DoubleWidth);
    }

    @Override
    public int getDoubleAlign() {
        return Unsigned.$uchar2uint((byte)this.DoubleAlign);
    }

    @Override
    public fltSemantics getDoubleFormat() {
        return (fltSemantics)Native.$Deref((Object)this.DoubleFormat);
    }

    @Override
    public int getLongDoubleWidth() {
        return Unsigned.$uchar2uint((byte)this.LongDoubleWidth);
    }

    @Override
    public int getLongDoubleAlign() {
        return Unsigned.$uchar2uint((byte)this.LongDoubleAlign);
    }

    @Override
    public fltSemantics getLongDoubleFormat() {
        return (fltSemantics)Native.$Deref((Object)this.LongDoubleFormat);
    }

    @Override
    public int getFloat128Width() {
        return 128;
    }

    @Override
    public int getFloat128Align() {
        return Unsigned.$uchar2uint((byte)this.Float128Align);
    }

    @Override
    public fltSemantics getFloat128Format() {
        return (fltSemantics)Native.$Deref((Object)this.Float128Format);
    }

    @Override
    public boolean useFloat128ManglingForLongDouble() {
        return false;
    }

    @Override
    public int getFloatEvalMethod() {
        return 0;
    }

    @Override
    public int getLargeArrayMinWidth() {
        return Unsigned.$uchar2uint((byte)this.LargeArrayMinWidth);
    }

    @Override
    public int getLargeArrayAlign() {
        return Unsigned.$uchar2uint((byte)this.LargeArrayAlign);
    }

    @Override
    public int getMaxAtomicPromoteWidth() {
        return Unsigned.$uchar2uint((byte)this.MaxAtomicPromoteWidth);
    }

    @Override
    public int getMaxAtomicInlineWidth() {
        return Unsigned.$uchar2uint((byte)this.MaxAtomicInlineWidth);
    }

    @Override
    public boolean hasBuiltinAtomic(long AtomicSizeInBits, long AlignmentInBits) {
        return Unsigned.$lesseq_ulong((long)AtomicSizeInBits, (long)AlignmentInBits) && Unsigned.$lesseq_ulong_uint((long)AtomicSizeInBits, (int)this.getMaxAtomicInlineWidth()) && (Unsigned.$lesseq_ulong_uint((long)AtomicSizeInBits, (int)this.getCharWidth()) || llvm.isPowerOf2_64((long)Unsigned.$div_ulong_uint((long)AtomicSizeInBits, (int)this.getCharWidth())));
    }

    @Override
    public int getMaxVectorAlign() {
        return Unsigned.$ushort2uint((char)this.MaxVectorAlign);
    }

    @Override
    public int getSimdDefaultAlign() {
        return Unsigned.$ushort2uint((char)this.SimdDefaultAlign);
    }

    @Override
    public int getExnObjectAlignment() {
        return this.getDefaultAlignForAttributeAligned();
    }

    @Override
    public int getIntMaxTWidth() {
        return this.getTypeWidth(this.IntMaxType);
    }

    @Override
    public int getUnwindWordWidth() {
        return Unsigned.$ulong2uint((long)this.getPointerWidth(0));
    }

    @Override
    public int getRegisterWidth() {
        return Unsigned.$uchar2uint((byte)this.PointerWidth);
    }

    @Override
    public char.ptr getMCountName() {
        return this.MCountName;
    }

    @Override
    public boolean useSignedCharForObjCBool() {
        return this.UseSignedCharForObjCBool;
    }

    @Override
    public void noSignedCharForObjCBool() {
        this.UseSignedCharForObjCBool = false;
    }

    @Override
    public boolean useBitFieldTypeAlignment() {
        return this.UseBitFieldTypeAlignment;
    }

    @Override
    public boolean useZeroLengthBitfieldAlignment() {
        return this.UseZeroLengthBitfieldAlignment;
    }

    @Override
    public int getZeroLengthBitfieldBoundary() {
        return this.ZeroLengthBitfieldBoundary;
    }

    @Override
    public boolean useExplicitBitFieldAlignment() {
        return this.UseExplicitBitFieldAlignment;
    }

    @Override
    public boolean hasAlignMac68kSupport() {
        return this.HasAlignMac68kSupport;
    }

    public static char.ptr getTypeName(TargetInfo.IntType T2) {
        switch (T2) {
            default: {
                throw new llvm_unreachable("not an integer!");
            }
            case SignedChar: {
                return NativePointer.$signed_char;
            }
            case UnsignedChar: {
                return NativePointer.$unsigned_char;
            }
            case SignedShort: {
                return NativePointer.$short;
            }
            case UnsignedShort: {
                return NativePointer.$unsigned_short;
            }
            case SignedInt: {
                return NativePointer.$int;
            }
            case UnsignedInt: {
                return NativePointer.$unsigned_int;
            }
            case SignedLong: {
                return NativePointer.$long_int;
            }
            case UnsignedLong: {
                return NativePointer.$long_unsigned_int;
            }
            case SignedLongLong: {
                return NativePointer.$long_long_int;
            }
            case UnsignedLongLong: 
        }
        return NativePointer.$long_long_unsigned_int;
    }

    @Override
    public char.ptr getTypeConstantSuffix(TargetInfo.IntType T2) {
        switch (T2) {
            default: {
                throw new llvm_unreachable("not an integer!");
            }
            case SignedChar: 
            case SignedShort: 
            case SignedInt: {
                return NativePointer.$EMPTY;
            }
            case SignedLong: {
                return NativePointer.$L;
            }
            case SignedLongLong: {
                return NativePointer.$LL;
            }
            case UnsignedChar: {
                if (Unsigned.$less_uint((int)this.getCharWidth(), (int)this.getIntWidth())) {
                    return NativePointer.$EMPTY;
                }
            }
            case UnsignedShort: {
                if (Unsigned.$less_uint((int)this.getShortWidth(), (int)this.getIntWidth())) {
                    return NativePointer.$EMPTY;
                }
            }
            case UnsignedInt: {
                return NativePointer.$U;
            }
            case UnsignedLong: {
                return NativePointer.$UL;
            }
            case UnsignedLongLong: 
        }
        return NativePointer.$ULL;
    }

    public static char.ptr getTypeFormatModifier(TargetInfo.IntType T2) {
        switch (T2) {
            default: {
                throw new llvm_unreachable("not an integer!");
            }
            case SignedChar: 
            case UnsignedChar: {
                return NativePointer.$hh;
            }
            case SignedShort: 
            case UnsignedShort: {
                return NativePointer.$h;
            }
            case SignedInt: 
            case UnsignedInt: {
                return NativePointer.$EMPTY;
            }
            case SignedLong: 
            case UnsignedLong: {
                return NativePointer.$l;
            }
            case SignedLongLong: 
            case UnsignedLongLong: 
        }
        return NativePointer.$ll;
    }

    @Override
    public boolean useObjCFPRetForRealType(TargetInfo.RealType T2) {
        return (this.RealTypeUsesObjCFPRet & 1 << T2.getValue()) != 0;
    }

    @Override
    public boolean useObjCFP2RetForComplexLongDouble() {
        return this.ComplexLongDoubleUsesFP2Ret;
    }

    @Override
    public boolean useAddressSpaceMapMangling() {
        return this.UseAddrSpaceMapMangling;
    }

    @Override
    public abstract void getTargetDefines(LangOptions var1, MacroBuilder var2);

    @Override
    public abstract ArrayRef<Builtin.Info> getTargetBuiltins();

    @Override
    public boolean isCLZForZeroUndef() {
        return true;
    }

    @Override
    public abstract TargetInfo.BuiltinVaListKind getBuiltinVaListKind();

    @Override
    public boolean hasBuiltinMSVaList() {
        return this.HasBuiltinMSVaList;
    }

    @Override
    public boolean isValidClobber(StringRef Name) {
        return this.isValidGCCRegisterName(new StringRef(Name)) || llvm.$eq_StringRef((StringRef)Name, (String)"memory") || llvm.$eq_StringRef((StringRef)Name, (String)"cc");
    }

    @Override
    public boolean isValidGCCRegisterName(StringRef Name) {
        uint.ref n;
        if (Name.empty()) {
            return false;
        }
        Name.$assignMove(TargetInfoStatics.removeGCCRegisterPrefix(new StringRef(Name)));
        if (Name.empty()) {
            return false;
        }
        ArrayRef<char.ptr> Names = this.getGCCRegNames();
        if (BasicClangGlobals.isDigit(Name.$at(0)) && !Name.getAsInteger$NotSigned(0, n = NativePointer.create_uint$ref())) {
            return Unsigned.$less_uint((uint.ref)n, (int)Names.size());
        }
        if (Native.$noteq_ptr((void.ptr)((void.ptr)std.find((type.iterator)Names.begin(), (type.iterator)Names.end(), (Object)Name)), (void.ptr)Names.end())) {
            return true;
        }
        for (TargetInfo.AddlRegName ARN : this.getGCCAddlRegNames()) {
            for (char.ptr AN : ARN.Names) {
                if (AN == null) break;
                if (!llvm.$eq_StringRef((char.ptr)AN, (StringRef)Name) || !Unsigned.$less_uint((int)ARN.RegNum, (int)Names.size())) continue;
                return true;
            }
        }
        for (TargetInfo.GCCRegAlias GRA : this.getGCCRegAliases()) {
            for (char.ptr A : GRA.Aliases) {
                if (A == null) break;
                if (!llvm.$eq_StringRef((char.ptr)A, (StringRef)Name)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public StringRef getNormalizedGCCRegisterName(StringRef Name) {
        uint.ref n;
        assert (this.isValidGCCRegisterName(new StringRef(Name))) : "Invalid register passed in";
        Name.$assignMove(TargetInfoStatics.removeGCCRegisterPrefix(new StringRef(Name)));
        ArrayRef<char.ptr> Names = this.getGCCRegNames();
        if (BasicClangGlobals.isDigit(Name.$at(0)) && !Name.getAsInteger$NotSigned(0, n = NativePointer.create_uint$ref())) {
            assert (Unsigned.$less_uint((uint.ref)n, (int)Names.size())) : "Out of bounds register number!";
            return new StringRef((char.ptr)Names.$at(n));
        }
        for (TargetInfo.AddlRegName ARN : this.getGCCAddlRegNames()) {
            for (char.ptr AN : ARN.Names) {
                if (AN == null) break;
                if (!llvm.$eq_StringRef((char.ptr)AN, (StringRef)Name) || !Unsigned.$less_uint((int)ARN.RegNum, (int)Names.size())) continue;
                return new StringRef(JavaDifferentiators.JD.Move.INSTANCE, Name);
            }
        }
        for (TargetInfo.GCCRegAlias RA : this.getGCCRegAliases()) {
            for (char.ptr A : RA.Aliases) {
                if (A == null) break;
                if (!llvm.$eq_StringRef((char.ptr)A, (StringRef)Name)) continue;
                return new StringRef(RA.Register);
            }
        }
        return new StringRef(JavaDifferentiators.JD.Move.INSTANCE, Name);
    }

    @Override
    public boolean validateGlobalRegisterVariable(StringRef RegName, int RegSize, bool.ref HasSizeMismatch) {
        HasSizeMismatch.$set(false);
        return true;
    }

    @Override
    public boolean validateOutputConstraint(TargetInfo.ConstraintInfo Info2) {
        char.ptr Name = Native.$tryClone((char.ptr)Info2.getConstraintStr().c_str());
        if (Name.$star() != 61 && Name.$star() != 43) {
            return false;
        }
        if (Name.$star() == 43) {
            Info2.setIsReadWrite();
        }
        Name.$postInc();
        while (Name.$star() != 0) {
            switch (Name.$star()) {
                default: {
                    if (this.validateAsmConstraint(Name, Info2)) break;
                    return false;
                }
                case 38: {
                    Info2.setEarlyClobber();
                    break;
                }
                case 37: {
                    break;
                }
                case 114: {
                    Info2.setAllowsRegister();
                    break;
                }
                case 60: 
                case 62: 
                case 86: 
                case 109: 
                case 111: {
                    Info2.setAllowsMemory();
                    break;
                }
                case 88: 
                case 103: {
                    Info2.setAllowsRegister();
                    Info2.setAllowsMemory();
                    break;
                }
                case 44: {
                    if (Name.$at(1) != 61 && Name.$at(1) != 43) break;
                    Name.$postInc();
                    break;
                }
                case 35: {
                    while (Name.$at(1) != 0 && Name.$at(1) != 44) {
                        Name.$postInc();
                    }
                    break;
                }
                case 33: 
                case 42: 
                case 63: 
            }
            Name.$postInc();
        }
        if (Info2.earlyClobber() && Info2.isReadWrite() && !Info2.allowsRegister()) {
            return false;
        }
        return Info2.allowsMemory() || Info2.allowsRegister();
    }

    @Override
    public boolean validateInputConstraint(MutableArrayRef<TargetInfo.ConstraintInfo> OutputConstraints, TargetInfo.ConstraintInfo Info2) {
        char.ptr Name = Native.$tryClone((char.ptr)Info2.ConstraintStr.c_str());
        if (Name.$star() == 0) {
            return false;
        }
        while (Name.$star() != 0) {
            switch (Name.$star()) {
                default: {
                    if (Name.$star() >= 48 && Name.$star() <= 57) {
                        char.ptr DigitStart = Native.$tryClone((char.ptr)Name);
                        while (Name.$at(1) >= 48 && Name.$at(1) <= 57) {
                            Name.$postInc();
                        }
                        char.ptr DigitEnd = Native.$tryClone((char.ptr)Name);
                        uint.ref i = NativePointer.create_uint$ref();
                        if (new StringRef(DigitStart, DigitEnd.$sub((abstract_iterator)DigitStart) + 1).getAsInteger$NotSigned(10, i)) {
                            return false;
                        }
                        if (Unsigned.$greatereq_uint((uint.ref)i, (int)OutputConstraints.size())) {
                            return false;
                        }
                        if (((TargetInfo.ConstraintInfo)OutputConstraints.$at(i)).isReadWrite()) {
                            return false;
                        }
                        if (Info2.hasTiedOperand() && Info2.getTiedOperand() != i.$deref()) {
                            return false;
                        }
                        Info2.setTiedOperand(i.$deref(), (TargetInfo.ConstraintInfo)OutputConstraints.$at(i));
                        break;
                    }
                    if (this.validateAsmConstraint(Name, Info2)) break;
                    return false;
                }
                case 91: {
                    uint.ref Index = NativePointer.create_uint$ref((int)0);
                    if (!this.resolveSymbolicName(Name, (ArrayRef<TargetInfo.ConstraintInfo>)new ArrayRef(OutputConstraints), Index)) {
                        return false;
                    }
                    if (Info2.hasTiedOperand() && Info2.getTiedOperand() != Index.$deref()) {
                        return false;
                    }
                    if (((TargetInfo.ConstraintInfo)OutputConstraints.$at(Index)).isReadWrite()) {
                        return false;
                    }
                    Info2.setTiedOperand(Index.$deref(), (TargetInfo.ConstraintInfo)OutputConstraints.$at(Index));
                    break;
                }
                case 37: {
                    break;
                }
                case 105: 
                case 110: {
                    break;
                }
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: {
                    if (this.validateAsmConstraint(Name, Info2)) break;
                    return false;
                }
                case 114: {
                    Info2.setAllowsRegister();
                    break;
                }
                case 60: 
                case 62: 
                case 86: 
                case 109: 
                case 111: {
                    Info2.setAllowsMemory();
                    break;
                }
                case 88: 
                case 103: {
                    Info2.setAllowsRegister();
                    Info2.setAllowsMemory();
                    break;
                }
                case 69: 
                case 70: 
                case 112: {
                    break;
                }
                case 44: {
                    break;
                }
                case 35: {
                    while (Name.$at(1) != 0 && Name.$at(1) != 44) {
                        Name.$postInc();
                    }
                    break;
                }
                case 33: 
                case 42: 
                case 63: 
            }
            Name.$postInc();
        }
        return true;
    }

    @Override
    public boolean validateOutputSize(StringRef $Prm0, int $Prm1) {
        return true;
    }

    @Override
    public boolean validateInputSize(StringRef $Prm0, int $Prm1) {
        return true;
    }

    @Override
    public boolean validateConstraintModifier(StringRef $Prm0, byte $Prm1, int $Prm2, std.string $Prm3) {
        return true;
    }

    @Override
    public abstract boolean validateAsmConstraint(char.ptr var1, TargetInfo.ConstraintInfo var2);

    @Override
    public boolean resolveSymbolicName(char.ptr Name, ArrayRef<TargetInfo.ConstraintInfo> OutputConstraints, uint.ref Index) {
        assert (Name.$star() == 91) : "Symbolic name did not start with '['";
        Name.$postInc();
        char.ptr Start = Native.$tryClone((char.ptr)Name);
        while (Name.$star() != 0 && Name.$star() != 93) {
            Name.$postInc();
        }
        if (Name.$star() == 0) {
            return false;
        }
        std.string SymbolicName = new std.string(Start, Name.$sub((abstract_iterator)Start));
        Index.$set(0);
        while (Index.$deref() != OutputConstraints.size()) {
            if (std.$eq_str$C((std.string)SymbolicName, (std.string)((TargetInfo.ConstraintInfo)OutputConstraints.$at(Index.$deref())).getName())) {
                return true;
            }
            Index.$set$preInc();
        }
        return false;
    }

    @Override
    public std.string convertConstraint(char.ptr Constraint) {
        if (Constraint.$star() == 112) {
            return new std.string(NativePointer.$r);
        }
        return new std.string(1, Constraint.$star());
    }

    @Override
    public abstract char.ptr getClobbers();

    @Override
    public boolean isNan2008() {
        return true;
    }

    @Override
    public Triple getTriple() {
        return this._Triple;
    }

    @Override
    public DataLayout getDataLayout() {
        assert (this.DataLayout.$bool()) : "Uninitialized DataLayout!";
        return (DataLayout)this.DataLayout.$star();
    }

    @Override
    public boolean hasProtectedVisibility() {
        return true;
    }

    @Override
    public std.string isValidSectionSpecifier(StringRef SR) {
        return new std.string(NativePointer.$EMPTY);
    }

    @Override
    public void adjust(LangOptions Opts) {
        if (Opts.NoBitFieldTypeAlign) {
            this.UseBitFieldTypeAlignment = false;
        }
        if (Opts.ShortWChar) {
            this.WCharType = TargetInfo.IntType.UnsignedShort;
        }
        if (Opts.AlignDouble) {
            this.LongLongAlign = (byte)64;
            this.DoubleAlign = (byte)64;
            this.LongDoubleAlign = (byte)64;
        }
        if (Opts.OpenCL) {
            this.IntAlign = (byte)32;
            this.IntWidth = (byte)32;
            this.LongAlign = (byte)64;
            this.LongWidth = (byte)64;
            this.LongLongWidth = this.LongLongAlign = Unsigned.$int2uchar((int)128);
            this.HalfAlign = (byte)16;
            this.HalfWidth = (byte)16;
            this.FloatAlign = (byte)32;
            this.FloatWidth = (byte)32;
            if (Unsigned.$uchar2int((byte)this.DoubleWidth) != Unsigned.$uchar2int((byte)this.FloatWidth)) {
                this.DoubleAlign = (byte)64;
                this.DoubleWidth = (byte)64;
                this.DoubleFormat = (fltSemantics)Native.$AddrOf((Object)APFloat.IEEEdouble);
            }
            this.LongDoubleWidth = this.LongDoubleAlign = Unsigned.$int2uchar((int)128);
            assert (Unsigned.$uchar2int((byte)this.PointerWidth) == 32 || Unsigned.$uchar2int((byte)this.PointerWidth) == 64);
            boolean Is32BitArch = Unsigned.$uchar2int((byte)this.PointerWidth) == 32;
            this.SizeType = Is32BitArch ? TargetInfo.IntType.UnsignedInt : TargetInfo.IntType.UnsignedLong;
            this.PtrDiffType = Is32BitArch ? TargetInfo.IntType.SignedInt : TargetInfo.IntType.SignedLong;
            this.IntPtrType = Is32BitArch ? TargetInfo.IntType.SignedInt : TargetInfo.IntType.SignedLong;
            this.IntMaxType = TargetInfo.IntType.SignedLongLong;
            this.Int64Type = TargetInfo.IntType.SignedLong;
            this.HalfFormat = (fltSemantics)Native.$AddrOf((Object)APFloat.IEEEhalf);
            this.FloatFormat = (fltSemantics)Native.$AddrOf((Object)APFloat.IEEEsingle);
            this.LongDoubleFormat = (fltSemantics)Native.$AddrOf((Object)APFloat.IEEEquad);
        }
    }

    @Override
    public boolean initFeatureMap(StringMapBool Features, DiagnosticsEngine Diags, StringRef CPU, std.vectorString FeatureVec) {
        for (std.string F : FeatureVec) {
            StringRef Name = new StringRef(F);
            boolean Enabled = Name.$at(0) == 43;
            this.setFeatureEnabled(Features, Name.substr(1), Enabled);
        }
        return true;
    }

    @Override
    public StringRef getABI() {
        return new StringRef();
    }

    @Override
    public TargetCXXABI getCXXABI() {
        return this.TheCXXABI;
    }

    @Override
    public boolean setCPU(std.string Name) {
        return false;
    }

    @Override
    public boolean setABI(std.string Name) {
        return false;
    }

    @Override
    public boolean setFPMath(StringRef Name) {
        return false;
    }

    @Override
    public void setFeatureEnabled(StringMapBool Features, StringRef Name, boolean Enabled) {
        Features.GetOrCreateValue(Name).setValue(Enabled);
    }

    @Override
    public boolean handleTargetFeatures(std.vectorString Features, DiagnosticsEngine Diags) {
        return true;
    }

    @Override
    public boolean hasFeature(StringRef Feature2) {
        return false;
    }

    @Override
    public boolean validateCpuSupports(StringRef Name) {
        return false;
    }

    @Override
    public int getRegParmMax() {
        assert (Unsigned.$uchar2int((byte)this.RegParmMax) < 7) : "RegParmMax value is larger than AST can handle";
        return Unsigned.$uchar2uint((byte)this.RegParmMax);
    }

    @Override
    public boolean isTLSSupported() {
        return this.TLSSupported;
    }

    @Override
    public char getMaxTLSAlign() {
        return this.MaxTLSAlign;
    }

    @Override
    public boolean isSEHTrySupported() {
        return this.getTriple().isOSWindows() && (this.getTriple().getArch() == Triple.ArchType.x86 || this.getTriple().getArch() == Triple.ArchType.x86_64);
    }

    @Override
    public boolean hasNoAsmVariants() {
        return this.NoAsmVariants;
    }

    @Override
    public int getEHDataRegisterNumber(int RegNo) {
        return -1;
    }

    @Override
    public char.ptr getStaticInitSectionSpecifier() {
        return null;
    }

    @Override
    public LangAS.Map getAddressSpaceMap() {
        return this.AddrSpaceMap;
    }

    @Override
    public StringRef getPlatformName() {
        return this.PlatformName;
    }

    @Override
    public VersionTuple getPlatformMinVersion() {
        return this.PlatformMinVersion;
    }

    @Override
    public boolean isBigEndian() {
        return this.BigEndian;
    }

    @Override
    public CallingConv getDefaultCallingConv(TargetInfo.CallingConvMethodType MT) {
        return CallingConv.CC_C;
    }

    @Override
    public TargetInfo.CallingConvCheckResult checkCallingConvention(CallingConv CC) {
        switch (CC) {
            default: {
                return TargetInfo.CallingConvCheckResult.CCCR_Warning;
            }
            case CC_C: 
        }
        return TargetInfo.CallingConvCheckResult.CCCR_OK;
    }

    @Override
    public boolean hasSjLjLowering() {
        return false;
    }

    @Override
    public boolean allowsLargerPreferedTypeAlignment() {
        return true;
    }

    @Override
    public void setSupportedOpenCLOpts() {
    }

    @Override
    public OpenCLOptions getSupportedOpenCLOpts() {
        return this.getTargetOpts().SupportedOpenCLOptions;
    }

    @Override
    public OpenCLOptions getSupportedOpenCLOpts$Const() {
        return this.getTargetOpts().SupportedOpenCLOptions;
    }

    @Override
    public boolean validateTarget(DiagnosticsEngine Diags) {
        return true;
    }

    @Override
    protected long getPointerWidthV(int AddrSpace) {
        return Unsigned.$uchar2ulong((byte)this.PointerWidth);
    }

    @Override
    protected long getPointerAlignV(int AddrSpace) {
        return Unsigned.$uchar2ulong((byte)this.PointerAlign);
    }

    @Override
    protected TargetInfo.IntType getPtrDiffTypeV(int AddrSpace) {
        return this.PtrDiffType;
    }

    @Override
    protected abstract ArrayRef<char.ptr> getGCCRegNames();

    @Override
    protected abstract ArrayRef<TargetInfo.GCCRegAlias> getGCCRegAliases();

    @Override
    protected ArrayRef<TargetInfo.AddlRegName> getGCCAddlRegNames() {
        return ArrayRef.None();
    }

    public String toString() {
        return "TargetOpts=" + this.TargetOpts + ", _Triple=" + this._Triple + ", BigEndian=" + this.BigEndian + ", TLSSupported=" + this.TLSSupported + ", NoAsmVariants=" + this.NoAsmVariants + ", HasFloat128=" + this.HasFloat128 + ", PointerWidth=" + this.PointerWidth + ", PointerAlign=" + this.PointerAlign + ", BoolWidth=" + this.BoolWidth + ", BoolAlign=" + this.BoolAlign + ", IntWidth=" + this.IntWidth + ", IntAlign=" + this.IntAlign + ", HalfWidth=" + this.HalfWidth + ", HalfAlign=" + this.HalfAlign + ", FloatWidth=" + this.FloatWidth + ", FloatAlign=" + this.FloatAlign + ", DoubleWidth=" + this.DoubleWidth + ", DoubleAlign=" + this.DoubleAlign + ", LongDoubleWidth=" + this.LongDoubleWidth + ", LongDoubleAlign=" + this.LongDoubleAlign + ", Float128Align=" + this.Float128Align + ", LargeArrayMinWidth=" + this.LargeArrayMinWidth + ", LargeArrayAlign=" + this.LargeArrayAlign + ", LongWidth=" + this.LongWidth + ", LongAlign=" + this.LongAlign + ", LongLongWidth=" + this.LongLongWidth + ", LongLongAlign=" + this.LongLongAlign + ", SuitableAlign=" + this.SuitableAlign + ", DefaultAlignForAttributeAligned=" + this.DefaultAlignForAttributeAligned + ", MinGlobalAlign=" + this.MinGlobalAlign + ", MaxAtomicPromoteWidth=" + this.MaxAtomicPromoteWidth + ", MaxAtomicInlineWidth=" + this.MaxAtomicInlineWidth + ", MaxVectorAlign=" + this.MaxVectorAlign + ", MaxTLSAlign=" + this.MaxTLSAlign + ", SimdDefaultAlign=" + this.SimdDefaultAlign + ", DataLayout=" + this.DataLayout + ", MCountName=" + this.MCountName + ", HalfFormat=" + this.HalfFormat + ", FloatFormat=" + this.FloatFormat + ", DoubleFormat=" + this.DoubleFormat + ", LongDoubleFormat=" + this.LongDoubleFormat + ", Float128Format=" + this.Float128Format + ", RegParmMax=" + this.RegParmMax + ", SSERegParmMax=" + this.SSERegParmMax + ", TheCXXABI=" + this.TheCXXABI + ", AddrSpaceMap=" + this.AddrSpaceMap + ", PlatformName=" + this.PlatformName + ", PlatformMinVersion=" + this.PlatformMinVersion + ", HasAlignMac68kSupport=" + this.HasAlignMac68kSupport + ", RealTypeUsesObjCFPRet=" + this.RealTypeUsesObjCFPRet + ", ComplexLongDoubleUsesFP2Ret=" + this.ComplexLongDoubleUsesFP2Ret + ", HasBuiltinMSVaList=" + this.HasBuiltinMSVaList + ", SizeType=" + (Object)((Object)this.SizeType) + ", IntMaxType=" + (Object)((Object)this.IntMaxType) + ", PtrDiffType=" + (Object)((Object)this.PtrDiffType) + ", IntPtrType=" + (Object)((Object)this.IntPtrType) + ", WCharType=" + (Object)((Object)this.WCharType) + ", WIntType=" + (Object)((Object)this.WIntType) + ", Char16Type=" + (Object)((Object)this.Char16Type) + ", Char32Type=" + (Object)((Object)this.Char32Type) + ", Int64Type=" + (Object)((Object)this.Int64Type) + ", SigAtomicType=" + (Object)((Object)this.SigAtomicType) + ", ProcessIDType=" + (Object)((Object)this.ProcessIDType) + ", UseSignedCharForObjCBool=" + this.UseSignedCharForObjCBool + ", UseBitFieldTypeAlignment=" + this.UseBitFieldTypeAlignment + ", UseZeroLengthBitfieldAlignment=" + this.UseZeroLengthBitfieldAlignment + ", UseExplicitBitFieldAlignment=" + this.UseExplicitBitFieldAlignment + ", ZeroLengthBitfieldBoundary=" + this.ZeroLengthBitfieldBoundary + ", UseAddrSpaceMapMangling=" + this.UseAddrSpaceMapMangling + super.toString();
    }
}

