/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic.target.impl;

import org.clang.basic.target.TargetInfo;
import org.clang.basic.target.TargetOptions;
import org.clang.basic.target.impl.PPCTargetInfo;
import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.llvm.adt.APFloat;
import org.llvm.adt.StringRef;
import org.llvm.adt.Triple;
import org.llvm.support.fltSemantics;

public class PPC64TargetInfo
extends PPCTargetInfo
implements Destructors.ClassWithDestructor {
    public PPC64TargetInfo(Triple _Triple, TargetOptions Opts) {
        super(_Triple, Opts);
        this.PointerAlign = (byte)64;
        this.PointerWidth = (byte)64;
        this.LongAlign = (byte)64;
        this.LongWidth = (byte)64;
        this.IntMaxType = TargetInfo.IntType.SignedLong;
        this.Int64Type = TargetInfo.IntType.SignedLong;
        if (_Triple.getArch() == Triple.ArchType.ppc64le) {
            this.resetDataLayout(new StringRef("e-m:e-i64:64-n32:64"));
            this.ABI.$assign((CharSequence)"elfv2");
        } else {
            this.resetDataLayout(new StringRef("E-m:e-i64:64-n32:64"));
            this.ABI.$assign((CharSequence)"elfv1");
        }
        switch (this.getTriple().getOS()) {
            case FreeBSD: {
                this.LongDoubleAlign = (byte)64;
                this.LongDoubleWidth = (byte)64;
                this.LongDoubleFormat = (fltSemantics)Native.$AddrOf((Object)APFloat.IEEEdouble);
                break;
            }
            case NetBSD: {
                this.IntMaxType = TargetInfo.IntType.SignedLongLong;
                this.Int64Type = TargetInfo.IntType.SignedLongLong;
                break;
            }
        }
        this.MaxAtomicInlineWidth = (byte)64;
        this.MaxAtomicPromoteWidth = (byte)64;
    }

    @Override
    public TargetInfo.BuiltinVaListKind getBuiltinVaListKind() {
        return TargetInfo.BuiltinVaListKind.CharPtrBuiltinVaList;
    }

    @Override
    public boolean setABI(std.string Name) {
        if (std.$eq_string$C_T((std.string)Name, (String)"elfv1") || std.$eq_string$C_T((std.string)Name, (String)"elfv1-qpx") || std.$eq_string$C_T((std.string)Name, (String)"elfv2")) {
            this.ABI.$assign(Name);
            return true;
        }
        return false;
    }

    @Override
    public void $destroy() {
        super.$destroy();
    }

    @Override
    public String toString() {
        return "" + super.toString();
    }
}

