/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic.target.impl;

import org.clang.basic.Builtin;
import org.clang.basic.CallingConv;
import org.clang.basic.DiagnosticsEngine;
import org.clang.basic.LangAS;
import org.clang.basic.LangOptions;
import org.clang.basic.MacroBuilder;
import org.clang.basic.OpenCLOptions;
import org.clang.basic.target.TargetInfo;
import org.clang.basic.target.TargetOptions;
import org.clang.basic.target.impl.TargetInfo;
import org.clang.basic.target.impl.TargetsStatics;
import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.llvm.adt.StringRef;
import org.llvm.adt.StringSwitch;
import org.llvm.adt.Triple;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.StringMapBool;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;

public final class AMDGPUTargetInfo
extends TargetInfo
implements Destructors.ClassWithDestructor {
    private static Builtin.Info[] BuiltinInfo = new Builtin.Info[]{new Builtin.Info("__builtin_amdgcn_kernarg_segment_ptr", "Uc*2", NativePointer.$nc, null, 14, null), new Builtin.Info("__builtin_amdgcn_implicitarg_ptr", "Uc*2", NativePointer.$nc, null, 14, null), new Builtin.Info("__builtin_amdgcn_workgroup_id_x", "Ui", NativePointer.$nc, null, 14, null), new Builtin.Info("__builtin_amdgcn_workgroup_id_y", "Ui", NativePointer.$nc, null, 14, null), new Builtin.Info("__builtin_amdgcn_workgroup_id_z", "Ui", NativePointer.$nc, null, 14, null), new Builtin.Info("__builtin_amdgcn_workitem_id_x", "Ui", NativePointer.$nc, null, 14, null), new Builtin.Info("__builtin_amdgcn_workitem_id_y", "Ui", NativePointer.$nc, null, 14, null), new Builtin.Info("__builtin_amdgcn_workitem_id_z", "Ui", NativePointer.$nc, null, 14, null), new Builtin.Info("__builtin_amdgcn_s_barrier", NativePointer.$v, NativePointer.$n, null, 14, null), new Builtin.Info("__builtin_amdgcn_div_scale", "dddbb*", NativePointer.$n, null, 14, null), new Builtin.Info("__builtin_amdgcn_div_scalef", "fffbb*", NativePointer.$n, null, 14, null), new Builtin.Info("__builtin_amdgcn_div_fmas", "ddddb", NativePointer.$nc, null, 14, null), new Builtin.Info("__builtin_amdgcn_div_fmasf", "ffffb", NativePointer.$nc, null, 14, null), new Builtin.Info("__builtin_amdgcn_div_fixup", "dddd", NativePointer.$nc, null, 14, null), new Builtin.Info("__builtin_amdgcn_div_fixupf", "ffff", NativePointer.$nc, null, 14, null), new Builtin.Info("__builtin_amdgcn_trig_preop", "ddi", NativePointer.$nc, null, 14, null), new Builtin.Info("__builtin_amdgcn_trig_preopf", "ffi", NativePointer.$nc, null, 14, null), new Builtin.Info("__builtin_amdgcn_rcp", NativePointer.$dd, NativePointer.$nc, null, 14, null), new Builtin.Info("__builtin_amdgcn_rcpf", NativePointer.$ff, NativePointer.$nc, null, 14, null), new Builtin.Info("__builtin_amdgcn_rsq", NativePointer.$dd, NativePointer.$nc, null, 14, null), new Builtin.Info("__builtin_amdgcn_rsqf", NativePointer.$ff, NativePointer.$nc, null, 14, null), new Builtin.Info("__builtin_amdgcn_rsq_clamp", NativePointer.$dd, NativePointer.$nc, null, 14, null), new Builtin.Info("__builtin_amdgcn_rsq_clampf", NativePointer.$ff, NativePointer.$nc, null, 14, null), new Builtin.Info("__builtin_amdgcn_sinf", NativePointer.$ff, NativePointer.$nc, null, 14, null), new Builtin.Info("__builtin_amdgcn_cosf", NativePointer.$ff, NativePointer.$nc, null, 14, null), new Builtin.Info("__builtin_amdgcn_log_clampf", NativePointer.$ff, NativePointer.$nc, null, 14, null), new Builtin.Info("__builtin_amdgcn_ldexp", "ddi", NativePointer.$nc, null, 14, null), new Builtin.Info("__builtin_amdgcn_ldexpf", "ffi", NativePointer.$nc, null, 14, null), new Builtin.Info("__builtin_amdgcn_frexp_mant", NativePointer.$dd, NativePointer.$nc, null, 14, null), new Builtin.Info("__builtin_amdgcn_frexp_mantf", NativePointer.$ff, NativePointer.$nc, null, 14, null), new Builtin.Info("__builtin_amdgcn_frexp_exp", "id", NativePointer.$nc, null, 14, null), new Builtin.Info("__builtin_amdgcn_frexp_expf", NativePointer.$if, NativePointer.$nc, null, 14, null), new Builtin.Info("__builtin_amdgcn_fract", NativePointer.$dd, NativePointer.$nc, null, 14, null), new Builtin.Info("__builtin_amdgcn_fractf", NativePointer.$ff, NativePointer.$nc, null, 14, null), new Builtin.Info("__builtin_amdgcn_lerp", "UiUiUiUi", NativePointer.$nc, null, 14, null), new Builtin.Info("__builtin_amdgcn_class", "bdi", NativePointer.$nc, null, 14, null), new Builtin.Info("__builtin_amdgcn_classf", "bfi", NativePointer.$nc, null, 14, null), new Builtin.Info("__builtin_amdgcn_cubeid", "ffff", NativePointer.$nc, null, 14, null), new Builtin.Info("__builtin_amdgcn_cubesc", "ffff", NativePointer.$nc, null, 14, null), new Builtin.Info("__builtin_amdgcn_cubetc", "ffff", NativePointer.$nc, null, 14, null), new Builtin.Info("__builtin_amdgcn_cubema", "ffff", NativePointer.$nc, null, 14, null), new Builtin.Info("__builtin_amdgcn_s_memtime", "LUi", NativePointer.$n, null, 14, null), new Builtin.Info("__builtin_amdgcn_s_sleep", "vIi", NativePointer.$n, null, 14, null), new Builtin.Info("__builtin_amdgcn_s_memrealtime", "LUi", NativePointer.$n, null, 14, NativePointer.$((String)"s-memrealtime")), new Builtin.Info("__builtin_amdgcn_read_exec", "LUi", NativePointer.$nc, null, 14, null), new Builtin.Info("__builtin_r600_implicitarg_ptr", "Uc*7", NativePointer.$nc, null, 14, null), new Builtin.Info("__builtin_r600_read_tgid_x", "Ui", NativePointer.$nc, null, 14, null), new Builtin.Info("__builtin_r600_read_tgid_y", "Ui", NativePointer.$nc, null, 14, null), new Builtin.Info("__builtin_r600_read_tgid_z", "Ui", NativePointer.$nc, null, 14, null), new Builtin.Info("__builtin_r600_read_tidig_x", "Ui", NativePointer.$nc, null, 14, null), new Builtin.Info("__builtin_r600_read_tidig_y", "Ui", NativePointer.$nc, null, 14, null), new Builtin.Info("__builtin_r600_read_tidig_z", "Ui", NativePointer.$nc, null, 14, null), new Builtin.Info("__builtin_r600_recipsqrt_ieee", NativePointer.$dd, NativePointer.$nc, null, 14, null), new Builtin.Info("__builtin_r600_recipsqrt_ieeef", NativePointer.$ff, NativePointer.$nc, null, 14, null)};
    private static char.ptr[] GCCRegNames = new char.ptr[]{NativePointer.$((String)"v0"), NativePointer.$((String)"v1"), NativePointer.$((String)"v2"), NativePointer.$((String)"v3"), NativePointer.$((String)"v4"), NativePointer.$((String)"v5"), NativePointer.$((String)"v6"), NativePointer.$((String)"v7"), NativePointer.$((String)"v8"), NativePointer.$((String)"v9"), NativePointer.$((String)"v10"), NativePointer.$((String)"v11"), NativePointer.$((String)"v12"), NativePointer.$((String)"v13"), NativePointer.$((String)"v14"), NativePointer.$((String)"v15"), NativePointer.$((String)"v16"), NativePointer.$((String)"v17"), NativePointer.$((String)"v18"), NativePointer.$((String)"v19"), NativePointer.$((String)"v20"), NativePointer.$((String)"v21"), NativePointer.$((String)"v22"), NativePointer.$((String)"v23"), NativePointer.$((String)"v24"), NativePointer.$((String)"v25"), NativePointer.$((String)"v26"), NativePointer.$((String)"v27"), NativePointer.$((String)"v28"), NativePointer.$((String)"v29"), NativePointer.$((String)"v30"), NativePointer.$((String)"v31"), NativePointer.$((String)"v32"), NativePointer.$((String)"v33"), NativePointer.$((String)"v34"), NativePointer.$((String)"v35"), NativePointer.$((String)"v36"), NativePointer.$((String)"v37"), NativePointer.$((String)"v38"), NativePointer.$((String)"v39"), NativePointer.$((String)"v40"), NativePointer.$((String)"v41"), NativePointer.$((String)"v42"), NativePointer.$((String)"v43"), NativePointer.$((String)"v44"), NativePointer.$((String)"v45"), NativePointer.$((String)"v46"), NativePointer.$((String)"v47"), NativePointer.$((String)"v48"), NativePointer.$((String)"v49"), NativePointer.$((String)"v50"), NativePointer.$((String)"v51"), NativePointer.$((String)"v52"), NativePointer.$((String)"v53"), NativePointer.$((String)"v54"), NativePointer.$((String)"v55"), NativePointer.$((String)"v56"), NativePointer.$((String)"v57"), NativePointer.$((String)"v58"), NativePointer.$((String)"v59"), NativePointer.$((String)"v60"), NativePointer.$((String)"v61"), NativePointer.$((String)"v62"), NativePointer.$((String)"v63"), NativePointer.$((String)"v64"), NativePointer.$((String)"v65"), NativePointer.$((String)"v66"), NativePointer.$((String)"v67"), NativePointer.$((String)"v68"), NativePointer.$((String)"v69"), NativePointer.$((String)"v70"), NativePointer.$((String)"v71"), NativePointer.$((String)"v72"), NativePointer.$((String)"v73"), NativePointer.$((String)"v74"), NativePointer.$((String)"v75"), NativePointer.$((String)"v76"), NativePointer.$((String)"v77"), NativePointer.$((String)"v78"), NativePointer.$((String)"v79"), NativePointer.$((String)"v80"), NativePointer.$((String)"v81"), NativePointer.$((String)"v82"), NativePointer.$((String)"v83"), NativePointer.$((String)"v84"), NativePointer.$((String)"v85"), NativePointer.$((String)"v86"), NativePointer.$((String)"v87"), NativePointer.$((String)"v88"), NativePointer.$((String)"v89"), NativePointer.$((String)"v90"), NativePointer.$((String)"v91"), NativePointer.$((String)"v92"), NativePointer.$((String)"v93"), NativePointer.$((String)"v94"), NativePointer.$((String)"v95"), NativePointer.$((String)"v96"), NativePointer.$((String)"v97"), NativePointer.$((String)"v98"), NativePointer.$((String)"v99"), NativePointer.$((String)"v100"), NativePointer.$((String)"v101"), NativePointer.$((String)"v102"), NativePointer.$((String)"v103"), NativePointer.$((String)"v104"), NativePointer.$((String)"v105"), NativePointer.$((String)"v106"), NativePointer.$((String)"v107"), NativePointer.$((String)"v108"), NativePointer.$((String)"v109"), NativePointer.$((String)"v110"), NativePointer.$((String)"v111"), NativePointer.$((String)"v112"), NativePointer.$((String)"v113"), NativePointer.$((String)"v114"), NativePointer.$((String)"v115"), NativePointer.$((String)"v116"), NativePointer.$((String)"v117"), NativePointer.$((String)"v118"), NativePointer.$((String)"v119"), NativePointer.$((String)"v120"), NativePointer.$((String)"v121"), NativePointer.$((String)"v122"), NativePointer.$((String)"v123"), NativePointer.$((String)"v124"), NativePointer.$((String)"v125"), NativePointer.$((String)"v126"), NativePointer.$((String)"v127"), NativePointer.$((String)"v128"), NativePointer.$((String)"v129"), NativePointer.$((String)"v130"), NativePointer.$((String)"v131"), NativePointer.$((String)"v132"), NativePointer.$((String)"v133"), NativePointer.$((String)"v134"), NativePointer.$((String)"v135"), NativePointer.$((String)"v136"), NativePointer.$((String)"v137"), NativePointer.$((String)"v138"), NativePointer.$((String)"v139"), NativePointer.$((String)"v140"), NativePointer.$((String)"v141"), NativePointer.$((String)"v142"), NativePointer.$((String)"v143"), NativePointer.$((String)"v144"), NativePointer.$((String)"v145"), NativePointer.$((String)"v146"), NativePointer.$((String)"v147"), NativePointer.$((String)"v148"), NativePointer.$((String)"v149"), NativePointer.$((String)"v150"), NativePointer.$((String)"v151"), NativePointer.$((String)"v152"), NativePointer.$((String)"v153"), NativePointer.$((String)"v154"), NativePointer.$((String)"v155"), NativePointer.$((String)"v156"), NativePointer.$((String)"v157"), NativePointer.$((String)"v158"), NativePointer.$((String)"v159"), NativePointer.$((String)"v160"), NativePointer.$((String)"v161"), NativePointer.$((String)"v162"), NativePointer.$((String)"v163"), NativePointer.$((String)"v164"), NativePointer.$((String)"v165"), NativePointer.$((String)"v166"), NativePointer.$((String)"v167"), NativePointer.$((String)"v168"), NativePointer.$((String)"v169"), NativePointer.$((String)"v170"), NativePointer.$((String)"v171"), NativePointer.$((String)"v172"), NativePointer.$((String)"v173"), NativePointer.$((String)"v174"), NativePointer.$((String)"v175"), NativePointer.$((String)"v176"), NativePointer.$((String)"v177"), NativePointer.$((String)"v178"), NativePointer.$((String)"v179"), NativePointer.$((String)"v180"), NativePointer.$((String)"v181"), NativePointer.$((String)"v182"), NativePointer.$((String)"v183"), NativePointer.$((String)"v184"), NativePointer.$((String)"v185"), NativePointer.$((String)"v186"), NativePointer.$((String)"v187"), NativePointer.$((String)"v188"), NativePointer.$((String)"v189"), NativePointer.$((String)"v190"), NativePointer.$((String)"v191"), NativePointer.$((String)"v192"), NativePointer.$((String)"v193"), NativePointer.$((String)"v194"), NativePointer.$((String)"v195"), NativePointer.$((String)"v196"), NativePointer.$((String)"v197"), NativePointer.$((String)"v198"), NativePointer.$((String)"v199"), NativePointer.$((String)"v200"), NativePointer.$((String)"v201"), NativePointer.$((String)"v202"), NativePointer.$((String)"v203"), NativePointer.$((String)"v204"), NativePointer.$((String)"v205"), NativePointer.$((String)"v206"), NativePointer.$((String)"v207"), NativePointer.$((String)"v208"), NativePointer.$((String)"v209"), NativePointer.$((String)"v210"), NativePointer.$((String)"v211"), NativePointer.$((String)"v212"), NativePointer.$((String)"v213"), NativePointer.$((String)"v214"), NativePointer.$((String)"v215"), NativePointer.$((String)"v216"), NativePointer.$((String)"v217"), NativePointer.$((String)"v218"), NativePointer.$((String)"v219"), NativePointer.$((String)"v220"), NativePointer.$((String)"v221"), NativePointer.$((String)"v222"), NativePointer.$((String)"v223"), NativePointer.$((String)"v224"), NativePointer.$((String)"v225"), NativePointer.$((String)"v226"), NativePointer.$((String)"v227"), NativePointer.$((String)"v228"), NativePointer.$((String)"v229"), NativePointer.$((String)"v230"), NativePointer.$((String)"v231"), NativePointer.$((String)"v232"), NativePointer.$((String)"v233"), NativePointer.$((String)"v234"), NativePointer.$((String)"v235"), NativePointer.$((String)"v236"), NativePointer.$((String)"v237"), NativePointer.$((String)"v238"), NativePointer.$((String)"v239"), NativePointer.$((String)"v240"), NativePointer.$((String)"v241"), NativePointer.$((String)"v242"), NativePointer.$((String)"v243"), NativePointer.$((String)"v244"), NativePointer.$((String)"v245"), NativePointer.$((String)"v246"), NativePointer.$((String)"v247"), NativePointer.$((String)"v248"), NativePointer.$((String)"v249"), NativePointer.$((String)"v250"), NativePointer.$((String)"v251"), NativePointer.$((String)"v252"), NativePointer.$((String)"v253"), NativePointer.$((String)"v254"), NativePointer.$((String)"v255"), NativePointer.$((String)"s0"), NativePointer.$((String)"s1"), NativePointer.$((String)"s2"), NativePointer.$((String)"s3"), NativePointer.$((String)"s4"), NativePointer.$((String)"s5"), NativePointer.$((String)"s6"), NativePointer.$((String)"s7"), NativePointer.$((String)"s8"), NativePointer.$((String)"s9"), NativePointer.$((String)"s10"), NativePointer.$((String)"s11"), NativePointer.$((String)"s12"), NativePointer.$((String)"s13"), NativePointer.$((String)"s14"), NativePointer.$((String)"s15"), NativePointer.$((String)"s16"), NativePointer.$((String)"s17"), NativePointer.$((String)"s18"), NativePointer.$((String)"s19"), NativePointer.$((String)"s20"), NativePointer.$((String)"s21"), NativePointer.$((String)"s22"), NativePointer.$((String)"s23"), NativePointer.$((String)"s24"), NativePointer.$((String)"s25"), NativePointer.$((String)"s26"), NativePointer.$((String)"s27"), NativePointer.$((String)"s28"), NativePointer.$((String)"s29"), NativePointer.$((String)"s30"), NativePointer.$((String)"s31"), NativePointer.$((String)"s32"), NativePointer.$((String)"s33"), NativePointer.$((String)"s34"), NativePointer.$((String)"s35"), NativePointer.$((String)"s36"), NativePointer.$((String)"s37"), NativePointer.$((String)"s38"), NativePointer.$((String)"s39"), NativePointer.$((String)"s40"), NativePointer.$((String)"s41"), NativePointer.$((String)"s42"), NativePointer.$((String)"s43"), NativePointer.$((String)"s44"), NativePointer.$((String)"s45"), NativePointer.$((String)"s46"), NativePointer.$((String)"s47"), NativePointer.$((String)"s48"), NativePointer.$((String)"s49"), NativePointer.$((String)"s50"), NativePointer.$((String)"s51"), NativePointer.$((String)"s52"), NativePointer.$((String)"s53"), NativePointer.$((String)"s54"), NativePointer.$((String)"s55"), NativePointer.$((String)"s56"), NativePointer.$((String)"s57"), NativePointer.$((String)"s58"), NativePointer.$((String)"s59"), NativePointer.$((String)"s60"), NativePointer.$((String)"s61"), NativePointer.$((String)"s62"), NativePointer.$((String)"s63"), NativePointer.$((String)"s64"), NativePointer.$((String)"s65"), NativePointer.$((String)"s66"), NativePointer.$((String)"s67"), NativePointer.$((String)"s68"), NativePointer.$((String)"s69"), NativePointer.$((String)"s70"), NativePointer.$((String)"s71"), NativePointer.$((String)"s72"), NativePointer.$((String)"s73"), NativePointer.$((String)"s74"), NativePointer.$((String)"s75"), NativePointer.$((String)"s76"), NativePointer.$((String)"s77"), NativePointer.$((String)"s78"), NativePointer.$((String)"s79"), NativePointer.$((String)"s80"), NativePointer.$((String)"s81"), NativePointer.$((String)"s82"), NativePointer.$((String)"s83"), NativePointer.$((String)"s84"), NativePointer.$((String)"s85"), NativePointer.$((String)"s86"), NativePointer.$((String)"s87"), NativePointer.$((String)"s88"), NativePointer.$((String)"s89"), NativePointer.$((String)"s90"), NativePointer.$((String)"s91"), NativePointer.$((String)"s92"), NativePointer.$((String)"s93"), NativePointer.$((String)"s94"), NativePointer.$((String)"s95"), NativePointer.$((String)"s96"), NativePointer.$((String)"s97"), NativePointer.$((String)"s98"), NativePointer.$((String)"s99"), NativePointer.$((String)"s100"), NativePointer.$((String)"s101"), NativePointer.$((String)"s102"), NativePointer.$((String)"s103"), NativePointer.$((String)"s104"), NativePointer.$((String)"s105"), NativePointer.$((String)"s106"), NativePointer.$((String)"s107"), NativePointer.$((String)"s108"), NativePointer.$((String)"s109"), NativePointer.$((String)"s110"), NativePointer.$((String)"s111"), NativePointer.$((String)"s112"), NativePointer.$((String)"s113"), NativePointer.$((String)"s114"), NativePointer.$((String)"s115"), NativePointer.$((String)"s116"), NativePointer.$((String)"s117"), NativePointer.$((String)"s118"), NativePointer.$((String)"s119"), NativePointer.$((String)"s120"), NativePointer.$((String)"s121"), NativePointer.$((String)"s122"), NativePointer.$((String)"s123"), NativePointer.$((String)"s124"), NativePointer.$((String)"s125"), NativePointer.$((String)"s126"), NativePointer.$((String)"s127"), NativePointer.$((String)"exec"), NativePointer.$((String)"vcc"), NativePointer.$((String)"scc"), NativePointer.$((String)"m0"), NativePointer.$((String)"flat_scratch"), NativePointer.$((String)"exec_lo"), NativePointer.$((String)"exec_hi"), NativePointer.$((String)"vcc_lo"), NativePointer.$((String)"vcc_hi"), NativePointer.$((String)"flat_scratch_lo"), NativePointer.$((String)"flat_scratch_hi")};
    private GPUKind GPU;
    private boolean hasFP64;
    private boolean hasFMAF;
    private boolean hasLDEXPF;

    private static boolean isAMDGCN(Triple TT) {
        return TT.getArch() == Triple.ArchType.amdgcn;
    }

    public AMDGPUTargetInfo(Triple _Triple, TargetOptions $Prm1) {
        super(_Triple);
        this.GPU = AMDGPUTargetInfo.isAMDGCN(_Triple) ? GPUKind.GK_SOUTHERN_ISLANDS : GPUKind.GK_R600;
        this.hasFP64 = false;
        this.hasFMAF = false;
        this.hasLDEXPF = false;
        if (this.getTriple().getArch() == Triple.ArchType.amdgcn) {
            this.hasFP64 = true;
            this.hasFMAF = true;
            this.hasLDEXPF = true;
        }
        this.resetDataLayout(new StringRef(this.getTriple().getArch() == Triple.ArchType.amdgcn ? TargetsStatics.DataLayoutStringSI : TargetsStatics.DataLayoutStringR600));
        this.AddrSpaceMap = new LangAS.Map((int[])Native.$AddrOf((Object)TargetsStatics.AMDGPUAddrSpaceMap));
        this.UseAddrSpaceMapMangling = true;
    }

    @Override
    public long getPointerWidthV(int AddrSpace) {
        if (this.GPU.getValue() <= GPUKind.GK_CAYMAN.getValue()) {
            return 32L;
        }
        switch (AddrSpace) {
            default: {
                return 64L;
            }
            case 0: 
            case 3: 
            case 5: 
        }
        return 32L;
    }

    @Override
    public char.ptr getClobbers() {
        return NativePointer.$EMPTY;
    }

    @Override
    public ArrayRef<char.ptr> getGCCRegNames() {
        return llvm.makeArrayRef((Object[])GCCRegNames);
    }

    @Override
    public ArrayRef<TargetInfo.GCCRegAlias> getGCCRegAliases() {
        return ArrayRef.None();
    }

    @Override
    public boolean validateAsmConstraint(char.ptr Name, TargetInfo.ConstraintInfo Info2) {
        switch (Name.$star()) {
            default: {
                break;
            }
            case 115: 
            case 118: {
                Info2.setAllowsRegister();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean initFeatureMap(StringMapBool Features, DiagnosticsEngine Diags, StringRef CPU, std.vectorString FeatureVec) {
        block13: {
            block12: {
                if (this.getTriple().getArch() != Triple.ArchType.amdgcn) break block12;
                if (CPU.empty()) {
                    CPU.$assignMove("tahiti");
                }
                switch (AMDGPUTargetInfo.parseAMDGCNName(new StringRef(CPU))) {
                    case GK_SOUTHERN_ISLANDS: 
                    case GK_SEA_ISLANDS: {
                        break block13;
                    }
                    case GK_VOLCANIC_ISLANDS: {
                        Features.$set("s-memrealtime", true);
                        Features.$set("16-bit-insts", true);
                        break block13;
                    }
                    case GK_NONE: {
                        return false;
                    }
                    default: {
                        throw new llvm_unreachable("unhandled subtarget");
                    }
                }
            }
            if (CPU.empty()) {
                CPU.$assignMove("r600");
            }
            switch (AMDGPUTargetInfo.parseR600Name(new StringRef(CPU))) {
                case GK_R600: 
                case GK_R700: 
                case GK_EVERGREEN: 
                case GK_NORTHERN_ISLANDS: {
                    break;
                }
                case GK_R600_DOUBLE_OPS: 
                case GK_R700_DOUBLE_OPS: 
                case GK_EVERGREEN_DOUBLE_OPS: 
                case GK_CAYMAN: {
                    Features.$set("fp64", true);
                    break;
                }
                case GK_NONE: {
                    return false;
                }
                default: {
                    throw new llvm_unreachable("unhandled subtarget");
                }
            }
        }
        return super.initFeatureMap(Features, Diags, CPU, FeatureVec);
    }

    @Override
    public ArrayRef<Builtin.Info> getTargetBuiltins() {
        return llvm.makeArrayRef((Object[])BuiltinInfo, (int)(1024 - Builtin.ID.FirstTSBuiltin.getValue()));
    }

    @Override
    public void getTargetDefines(LangOptions Opts, MacroBuilder Builder2) {
        if (this.getTriple().getArch() == Triple.ArchType.amdgcn) {
            Builder2.defineMacro(new Twine("__AMDGCN__"));
        } else {
            Builder2.defineMacro(new Twine("__R600__"));
        }
        if (this.hasFMAF) {
            Builder2.defineMacro(new Twine("__HAS_FMAF__"));
        }
        if (this.hasLDEXPF) {
            Builder2.defineMacro(new Twine("__HAS_LDEXPF__"));
        }
        if (this.hasFP64) {
            Builder2.defineMacro(new Twine("__HAS_FP64__"));
        }
    }

    @Override
    public TargetInfo.BuiltinVaListKind getBuiltinVaListKind() {
        return TargetInfo.BuiltinVaListKind.CharPtrBuiltinVaList;
    }

    public static GPUKind parseR600Name(StringRef Name) {
        return (GPUKind)((Object)new StringSwitch(Name).Case("r600", (Object)GPUKind.GK_R600).Case("rv610", (Object)GPUKind.GK_R600).Case("rv620", (Object)GPUKind.GK_R600).Case("rv630", (Object)GPUKind.GK_R600).Case("rv635", (Object)GPUKind.GK_R600).Case("rs780", (Object)GPUKind.GK_R600).Case("rs880", (Object)GPUKind.GK_R600).Case("rv670", (Object)GPUKind.GK_R600_DOUBLE_OPS).Case("rv710", (Object)GPUKind.GK_R700).Case("rv730", (Object)GPUKind.GK_R700).Case("rv740", (Object)GPUKind.GK_R700_DOUBLE_OPS).Case("rv770", (Object)GPUKind.GK_R700_DOUBLE_OPS).Case("palm", (Object)GPUKind.GK_EVERGREEN).Case("cedar", (Object)GPUKind.GK_EVERGREEN).Case("sumo", (Object)GPUKind.GK_EVERGREEN).Case("sumo2", (Object)GPUKind.GK_EVERGREEN).Case("redwood", (Object)GPUKind.GK_EVERGREEN).Case("juniper", (Object)GPUKind.GK_EVERGREEN).Case("hemlock", (Object)GPUKind.GK_EVERGREEN_DOUBLE_OPS).Case("cypress", (Object)GPUKind.GK_EVERGREEN_DOUBLE_OPS).Case("barts", (Object)GPUKind.GK_NORTHERN_ISLANDS).Case("turks", (Object)GPUKind.GK_NORTHERN_ISLANDS).Case("caicos", (Object)GPUKind.GK_NORTHERN_ISLANDS).Case("cayman", (Object)GPUKind.GK_CAYMAN).Case("aruba", (Object)GPUKind.GK_CAYMAN).Default((Object)GPUKind.GK_NONE));
    }

    public static GPUKind parseAMDGCNName(StringRef Name) {
        return (GPUKind)((Object)new StringSwitch(Name).Case("tahiti", (Object)GPUKind.GK_SOUTHERN_ISLANDS).Case("pitcairn", (Object)GPUKind.GK_SOUTHERN_ISLANDS).Case("verde", (Object)GPUKind.GK_SOUTHERN_ISLANDS).Case("oland", (Object)GPUKind.GK_SOUTHERN_ISLANDS).Case("hainan", (Object)GPUKind.GK_SOUTHERN_ISLANDS).Case("bonaire", (Object)GPUKind.GK_SEA_ISLANDS).Case("kabini", (Object)GPUKind.GK_SEA_ISLANDS).Case("kaveri", (Object)GPUKind.GK_SEA_ISLANDS).Case("hawaii", (Object)GPUKind.GK_SEA_ISLANDS).Case("mullins", (Object)GPUKind.GK_SEA_ISLANDS).Case("tonga", (Object)GPUKind.GK_VOLCANIC_ISLANDS).Case("iceland", (Object)GPUKind.GK_VOLCANIC_ISLANDS).Case("carrizo", (Object)GPUKind.GK_VOLCANIC_ISLANDS).Case("fiji", (Object)GPUKind.GK_VOLCANIC_ISLANDS).Case("stoney", (Object)GPUKind.GK_VOLCANIC_ISLANDS).Default((Object)GPUKind.GK_NONE));
    }

    @Override
    public boolean setCPU(std.string Name) {
        this.GPU = this.getTriple().getArch() == Triple.ArchType.amdgcn ? AMDGPUTargetInfo.parseAMDGCNName(new StringRef(Name)) : AMDGPUTargetInfo.parseR600Name(new StringRef(Name));
        return this.GPU != GPUKind.GK_NONE;
    }

    @Override
    public void setSupportedOpenCLOpts() {
        OpenCLOptions Opts = this.getSupportedOpenCLOpts();
        Opts.cl_clang_storage_class_specifiers = true;
        Opts.cl_khr_icd = true;
        if (this.hasFP64) {
            Opts.cl_khr_fp64 = true;
        }
        if (this.GPU.getValue() >= GPUKind.GK_EVERGREEN.getValue()) {
            Opts.cl_khr_byte_addressable_store = true;
            Opts.cl_khr_global_int32_base_atomics = true;
            Opts.cl_khr_global_int32_extended_atomics = true;
            Opts.cl_khr_local_int32_base_atomics = true;
            Opts.cl_khr_local_int32_extended_atomics = true;
        }
        if (this.GPU.getValue() >= GPUKind.GK_SOUTHERN_ISLANDS.getValue()) {
            Opts.cl_khr_fp16 = true;
            Opts.cl_khr_int64_base_atomics = true;
            Opts.cl_khr_int64_extended_atomics = true;
            Opts.cl_khr_3d_image_writes = true;
        }
    }

    @Override
    public TargetInfo.CallingConvCheckResult checkCallingConvention(CallingConv CC) {
        switch (CC) {
            default: {
                return TargetInfo.CallingConvCheckResult.CCCR_Warning;
            }
            case CC_C: 
            case CC_OpenCLKernel: 
        }
        return TargetInfo.CallingConvCheckResult.CCCR_OK;
    }

    @Override
    public void $destroy() {
        super.$destroy();
    }

    @Override
    public String toString() {
        return "GPU=" + (Object)((Object)this.GPU) + ", hasFP64=" + this.hasFP64 + ", hasFMAF=" + this.hasFMAF + ", hasLDEXPF=" + this.hasLDEXPF + super.toString();
    }

    private static final class GPUKind
    extends Enum<GPUKind>
    implements Native.ComparableLower {
        public static final /* enum */ GPUKind GK_NONE = new GPUKind(0);
        public static final /* enum */ GPUKind GK_R600 = new GPUKind(GK_NONE.getValue() + 1);
        public static final /* enum */ GPUKind GK_R600_DOUBLE_OPS = new GPUKind(GK_R600.getValue() + 1);
        public static final /* enum */ GPUKind GK_R700 = new GPUKind(GK_R600_DOUBLE_OPS.getValue() + 1);
        public static final /* enum */ GPUKind GK_R700_DOUBLE_OPS = new GPUKind(GK_R700.getValue() + 1);
        public static final /* enum */ GPUKind GK_EVERGREEN = new GPUKind(GK_R700_DOUBLE_OPS.getValue() + 1);
        public static final /* enum */ GPUKind GK_EVERGREEN_DOUBLE_OPS = new GPUKind(GK_EVERGREEN.getValue() + 1);
        public static final /* enum */ GPUKind GK_NORTHERN_ISLANDS = new GPUKind(GK_EVERGREEN_DOUBLE_OPS.getValue() + 1);
        public static final /* enum */ GPUKind GK_CAYMAN = new GPUKind(GK_NORTHERN_ISLANDS.getValue() + 1);
        public static final /* enum */ GPUKind GK_SOUTHERN_ISLANDS = new GPUKind(GK_CAYMAN.getValue() + 1);
        public static final /* enum */ GPUKind GK_SEA_ISLANDS = new GPUKind(GK_SOUTHERN_ISLANDS.getValue() + 1);
        public static final /* enum */ GPUKind GK_VOLCANIC_ISLANDS = new GPUKind(GK_SEA_ISLANDS.getValue() + 1);
        private final int value;
        private static final /* synthetic */ GPUKind[] $VALUES;

        public static GPUKind[] values() {
            return (GPUKind[])$VALUES.clone();
        }

        public static GPUKind valueOf(String name) {
            return Enum.valueOf(GPUKind.class, name);
        }

        public static GPUKind valueOf(int val) {
            GPUKind out;
            GPUKind gPUKind = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private GPUKind(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        public boolean $less(Object obj) {
            return Unsigned.$less_uint((int)this.value, (int)((GPUKind)((Object)obj)).value);
        }

        public boolean $lesseq(Object obj) {
            return Unsigned.$lesseq_uint((int)this.value, (int)((GPUKind)((Object)obj)).value);
        }

        static {
            $VALUES = new GPUKind[]{GK_NONE, GK_R600, GK_R600_DOUBLE_OPS, GK_R700, GK_R700_DOUBLE_OPS, GK_EVERGREEN, GK_EVERGREEN_DOUBLE_OPS, GK_NORTHERN_ISLANDS, GK_CAYMAN, GK_SOUTHERN_ISLANDS, GK_SEA_ISLANDS, GK_VOLCANIC_ISLANDS};
        }

        private static final class Values {
            private static final GPUKind[] VALUES;
            private static final GPUKind[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (GPUKind kind : GPUKind.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new GPUKind[min < 0 ? 1 - min : 0];
                VALUES = new GPUKind[max >= 0 ? 1 + max : 0];
                for (GPUKind kind : GPUKind.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((GPUKind)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((GPUKind)kind).value] = kind;
                }
            }
        }
    }
}

