/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic.java;

import java.lang.reflect.Field;
import java.util.logging.Level;
import org.clang.basic.DiagnosticIDs;
import org.clang.basic.diag;
import org.clang.basic.impl.DiagnosticIDsStatics;
import org.clang.basic.impl.StaticDiagCategoryRec;
import org.clank.support.NativeTrace;
import org.clank.support.Unsigned;
import org.llvm.adt.StringRef;

public final class diagJava {
    private static final String[] DIAG_NAMES;
    private static final String[] CATEGORY_NAMES;

    private diagJava() {
    }

    public static String $name(int DiagID) {
        int id = DiagID;
        if (id >= 0 && id < DIAG_NAMES.length && DIAG_NAMES[id] != null) {
            return DIAG_NAMES[id];
        }
        return "Unknown diagnostic ID " + DiagID;
    }

    public static final String[] getDiagnosticNames() {
        return DIAG_NAMES;
    }

    public static final String[] getCategoryNames() {
        return CATEGORY_NAMES;
    }

    public static String $categoryName(byte Category2) {
        StringRef Name = DiagnosticIDs.getCategoryNameFromID(Unsigned.$uchar2uint((byte)Category2));
        return Name.toJavaString();
    }

    public static String $diagClass(int DiagClass) {
        switch (DiagClass) {
            case 1: {
                return "CLASS_NOTE";
            }
            case 2: {
                return "CLASS_REMARK";
            }
            case 3: {
                return "CLASS_WARNING";
            }
            case 4: {
                return "CLASS_EXTENSION";
            }
            case 5: {
                return "CLASS_ERROR";
            }
        }
        return "Unknown Class ID " + DiagClass;
    }

    static {
        Field[] fields = diag.class.getDeclaredFields();
        int max = 0;
        boolean insideTheRange = false;
        for (int i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            String name = f.getName();
            if ("__COMMONSTART".equals(name)) {
                insideTheRange = true;
            } else if ("NUM_BUILTIN_SERIALIZATION_DIAGNOSTICS".equals(f.getName())) {
                insideTheRange = false;
            }
            if (insideTheRange) {
                if (name.startsWith("__") && name.endsWith("START")) {
                    fields[i] = null;
                    continue;
                }
                if (name.startsWith("NUM_") && name.endsWith("_DIAGNOSTICS")) {
                    fields[i] = null;
                    continue;
                }
                assert (f.getType() == Integer.TYPE);
                int value = -1;
                try {
                    value = f.getInt(diag.class);
                }
                catch (IllegalAccessException | IllegalArgumentException ex) {
                    fields[i] = null;
                    NativeTrace.printStackTraceOnce((Throwable)ex, (Level)Level.SEVERE, (boolean)false);
                }
                if (value <= 0) continue;
                max = value > max ? value : max;
                continue;
            }
            fields[i] = null;
        }
        DIAG_NAMES = new String[max + 1];
        for (Field f : fields) {
            if (f == null) continue;
            assert (f.getType() == Integer.TYPE);
            try {
                int value = f.getInt(diag.class);
                diagJava.DIAG_NAMES[value] = f.getName();
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                NativeTrace.printStackTraceOnce((Throwable)ex, (Level)Level.SEVERE, (boolean)false);
            }
        }
        CATEGORY_NAMES = new String[DiagnosticIDsStatics.CategoryNameTable.length];
        for (int i = 0; i < DiagnosticIDsStatics.CategoryNameTable.length; ++i) {
            StaticDiagCategoryRec staticDiagCategoryRec = DiagnosticIDsStatics.CategoryNameTable[i];
            diagJava.CATEGORY_NAMES[i] = staticDiagCategoryRec.getName().toJavaString();
        }
    }
}

