/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic;

import org.clang.basic.BasicClangGlobals;
import org.clang.basic.impl.VersionTupleStatics;
import org.clank.java.std;
import org.clank.support.JavaDifferentiators;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.clank.support.aliases.uint;
import org.llvm.adt.ADTAliases;
import org.llvm.adt.NoneType;
import org.llvm.adt.StringRef;
import org.llvm.support.raw_ostream;
import org.llvm.support.raw_string_ostream;

public class VersionTuple {
    int Major;
    private boolean UsesUnderscores;
    int Minor;
    private boolean HasMinor;
    int Subminor;
    private boolean HasSubminor;
    int Build;
    private boolean HasBuild;

    public VersionTuple() {
        this.Major = 0;
        this.UsesUnderscores = false;
        this.Minor = 0;
        this.HasMinor = false;
        this.Subminor = 0;
        this.HasSubminor = false;
        this.Build = 0;
        this.HasBuild = false;
    }

    public VersionTuple(int Major) {
        this.Major = Major;
        this.UsesUnderscores = false;
        this.Minor = 0;
        this.HasMinor = false;
        this.Subminor = 0;
        this.HasSubminor = false;
        this.Build = 0;
        this.HasBuild = false;
    }

    public VersionTuple(int Major, int Minor) {
        this(Major, Minor, false);
    }

    public VersionTuple(int Major, int Minor, boolean UsesUnderscores) {
        this.Major = Major;
        this.UsesUnderscores = UsesUnderscores;
        this.Minor = Minor;
        this.HasMinor = true;
        this.Subminor = 0;
        this.HasSubminor = false;
        this.Build = 0;
        this.HasBuild = false;
    }

    public VersionTuple(int Major, int Minor, int Subminor) {
        this(Major, Minor, Subminor, false);
    }

    public VersionTuple(int Major, int Minor, int Subminor, boolean UsesUnderscores) {
        this.Major = Major;
        this.UsesUnderscores = UsesUnderscores;
        this.Minor = Minor;
        this.HasMinor = true;
        this.Subminor = Subminor;
        this.HasSubminor = true;
        this.Build = 0;
        this.HasBuild = false;
    }

    public VersionTuple(int Major, int Minor, int Subminor, int Build) {
        this(Major, Minor, Subminor, Build, false);
    }

    public VersionTuple(int Major, int Minor, int Subminor, int Build, boolean UsesUnderscores) {
        this.Major = Major;
        this.UsesUnderscores = UsesUnderscores;
        this.Minor = Minor;
        this.HasMinor = true;
        this.Subminor = Subminor;
        this.HasSubminor = true;
        this.Build = Build;
        this.HasBuild = true;
    }

    public boolean empty() {
        return this.Major == 0 && this.Minor == 0 && this.Subminor == 0 && this.Build == 0;
    }

    public int getMajor() {
        return this.Major;
    }

    public ADTAliases.OptionalUInt getMinor() {
        if (!this.HasMinor) {
            return new ADTAliases.OptionalUInt(NoneType.None);
        }
        return new ADTAliases.OptionalUInt(this.Minor);
    }

    public ADTAliases.OptionalUInt getSubminor() {
        if (!this.HasSubminor) {
            return new ADTAliases.OptionalUInt(NoneType.None);
        }
        return new ADTAliases.OptionalUInt(this.Subminor);
    }

    public ADTAliases.OptionalUInt getBuild() {
        if (!this.HasBuild) {
            return new ADTAliases.OptionalUInt(NoneType.None);
        }
        return new ADTAliases.OptionalUInt(this.Build);
    }

    public boolean usesUnderscores() {
        return this.UsesUnderscores;
    }

    public void UseDotAsSeparator() {
        this.UsesUnderscores = false;
    }

    public static boolean $eq_VersionTuple$C(VersionTuple X, VersionTuple Y) {
        return X.Major == Y.Major && X.Minor == Y.Minor && X.Subminor == Y.Subminor && X.Build == Y.Build;
    }

    public static boolean $noteq_VersionTuple$C(VersionTuple X, VersionTuple Y) {
        return !VersionTuple.$eq_VersionTuple$C(X, Y);
    }

    public static boolean $less_VersionTuple$C(VersionTuple X, VersionTuple Y) {
        if (X.Major != Y.Major) {
            return Unsigned.$less_uint((int)X.Major, (int)Y.Major);
        }
        if (X.Minor != Y.Minor) {
            return Unsigned.$less_uint((int)X.Minor, (int)Y.Minor);
        }
        if (X.Subminor != Y.Subminor) {
            return Unsigned.$less_uint((int)X.Subminor, (int)Y.Subminor);
        }
        return Unsigned.$less_uint((int)X.Build, (int)Y.Build);
    }

    public static boolean $greater_VersionTuple$C(VersionTuple X, VersionTuple Y) {
        return VersionTuple.$less_VersionTuple$C(Y, X);
    }

    public static boolean $lesseq_VersionTuple$C(VersionTuple X, VersionTuple Y) {
        return !VersionTuple.$less_VersionTuple$C(Y, X);
    }

    public static boolean $greatereq_VersionTuple$C(VersionTuple X, VersionTuple Y) {
        return !VersionTuple.$less_VersionTuple$C(X, Y);
    }

    public std.string getAsString() {
        std.string Result = new std.string();
        raw_string_ostream Out = null;
        try {
            Out = new raw_string_ostream(Result);
            BasicClangGlobals.$out_raw_ostream_VersionTuple$C((raw_ostream)Out, this);
        }
        finally {
            if (Out != null) {
                Out.$destroy();
            }
        }
        return Result;
    }

    public boolean tryParse(char.ptr input) {
        return this.tryParse(new StringRef(input));
    }

    public boolean tryParse(StringRef input) {
        uint.ref major = NativePointer.create_uint$ref();
        uint.ref minor = NativePointer.create_uint$ref();
        uint.ref micro = NativePointer.create_uint$ref();
        uint.ref build = NativePointer.create_uint$ref();
        if (VersionTupleStatics.parseInt(input, major)) {
            return true;
        }
        if (input.empty()) {
            this.$assignMove(new VersionTuple(major.$deref()));
            return false;
        }
        if (input.$at(0) != 46) {
            return true;
        }
        input.$assignMove(input.substr(1));
        if (VersionTupleStatics.parseInt(input, minor)) {
            return true;
        }
        if (input.empty()) {
            this.$assignMove(new VersionTuple(major.$deref(), minor.$deref()));
            return false;
        }
        if (input.$at(0) != 46) {
            return true;
        }
        input.$assignMove(input.substr(1));
        if (VersionTupleStatics.parseInt(input, micro)) {
            return true;
        }
        if (input.empty()) {
            this.$assignMove(new VersionTuple(major.$deref(), minor.$deref(), micro.$deref()));
            return false;
        }
        if (input.$at(0) != 46) {
            return true;
        }
        input.$assignMove(input.substr(1));
        if (VersionTupleStatics.parseInt(input, build)) {
            return true;
        }
        if (!input.empty()) {
            return true;
        }
        this.$assignMove(new VersionTuple(major.$deref(), minor.$deref(), micro.$deref(), build.$deref()));
        return false;
    }

    public VersionTuple(VersionTuple $Prm0) {
        this.Major = $Prm0.Major;
        this.UsesUnderscores = $Prm0.UsesUnderscores;
        this.Minor = $Prm0.Minor;
        this.HasMinor = $Prm0.HasMinor;
        this.Subminor = $Prm0.Subminor;
        this.HasSubminor = $Prm0.HasSubminor;
        this.Build = $Prm0.Build;
        this.HasBuild = $Prm0.HasBuild;
    }

    public VersionTuple(JavaDifferentiators.JD.Move _dparam, VersionTuple $Prm0) {
        this.Major = $Prm0.Major;
        this.UsesUnderscores = $Prm0.UsesUnderscores;
        this.Minor = $Prm0.Minor;
        this.HasMinor = $Prm0.HasMinor;
        this.Subminor = $Prm0.Subminor;
        this.HasSubminor = $Prm0.HasSubminor;
        this.Build = $Prm0.Build;
        this.HasBuild = $Prm0.HasBuild;
    }

    public VersionTuple $assign(VersionTuple $Prm0) {
        this.Major = $Prm0.Major;
        this.UsesUnderscores = $Prm0.UsesUnderscores;
        this.Minor = $Prm0.Minor;
        this.HasMinor = $Prm0.HasMinor;
        this.Subminor = $Prm0.Subminor;
        this.HasSubminor = $Prm0.HasSubminor;
        this.Build = $Prm0.Build;
        this.HasBuild = $Prm0.HasBuild;
        return this;
    }

    public VersionTuple $assignMove(VersionTuple $Prm0) {
        this.Major = $Prm0.Major;
        this.UsesUnderscores = $Prm0.UsesUnderscores;
        this.Minor = $Prm0.Minor;
        this.HasMinor = $Prm0.HasMinor;
        this.Subminor = $Prm0.Subminor;
        this.HasSubminor = $Prm0.HasSubminor;
        this.Build = $Prm0.Build;
        this.HasBuild = $Prm0.HasBuild;
        return this;
    }

    public String toString() {
        return "Major=" + this.Major + ", UsesUnderscores=" + this.UsesUnderscores + ", Minor=" + this.Minor + ", HasMinor=" + this.HasMinor + ", Subminor=" + this.Subminor + ", HasSubminor=" + this.HasSubminor + ", Build=" + this.Build + ", HasBuild=" + this.HasBuild;
    }
}

