/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic;

import org.clang.basic.IdentifierInfo;
import org.clang.basic.IdentifierInfoStringMapEntry;
import org.clang.basic.StringMapIteratorIdentifierInfo;
import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.char;
import org.llvm.adt.StringMapEntryBase;
import org.llvm.adt.StringMapImpl;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.StringMapEntry;
import org.llvm.support.BumpPtrAllocator;
import org.llvm.support.StringMapBumpPtrAllocator;
import org.llvm.support.llvm;

public class StringMapIdentifierInfo
extends StringMapImpl
implements Destructors.ClassWithDestructor {
    private final BumpPtrAllocator Allocator;
    private final IdentifierInfo defaultValue;

    public StringMapIdentifierInfo(IdentifierInfo defaultValue) {
        super(StringMapEntry.$sizeof_StringMapEntry());
        this.defaultValue = defaultValue;
        this.Allocator = new StringMapBumpPtrAllocator();
    }

    public StringMapIdentifierInfo(int InitialSize, IdentifierInfo defaultValue) {
        super(InitialSize, StringMapEntry.$sizeof_StringMapEntry());
        this.defaultValue = defaultValue;
        this.Allocator = new StringMapBumpPtrAllocator();
    }

    public StringMapIdentifierInfo(BumpPtrAllocator A, IdentifierInfo defaultValue) {
        super(StringMapEntry.$sizeof_StringMapEntry());
        assert (A != null);
        this.Allocator = A;
        this.defaultValue = defaultValue;
    }

    public StringMapIdentifierInfo(int InitialSize, StringMapBumpPtrAllocator A, IdentifierInfo defaultValue) {
        super(InitialSize, StringMapEntry.$sizeof_StringMapEntry());
        assert (A != null);
        this.Allocator = A;
        this.defaultValue = defaultValue;
    }

    public StringMapIdentifierInfo(StringMapIdentifierInfo RHS, IdentifierInfo defaultValue) {
        super(StringMapEntry.$sizeof_StringMapEntry());
        this.defaultValue = defaultValue;
        if (!RHS.empty()) {
            throw new AssertionError((Object)"Copy ctor from non-empty stringmap not implemented yet!");
        }
        this.Allocator = new StringMapBumpPtrAllocator();
    }

    public void $assign(StringMapIdentifierInfo RHS) {
        if (!RHS.empty()) {
            throw new AssertionError((Object)"assignment from non-empty stringmap not implemented yet!");
        }
        this.clear();
    }

    public BumpPtrAllocator getAllocator() {
        return this.Allocator;
    }

    public StringMapIteratorIdentifierInfo begin() {
        return new StringMapIteratorIdentifierInfo(this.TheTable, 0, this.NumBuckets == 0);
    }

    public StringMapIteratorIdentifierInfo end() {
        return new StringMapIteratorIdentifierInfo(this.TheTable, this.NumBuckets, true);
    }

    public StringMapIteratorIdentifierInfo find(StringRef Key) {
        int Bucket = this.FindKey(Key);
        if (Bucket == -1) {
            return this.end();
        }
        return new StringMapIteratorIdentifierInfo(this.TheTable, Bucket, true);
    }

    public IdentifierInfo lookup(StringRef Key) {
        int Bucket = this.FindKey(Key);
        if (Bucket != -1) {
            return ((IdentifierInfoStringMapEntry)this.TheTable[Bucket]).getValue();
        }
        return (IdentifierInfo)((Object)Native.$tryClone((Object)((Object)this.defaultValue)));
    }

    public IdentifierInfo $at(StringRef Key) {
        return this.GetOrCreateValue(Key).getValue();
    }

    public int count(StringRef Key) {
        return this.FindKey(Key) == -1 ? 0 : 1;
    }

    public boolean insert(IdentifierInfoStringMapEntry KeyValue) {
        int FullHashValue;
        int keyLength;
        char.ptr keyData = KeyValue.getKeyData();
        int BucketNo = this.LookupBucketFor(keyData, keyLength = KeyValue.getKeyLength(), FullHashValue = llvm.HashString((char.ptr)keyData, (int)keyLength));
        Object Bucket = this.TheTable[BucketNo];
        if (Bucket != null && Bucket != StringMapIdentifierInfo.getTombstoneVal()) {
            return false;
        }
        if (Bucket == StringMapIdentifierInfo.getTombstoneVal()) {
            --this.NumTombstones;
        }
        this.TheTable[BucketNo] = Bucket = KeyValue;
        ++this.NumItems;
        assert (this.NumItems + this.NumTombstones <= this.NumBuckets);
        this.RehashTable();
        return true;
    }

    public void clear() {
        if (this.empty()) {
            return;
        }
        int E = this.NumBuckets;
        for (int I = 0; I != E; ++I) {
            StringMapEntryBase Bucket = this.TheTable[I];
            this.TheTable[I] = null;
        }
        this.NumItems = 0;
        this.NumTombstones = 0;
        this.Allocator.Reset();
    }

    public IdentifierInfoStringMapEntry GetOrCreateValue(StringRef Key, IdentifierInfo Val) {
        return this.GetOrCreateValue(Key.data(), Key.size(), Val);
    }

    public IdentifierInfoStringMapEntry GetOrCreateValue(char.ptr Key, int Len, IdentifierInfo Val) {
        int FullHashValue = llvm.HashString((char.ptr)Key, (int)Len);
        int BucketNo = this.LookupBucketFor(Key, Len, FullHashValue);
        Object Bucket = this.TheTable[BucketNo];
        if (Bucket != null && Bucket != StringMapIdentifierInfo.getTombstoneVal()) {
            return (IdentifierInfoStringMapEntry)((Object)Bucket);
        }
        IdentifierInfo NewItem = IdentifierInfoStringMapEntry.Create(Key, Len, FullHashValue, this.Allocator, Val);
        if (Bucket == StringMapIdentifierInfo.getTombstoneVal()) {
            --this.NumTombstones;
        }
        ++this.NumItems;
        assert (this.NumItems + this.NumTombstones <= this.NumBuckets);
        this.TheTable[BucketNo] = Bucket = NewItem;
        this.RehashTable();
        return (IdentifierInfoStringMapEntry)((Object)Bucket);
    }

    private IdentifierInfoStringMapEntry GetOrCreateValue(byte[] Key, int KeyStIndex, int Len, IdentifierInfo Val) {
        int FullHashValue = llvm.HashString((byte[])Key, (int)KeyStIndex, (int)Len);
        int BucketNo = this.LookupBucketFor(Key, KeyStIndex, Len, FullHashValue);
        Object Bucket = this.TheTable[BucketNo];
        if (Bucket != null && Bucket != StringMapIdentifierInfo.getTombstoneVal()) {
            return (IdentifierInfoStringMapEntry)((Object)Bucket);
        }
        IdentifierInfo NewItem = IdentifierInfoStringMapEntry.Create(Key, KeyStIndex, Len, FullHashValue, this.Allocator, Val);
        if (Bucket == StringMapIdentifierInfo.getTombstoneVal()) {
            --this.NumTombstones;
        }
        ++this.NumItems;
        assert (this.NumItems + this.NumTombstones <= this.NumBuckets);
        this.TheTable[BucketNo] = Bucket = NewItem;
        this.RehashTable();
        return (IdentifierInfoStringMapEntry)((Object)Bucket);
    }

    public IdentifierInfoStringMapEntry GetOrCreateValue(StringRef Key) {
        return this.GetOrCreateValue(Key, this.defaultValue);
    }

    public IdentifierInfoStringMapEntry GetOrCreateValue(char.ptr Key, int Len) {
        return this.GetOrCreateValue(Key, Len, this.defaultValue);
    }

    public IdentifierInfoStringMapEntry GetOrCreateValue(byte[] Key, int KeyStIndex, int Len) {
        return this.GetOrCreateValue(Key, KeyStIndex, Len, this.defaultValue);
    }

    public void remove(IdentifierInfoStringMapEntry KeyValue) {
        this.RemoveKey((StringMapEntryBase)KeyValue);
    }

    public void erase(StringMapIteratorIdentifierInfo I) {
        IdentifierInfoStringMapEntry V = (IdentifierInfoStringMapEntry)((Object)Native.$Deref((Object)((Object)I.$star())));
        this.remove((IdentifierInfoStringMapEntry)((Object)Native.$AddrOf((Object)((Object)V))));
        V.Destroy(this.Allocator);
    }

    public boolean erase(StringRef Key) {
        StringMapIteratorIdentifierInfo I = this.find(Key);
        if (Native.$eq_iter((abstract_iterator)I, (abstract_iterator)this.end())) {
            return false;
        }
        this.erase(I);
        return true;
    }

    public void $destroy() {
        assert (this.checkAlive());
        this.clear();
        std.free((Object)this.TheTable);
        this.Allocator.$destroy();
        super.set$destroyed();
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        StringMapIteratorIdentifierInfo B2 = this.begin();
        StringMapIteratorIdentifierInfo E = this.end();
        while (B2.$noteq(E)) {
            out.append("{").append(B2.$star().first()).append("=>").append((Object)B2.$star().getValue()).append("}\n");
            B2.$preInc();
        }
        return out.toString();
    }
}

