/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic;

import java.util.logging.Level;
import org.clang.basic.BasicClangGlobals;
import org.clang.basic.DiagnosticsEngine;
import org.clang.basic.ExternalSLocEntrySource;
import org.clang.basic.FileEntry;
import org.clang.basic.FileID;
import org.clang.basic.FileManager;
import org.clang.basic.FullSourceLoc;
import org.clang.basic.InBeforeInTUCacheEntry;
import org.clang.basic.LineEntry;
import org.clang.basic.LineTableInfo;
import org.clang.basic.PresumedLoc;
import org.clang.basic.SmallVectorSLocEntry;
import org.clang.basic.SourceLocation;
import org.clang.basic.SourceRange;
import org.clang.basic.SrcMgr;
import org.clang.basic.impl.SourceManagerStatics;
import org.clang.basic.llvm.DenseMapInfoIntFileID;
import org.clank.java.std;
import org.clank.java.std_map;
import org.clank.java.std_pair;
import org.clank.java.std_ptr;
import org.clank.java.stdimpl.aliases.StdMapUIntType;
import org.clank.support.Casts;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.NativeType;
import org.clank.support.Unsigned;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.char;
import org.clank.support.aliases.int;
import org.clank.support.aliases.type;
import org.clank.support.aliases.uint;
import org.llvm.adt.ADTAliases;
import org.llvm.adt.NoneType;
import org.llvm.adt.Optional;
import org.llvm.adt.RefCountedBase;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.DenseMap;
import org.llvm.adt.aliases.DenseMapInfoInt;
import org.llvm.adt.aliases.DenseMapInfoULong;
import org.llvm.adt.aliases.DenseMapIntLong;
import org.llvm.adt.aliases.DenseMapIntType;
import org.llvm.adt.aliases.DenseMapIterator;
import org.llvm.adt.aliases.DenseMapIteratorIntUInt;
import org.llvm.adt.aliases.DenseMapIteratorULongType;
import org.llvm.adt.aliases.DenseMapULongType;
import org.llvm.adt.aliases.DenseSet;
import org.llvm.adt.aliases.SmallDenseMapIntUInt;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.support.BumpPtrAllocator;
import org.llvm.support.MemoryBuffer;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;
import org.llvm.support.raw_ostream;
import org.llvm.support.sys.fs;
import org.llvm.support.sys.path;

public final class SourceManager
extends RefCountedBase<SourceManager>
implements Destructors.ClassWithDestructor {
    private DiagnosticsEngine Diag;
    private FileManager FileMgr;
    private BumpPtrAllocator ContentCacheAlloc;
    private DenseMap<FileEntry, SrcMgr.ContentCache> FileInfos;
    private SmallVector<SrcMgr.ContentCache> AllContentCaches;
    private boolean OverridenFilesKeepOriginalName;
    private boolean UserFilesAreVolatile;
    private boolean FilesAreTransient;
    private std_ptr.unique_ptr<OverriddenFilesInfoTy> OverriddenFilesInfo;
    private std.vector<SrcMgr.ContentCache> MemBufferInfos;
    public static final String SLOC_ENTY_VECTOR_REUSE_PROP = "clank.slocentry.vector.reuse";
    public static final boolean SLOC_ENTY_VECTOR_REUSE = Boolean.getBoolean(System.getProperty("clank.slocentry.vector.reuse", "false"));
    public static final int DEFAULT_LOCAL_SLOC_ENTRY_TABLE_CAPACITY = Integer.getInteger("clank.sm.local.size", 32768);
    private SmallVectorSLocEntry LocalSLocEntryTable;
    private static final int DEFAULT_LOADED_SLOC_ENTRY_TABLE_CAPACITY = 0;
    private SmallVectorSLocEntry LoadedSLocEntryTable;
    private int NextLocalOffset;
    private int CurrentLoadedOffset;
    public static final int MaxLoadedOffset = Integer.MIN_VALUE;
    private std.vectorBool SLocEntryLoaded;
    private ExternalSLocEntrySource ExternalSLocEntries;
    private int LastFileIDLookup;
    private int LastFileIDLookupLocalSlice;
    private int[] LastFileIDLookupLocalSliceArray;
    private int LastFileIDLookupLocalSLocEntryIndex;
    private int LastFileIDLookupLocalIndexInSlice;
    private int LastFileIDLookupLocalOffset;
    private static final boolean USE_LAST_MACRO_ID = Boolean.valueOf(System.getProperty("use.last.macro", "true"));
    private int LastMacroIDLookup;
    private int LastMacroIDLookupLocalSlice;
    private int[] LastMacroIDLookupLocalSliceArray;
    private int LastMacroIDLookupLocalSLocEntryIndex;
    private int LastMacroIDLookupLocalIndexInSlice;
    private int LastMacroIDLookupLocalOffset;
    private boolean LocalSLocTableIsSliced;
    private int LocalSliceMaskForIndex;
    private int LocalSliceSize;
    private int MaxIndexInLastLocalSlice;
    private int LocalMaxSliceIndex;
    private int local_sloc_entry_size;
    private boolean LoadedSLocTableIsSliced;
    private int LastFileIDLookupLoadedSlice;
    private int LastMacroIDLookupLoadedSlice;
    private LineTableInfo LineTable;
    private int LastLineNoFileIDQuery;
    private SrcMgr.ContentCache LastLineNoContentCache;
    private int LastLineNoFilePos;
    private int LastLineNoResult;
    private FileID MainFileID;
    private FileID PreambleFileID;
    private int NumLinearMacroScans;
    private int NumBinaryMacroProbes;
    private int NumLinearScans;
    private int NumBinaryProbes;
    private int NumLinearSliceScans;
    private int NumImmediateSliceScans;
    private int NumBinarySliceProbes;
    private DenseMapIntLong IncludedLocMap;
    private static final long $INCLUDED_LOC_MAP_NO_ENTRY_MARKER = BasicClangGlobals.wrap_FileID_Offset(FileID.getSentinelID(), -842150451);
    private static final long $INVALID_FILEID_ZERO_OFFSET = BasicClangGlobals.wrap_FileID_Offset(FileID.getInvalidID(), 0);
    public static final int INVALID_SLOC_ENTRY_INDEX = 0;
    private InBeforeInTUCache IBTUCache;
    private InBeforeInTUCacheEntry IBTUCacheOverflow;
    private static final int MagicCacheSize = 300;
    private static final char.ptr INVALID_BUFFER_CHAR_PTR = NativePointer.$((String)"<<<<INVALID BUFFER>>>>");
    private static final StringRef INVALID_BUFFER_STRING_REF = new StringRef(INVALID_BUFFER_CHAR_PTR);
    private std_ptr.unique_ptr<MemoryBuffer> FakeBufferForRecovery;
    private std_ptr.unique_ptr<SrcMgr.ContentCache> FakeContentCacheForRecovery;
    private static final int FAKE_CONTENT_CACHE_INDEX = -1;
    private DenseMapIntType<std_map.mapUIntType<SourceLocation>> MacroArgsCacheMap;
    private SmallVector<std_pair.pair<std.string, FullSourceLoc>> StoredModuleBuildStack;
    private static boolean tracedEntryTables = false;
    public static final StringRef INVALID_BUFFER_DATA = new StringRef("<<<<<INVALID SOURCE LOCATION>>>>>");
    private static final int LOADED_ZERO_INDEX = Integer.MIN_VALUE;
    private final char.ptr.array $CharacterDataPtr = (char.ptr.array)NativePointer.create_reusable_char$ptr();
    private boolean $CharacterDataPtrInUse = false;
    private final int.ptr $OffsetPtr = NativePointer.create_int$ptr((int)0);
    private boolean $OffsetPtrInUse = false;

    boolean repairVolatileContentCache(SrcMgr.ContentCache ContentCache2) {
        boolean repaired = false;
        if (this.AllContentCaches.$at(this.AllContentCaches.size() - 1) == ContentCache2) {
            if (this.LocalSLocEntryTable.$getContentCacheIndex(this.LocalSLocEntryTable.size() - 1) == ContentCache2.$index()) {
                assert (ContentCache2.getRawBuffer() != null) : "No Buffer in " + ContentCache2;
                assert (ContentCache2.ContentsEntry != null) : "No File Entry in " + ContentCache2;
                int BufferSize = ContentCache2.getRawBuffer().getBufferSize();
                long FileSize = ContentCache2.ContentsEntry.getSize();
                FileManager.modifyFileEntry(ContentCache2.ContentsEntry, BufferSize, 0L);
                this.NextLocalOffset = (int)((long)this.NextLocalOffset + ((long)BufferSize - FileSize));
                repaired = true;
            } else {
                repaired = false;
            }
        } else {
            repaired = false;
        }
        NativeTrace.getLogger().log(repaired ? Level.FINE : Level.INFO, "SM {0}:{1} {7} repairVolatileContentCache {2}:\n\tBufSize={3} vs. FileEntry.Size={4} [{5}]:\n{6}", new Object[]{System.identityHashCode((Object)this), this.NextLocalOffset, Casts.toJavaString((char.ptr)ContentCache2.ContentsEntry.Name), ContentCache2.getRawBuffer().getBufferSize(), ContentCache2.ContentsEntry.getSize(), Thread.currentThread().getName(), ContentCache2.ContentsEntry, repaired ? "DONE" : "FAILED"});
        return repaired;
    }

    private OverriddenFilesInfoTy getOverriddenFilesInfo() {
        if (!this.OverriddenFilesInfo.$bool()) {
            this.OverriddenFilesInfo.reset((Object)new OverriddenFilesInfoTy());
        }
        return (OverriddenFilesInfoTy)this.OverriddenFilesInfo.$star();
    }

    private InBeforeInTUCacheEntry getInBeforeInTUCache(int LFID, int RFID) {
        long Key = std_pair.wrap_int_int_pair((int)LFID, (int)RFID);
        if (Unsigned.$less_uint((int)this.IBTUCache.size(), (int)300)) {
            return (InBeforeInTUCacheEntry)this.IBTUCache.$at(Key);
        }
        DenseMapIteratorULongType I = this.IBTUCache.find(Key);
        if (I.$noteq(this.IBTUCache.end())) {
            return (InBeforeInTUCacheEntry)I.$arrow().second;
        }
        return this.IBTUCacheOverflow;
    }

    private SourceManager(SourceManager $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    private void $assign(SourceManager $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    public SourceManager(DiagnosticsEngine Diag, FileManager FileMgr) {
        this(Diag, FileMgr, false);
    }

    public SourceManager(DiagnosticsEngine Diag, FileManager FileMgr, boolean UserFilesAreVolatile) {
        this.Diag = Diag;
        this.FileMgr = FileMgr;
        this.ContentCacheAlloc = new BumpPtrAllocator();
        this.FileInfos = new DenseMap(FileEntry.DMI$FileEntryPtr, null);
        this.AllContentCaches = new SmallVector(1024, null);
        this.OverridenFilesKeepOriginalName = true;
        this.UserFilesAreVolatile = UserFilesAreVolatile;
        this.FilesAreTransient = false;
        this.OverriddenFilesInfo = new std_ptr.unique_ptr();
        this.MemBufferInfos = new std.vector((Object)null);
        this.SLocEntryLoaded = new std.vectorBool();
        this.ExternalSLocEntries = null;
        this.LastFileIDLookup = 0;
        this.LastFileIDLookupLocalSLocEntryIndex = 0;
        this.LastFileIDLookupLocalOffset = 0;
        this.LastMacroIDLookup = 0;
        this.LastMacroIDLookupLocalSLocEntryIndex = 0;
        this.LastMacroIDLookupLocalOffset = 0;
        this.LineTable = null;
        this.LastLineNoFileIDQuery = FileID.getInvalidID();
        this.MainFileID = new FileID();
        this.PreambleFileID = new FileID();
        this.NumLinearScans = 0;
        this.NumBinaryProbes = 0;
        this.NumLinearSliceScans = 0;
        this.NumImmediateSliceScans = 0;
        this.NumBinarySliceProbes = 0;
        this.NumLinearMacroScans = 0;
        this.NumBinaryMacroProbes = 0;
        this.IncludedLocMap = new DenseMapIntLong((DenseMapInfoInt)new DenseMapInfoIntFileID(), $INCLUDED_LOC_MAP_NO_ENTRY_MARKER);
        this.IBTUCache = new InBeforeInTUCache();
        this.IBTUCacheOverflow = new InBeforeInTUCacheEntry();
        this.FakeBufferForRecovery = new std_ptr.unique_ptr();
        this.FakeContentCacheForRecovery = new std_ptr.unique_ptr();
        this.MacroArgsCacheMap = new DenseMapIntType((DenseMapInfoInt)new DenseMapInfoIntFileID(), null);
        this.StoredModuleBuildStack = new SmallVector(2, (Object)new std_pair.pair((Object)new std.string(), (Object)new FullSourceLoc()));
        this.initSLocTables();
        this.clearIDTables();
        Diag.setSourceManager(this);
    }

    public void $destroy() {
        if (this.LineTable != null) {
            this.LineTable.$destroy();
        }
        int e = this.MemBufferInfos.size();
        for (int i = 0; i != e; ++i) {
            if (this.MemBufferInfos.$at(i) == null) continue;
            ((SrcMgr.ContentCache)this.MemBufferInfos.$at(i)).$destroy();
            this.ContentCacheAlloc.Deallocate$NotSameRemoveCV(this.MemBufferInfos.$at(i));
        }
        DenseMapIterator I = this.FileInfos.begin();
        DenseMapIterator E = this.FileInfos.end();
        while (I.$noteq(E)) {
            if (I.$arrow().second != null) {
                ((SrcMgr.ContentCache)I.$arrow().second).$destroy();
                this.ContentCacheAlloc.Deallocate$NotSameRemoveCV(I.$arrow().second);
            }
            I.$preInc();
        }
        this.AllContentCaches.clear();
        llvm.DeleteContainerSeconds(this.MacroArgsCacheMap);
        this.StoredModuleBuildStack.$destroy();
        this.MacroArgsCacheMap.$destroy();
        this.FakeContentCacheForRecovery.$destroy();
        this.FakeBufferForRecovery.$destroy();
        this.IBTUCache.$destroy();
        this.IncludedLocMap.$destroy();
        this.SLocEntryLoaded.$destroy();
        SmallVectorSLocEntry.$release(this.LoadedSLocEntryTable);
        this.LoadedSLocEntryTable = null;
        SmallVectorSLocEntry.$release(this.LocalSLocEntryTable);
        this.LocalSLocEntryTable = null;
        this.MemBufferInfos.$destroy();
        this.OverriddenFilesInfo.$destroy();
        this.FileInfos.$destroy();
        this.ContentCacheAlloc.$destroy();
        super.$destroy();
    }

    private void initSLocTables() {
        this.LocalSLocEntryTable = SmallVectorSLocEntry.$create(DEFAULT_LOCAL_SLOC_ENTRY_TABLE_CAPACITY);
        this.LoadedSLocEntryTable = SmallVectorSLocEntry.$create(0);
        if ((NativeTrace.VERBOSE_MODE || NativeTrace.STATISTICS) && !tracedEntryTables) {
            tracedEntryTables = true;
            if (NativeTrace.STAT_OUT_FOLDER == null) {
                llvm.errs().$out("Using LocalTable ").$out(this.LocalSLocEntryTable.getClass().getSimpleName()).$out(" with initial capacity ").$out(NativeTrace.formatNumber((long)(4 * this.LocalSLocEntryTable.capacity() / 1024))).$out("K\n");
                llvm.errs().$out("Using LoadedTable ").$out(this.LoadedSLocEntryTable.getClass().getSimpleName()).$out(" with initial capacity ").$out(NativeTrace.formatNumber((long)(4 * this.LoadedSLocEntryTable.capacity() / 1024))).$out("K\n");
            }
        }
    }

    public void clearIDTables() {
        this.MainFileID.$assignMove(FileID.getInvalidID());
        this.LocalSLocEntryTable.clear();
        this.LoadedSLocEntryTable.clear();
        this.SLocEntryLoaded.clear();
        this.LastLineNoFileIDQuery = FileID.getInvalidID();
        this.LastLineNoContentCache = null;
        this.LastFileIDLookup = 0;
        this.LastMacroIDLookup = 0;
        if (this.LineTable != null) {
            this.LineTable.clear();
        }
        this.NextLocalOffset = 0;
        this.LastFileIDLookupLocalOffset = 0;
        this.LastFileIDLookupLocalSLocEntryIndex = 0;
        this.LastMacroIDLookupLocalOffset = 0;
        this.LastMacroIDLookupLocalSLocEntryIndex = 0;
        this.updateLocalSLocConstants();
        this.CurrentLoadedOffset = Integer.MIN_VALUE;
        this.LoadedSLocTableIsSliced = this.LoadedSLocEntryTable.isSlicedByOffsets();
        this.LastFileIDLookupLoadedSlice = 0;
        this.LastMacroIDLookupLoadedSlice = 0;
        this.createExpansionLoc(SourceLocation.getInvalid(), SourceLocation.getInvalid(), SourceLocation.getInvalid(), 1);
    }

    private void updateLocalSLocConstants() {
        this.local_sloc_entry_size = this.LocalSLocEntryTable.size();
        this.LocalSLocTableIsSliced = this.LocalSLocEntryTable.isSlicedByOffsets();
        this.LastFileIDLookupLocalSliceArray = null;
        this.LastMacroIDLookupLocalSliceArray = null;
        if (this.LocalSLocTableIsSliced) {
            this.LocalMaxSliceIndex = this.LocalSLocEntryTable.$OffsetsMaxSliceIndex();
            this.LocalSliceSize = this.LocalSLocEntryTable.$OffsetsSliceSize();
            assert ((this.LocalSliceSize & this.LocalSliceSize - 1) == 0) : "must be power of 2 " + Integer.toBinaryString(this.LocalSliceSize);
            this.LocalSliceMaskForIndex = this.LocalSliceSize - 1;
            this.MaxIndexInLastLocalSlice = this.local_sloc_entry_size == 0 ? 0 : (this.local_sloc_entry_size - 1 & this.LocalSliceMaskForIndex) + 1;
            this.LastFileIDLookupLocalSlice = this.LastFileIDLookupLocalSLocEntryIndex / this.LocalSliceSize;
            this.LastFileIDLookupLocalIndexInSlice = this.LastFileIDLookupLocalSLocEntryIndex & this.LocalSliceMaskForIndex;
            this.LastFileIDLookupLocalSliceArray = this.LocalSLocEntryTable.$OffsetsSliceByIndex(this.LastFileIDLookupLocalSlice);
            assert (this.LastFileIDLookupLocalSLocEntryIndex == this.LastFileIDLookupLocalSlice * this.LocalSliceSize + this.LastFileIDLookupLocalIndexInSlice) : this.LastFileIDLookupLocalSLocEntryIndex + " vs. " + (this.LastFileIDLookupLocalSlice * this.LocalSliceSize + this.LastFileIDLookupLocalIndexInSlice);
            this.LastMacroIDLookupLocalSlice = this.LastMacroIDLookup / this.LocalSliceSize;
            this.LastMacroIDLookupLocalIndexInSlice = this.LastMacroIDLookupLocalSLocEntryIndex & this.LocalSliceMaskForIndex;
            this.LastMacroIDLookupLocalSliceArray = this.LocalSLocEntryTable.$OffsetsSliceByIndex(this.LastMacroIDLookupLocalSlice);
            assert (this.LastMacroIDLookupLocalSLocEntryIndex == this.LastMacroIDLookupLocalSlice * this.LocalSliceSize + this.LastMacroIDLookupLocalIndexInSlice) : this.LastMacroIDLookupLocalSLocEntryIndex + " vs. " + (this.LastMacroIDLookupLocalSlice * this.LocalSliceSize + this.LastMacroIDLookupLocalIndexInSlice);
        }
    }

    public DiagnosticsEngine getDiagnostics() {
        return this.Diag;
    }

    public FileManager getFileManager() {
        return this.FileMgr;
    }

    public void setOverridenFilesKeepOriginalName(boolean value) {
        this.OverridenFilesKeepOriginalName = value;
    }

    public boolean userFilesAreVolatile() {
        return this.UserFilesAreVolatile;
    }

    public ArrayRef<std_pair.pair<std.string, FullSourceLoc>> getModuleBuildStack() {
        return new ArrayRef(this.StoredModuleBuildStack);
    }

    public void setModuleBuildStack(ArrayRef<std_pair.pair<std.string, FullSourceLoc>> stack) {
        this.StoredModuleBuildStack.clear();
        this.StoredModuleBuildStack.append_T((type.iterator)stack.begin(), (type.iterator)stack.end());
    }

    public void pushModuleBuildStack(StringRef moduleName, FullSourceLoc importLoc) {
        this.StoredModuleBuildStack.push_back((Object)std.make_pair((Object)moduleName.str(), (Object)importLoc));
    }

    public FileID getMainFileID() {
        return this.MainFileID;
    }

    public void setMainFileID(FileID FID) {
        this.setMainFileID(FID.ID);
    }

    public void setMainFileID(int FID) {
        this.MainFileID.$assign(FID);
    }

    public void setPreambleFileID(FileID Preamble) {
        assert (this.PreambleFileID.isInvalid()) : "PreambleFileID already set!";
        this.PreambleFileID.$assign(Preamble);
    }

    public FileID getPreambleFileID() {
        return this.PreambleFileID;
    }

    public FileID createFileID(FileEntry SourceFile, SourceLocation IncludePos, SrcMgr.CharacteristicKind FileCharacter) {
        return FileID.getFromRawEncoding(this.createFileID(SourceFile, IncludePos.getRawEncoding(), FileCharacter, 0, 0));
    }

    public FileID createFileID(FileEntry SourceFile, SourceLocation IncludePos, SrcMgr.CharacteristicKind FileCharacter, int LoadedID) {
        return FileID.getFromRawEncoding(this.createFileID(SourceFile, IncludePos.getRawEncoding(), FileCharacter, LoadedID, 0));
    }

    public FileID createFileID(FileEntry SourceFile, SourceLocation IncludePos, SrcMgr.CharacteristicKind FileCharacter, int LoadedID, int LoadedOffset) {
        return FileID.getFromRawEncoding(this.createFileID(SourceFile, IncludePos.getRawEncoding(), FileCharacter, LoadedID, LoadedOffset));
    }

    public int createFileID(FileEntry SourceFile, int IncludePos, SrcMgr.CharacteristicKind FileCharacter) {
        return this.createFileID(SourceFile, IncludePos, FileCharacter, 0, 0);
    }

    public int createFileID(FileEntry SourceFile, int IncludePos, SrcMgr.CharacteristicKind FileCharacter, int LoadedID) {
        return this.createFileID(SourceFile, IncludePos, FileCharacter, LoadedID, 0);
    }

    public int createFileID(FileEntry SourceFile, int IncludePos, SrcMgr.CharacteristicKind FileCharacter, int LoadedID, int LoadedOffset) {
        SrcMgr.ContentCache IR = this.getOrCreateContentCache(SourceFile, FileCharacter != SrcMgr.CharacteristicKind.C_User);
        assert (IR != null) : "getOrCreateContentCache() cannot return NULL";
        return this.createFileID(IR, IncludePos, FileCharacter, LoadedID, LoadedOffset);
    }

    public int createFileID(std_ptr.unique_ptr<MemoryBuffer> Buffer2) {
        return this.createFileID(Buffer2, SrcMgr.CharacteristicKind.C_User, 0, 0, SourceLocation.getInvalid());
    }

    public int createFileID(std_ptr.unique_ptr<MemoryBuffer> Buffer2, SrcMgr.CharacteristicKind FileCharacter) {
        return this.createFileID(Buffer2, FileCharacter, 0, 0, SourceLocation.getInvalid());
    }

    public int createFileID(std_ptr.unique_ptr<MemoryBuffer> Buffer2, SrcMgr.CharacteristicKind FileCharacter, int LoadedID) {
        return this.createFileID(Buffer2, FileCharacter, LoadedID, 0, SourceLocation.getInvalid());
    }

    public int createFileID(std_ptr.unique_ptr<MemoryBuffer> Buffer2, SrcMgr.CharacteristicKind FileCharacter, int LoadedID, int LoadedOffset) {
        return this.createFileID(Buffer2, FileCharacter, LoadedID, LoadedOffset, SourceLocation.getInvalid());
    }

    public int createFileID(std_ptr.unique_ptr<MemoryBuffer> Buffer2, SrcMgr.CharacteristicKind FileCharacter, int LoadedID, int LoadedOffset, int IncludeLoc) {
        return this.createFileID(this.createMemBufferContentCache(Buffer2), IncludeLoc, FileCharacter, LoadedID, LoadedOffset);
    }

    public int createFileID(std_ptr.unique_ptr<MemoryBuffer> Buffer2, SrcMgr.CharacteristicKind FileCharacter, int LoadedID, int LoadedOffset, SourceLocation IncludeLoc) {
        return this.createFileID(this.createMemBufferContentCache(Buffer2), IncludeLoc.getRawEncoding(), FileCharacter, LoadedID, LoadedOffset);
    }

    public FileID getOrCreateFileID(FileEntry SourceFile, SrcMgr.CharacteristicKind FileCharacter) {
        FileID ID2 = this.translateFile(SourceFile);
        return ID2.isValid() ? ID2 : FileID.get(this.createFileID(SourceFile, SourceLocation.getInvalid(), FileCharacter));
    }

    public int createMacroArgExpansionLoc(int SpellingLoc, int ExpansionLoc, int TokLength) {
        return this.createExpansionLocImpl(SpellingLoc, ExpansionLoc, SourceLocation.getInvalid(), TokLength, 0, 0);
    }

    public int createExpansionLoc(SourceLocation SpellingLoc, SourceLocation ExpansionLocStart, SourceLocation ExpansionLocEnd, int TokLength) {
        return this.createExpansionLoc(SpellingLoc.getRawEncoding(), ExpansionLocStart.getRawEncoding(), ExpansionLocEnd.getRawEncoding(), TokLength, 0, 0);
    }

    public int createExpansionLoc(int SpellingLoc, int ExpansionLocStart, int ExpansionLocEnd, int TokLength) {
        return this.createExpansionLoc(SpellingLoc, ExpansionLocStart, ExpansionLocEnd, TokLength, 0, 0);
    }

    public int createExpansionLoc(int SpellingLoc, int ExpansionLocStart, int ExpansionLocEnd, int TokLength, int LoadedID) {
        return this.createExpansionLoc(SpellingLoc, ExpansionLocStart, ExpansionLocEnd, TokLength, LoadedID, 0);
    }

    public int createExpansionLoc(int SpellingLoc, int ExpansionLocStart, int ExpansionLocEnd, int TokLength, int LoadedID, int LoadedOffset) {
        return this.createExpansionLocImpl(SpellingLoc, ExpansionLocStart, ExpansionLocEnd, TokLength, LoadedID, LoadedOffset);
    }

    public int createExpansionLoc(SourceLocation SpellingLoc, SourceLocation ExpansionLocStart, SourceLocation ExpansionLocEnd, int TokLength, int LoadedID, int LoadedOffset) {
        return this.createExpansionLocImpl(SpellingLoc.getRawEncoding(), ExpansionLocStart.getRawEncoding(), ExpansionLocEnd.getRawEncoding(), TokLength, LoadedID, LoadedOffset);
    }

    public MemoryBuffer getMemoryBufferForFile(FileEntry File2) {
        return this.getMemoryBufferForFile(File2, null);
    }

    public MemoryBuffer getMemoryBufferForFile(FileEntry File2, bool.ptr Invalid) {
        SrcMgr.ContentCache IR = this.getOrCreateContentCache(File2);
        assert (IR != null) : "getOrCreateContentCache() cannot return NULL";
        return IR.getBuffer(this.Diag, this, SourceLocation.getInvalid(), Invalid);
    }

    public void overrideFileContents(FileEntry SourceFile, MemoryBuffer Buffer2, boolean DoNotFree) {
        SrcMgr.ContentCache IR = this.getOrCreateContentCache(SourceFile);
        assert (IR != null) : "getOrCreateContentCache() cannot return NULL";
        IR.replaceBuffer(Buffer2, DoNotFree);
        IR.BufferOverridden = true;
        this.getOverriddenFilesInfo().OverriddenFilesWithBuffer.insert((Object)SourceFile);
    }

    public void overrideFileContents(FileEntry SourceFile, std_ptr.unique_ptr<MemoryBuffer> Buffer2) {
        this.overrideFileContents(SourceFile, (MemoryBuffer)Buffer2.release(), false);
    }

    public void overrideFileContents(FileEntry SourceFile, FileEntry NewFile) {
        assert (SourceFile.getSize() == NewFile.getSize()) : "Different sizes, use the FileManager to create a virtual file with the correct size";
        assert (this.FileInfos.count((Object)SourceFile) == 0) : "This function should be called at the initialization stage, before any parsing occurs.";
        this.getOverriddenFilesInfo().OverriddenFiles.$set((Object)SourceFile, (Object)NewFile);
    }

    public boolean isFileOverridden(FileEntry File2) {
        if (this.OverriddenFilesInfo.$bool()) {
            if (((OverriddenFilesInfoTy)this.OverriddenFilesInfo.$arrow()).OverriddenFilesWithBuffer.count((Object)File2) != 0) {
                return true;
            }
            if (((OverriddenFilesInfoTy)this.OverriddenFilesInfo.$arrow()).OverriddenFiles.find((Object)File2).$noteq(((OverriddenFilesInfoTy)this.OverriddenFilesInfo.$arrow()).OverriddenFiles.end())) {
                return true;
            }
        }
        return false;
    }

    public void disableFileContentsOverride(FileEntry File2) {
        if (!this.isFileOverridden(File2)) {
            return;
        }
        SrcMgr.ContentCache IR = this.getOrCreateContentCache(File2);
        IR.replaceBuffer(null);
        IR.ContentsEntry = IR.OrigEntry;
        assert (this.OverriddenFilesInfo.$bool());
        ((OverriddenFilesInfoTy)this.OverriddenFilesInfo.$arrow()).OverriddenFiles.erase((Object)File2);
        ((OverriddenFilesInfoTy)this.OverriddenFilesInfo.$arrow()).OverriddenFilesWithBuffer.erase((Object)File2);
    }

    public void setFileIsTransient(FileEntry File2) {
        SrcMgr.ContentCache CC = this.getOrCreateContentCache(File2);
        CC.IsTransient = true;
    }

    public void setAllFilesAreTransient(boolean Transient) {
        this.FilesAreTransient = Transient;
    }

    public MemoryBuffer getBuffer(FileID FID, SourceLocation Loc) {
        return this.getBuffer(FID.ID, Loc.getRawEncoding(), (bool.ptr)null);
    }

    public MemoryBuffer getBuffer(FileID FID, SourceLocation Loc, bool.ptr Invalid) {
        return this.getBuffer(FID.ID, Loc.getRawEncoding(), Invalid);
    }

    public MemoryBuffer getBuffer(int FID, int Loc) {
        return this.getBuffer(FID, Loc, (bool.ptr)null);
    }

    public MemoryBuffer getBuffer(int FID, int Loc, bool.ptr Invalid) {
        NativeTrace.assertTrue((Invalid == null ? 1 : 0) != 0, (String)"check out value for MemoryBuffer.isInvalid instead of passing Invalid");
        int SLocEntryIndex = this.getFileSLocEntryByID_LoadEntryIfAbsent(FID);
        if (SLocEntryIndex == 0) {
            if (Invalid != null) {
                Invalid.$set(true);
            }
            return this.getFakeBufferForRecovery();
        }
        MemoryBuffer Buf = this.$getContentCache(SLocEntryIndex).getBuffer(this.Diag, this, Loc, null);
        if (Invalid != null) {
            Invalid.$set(Buf.isInvalid());
        }
        return Buf;
    }

    public MemoryBuffer getBuffer(FileID FID) {
        return this.getBuffer(FID.ID, SourceLocation.getInvalid(), (bool.ptr)null);
    }

    public MemoryBuffer getBuffer(FileID FID, bool.ptr Invalid) {
        return this.getBuffer(FID.ID, SourceLocation.getInvalid(), Invalid);
    }

    public MemoryBuffer getBuffer(int FID) {
        return this.getBuffer(FID, SourceLocation.getInvalid(), (bool.ptr)null);
    }

    public MemoryBuffer getBuffer(int FID, bool.ptr Invalid) {
        return this.getBuffer(FID, SourceLocation.getInvalid(), Invalid);
    }

    public SrcMgr.ContentCache getContentCache(SrcMgr.SLocEntry SLoc) {
        return this.getContentCacheByCacheIndex(SLoc.getFile_ContentCacheIndex());
    }

    private SrcMgr.ContentCache getContentCacheByCacheIndex(int index) {
        if (index == -1) {
            assert (this.FakeContentCacheForRecovery != null) : "getFakeContentCacheForRecovery was not yet called?";
            return (SrcMgr.ContentCache)this.FakeContentCacheForRecovery.get();
        }
        return (SrcMgr.ContentCache)this.AllContentCaches.$at(index);
    }

    public FileEntry getFileEntryForID(FileID FID) {
        return this.getFileEntryForID(FID.ID);
    }

    public FileEntry getFileEntryForID(int FID) {
        int Entry2 = this.getFileSLocEntryByID_LoadEntryIfAbsent(FID);
        if (Entry2 == 0) {
            return null;
        }
        SrcMgr.ContentCache Content = this.$getContentCache(Entry2);
        if (Content == null) {
            return null;
        }
        return Content.OrigEntry;
    }

    public FileEntry getFileEntryForSLocEntry(SrcMgr.SLocEntry sloc) {
        SrcMgr.ContentCache Content = this.getContentCache(sloc);
        if (Content == null) {
            return null;
        }
        return Content.OrigEntry;
    }

    public StringRef getBufferData(FileID FID) {
        return this.getBufferData(FID.ID, (bool.ptr)null);
    }

    public StringRef getBufferData(FileID FID, bool.ptr Invalid) {
        return this.getBufferData(FID.ID, Invalid);
    }

    public StringRef getBufferData(int FID) {
        return this.getBufferData(FID, (bool.ptr)null);
    }

    public StringRef getBufferData(int FID, bool.ptr Invalid) {
        NativeTrace.assertTrue((Invalid == null ? 1 : 0) != 0, (String)"check out value for INVALID_BUFFER_DATA instead of passing Invalid");
        MemoryBuffer Buf = this.getBuffer(FID, SourceLocation.getInvalid(), Invalid);
        if (Invalid != null) {
            Invalid.$set(Buf.isInvalid());
        }
        return Buf.isInvalid() ? INVALID_BUFFER_DATA : Buf.getBuffer();
    }

    public int getNumCreatedFIDsForFileID(FileID FID) {
        int SLocEntryIndex = this.getFileSLocEntryByID_LoadEntryIfAbsent(FID.ID);
        if (SLocEntryIndex == 0) {
            return 0;
        }
        return this.$getNumCreatedFIDs(SLocEntryIndex);
    }

    public void setNumCreatedFIDsForFileID(FileID FID, int NumFIDs) {
        this.setNumCreatedFIDsForFileID(FID.ID, NumFIDs);
    }

    public void setNumCreatedFIDsForFileID(int FID, int NumFIDs) {
        int SLocEntryIndex = this.getFileSLocEntryByID_LoadEntryIfAbsent(FID);
        this.$setFileSLocEntry_NumCreatedFIDs(SLocEntryIndex, NumFIDs);
    }

    public void $setFileSLocEntry_NumCreatedFIDs(int SLocEntryIndex, int NumFIDs) {
        if (SLocEntryIndex > 0) {
            assert (this.LocalSLocEntryTable.isFile_$at(SLocEntryIndex));
            this.LocalSLocEntryTable.$setNumCreatedFIDs(SLocEntryIndex, NumFIDs);
        } else if (SLocEntryIndex < 0) {
            SLocEntryIndex = SourceManager.unmaskLoadedIndex(SLocEntryIndex);
            assert (this.LoadedSLocEntryTable.isFile_$at(SLocEntryIndex));
            this.LoadedSLocEntryTable.$setNumCreatedFIDs(SLocEntryIndex, NumFIDs);
        }
    }

    public FileID getFileID(SourceLocation SpellingLoc) {
        return FileID.get(this.getFileID(SpellingLoc.getRawEncoding()));
    }

    public int getFileID(int SpellingLoc) {
        int SLocOffset = SourceLocation.getOffset(SpellingLoc);
        if (this.isOffsetInFileID(this.LastFileIDLookup, SLocOffset)) {
            return this.LastFileIDLookup;
        }
        if (USE_LAST_MACRO_ID && this.isOffsetInFileID(this.LastMacroIDLookup, SLocOffset)) {
            return this.LastMacroIDLookup;
        }
        return this.getFileIDSlow(SLocOffset);
    }

    public StringRef getFilename(SourceLocation SpellingLoc) {
        FileEntry F = this.getFileEntryForID(this.getFileID(SpellingLoc));
        if (F != null) {
            return new StringRef(F.getName());
        }
        return new StringRef();
    }

    public SourceLocation getLocForStartOfFile(FileID FID) {
        return SourceLocation.getFromRawEncoding(this.getLocForStartOfFile(FID.ID));
    }

    public int getLocForStartOfFile(int FID) {
        int SLocEntryIndex = this.getFileSLocEntryByID_LoadEntryIfAbsent(FID);
        int FileOffset = SourceLocation.getInvalid();
        if (SLocEntryIndex != 0) {
            FileOffset = this.$getOffset(SLocEntryIndex);
        }
        return SourceLocation.$getFileLoc(FileOffset);
    }

    public SourceLocation getLocForEndOfFile(FileID FID) {
        return SourceLocation.getFromRawEncoding(this.getLocForEndOfFile(FID.ID));
    }

    public int getLocForEndOfFile(int FID) {
        int Entry2 = this.getFileSLocEntryByID_LoadEntryIfAbsent(FID);
        if (Entry2 == 0) {
            return SourceLocation.getInvalid();
        }
        int FileOffset = this.$getOffset(Entry2);
        return SourceLocation.$getFileLoc(FileOffset + this.getFileIDSize(FID));
    }

    public SourceLocation getIncludeLoc(FileID FID) {
        return SourceLocation.getFromRawEncoding(this.getIncludeLoc(FID.ID));
    }

    public int getIncludeLoc(int FID) {
        int SLocEntryIndex = this.getFileSLocEntryByID_LoadEntryIfAbsent(FID);
        if (SLocEntryIndex == 0) {
            return 0;
        }
        return this.$getIncludeLoc(SLocEntryIndex);
    }

    public std_pair.pair<SourceLocation, StringRef> getModuleImportLoc(SourceLocation Loc) {
        FileID FID = this.getFileID(Loc);
        if (FID.ID >= -1) {
            return std.make_pair((Object)new SourceLocation(), (Object)StringRef.R$EMPTY);
        }
        return this.ExternalSLocEntries.getModuleImportLoc(FID.ID);
    }

    public SourceLocation getExpansionLoc(SourceLocation Loc) {
        return SourceLocation.getFromRawEncoding(this.getExpansionLoc(Loc.getRawEncoding()));
    }

    public int getExpansionLoc(int Loc) {
        if (SourceLocation.isFileID(Loc)) {
            return Loc;
        }
        return this.getExpansionLocSlowCase(Loc);
    }

    public SourceLocation getFileLoc(SourceLocation Loc) {
        return SourceLocation.getFromRawEncoding(this.getFileLoc(Loc.getRawEncoding()));
    }

    public int getFileLoc(int Loc) {
        if (SourceLocation.isFileID(Loc)) {
            return Loc;
        }
        return this.getFileLocSlowCase(Loc);
    }

    public std_pair.pair<SourceLocation, SourceLocation> getImmediateExpansionRange(SourceLocation Loc) {
        long pair2 = this.getImmediateExpansionRange(Loc.getRawEncoding());
        return std.make_pair((Object)SourceLocation.getFromRawEncoding(std_pair.$first_int((long)pair2)), (Object)SourceLocation.getFromRawEncoding(std_pair.$second_int((long)pair2)));
    }

    public long getImmediateExpansionRange(int Loc) {
        assert (SourceLocation.isMacroID(Loc)) : "Not a macro expansion loc!";
        int SLocEntryIndex = this.getSLocEntryByID_LoadEntryIfAbsent(this.getFileID(Loc));
        return this.$getExpansionLocRange(SLocEntryIndex);
    }

    public long $getExpansionLocRange(int SLocEntryIndex) {
        if (SLocEntryIndex >= 0) {
            assert (this.LocalSLocEntryTable.isExpansion_$at(SLocEntryIndex));
            return this.LocalSLocEntryTable.$getRawExpansionLocRange(SLocEntryIndex);
        }
        SLocEntryIndex = SourceManager.unmaskLoadedIndex(SLocEntryIndex);
        assert (this.LoadedSLocEntryTable.isExpansion_$at(SLocEntryIndex));
        return this.LoadedSLocEntryTable.$getRawExpansionLocRange(SLocEntryIndex);
    }

    public boolean $isExpansion(int SLocEntryIndex) {
        if (SLocEntryIndex >= 0) {
            if (SLocEntryIndex == this.LastFileIDLookupLocalSLocEntryIndex) {
                assert (!this.LocalSLocEntryTable.isExpansion_$at(SLocEntryIndex)) : this.LocalSLocEntryTable.isExpansion_$at(SLocEntryIndex) + " for " + SLocEntryIndex;
                return false;
            }
            if (SLocEntryIndex == this.LastMacroIDLookupLocalSLocEntryIndex) {
                assert (this.LocalSLocEntryTable.isExpansion_$at(SLocEntryIndex)) : this.LocalSLocEntryTable.isExpansion_$at(SLocEntryIndex) + " for " + SLocEntryIndex;
                return true;
            }
            return this.LocalSLocEntryTable.isExpansion_$at(SLocEntryIndex);
        }
        SLocEntryIndex = SourceManager.unmaskLoadedIndex(SLocEntryIndex);
        return this.LoadedSLocEntryTable.isExpansion_$at(SLocEntryIndex);
    }

    public boolean $isFile(int SLocEntryIndex) {
        if (SLocEntryIndex >= 0) {
            if (SLocEntryIndex == this.LastFileIDLookupLocalSLocEntryIndex) {
                assert (this.LocalSLocEntryTable.isFile_$at(SLocEntryIndex)) : this.LocalSLocEntryTable.isFile_$at(SLocEntryIndex) + " for " + SLocEntryIndex;
                return true;
            }
            if (SLocEntryIndex == this.LastMacroIDLookupLocalSLocEntryIndex) {
                assert (!this.LocalSLocEntryTable.isFile_$at(SLocEntryIndex)) : this.LocalSLocEntryTable.isFile_$at(SLocEntryIndex) + " for " + SLocEntryIndex;
                return false;
            }
            return this.LocalSLocEntryTable.isFile_$at(SLocEntryIndex);
        }
        SLocEntryIndex = SourceManager.unmaskLoadedIndex(SLocEntryIndex);
        return this.LoadedSLocEntryTable.isFile_$at(SLocEntryIndex);
    }

    public int $getOffset(int SLocEntryIndex) {
        if (SLocEntryIndex >= 0) {
            if (SLocEntryIndex == this.LastFileIDLookupLocalSLocEntryIndex) {
                assert (this.LastFileIDLookupLocalOffset == this.LocalSLocEntryTable.offset_$at(SLocEntryIndex)) : this.LastFileIDLookupLocalOffset + " vs. " + this.LocalSLocEntryTable.offset_$at(SLocEntryIndex) + " for " + SLocEntryIndex;
                return this.LastFileIDLookupLocalOffset;
            }
            if (SLocEntryIndex == this.LastMacroIDLookupLocalSLocEntryIndex) {
                assert (this.LastMacroIDLookupLocalOffset == this.LocalSLocEntryTable.offset_$at(SLocEntryIndex)) : this.LastMacroIDLookupLocalOffset + " vs. " + this.LocalSLocEntryTable.offset_$at(SLocEntryIndex) + " for " + SLocEntryIndex;
                return this.LastMacroIDLookupLocalOffset;
            }
            return this.LocalSLocEntryTable.offset_$at(SLocEntryIndex);
        }
        SLocEntryIndex = SourceManager.unmaskLoadedIndex(SLocEntryIndex);
        return this.LoadedSLocEntryTable.offset_$at(SLocEntryIndex);
    }

    public int $getSpellingLoc(int SLocEntryIndex) {
        if (SLocEntryIndex >= 0) {
            return this.LocalSLocEntryTable.$getRawSpellingLoc(SLocEntryIndex);
        }
        SLocEntryIndex = SourceManager.unmaskLoadedIndex(SLocEntryIndex);
        return this.LoadedSLocEntryTable.$getRawSpellingLoc(SLocEntryIndex);
    }

    public int $getExpansionLocStart(int SLocEntryIndex) {
        if (SLocEntryIndex >= 0) {
            return this.LocalSLocEntryTable.$getRawExpansionLocStart(SLocEntryIndex);
        }
        SLocEntryIndex = SourceManager.unmaskLoadedIndex(SLocEntryIndex);
        return this.LoadedSLocEntryTable.$getRawExpansionLocStart(SLocEntryIndex);
    }

    public int $getExpansionLocEnd(int SLocEntryIndex) {
        if (SLocEntryIndex >= 0) {
            return this.LocalSLocEntryTable.$getRawExpansionLocEnd(SLocEntryIndex);
        }
        SLocEntryIndex = SourceManager.unmaskLoadedIndex(SLocEntryIndex);
        return this.LoadedSLocEntryTable.$getRawExpansionLocEnd(SLocEntryIndex);
    }

    public boolean $isMacroArgExpansion(int SLocEntryIndex) {
        if (SLocEntryIndex >= 0) {
            return this.LocalSLocEntryTable.$isMacroArgExpansion(SLocEntryIndex);
        }
        SLocEntryIndex = SourceManager.unmaskLoadedIndex(SLocEntryIndex);
        return this.LoadedSLocEntryTable.$isMacroArgExpansion(SLocEntryIndex);
    }

    public boolean $isMacroBodyExpansion(int SLocEntryIndex) {
        if (SLocEntryIndex >= 0) {
            return this.LocalSLocEntryTable.$isMacroBodyExpansion(SLocEntryIndex);
        }
        SLocEntryIndex = SourceManager.unmaskLoadedIndex(SLocEntryIndex);
        return this.LoadedSLocEntryTable.$isMacroBodyExpansion(SLocEntryIndex);
    }

    public boolean $isFunctionMacroExpansion(int SLocEntryIndex) {
        if (SLocEntryIndex >= 0) {
            return this.LocalSLocEntryTable.$isFunctionMacroExpansion(SLocEntryIndex);
        }
        SLocEntryIndex = SourceManager.unmaskLoadedIndex(SLocEntryIndex);
        return this.LoadedSLocEntryTable.$isFunctionMacroExpansion(SLocEntryIndex);
    }

    public int $getNumCreatedFIDs(int SLocEntryIndex) {
        if (SLocEntryIndex >= 0) {
            return this.LocalSLocEntryTable.$getNumCreatedFIDs(SLocEntryIndex);
        }
        SLocEntryIndex = SourceManager.unmaskLoadedIndex(SLocEntryIndex);
        return this.LoadedSLocEntryTable.$getNumCreatedFIDs(SLocEntryIndex);
    }

    public int $getIncludeLoc(int SLocEntryIndex) {
        if (SLocEntryIndex >= 0) {
            return this.LocalSLocEntryTable.$getRawIncludeLoc(SLocEntryIndex);
        }
        SLocEntryIndex = SourceManager.unmaskLoadedIndex(SLocEntryIndex);
        return this.LoadedSLocEntryTable.$getRawIncludeLoc(SLocEntryIndex);
    }

    public boolean $hasLineDirectives(int SLocEntryIndex) {
        if (SLocEntryIndex >= 0) {
            return this.LocalSLocEntryTable.$hasLineDirectives(SLocEntryIndex);
        }
        SLocEntryIndex = SourceManager.unmaskLoadedIndex(SLocEntryIndex);
        return this.LoadedSLocEntryTable.$hasLineDirectives(SLocEntryIndex);
    }

    public SrcMgr.SLocEntry $getSLocEntry(int SLocEntryIndex) {
        if (SLocEntryIndex >= 0) {
            return this.LocalSLocEntryTable.$at(SLocEntryIndex);
        }
        SLocEntryIndex = SourceManager.unmaskLoadedIndex(SLocEntryIndex);
        return this.LoadedSLocEntryTable.$at(SLocEntryIndex);
    }

    public SrcMgr.CharacteristicKind $getFileCharacteristic(int SLocEntryIndex) {
        if (SLocEntryIndex >= 0) {
            return this.LocalSLocEntryTable.$getFileCharacteristic(SLocEntryIndex);
        }
        SLocEntryIndex = SourceManager.unmaskLoadedIndex(SLocEntryIndex);
        return this.LoadedSLocEntryTable.$getFileCharacteristic(SLocEntryIndex);
    }

    public SrcMgr.ContentCache $getContentCache(int SLocEntryIndex) {
        int ContentCacheIndex = -1;
        if (SLocEntryIndex > 0) {
            ContentCacheIndex = this.LocalSLocEntryTable.$getContentCacheIndex(SLocEntryIndex);
        } else if (SLocEntryIndex < 0) {
            SLocEntryIndex = SourceManager.unmaskLoadedIndex(SLocEntryIndex);
            ContentCacheIndex = this.LoadedSLocEntryTable.$getContentCacheIndex(SLocEntryIndex);
        }
        return this.getContentCacheByCacheIndex(ContentCacheIndex);
    }

    public std_pair.pair<SourceLocation, SourceLocation> getExpansionRange(SourceLocation Loc) {
        long rawExpansionRange = this.getExpansionRange(Loc.getRawEncoding());
        return new std_pair.pair((Object)SourceLocation.getFromRawEncoding(std_pair.$first_int((long)rawExpansionRange)), (Object)SourceLocation.getFromRawEncoding(std_pair.$second_int((long)rawExpansionRange)));
    }

    public long getExpansionRange(int Loc) {
        if (SourceLocation.isFileID(Loc)) {
            return BasicClangGlobals.wrap_SourceLocation_SourceLocation(Loc, Loc);
        }
        long Res = this.getImmediateExpansionRange(Loc);
        int First = BasicClangGlobals.$first_SourceLocation(Res);
        int Second = BasicClangGlobals.$second_SourceLocation(Res);
        while (!SourceLocation.isFileID(First)) {
            First = BasicClangGlobals.$first_SourceLocation(this.getImmediateExpansionRange(First));
        }
        while (!SourceLocation.isFileID(Second)) {
            Second = BasicClangGlobals.$second_SourceLocation(this.getImmediateExpansionRange(Second));
        }
        return BasicClangGlobals.wrap_SourceLocation_SourceLocation(First, Second);
    }

    public SourceRange getExpansionRange(SourceRange Range) {
        return new SourceRange(std_pair.$first_int((long)this.getExpansionRange(Range.$getBegin())), std_pair.$second_int((long)this.getExpansionRange(Range.$getEnd())));
    }

    public SourceLocation getSpellingLoc(SourceLocation Loc) {
        return SourceLocation.getFromRawEncoding(this.getSpellingLoc(Loc.getRawEncoding()));
    }

    public int getSpellingLoc(int Loc) {
        if (SourceLocation.isFileID(Loc)) {
            return Loc;
        }
        return this.getSpellingLocSlowCase(Loc);
    }

    public SourceLocation getImmediateSpellingLoc(SourceLocation Loc) {
        return SourceLocation.getFromRawEncoding(this.getImmediateSpellingLoc(Loc.getRawEncoding()));
    }

    public int getImmediateSpellingLoc(int Loc) {
        if (SourceLocation.isFileID(Loc)) {
            return Loc;
        }
        long LocInfo = this.getDecomposedLoc(Loc);
        int Expansion = this.getExpansionSLocEntryByID_LoadEntryIfAbsent(BasicClangGlobals.$first_FileID(LocInfo));
        Loc = this.$getSpellingLoc(Expansion);
        return SourceLocation.$getLocWithOffset(Loc, BasicClangGlobals.$second_offset(LocInfo));
    }

    public std_pair.pairTypeUInt<FileID> getDecomposedLoc(SourceLocation Loc) {
        long decomposedLoc = this.getDecomposedLoc(Loc.getRawEncoding());
        return new std_pair.pairTypeUInt((Object)FileID.get(BasicClangGlobals.$first_FileID(decomposedLoc)), BasicClangGlobals.$second_offset(decomposedLoc));
    }

    public long getDecomposedLoc(int Loc) {
        int FID = this.getFileID(Loc);
        int SLocEntryIndex = this.getSLocEntryByID_LoadEntryIfAbsent(FID);
        if (SLocEntryIndex == 0) {
            return $INVALID_FILEID_ZERO_OFFSET;
        }
        return BasicClangGlobals.wrap_FileID_Offset(FID, SourceLocation.getOffset(Loc) - this.$getOffset(SLocEntryIndex));
    }

    public std_pair.pairTypeUInt<FileID> getDecomposedExpansionLoc(SourceLocation Loc) {
        long decomposedLoc = this.getDecomposedExpansionLoc(Loc.getRawEncoding());
        return new std_pair.pairTypeUInt((Object)FileID.get(BasicClangGlobals.$first_FileID(decomposedLoc)), BasicClangGlobals.$second_offset(decomposedLoc));
    }

    public long getDecomposedExpansionLoc(int Loc) {
        int FID = this.getFileID(Loc);
        int E = Native.$AddrOf((int)this.getSLocEntryByID_LoadEntryIfAbsent(FID));
        if (E == 0) {
            return $INVALID_FILEID_ZERO_OFFSET;
        }
        int Offset = SourceLocation.getOffset(Loc) - this.$getOffset(E);
        if (SourceLocation.isFileID(Loc)) {
            return BasicClangGlobals.wrap_FileID_Offset(FID, Offset);
        }
        return this.getDecomposedExpansionLocSlowCase(E);
    }

    public std_pair.pairTypeUInt<FileID> getDecomposedSpellingLoc(SourceLocation Loc) {
        long decomposedLoc = this.getDecomposedSpellingLoc(Loc.getRawEncoding());
        return new std_pair.pairTypeUInt((Object)FileID.get(BasicClangGlobals.$first_FileID(decomposedLoc)), BasicClangGlobals.$second_offset(decomposedLoc));
    }

    public long getDecomposedSpellingLoc(int Loc) {
        int FID = this.getFileID(Loc);
        int SLocEntryIndex = this.getSLocEntryByID_LoadEntryIfAbsent(FID);
        if (SLocEntryIndex == 0) {
            return $INVALID_FILEID_ZERO_OFFSET;
        }
        int Offset = SourceLocation.getOffset(Loc) - this.$getOffset(SLocEntryIndex);
        assert (Offset >= 0);
        if (SourceLocation.isFileID(Loc)) {
            return BasicClangGlobals.wrap_FileID_Offset(FID, Offset);
        }
        return this.getDecomposedSpellingLocSlowCase(SLocEntryIndex, Offset);
    }

    public std_pair.pairTypeUInt<FileID> getDecomposedIncludedLoc(FileID FID) {
        long decomposedLoc = this.getDecomposedIncludedLoc(FID.ID);
        return new std_pair.pairTypeUInt((Object)FileID.get(BasicClangGlobals.$first_FileID(decomposedLoc)), BasicClangGlobals.$second_offset(decomposedLoc));
    }

    public long getDecomposedIncludedLoc(int FID) {
        if (FileID.isInvalid(FID)) {
            return $INVALID_FILEID_ZERO_OFFSET;
        }
        std_pair.pairIntLong InsertOp = this.IncludedLocMap.FindAndConstruct(FID);
        long DecompLoc = InsertOp.second;
        if (DecompLoc != $INCLUDED_LOC_MAP_NO_ENTRY_MARKER) {
            return DecompLoc;
        }
        int UpperLoc = SourceLocation.getInvalid();
        int SLocEntryIndex = this.getSLocEntryByID_LoadEntryIfAbsent(FID);
        if (SLocEntryIndex != 0) {
            UpperLoc = this.$isExpansion(SLocEntryIndex) ? this.$getExpansionLocStart(SLocEntryIndex) : this.$getIncludeLoc(SLocEntryIndex);
        }
        DecompLoc = SourceLocation.isValid(UpperLoc) ? this.getDecomposedLoc(UpperLoc) : $INVALID_FILEID_ZERO_OFFSET;
        assert (DecompLoc != $INCLUDED_LOC_MAP_NO_ENTRY_MARKER);
        InsertOp.second = DecompLoc;
        return DecompLoc;
    }

    public int getFileOffset(SourceLocation SpellingLoc) {
        return this.getFileOffset(SpellingLoc.getRawEncoding());
    }

    public int getFileOffset(int SpellingLoc) {
        return BasicClangGlobals.$second_offset(this.getDecomposedLoc(SpellingLoc));
    }

    public boolean isMacroArgExpansion(SourceLocation Loc) {
        return this.isMacroArgExpansion(Loc.getRawEncoding(), (SourceLocation)null);
    }

    public boolean isMacroArgExpansion(SourceLocation Loc, SourceLocation StartLoc) {
        return this.isMacroArgExpansion(Loc.getRawEncoding(), StartLoc);
    }

    public boolean isMacroArgExpansion(int Loc) {
        return this.isMacroArgExpansion(Loc, null);
    }

    public boolean isMacroArgExpansion(int Loc, SourceLocation StartLoc) {
        if (!SourceLocation.isMacroID(Loc)) {
            return false;
        }
        int FID = this.getFileID(Loc);
        int Expansion = this.getExpansionSLocEntryByID_LoadEntryIfAbsent(FID);
        if (!this.$isMacroArgExpansion(Expansion)) {
            return false;
        }
        if (StartLoc != null) {
            StartLoc.$assignMove(this.$getExpansionLocStart(Expansion));
        }
        return true;
    }

    public boolean isMacroBodyExpansion(SourceLocation Loc) {
        return this.isMacroBodyExpansion(Loc.getRawEncoding());
    }

    public boolean isMacroBodyExpansion(int Loc) {
        if (!SourceLocation.isMacroID(Loc)) {
            return false;
        }
        int FID = this.getFileID(Loc);
        int Expansion = this.getExpansionSLocEntryByID_LoadEntryIfAbsent(FID);
        return this.$isMacroBodyExpansion(Expansion);
    }

    public boolean isAtStartOfImmediateMacroExpansion(SourceLocation Loc) {
        return this.isAtStartOfImmediateMacroExpansion(Loc, (SourceLocation)null);
    }

    public boolean isAtStartOfImmediateMacroExpansion(SourceLocation Loc, SourceLocation MacroBegin) {
        return this.isAtStartOfImmediateMacroExpansion(Loc.getRawEncoding(), MacroBegin);
    }

    public boolean isAtStartOfImmediateMacroExpansion(int Loc) {
        return this.isAtStartOfImmediateMacroExpansion(Loc, (SourceLocation)null);
    }

    public boolean isAtStartOfImmediateMacroExpansion(int Loc, SourceLocation MacroBegin) {
        int PrevFID;
        assert (SourceLocation.isValid(Loc) && SourceLocation.isMacroID(Loc)) : "Expected a valid macro loc";
        long DecompLoc = this.getDecomposedLoc(Loc);
        if (Unsigned.$greater_uint((int)BasicClangGlobals.$second_offset(DecompLoc), (int)0)) {
            return false;
        }
        int ExpInfo = this.getExpansionSLocEntryByID_LoadEntryIfAbsent(BasicClangGlobals.$first_FileID(DecompLoc));
        if (ExpInfo == 0) {
            return false;
        }
        int ExpLoc = this.$getExpansionLocStart(ExpInfo);
        if (this.$isMacroArgExpansion(ExpInfo) && !FileID.isInvalid(PrevFID = this.getPreviousFileID(BasicClangGlobals.$first_FileID(DecompLoc)))) {
            int PrevEntry = this.getSLocEntryByID_LoadEntryIfAbsent(PrevFID);
            if (PrevEntry == 0) {
                return false;
            }
            if (this.$isExpansion(PrevEntry) && BasicClangGlobals.$eq_SourceLocation$C(this.$getExpansionLocStart(PrevEntry), ExpLoc)) {
                return false;
            }
        }
        if (MacroBegin != null) {
            MacroBegin.$assign(ExpLoc);
        }
        return true;
    }

    public boolean isAtEndOfImmediateMacroExpansion(SourceLocation Loc) {
        return this.isAtEndOfImmediateMacroExpansion(Loc.getRawEncoding(), (SourceLocation)null);
    }

    public boolean isAtEndOfImmediateMacroExpansion(SourceLocation Loc, SourceLocation MacroEnd) {
        return this.isAtEndOfImmediateMacroExpansion(Loc.getRawEncoding(), MacroEnd);
    }

    public boolean isAtEndOfImmediateMacroExpansion(int Loc) {
        return this.isAtEndOfImmediateMacroExpansion(Loc, (SourceLocation)null);
    }

    public boolean isAtEndOfImmediateMacroExpansion(int Loc, SourceLocation MacroEnd) {
        int NextFID;
        assert (SourceLocation.isValid(Loc) && SourceLocation.isMacroID(Loc)) : "Expected a valid macro loc";
        int FID = this.getFileID(Loc);
        int NextLoc = SourceLocation.$getLocWithOffset(Loc, 1);
        if (this.isInFileID(NextLoc, FID)) {
            return false;
        }
        int ExpInfo = this.getExpansionSLocEntryByID_LoadEntryIfAbsent(FID);
        if (ExpInfo == 0) {
            return false;
        }
        if (this.$isMacroArgExpansion(ExpInfo) && !FileID.isInvalid(NextFID = this.getNextFileID(FID))) {
            int NextEntry = this.getSLocEntryByID_LoadEntryIfAbsent(NextFID);
            if (NextEntry == 0) {
                return false;
            }
            if (this.$isExpansion(NextEntry) && BasicClangGlobals.$eq_SourceLocation$C(this.$getExpansionLocStart(NextEntry), this.$getExpansionLocStart(ExpInfo))) {
                return false;
            }
        }
        if (MacroEnd != null) {
            MacroEnd.$assignMove(this.$getExpansionLocEnd(ExpInfo));
        }
        return true;
    }

    public boolean isInSLocAddrSpace(SourceLocation Loc, SourceLocation Start, int Length) {
        return this.isInSLocAddrSpace(Loc.getRawEncoding(), Start.getRawEncoding(), Length, (uint.ptr)null);
    }

    public boolean isInSLocAddrSpace(SourceLocation Loc, SourceLocation Start, int Length, uint.ptr RelativeOffset) {
        return this.isInSLocAddrSpace(Loc.getRawEncoding(), Start.getRawEncoding(), Length, RelativeOffset);
    }

    public boolean isInSLocAddrSpace(int Loc, int Start, int Length, uint.ptr RelativeOffset) {
        assert (RelativeOffset == null) : "use pair wrapped in $second_int(long) instead of uint$ptr creation";
        long out = this.isInSLocAddrSpace(Loc, Start, Length);
        if (RelativeOffset != null) {
            RelativeOffset.$set(std_pair.$second_uint((long)out));
        }
        return std_pair.$first_bool((long)out);
    }

    public long isInSLocAddrSpace(int Loc, int Start, int Length) {
        assert (Unsigned.$less_uint((int)SourceLocation.getOffset(Start), (int)this.NextLocalOffset) && Unsigned.$lesseq_uint((int)(SourceLocation.getOffset(Start) + Length), (int)this.NextLocalOffset) || Unsigned.$greatereq_uint((int)SourceLocation.getOffset(Start), (int)this.CurrentLoadedOffset) && Unsigned.$less_uint((int)(SourceLocation.getOffset(Start) + Length), (int)Integer.MIN_VALUE)) : "Chunk is not valid SLoc address space";
        int RelativeOffset = 0;
        int LocOffs = SourceLocation.getOffset(Loc);
        int BeginOffs = SourceLocation.getOffset(Start);
        int EndOffs = BeginOffs + Length;
        if (Unsigned.$greatereq_uint((int)LocOffs, (int)BeginOffs) && Unsigned.$less_uint((int)LocOffs, (int)EndOffs)) {
            RelativeOffset = LocOffs - BeginOffs;
            return std_pair.wrap_bool_int_pair((boolean)true, (int)RelativeOffset);
        }
        return std_pair.wrap_bool_int_pair((boolean)false, (int)RelativeOffset);
    }

    public boolean isInSameSLocAddrSpace(int LHS, int RHS, int.ptr RelativeOffset) {
        boolean RHSLoaded;
        int LHSOffs = SourceLocation.getOffset(LHS);
        int RHSOffs = SourceLocation.getOffset(RHS);
        boolean LHSLoaded = Unsigned.$greatereq_uint((int)LHSOffs, (int)this.CurrentLoadedOffset);
        if (LHSLoaded == (RHSLoaded = Unsigned.$greatereq_uint((int)RHSOffs, (int)this.CurrentLoadedOffset))) {
            if (RelativeOffset != null) {
                RelativeOffset.$set(RHSOffs - LHSOffs);
            }
            return true;
        }
        return false;
    }

    public char.ptr getCharacterData(SourceLocation SL) {
        return this.getCharacterData(SL.getRawEncoding(), (bool.ptr)null);
    }

    public char.ptr getCharacterData(int SL) {
        return this.getCharacterData(SL, (bool.ptr)null);
    }

    public char.ptr getCharacterData(SourceLocation SL, bool.ptr Invalid) {
        return this.getCharacterData(SL.getRawEncoding(), Invalid);
    }

    public char.ptr getCharacterData(int SL, bool.ptr Invalid) {
        NativeTrace.assertTrueInConsole((boolean)false, (String)"PERF: try to use faster getCharacterData_ValidOnly or getCharacterData_FirstChar or getCharacterDataStringRef_ValidOnly");
        long LocInfo = this.getDecomposedSpellingLoc(SL);
        MemoryBuffer Buffer2 = this.getBuffer(BasicClangGlobals.$first_FileID(LocInfo), SourceLocation.getInvalid());
        if (Invalid != null) {
            Invalid.$set(Buffer2.isInvalid());
        }
        int Offs = std_pair.$second_int((long)LocInfo);
        return Buffer2.isInvalid() || Offs == 0 ? Buffer2.getBufferStart() : (char.ptr)Buffer2.getBufferStart().$add(Offs);
    }

    public StringRef getCharacterDataStringRef_ValidOnly(int StLoc, int EndLoc) {
        long StLocInfo = this.getDecomposedSpellingLoc(StLoc);
        MemoryBuffer Buffer2 = this.getBuffer(BasicClangGlobals.$first_FileID(StLocInfo), SourceLocation.getInvalid());
        if (Buffer2.isInvalid()) {
            return StringRef.R$EMPTY;
        }
        int StOffs = std_pair.$second_int((long)StLocInfo);
        long EndLocInfo = this.getDecomposedSpellingLoc(EndLoc);
        assert (BasicClangGlobals.$first_FileID(StLocInfo) == BasicClangGlobals.$first_FileID(EndLocInfo)) : "Start and End should be from the same buffer";
        int EndOffs = std_pair.$second_int((long)EndLocInfo);
        int Len = EndOffs - StOffs;
        return StOffs == 0 ? new StringRef(Buffer2.getBufferStart(), Len) : new StringRef((char.ptr)Buffer2.getBufferStart().$add(StOffs), Len);
    }

    public char.ptr getCharacterData_ValidOnly(int SL, char.ptr DestPtr) {
        assert (DestPtr != null) : "forgot to call $DataPtr = SourceMgr.$CharacterDataPtr()? Don't forget to release then";
        long LocInfo = this.getDecomposedSpellingLoc(SL);
        MemoryBuffer Buffer2 = this.getBuffer(BasicClangGlobals.$first_FileID(LocInfo), SourceLocation.getInvalid());
        int Offs = std_pair.$second_int((long)LocInfo);
        assert (Offs >= 0) : "\n" + Integer.toBinaryString(Offs) + " in\n" + Long.toBinaryString(LocInfo);
        if (Buffer2.isInvalid()) {
            return NativePointer.$EMPTY;
        }
        char.ptr bufferStart = Buffer2.getBufferStart();
        if (Offs == 0) {
            return bufferStart;
        }
        DestPtr.$assign((Object)bufferStart);
        Native.$setIndex((char.ptr)DestPtr, (int)(bufferStart.$index() + Offs));
        return DestPtr;
    }

    public byte getCharacterData_FirstChar(int SL) {
        return this.getCharacterData_FirstChar(SL, null);
    }

    public byte getCharacterData_FirstChar(int SL, bool.ptr Invalid) {
        long LocInfo = this.getDecomposedSpellingLoc(SL);
        MemoryBuffer Buffer2 = this.getBuffer(BasicClangGlobals.$first_FileID(LocInfo), SourceLocation.getInvalid());
        if (Invalid != null) {
            Invalid.$set(Buffer2.isInvalid());
        }
        int Offs = std_pair.$second_uint((long)LocInfo);
        return Buffer2.isInvalid() ? (byte)0 : Buffer2.getBufferStart().$at(Offs);
    }

    public int getColumnNumber(FileID FID, int FilePos) {
        return this.getColumnNumber(FID.ID, FilePos, (bool.ptr)null);
    }

    public int getColumnNumber(FileID FID, int FilePos, bool.ptr Invalid) {
        return this.getColumnNumber(FID.ID, FilePos, Invalid);
    }

    public int getColumnNumber(int FID, int FilePos) {
        return this.getColumnNumber(FID, FilePos, (bool.ptr)null);
    }

    public int getColumnNumber(int FID, int FilePos, bool.ptr Invalid) {
        int LineStart;
        bool.ptr MyInvalid = null;
        MemoryBuffer MemBuf = this.getBuffer(FID, MyInvalid);
        if (Invalid != null) {
            Invalid.$set(MemBuf.isInvalid());
        }
        if (MemBuf.isInvalid()) {
            return 1;
        }
        if (Unsigned.$greater_uint((int)FilePos, (int)MemBuf.getBufferSize())) {
            if (Invalid != null) {
                Invalid.$set(true);
            }
            return 1;
        }
        if (this.LastLineNoFileIDQuery == FID && this.LastLineNoContentCache.SourceLineCache != null && Unsigned.$less_uint((int)this.LastLineNoResult, (int)this.LastLineNoContentCache.NumLines)) {
            int[] SourceLineCache = this.LastLineNoContentCache.SourceLineCache;
            LineStart = SourceLineCache[this.LastLineNoResult - 1];
            int LineEnd = SourceLineCache[this.LastLineNoResult];
            if (Unsigned.$greatereq_uint((int)FilePos, (int)LineStart) && Unsigned.$less_uint((int)FilePos, (int)LineEnd)) {
                return FilePos - LineStart + 1;
            }
        }
        char.ptr Buf = MemBuf.getBufferStart();
        for (LineStart = FilePos; LineStart != 0 && Buf.$at(LineStart - 1) != 10 && Buf.$at(LineStart - 1) != 13; --LineStart) {
        }
        return FilePos - LineStart + 1;
    }

    public int getSpellingColumnNumber(SourceLocation Loc) {
        return this.getSpellingColumnNumber(Loc, null);
    }

    public int getSpellingColumnNumber(SourceLocation Loc, bool.ptr Invalid) {
        if (SourceManagerStatics.isInvalid(Loc, Invalid)) {
            return 0;
        }
        long LocInfo = this.getDecomposedSpellingLoc(Loc.getRawEncoding());
        return this.getColumnNumber(BasicClangGlobals.$first_FileID(LocInfo), std_pair.$second_int((long)LocInfo), Invalid);
    }

    public int getExpansionColumnNumber(SourceLocation Loc) {
        return this.getExpansionColumnNumber(Loc, null);
    }

    public int getExpansionColumnNumber(SourceLocation Loc, bool.ptr Invalid) {
        if (SourceManagerStatics.isInvalid(Loc, Invalid)) {
            return 0;
        }
        long LocInfo = this.getDecomposedExpansionLoc(Loc.getRawEncoding());
        return this.getColumnNumber(BasicClangGlobals.$first_FileID(LocInfo), std_pair.$second_int((long)LocInfo), Invalid);
    }

    public int getPresumedColumnNumber(SourceLocation Loc) {
        return this.getPresumedColumnNumber(Loc, null);
    }

    public int getPresumedColumnNumber(SourceLocation Loc, bool.ptr Invalid) {
        PresumedLoc PLoc = this.getPresumedLoc(Loc);
        if (SourceManagerStatics.isInvalid(PLoc, Invalid)) {
            return 0;
        }
        return PLoc.getColumn();
    }

    public int getLineNumber(FileID FID, int FilePos) {
        return this.getLineNumber(FID.ID, FilePos, (bool.ptr)null);
    }

    public int getLineNumber(FileID FID, int FilePos, bool.ptr Invalid) {
        return this.getLineNumber(FID.ID, FilePos, Invalid);
    }

    public int getLineNumber(int FID, int FilePos) {
        return this.getLineNumber(FID, FilePos, (bool.ptr)null);
    }

    public int getLineNumber(int FID, int FilePos, bool.ptr Invalid) {
        int SourceLineCache;
        SrcMgr.ContentCache Content;
        if (FileID.isInvalid(FID)) {
            if (Invalid != null) {
                Invalid.$set(true);
            }
            return 1;
        }
        if (this.LastLineNoFileIDQuery == FID) {
            Content = this.LastLineNoContentCache;
        } else {
            int Entry2 = this.getFileSLocEntryByID_LoadEntryIfAbsent(FID);
            if (Entry2 == 0) {
                if (Invalid != null) {
                    Invalid.$set(true);
                }
                return 1;
            }
            Content = this.$getContentCache(Entry2);
        }
        if (Content.SourceLineCache == null) {
            boolean MyInvalid = SourceManagerStatics.ComputeLineNumbers(this.Diag, Content, this.ContentCacheAlloc, this, null);
            if (Invalid != null) {
                Invalid.$set(MyInvalid);
            }
            if (MyInvalid) {
                return 1;
            }
        } else if (Invalid != null) {
            Invalid.$set(false);
        }
        int[] $SourceLineCache = Content.SourceLineCache;
        int SourceLineCacheStart = SourceLineCache = 0;
        int SourceLineCacheEnd = SourceLineCache + Content.NumLines;
        int QueriedFilePos = FilePos + 1;
        assert (QueriedFilePos >= 0) : "must be unsigned " + QueriedFilePos;
        if (this.LastLineNoFileIDQuery == FID) {
            if (Unsigned.$greatereq_uint((int)QueriedFilePos, (int)this.LastLineNoFilePos)) {
                assert ((SourceLineCache += this.LastLineNoResult - 1) >= 0) : "must be unsigned " + SourceLineCache;
                if (SourceLineCache + 5 < SourceLineCacheEnd) {
                    if ($SourceLineCache[SourceLineCache + 5] > QueriedFilePos) {
                        SourceLineCacheEnd = SourceLineCache + 5;
                    } else if (SourceLineCache + 10 < SourceLineCacheEnd) {
                        if ($SourceLineCache[SourceLineCache + 10] > QueriedFilePos) {
                            SourceLineCacheEnd = SourceLineCache + 10;
                        } else if (SourceLineCache + 20 < SourceLineCacheEnd && $SourceLineCache[SourceLineCache + 20] > QueriedFilePos) {
                            SourceLineCacheEnd = SourceLineCache + 20;
                        }
                    }
                }
            } else if (Unsigned.$less_uint((int)this.LastLineNoResult, (int)Content.NumLines)) {
                SourceLineCacheEnd = SourceLineCache + this.LastLineNoResult + 1;
            }
        }
        assert (SourceLineCacheEnd >= 0) : "must be unsigned " + SourceLineCacheEnd;
        int Pos = std.lower_bound_int((int[])$SourceLineCache, (int)SourceLineCache, (int)SourceLineCacheEnd, (int)QueriedFilePos);
        int LineNo = Pos - SourceLineCacheStart;
        this.LastLineNoFileIDQuery = FID;
        this.LastLineNoContentCache = Content;
        this.LastLineNoFilePos = QueriedFilePos;
        this.LastLineNoResult = LineNo;
        return LineNo;
    }

    public int getSpellingLineNumber(SourceLocation Loc) {
        return this.getSpellingLineNumber(Loc, null);
    }

    public int getSpellingLineNumber(SourceLocation Loc, bool.ptr Invalid) {
        if (SourceManagerStatics.isInvalid(Loc, Invalid)) {
            return 0;
        }
        long LocInfo = this.getDecomposedSpellingLoc(Loc.getRawEncoding());
        return this.getLineNumber(BasicClangGlobals.$first_FileID(LocInfo), std_pair.$second_int((long)LocInfo));
    }

    public int getExpansionLineNumber(SourceLocation Loc) {
        return this.getExpansionLineNumber(Loc, null);
    }

    public int getExpansionLineNumber(SourceLocation Loc, bool.ptr Invalid) {
        if (SourceManagerStatics.isInvalid(Loc, Invalid)) {
            return 0;
        }
        long LocInfo = this.getDecomposedExpansionLoc(Loc.getRawEncoding());
        return this.getLineNumber(BasicClangGlobals.$first_FileID(LocInfo), std_pair.$second_int((long)LocInfo));
    }

    public int getPresumedLineNumber(SourceLocation Loc) {
        return this.getPresumedLineNumber(Loc, null);
    }

    public int getPresumedLineNumber(SourceLocation Loc, bool.ptr Invalid) {
        PresumedLoc PLoc = this.getPresumedLoc(Loc);
        if (SourceManagerStatics.isInvalid(PLoc, Invalid)) {
            return 0;
        }
        return PLoc.getLine();
    }

    public char.ptr getBufferName(SourceLocation Loc) {
        return this.getBufferName(Loc.getRawEncoding());
    }

    public char.ptr getBufferName(int Loc) {
        return this.getBufferName(Loc, (bool.ptr)null);
    }

    public char.ptr getBufferName(SourceLocation Loc, bool.ptr Invalid) {
        return this.getBufferName(Loc.getRawEncoding(), Invalid);
    }

    public char.ptr getBufferName(int Loc, bool.ptr Invalid) {
        if (SourceManagerStatics.isInvalid(Loc, Invalid)) {
            return NativePointer.$((String)"<invalid loc>");
        }
        return this.getBuffer(this.getFileID(Loc), Invalid).getBufferIdentifier();
    }

    public SrcMgr.CharacteristicKind getFileCharacteristic(SourceLocation Loc) {
        return this.getFileCharacteristic(Loc.getRawEncoding());
    }

    public SrcMgr.CharacteristicKind getFileCharacteristic(int Loc) {
        assert (SourceLocation.isValid(Loc)) : "Can't get file characteristic of invalid loc!";
        long LocInfo = this.getDecomposedExpansionLoc(Loc);
        int SLocEntryIndex = this.getFileSLocEntryByID_LoadEntryIfAbsent(BasicClangGlobals.$first_FileID(LocInfo));
        if (SLocEntryIndex == 0) {
            return SrcMgr.CharacteristicKind.C_User;
        }
        if (!this.$hasLineDirectives(SLocEntryIndex)) {
            return this.$getFileCharacteristic(SLocEntryIndex);
        }
        assert (this.LineTable != null) : "Can't have linetable entries without a LineTable!";
        LineEntry Entry2 = this.LineTable.FindNearestLineEntry(BasicClangGlobals.$first_FileID(LocInfo), std_pair.$second_int((long)LocInfo));
        if (Entry2 == null) {
            return this.$getFileCharacteristic(SLocEntryIndex);
        }
        return Entry2.FileKind;
    }

    public PresumedLoc getPresumedLoc(SourceLocation Loc) {
        return this.getPresumedLoc(Loc.getRawEncoding(), true);
    }

    public PresumedLoc getPresumedLoc(SourceLocation Loc, boolean UseLineDirectives) {
        return this.getPresumedLoc(Loc.getRawEncoding(), UseLineDirectives);
    }

    public PresumedLoc getPresumedLoc(int Loc) {
        return this.getPresumedLoc(Loc, true);
    }

    public PresumedLoc getPresumedLoc(int Loc, boolean UseLineDirectives) {
        if (SourceLocation.isInvalid(Loc)) {
            return new PresumedLoc();
        }
        long LocInfo = this.getDecomposedExpansionLoc(Loc);
        int SLocEntryIndex = this.getFileSLocEntryByID_LoadEntryIfAbsent(BasicClangGlobals.$first_FileID(LocInfo));
        if (SLocEntryIndex == 0) {
            return new PresumedLoc();
        }
        SrcMgr.ContentCache C2 = this.$getContentCache(SLocEntryIndex);
        char.ptr Filename = C2.OrigEntry != null ? C2.OrigEntry.getName() : C2.getBuffer(this.Diag, this).getBufferIdentifier();
        bool.ptr Invalid = NativePointer.create_bool$ptr((boolean)false);
        int LineNo = this.getLineNumber(BasicClangGlobals.$first_FileID(LocInfo), std_pair.$second_int((long)LocInfo), (bool.ptr)Native.$AddrOf((Object)Invalid));
        if (Invalid.$star()) {
            return new PresumedLoc();
        }
        int ColNo = this.getColumnNumber(BasicClangGlobals.$first_FileID(LocInfo), std_pair.$second_int((long)LocInfo), (bool.ptr)Native.$AddrOf((Object)Invalid));
        if (Invalid.$star()) {
            return new PresumedLoc();
        }
        int IncludeLoc = this.$getIncludeLoc(SLocEntryIndex);
        if (UseLineDirectives && this.$hasLineDirectives(SLocEntryIndex)) {
            assert (this.LineTable != null) : "Can't have linetable entries without a LineTable!";
            LineEntry Entry2 = this.LineTable.FindNearestLineEntry(BasicClangGlobals.$first_FileID(LocInfo), std_pair.$second_int((long)LocInfo));
            if (Entry2 != null) {
                if (Entry2.FilenameID != -1) {
                    Filename = this.LineTable.getFilename(Entry2.FilenameID);
                }
                int MarkerLineNo = this.getLineNumber(BasicClangGlobals.$first_FileID(LocInfo), Entry2.FileOffset);
                LineNo = Entry2.LineNo + (LineNo - MarkerLineNo - 1);
                if (Entry2.IncludeOffset != 0) {
                    IncludeLoc = this.getLocForStartOfFile(BasicClangGlobals.$first_FileID(LocInfo));
                    IncludeLoc = SourceLocation.$getLocWithOffset(IncludeLoc, Entry2.IncludeOffset);
                }
            }
        }
        return new PresumedLoc(Filename, LineNo, ColNo, IncludeLoc);
    }

    public boolean isInMainFile(SourceLocation Loc) {
        return this.isInMainFile(Loc.getRawEncoding());
    }

    public boolean isInMainFile(int Loc) {
        LineEntry Entry2;
        if (SourceLocation.isInvalid(Loc)) {
            return false;
        }
        long LocInfo = this.getDecomposedExpansionLoc(Loc);
        int SLocEntryIndex = this.getFileSLocEntryByID_LoadEntryIfAbsent(BasicClangGlobals.$first_FileID(LocInfo));
        if (SLocEntryIndex == 0) {
            return false;
        }
        if (this.$hasLineDirectives(SLocEntryIndex) && (Entry2 = this.LineTable.FindNearestLineEntry(BasicClangGlobals.$first_FileID(LocInfo), std_pair.$second_int((long)LocInfo))) != null && Entry2.IncludeOffset != 0) {
            return false;
        }
        return SourceLocation.isInvalid(this.$getIncludeLoc(SLocEntryIndex));
    }

    public boolean isWrittenInSameFile(SourceLocation Loc1, SourceLocation Loc2) {
        return this.isWrittenInSameFile(Loc1.getRawEncoding(), Loc2.getRawEncoding());
    }

    public boolean isWrittenInSameFile(int Loc1, int Loc2) {
        return this.getFileID(Loc1) == this.getFileID(Loc2);
    }

    public boolean isWrittenInMainFile(SourceLocation Loc) {
        return this.isWrittenInMainFile(Loc.getRawEncoding());
    }

    public boolean isWrittenInMainFile(int Loc) {
        return this.getFileID(Loc) == this.getMainFileID().$ID();
    }

    public boolean isInSystemHeader(SourceLocation Loc) {
        return this.isInSystemHeader(Loc.getRawEncoding());
    }

    public boolean isInSystemHeader(int Loc) {
        return this.getFileCharacteristic(Loc) != SrcMgr.CharacteristicKind.C_User;
    }

    public boolean isInExternCSystemHeader(SourceLocation Loc) {
        return this.isInExternCSystemHeader(Loc.getRawEncoding());
    }

    public boolean isInExternCSystemHeader(int Loc) {
        return this.getFileCharacteristic(Loc) == SrcMgr.CharacteristicKind.C_ExternCSystem;
    }

    public boolean isInSystemMacro(SourceLocation loc) {
        return this.isInSystemMacro(loc.getRawEncoding());
    }

    public boolean isInSystemMacro(int loc) {
        return SourceLocation.isMacroID(loc) && this.isInSystemHeader(this.getSpellingLoc(loc));
    }

    public int getFileIDSize(FileID FID) {
        return this.getFileIDSize(FID.ID);
    }

    public int getFileIDSize(int FID) {
        int Entry2 = this.getSLocEntryByID_LoadEntryIfAbsent(FID);
        if (Entry2 == 0) {
            return 0;
        }
        int ID2 = FID;
        int NextOffset = ID2 > 0 && ID2 + 1 == this.local_sloc_entry_size() ? this.getNextLocalOffset() : (ID2 + 1 == -1 ? Integer.MIN_VALUE : this.$getOffset(this.getSLocEntryByID_LoadEntryIfAbsent(ID2 + 1)));
        return NextOffset - this.$getOffset(Entry2) - 1;
    }

    public boolean isInFileID(SourceLocation Loc, FileID FID) {
        return this.isInFileID(Loc.getRawEncoding(), FID.ID, (uint.ptr)null);
    }

    public boolean isInFileID(SourceLocation Loc, FileID FID, uint.ptr RelativeOffset) {
        return this.isInFileID(Loc.getRawEncoding(), FID.ID, RelativeOffset);
    }

    public boolean isInFileID(int Loc, int FID) {
        return this.isInFileID(Loc, FID, (uint.ptr)null);
    }

    public boolean isInFileID(int Loc, int FID, uint.ptr RelativeOffset) {
        int Offs = SourceLocation.getOffset(Loc);
        if (this.isOffsetInFileID(FID, Offs)) {
            if (RelativeOffset != null) {
                RelativeOffset.$set(Offs - this.$getOffset(this.getSLocEntryByID_LoadEntryIfAbsent(FID)));
            }
            return true;
        }
        return false;
    }

    public int getLineTableFilenameID(StringRef Name) {
        return this.getLineTable().getLineTableFilenameID(Name);
    }

    public void AddLineNote(SourceLocation Loc, int LineNo, int FilenameID) {
        this.AddLineNote(Loc.getRawEncoding(), LineNo, FilenameID);
    }

    public void AddLineNote(int Loc, int LineNo, int FilenameID) {
        long LocInfo = this.getDecomposedExpansionLoc(Loc);
        if (!this.$setFileHasLineDirective(BasicClangGlobals.$first_FileID(LocInfo))) {
            return;
        }
        this.getLineTable().AddLineNote(BasicClangGlobals.$first_FileID(LocInfo), std_pair.$second_int((long)LocInfo), LineNo, FilenameID);
    }

    private boolean $setFileHasLineDirective(int FID) {
        int SLocEntryIndex = this.getFileSLocEntryByID_LoadEntryIfAbsent(FID);
        return this.$setFileSLocEntry_HasLineDirective(SLocEntryIndex);
    }

    public boolean $setFileSLocEntry_HasLineDirective(int SLocEntryIndex) {
        boolean out = false;
        if (SLocEntryIndex > 0) {
            assert (this.LocalSLocEntryTable.isFile_$at(SLocEntryIndex));
            out = true;
            this.LocalSLocEntryTable.$setHasLineDirectives(SLocEntryIndex);
        } else if (SLocEntryIndex < 0) {
            SLocEntryIndex = SourceManager.unmaskLoadedIndex(SLocEntryIndex);
            assert (this.LoadedSLocEntryTable.isFile_$at(SLocEntryIndex));
            out = true;
            this.LoadedSLocEntryTable.$setHasLineDirectives(SLocEntryIndex);
        }
        return out;
    }

    public void AddLineNote(SourceLocation Loc, int LineNo, int FilenameID, boolean IsFileEntry, boolean IsFileExit, boolean IsSystemHeader, boolean IsExternCHeader) {
        this.AddLineNote(Loc.getRawEncoding(), LineNo, FilenameID, IsFileEntry, IsFileExit, IsSystemHeader, IsExternCHeader);
    }

    public void AddLineNote(int Loc, int LineNo, int FilenameID, boolean IsFileEntry, boolean IsFileExit, boolean IsSystemHeader, boolean IsExternCHeader) {
        if (FilenameID == -1) {
            assert (!(IsFileEntry || IsFileExit || IsSystemHeader || IsExternCHeader)) : "Can't set flags without setting the filename!";
            this.AddLineNote(Loc, LineNo, FilenameID);
            return;
        }
        long LocInfo = this.getDecomposedExpansionLoc(Loc);
        if (!this.$setFileHasLineDirective(BasicClangGlobals.$first_FileID(LocInfo))) {
            return;
        }
        this.getLineTable();
        SrcMgr.CharacteristicKind FileKind = IsExternCHeader ? SrcMgr.CharacteristicKind.C_ExternCSystem : (IsSystemHeader ? SrcMgr.CharacteristicKind.C_System : SrcMgr.CharacteristicKind.C_User);
        int EntryExit = 0;
        if (IsFileEntry) {
            EntryExit = 1;
        } else if (IsFileExit) {
            EntryExit = 2;
        }
        this.LineTable.AddLineNote(BasicClangGlobals.$first_FileID(LocInfo), std_pair.$second_int((long)LocInfo), LineNo, FilenameID, EntryExit, FileKind);
    }

    public boolean hasLineTable() {
        return this.LineTable != null;
    }

    public LineTableInfo getLineTable() {
        if (this.LineTable == null) {
            this.LineTable = new LineTableInfo();
        }
        return (LineTableInfo)Native.$Deref((Object)this.LineTable);
    }

    public long getContentCacheSize() {
        return this.ContentCacheAlloc.getTotalMemory();
    }

    public MemoryBufferSizes getMemoryBufferSizes() {
        int malloc_bytes = 0;
        int mmap_bytes = 0;
        int e = this.MemBufferInfos.size();
        block4: for (int i = 0; i != e; ++i) {
            int sized_mapped = ((SrcMgr.ContentCache)this.MemBufferInfos.$at(i)).getSizeBytesMapped();
            if (sized_mapped == 0) continue;
            switch (((SrcMgr.ContentCache)this.MemBufferInfos.$at(i)).getMemoryBufferKind()) {
                case MemoryBuffer_MMap: {
                    mmap_bytes += sized_mapped;
                    continue block4;
                }
                case MemoryBuffer_Malloc: {
                    malloc_bytes += sized_mapped;
                }
            }
        }
        return new MemoryBufferSizes(malloc_bytes, mmap_bytes);
    }

    public int getDataStructureSizes() {
        int size = llvm.capacity_in_bytes(this.MemBufferInfos) + llvm.capacity_in_bytes((NativeType.SizeofCapable)this.LocalSLocEntryTable) + llvm.capacity_in_bytes((NativeType.SizeofCapable)this.LoadedSLocEntryTable) + llvm.capacity_in_bytes((NativeType.SizeofCapable)this.SLocEntryLoaded) + llvm.capacity_in_bytes(this.FileInfos);
        if (this.OverriddenFilesInfo.$bool()) {
            size += llvm.capacity_in_bytes(((OverriddenFilesInfoTy)this.OverriddenFilesInfo.$arrow()).OverriddenFiles);
        }
        return size;
    }

    public SourceLocation translateFileLineCol(FileEntry SourceFile, int Line, int Col) {
        assert (SourceFile != null) : "Null source file!";
        assert (Line != 0 && Col != 0) : "Line and column should start from 1!";
        FileID FirstFID = this.translateFile(SourceFile);
        return this.translateLineCol(FirstFID, Line, Col);
    }

    public FileID translateFile(FileEntry SourceFile) {
        int I;
        assert (SourceFile != null) : "Null source file!";
        FileID FirstFID = new FileID();
        Optional SourceFileUID = new Optional();
        Optional SourceFileName = new Optional();
        if (this.MainFileID.isValid()) {
            SrcMgr.ContentCache MainContentCache;
            int MainSLoc = this.getSLocEntryByID_LoadEntryIfAbsent(this.MainFileID.ID);
            if (MainSLoc == 0) {
                return new FileID();
            }
            if (this.$isFile(MainSLoc) && (MainContentCache = this.$getContentCache(MainSLoc)) != null) {
                if (MainContentCache.OrigEntry == SourceFile) {
                    FirstFID.$assign(this.MainFileID);
                } else {
                    FileEntry MainFile = MainContentCache.OrigEntry;
                    SourceFileName.$assign((Object)path.filename((StringRef)new StringRef(SourceFile.getName())));
                    if (llvm.$eq_StringRef((StringRef)((StringRef)SourceFileName.$star()), (StringRef)path.filename((StringRef)new StringRef(MainFile.getName())))) {
                        Optional<fs.UniqueID> MainFileUID;
                        SourceFileUID.$assignMove(SourceManagerStatics.getActualFileUID(SourceFile));
                        if (SourceFileUID.$bool() && (MainFileUID = SourceManagerStatics.getActualFileUID(MainFile)).$bool() && ((fs.UniqueID)SourceFileUID.$star()).$eq((fs.UniqueID)MainFileUID.$star())) {
                            FirstFID.$assign(this.MainFileID);
                            SourceFile = MainFile;
                        }
                    }
                }
            }
        }
        if (FirstFID.isInvalid()) {
            int N = this.local_sloc_entry_size();
            for (I = 1; I != N; ++I) {
                int SLoc = this.getLocalSLocEntry_performance(I);
                if (SLoc == 0) {
                    return new FileID();
                }
                if (!this.$isFile(SLoc) || this.$getContentCache(SLoc) == null || this.$getContentCache((int)SLoc).OrigEntry != SourceFile) continue;
                FirstFID.$assignMove(I);
                break;
            }
            if (FirstFID.isInvalid()) {
                N = this.loaded_sloc_entry_size();
                for (I = 0; I != N; ++I) {
                    int SLoc = this.getLoadedSLocEntry(I);
                    if (!this.$isFile(SLoc) || this.$getContentCache(SLoc) == null || this.$getContentCache((int)SLoc).OrigEntry != SourceFile) continue;
                    FirstFID.$assign(-I - 2);
                    break;
                }
            }
        }
        if (FirstFID.isInvalid() && (SourceFileName.$bool() || SourceFileName.$assign((Object)path.filename((StringRef)new StringRef(SourceFile.getName()))).$bool()) && (SourceFileUID.$bool() || SourceFileUID.$assignMove(SourceManagerStatics.getActualFileUID(SourceFile)).$bool())) {
            int N = this.local_sloc_entry_size();
            for (I = 0; I != N; ++I) {
                Optional<fs.UniqueID> EntryUID;
                FileEntry Entry2;
                int IFileID = I;
                int SLoc = this.getSLocEntryByID_LoadEntryIfAbsent(IFileID);
                if (SLoc == 0) {
                    return new FileID();
                }
                if (!this.$isFile(SLoc)) continue;
                SrcMgr.ContentCache FileContentCache = this.$getContentCache(SLoc);
                FileEntry fileEntry = Entry2 = FileContentCache != null ? FileContentCache.OrigEntry : null;
                if (Entry2 == null || !llvm.$eq_StringRef((StringRef)((StringRef)SourceFileName.$star()), (StringRef)path.filename((StringRef)new StringRef(Entry2.getName()))) || !(EntryUID = SourceManagerStatics.getActualFileUID(Entry2)).$bool() || !((fs.UniqueID)SourceFileUID.$star()).$eq((fs.UniqueID)EntryUID.$star())) continue;
                FirstFID.$assignMove(I);
                SourceFile = Entry2;
                break;
            }
        }
        return FirstFID;
    }

    public SourceLocation translateLineCol(FileID FID, int Line, int Col) {
        return SourceLocation.getFromRawEncoding(this.translateLineCol(FID.ID, Line, Col));
    }

    public int translateLineCol(int FID, int Line, int Col) {
        assert (Line != 0 && Col != 0) : "Line and column should start from 1!";
        if (FileID.isInvalid(FID)) {
            return SourceLocation.getInvalid();
        }
        int Entry2 = this.getSLocEntryByID_LoadEntryIfAbsent(FID);
        if (Entry2 == 0) {
            return SourceLocation.getInvalid();
        }
        if (!this.$isFile(Entry2)) {
            return SourceLocation.getInvalid();
        }
        int FileLoc = SourceLocation.$getFileLoc(this.$getOffset(Entry2));
        if (Line == 1 && Col == 1) {
            return FileLoc;
        }
        SrcMgr.ContentCache Content = this.$getContentCache(Entry2);
        if (Content == null) {
            return SourceLocation.getInvalid();
        }
        if (Content.SourceLineCache == null) {
            boolean MyInvalid = false;
            MyInvalid = SourceManagerStatics.ComputeLineNumbers(this.Diag, Content, this.ContentCacheAlloc, this, null);
            if (MyInvalid) {
                return SourceLocation.getInvalid();
            }
        }
        if (Unsigned.$greater_uint((int)Line, (int)Content.NumLines)) {
            int Size = Content.getBuffer(this.Diag, this).getBufferSize();
            if (Unsigned.$greater_uint((int)Size, (int)0)) {
                --Size;
            }
            return SourceLocation.$getLocWithOffset(FileLoc, Size);
        }
        MemoryBuffer Buffer2 = Content.getBuffer(this.Diag, this);
        int FilePos = Content.SourceLineCache[Line - 1];
        char.ptr Buf = (char.ptr)Buffer2.getBufferStart().$add(FilePos);
        int BufLength = Buffer2.getBufferSize() - FilePos;
        if (BufLength == 0) {
            return SourceLocation.$getLocWithOffset(FileLoc, FilePos);
        }
        int i = 0;
        while (Unsigned.$less_uint((int)i, (int)(BufLength - 1)) && Unsigned.$less_uint((int)i, (int)(Col - 1)) && Buf.$at(i) != 10 && Buf.$at(i) != 13) {
            ++i;
        }
        return SourceLocation.$getLocWithOffset(FileLoc, FilePos + i);
    }

    public SourceLocation getMacroArgExpandedLocation(SourceLocation Loc) {
        return SourceLocation.getFromRawEncoding(this.getMacroArgExpandedLocation(Loc.getRawEncoding()));
    }

    public int getMacroArgExpandedLocation(int Loc) {
        if (SourceLocation.isInvalid(Loc) || !SourceLocation.isFileID(Loc)) {
            return Loc;
        }
        long decomposedLoc = this.getDecomposedLoc(Loc);
        int FID = BasicClangGlobals.$first_FileID(decomposedLoc);
        int Offset = BasicClangGlobals.$second_offset(decomposedLoc);
        if (FileID.isInvalid(FID)) {
            return Loc;
        }
        std_map.mapUIntType MacroArgsCache = (std_map.mapUIntType)this.MacroArgsCacheMap.$at(FID);
        if (MacroArgsCache == null) {
            MacroArgsCache = new std_map.mapUIntType((Object)new SourceLocation());
            this.computeMacroArgsCache((std_map.mapUIntType<SourceLocation>)MacroArgsCache, FID);
            this.MacroArgsCacheMap.$set(FID, (Object)MacroArgsCache);
        }
        assert (!MacroArgsCache.empty());
        StdMapUIntType.iterator I = MacroArgsCache.upper_bound(Integer.valueOf(Offset));
        I.$preDec();
        int MacroArgBeginOffs = I.$arrow().first;
        SourceLocation MacroArgExpandedLoc = (SourceLocation)I.$arrow().second;
        if (MacroArgExpandedLoc.isValid()) {
            return MacroArgExpandedLoc.$getLocWithOffset(Offset - MacroArgBeginOffs);
        }
        return Loc;
    }

    public boolean isBeforeInTranslationUnit(SourceLocation LHS, SourceLocation RHS) {
        return this.isBeforeInTranslationUnit(LHS.getRawEncoding(), RHS.getRawEncoding());
    }

    public boolean isBeforeInTranslationUnit(int LHS, int RHS) {
        boolean RIsScratch;
        boolean RIsAsm;
        boolean RIsBuiltins;
        DenseMapIteratorIntUInt I;
        assert (SourceLocation.isValid(LHS) && SourceLocation.isValid(RHS)) : "Passed invalid source location!";
        if (BasicClangGlobals.$eq_SourceLocation$C(LHS, RHS)) {
            return false;
        }
        std_pair.pairIntUInt LOffs = new std_pair.pairIntUInt(this.getDecomposedLoc(LHS));
        std_pair.pairIntUInt ROffs = new std_pair.pairIntUInt(this.getDecomposedLoc(RHS));
        if (FileID.isInvalid(LOffs.first) || FileID.isInvalid(ROffs.first)) {
            return FileID.isInvalid(LOffs.first) && !FileID.isInvalid(ROffs.first);
        }
        if (LOffs.first == ROffs.first) {
            return Unsigned.$less_uint((int)LOffs.second, (int)ROffs.second);
        }
        InBeforeInTUCacheEntry IsBeforeInTUCache = this.getInBeforeInTUCache(LOffs.first, ROffs.first);
        if (IsBeforeInTUCache.isCacheValid(LOffs.first, ROffs.first)) {
            return IsBeforeInTUCache.getCachedResult(LOffs.second, ROffs.second);
        }
        IsBeforeInTUCache.setQueryFIDs(LOffs.first, ROffs.first, LOffs.first < ROffs.first);
        SmallDenseMapIntUInt LChain = new SmallDenseMapIntUInt((DenseMapInfoInt)new DenseMapInfoIntFileID(), 16, 0);
        do {
            LChain.insert(LOffs);
        } while (LOffs.first != ROffs.first && !SourceManagerStatics.MoveUpIncludeHierarchy(LOffs, this));
        while ((I = LChain.find(ROffs.first)).$eq(LChain.end()) && !SourceManagerStatics.MoveUpIncludeHierarchy(ROffs, this)) {
        }
        if (I.$noteq(LChain.end())) {
            LOffs.$assign(I.$star());
        }
        if (LOffs.first == ROffs.first) {
            IsBeforeInTUCache.setCommonLoc(LOffs.first, LOffs.second, ROffs.second);
            return IsBeforeInTUCache.getCachedResult(LOffs.second, ROffs.second);
        }
        IsBeforeInTUCache.clear();
        char.ptr LB = this.getBuffer(LOffs.first).getBufferIdentifier();
        char.ptr RB = this.getBuffer(ROffs.first).getBufferIdentifier();
        boolean LIsBuiltins = std.strcmp((char.ptr)NativePointer.$built_in_marker, (char.ptr)LB) == 0;
        boolean bl = RIsBuiltins = std.strcmp((char.ptr)NativePointer.$built_in_marker, (char.ptr)RB) == 0;
        if (LIsBuiltins || RIsBuiltins) {
            if (LIsBuiltins != RIsBuiltins) {
                return LIsBuiltins;
            }
            return LOffs.first < ROffs.first;
        }
        boolean LIsAsm = std.strcmp((CharSequence)"<inline asm>", (char.ptr)LB) == 0;
        boolean bl2 = RIsAsm = std.strcmp((CharSequence)"<inline asm>", (char.ptr)RB) == 0;
        if (LIsAsm || RIsAsm) {
            if (LIsAsm != RIsAsm) {
                return RIsAsm;
            }
            assert (LOffs.first == ROffs.first);
            return false;
        }
        boolean LIsScratch = std.strcmp((char.ptr)NativePointer.$scratch_space_marker, (char.ptr)LB) == 0;
        boolean bl3 = RIsScratch = std.strcmp((char.ptr)NativePointer.$scratch_space_marker, (char.ptr)RB) == 0;
        if (LIsScratch || RIsScratch) {
            if (LIsScratch != RIsScratch) {
                return LIsScratch;
            }
            return Unsigned.$less_uint((int)LOffs.second, (int)ROffs.second);
        }
        throw new llvm_unreachable("Unsortable locations found");
    }

    public boolean isBeforeInSLocAddrSpace_SLoc_SLoc(SourceLocation LHS, SourceLocation RHS) {
        return this.isBeforeInSLocAddrSpace_SLoc_Offset(LHS.getRawEncoding(), RHS.getOffset());
    }

    public boolean isBeforeInSLocAddrSpace_SLoc_SLoc(int LHS, int RHS) {
        return this.isBeforeInSLocAddrSpace_SLoc_Offset(LHS, SourceLocation.getOffset(RHS));
    }

    public boolean isBeforeInSLocAddrSpace_SLoc_Offset(SourceLocation LHS, int RHSOffset) {
        return this.isBeforeInSLocAddrSpace_SLoc_Offset(LHS.getRawEncoding(), RHSOffset);
    }

    public boolean isBeforeInSLocAddrSpace_SLoc_Offset(int LHS, int RHSOffset) {
        boolean RHSLoaded;
        int LHSOffset = SourceLocation.getOffset(LHS);
        boolean LHSLoaded = Unsigned.$greatereq_uint((int)LHSOffset, (int)this.CurrentLoadedOffset);
        if (LHSLoaded == (RHSLoaded = Unsigned.$greatereq_uint((int)RHSOffset, (int)this.CurrentLoadedOffset))) {
            return Unsigned.$less_uint((int)LHSOffset, (int)RHSOffset);
        }
        return LHSLoaded;
    }

    public DenseMapIterator<FileEntry, SrcMgr.ContentCache> fileinfo_begin() {
        return this.FileInfos.begin();
    }

    public DenseMapIterator<FileEntry, SrcMgr.ContentCache> fileinfo_end() {
        return this.FileInfos.end();
    }

    public boolean hasFileInfo(FileEntry File2) {
        return this.FileInfos.find((Object)File2).$noteq(this.FileInfos.end());
    }

    public void PrintStats() {
        this.PrintStats(llvm.errs());
    }

    public void PrintStats(raw_ostream OS) {
        OS.$out("\n*** Source Manager Stats:\n");
        OS.$out(NativeTrace.formatNumber((long)this.FileInfos.size())).$out(" files mapped, ").$out(NativeTrace.formatNumber((long)this.MemBufferInfos.size())).$out(" mem buffers mapped.\n");
        OS.$out(NativeTrace.formatNumber((long)this.local_sloc_entry_size())).$out(" local SLocEntry's allocated (").$out(NativeTrace.formatNumber((long)llvm.capacity_in_bytes((NativeType.SizeofCapable)this.LocalSLocEntryTable))).$out(" bytes of capacity), ").$out(NativeTrace.formatNumber((long)this.NextLocalOffset)).$out("B of Sloc address space used.\n");
        OS.$out(NativeTrace.formatNumber((long)this.LoadedSLocEntryTable.size())).$out(" loaded SLocEntries allocated, ").$out(NativeTrace.formatNumber((long)Unsigned.$uint2ulong((int)(Integer.MIN_VALUE - this.CurrentLoadedOffset)))).$out("B of Sloc address space used.\n");
        int NumLineNumsComputed = 0;
        int NumFileBytesMapped = 0;
        DenseMapIterator<FileEntry, SrcMgr.ContentCache> I = this.fileinfo_begin();
        DenseMapIterator<FileEntry, SrcMgr.ContentCache> E = this.fileinfo_end();
        while (I.$noteq(E)) {
            NumLineNumsComputed += ((SrcMgr.ContentCache)I.$arrow().second).SourceLineCache != null ? 1 : 0;
            NumFileBytesMapped += ((SrcMgr.ContentCache)I.$arrow().second).getSizeBytesMapped();
            I.$preInc();
        }
        int NumMacroArgsComputed = this.MacroArgsCacheMap.size();
        OS.$out(NativeTrace.formatNumber((long)NumFileBytesMapped)).$out(" bytes of files mapped, ").$out(NativeTrace.formatNumber((long)NumLineNumsComputed)).$out(" files with line #'s computed, ").$out(NativeTrace.formatNumber((long)NumMacroArgsComputed)).$out(" files with macro args computed.\n");
        OS.$out("FileID slow scans: ").$out(NativeTrace.formatNumber((long)(this.NumLinearScans + this.NumLinearMacroScans + this.NumBinaryProbes + this.NumBinaryMacroProbes))).$out(" total (").$out(NativeTrace.formatNumber((long)(this.NumLinearScans + this.NumLinearMacroScans))).$out(" linear, ").$out(NativeTrace.formatNumber((long)(this.NumBinaryProbes + this.NumBinaryMacroProbes))).$out(" binary).\n");
        OS.$out("FileID scans: ").$out(NativeTrace.formatNumber((long)this.NumLinearScans)).$out(" linear, ").$out(NativeTrace.formatNumber((long)this.NumBinaryProbes)).$out(" binary.\n");
        OS.$out("MacroID scans: ").$out(NativeTrace.formatNumber((long)this.NumLinearMacroScans)).$out(" linear, ").$out(NativeTrace.formatNumber((long)this.NumBinaryMacroProbes)).$out(" binary.\n");
        OS.$out("FileID Slice scans: ").$out(NativeTrace.formatNumber((long)this.NumImmediateSliceScans)).$out(" immediate, ").$out(NativeTrace.formatNumber((long)this.NumLinearSliceScans)).$out(" linear, ").$out(NativeTrace.formatNumber((long)this.NumBinarySliceProbes)).$out(" binary.\n");
    }

    public void dump() {
        raw_ostream out = llvm.errs();
        DumpSLocEntry DumpSLocEntry2 = (ID2, Entry2, NextStart) -> {
            out.$out("SLocEntry <FileID ").$out_int(ID2).$out("> ").$out(Entry2.isFile() ? "file" : "expansion").$out(" <SourceLocation ").$out_uint(Entry2.getOffset()).$out(NativePointer.$COLON);
            if (NextStart.$bool()) {
                out.$out_uint(NextStart.$star()).$out(NativePointer.$GT_LF);
            } else {
                out.$out("????>\n");
            }
            if (Entry2.isFile()) {
                SrcMgr.ContentCache CC;
                SrcMgr.FileInfo FI = Entry2.getFile();
                if (FI.getNumCreatedFIDs() != 0) {
                    out.$out("  covers <FileID ").$out_int(ID2).$out(NativePointer.$COLON).$out_int(ID2 + FI.getNumCreatedFIDs()).$out(NativePointer.$GT_LF);
                }
                if (FI.getIncludeLoc().isValid()) {
                    out.$out("  included from ").$out_uint(FI.getIncludeLoc().getOffset()).$out(NativePointer.$LF);
                }
                if ((CC = this.getContentCache(FI)) != null) {
                    out.$out("  for ").$out(CC.OrigEntry != null ? CC.OrigEntry.getName() : NativePointer.$((String)"<none>")).$out(NativePointer.$LF);
                    if (CC.BufferOverridden) {
                        out.$out("  contents overridden\n");
                    }
                    if (CC.ContentsEntry != CC.OrigEntry) {
                        out.$out("  contents from ").$out(CC.ContentsEntry != null ? CC.ContentsEntry.getName() : NativePointer.$((String)"<none>")).$out(NativePointer.$LF);
                    }
                }
            } else {
                SrcMgr.ExpansionInfo EI = Entry2.getExpansion();
                out.$out("  spelling from ").$out_uint(EI.getSpellingLoc().getOffset()).$out(NativePointer.$LF);
                out.$out("  macro ").$out(EI.isMacroArgExpansion() ? NativePointer.$((String)"arg") : NativePointer.$((String)"body")).$out(" range <").$out_uint(EI.getExpansionLocStart().getOffset()).$out(NativePointer.$COLON).$out_uint(EI.getExpansionLocEnd().getOffset()).$out(NativePointer.$GT_LF);
            }
        };
        int NumIDs = this.LocalSLocEntryTable.size();
        for (int ID3 = 0; ID3 != NumIDs; ++ID3) {
            DumpSLocEntry2.$call(ID3, this.LocalSLocEntryTable.$at(ID3), new ADTAliases.OptionalUInt(ID3 == NumIDs - 1 ? this.NextLocalOffset : this.LocalSLocEntryTable.$at(ID3 + 1).getOffset()));
        }
        ADTAliases.OptionalUInt NextStart2 = new ADTAliases.OptionalUInt();
        for (int Index = 0; Index != this.LoadedSLocEntryTable.size(); ++Index) {
            int ID4 = -Index - 2;
            if (this.SLocEntryLoaded.$at(Index)) {
                DumpSLocEntry2.$call(ID4, this.LoadedSLocEntryTable.$at(Index), NextStart2);
                NextStart2 = new ADTAliases.OptionalUInt(this.LoadedSLocEntryTable.$at(Index).getOffset());
                continue;
            }
            NextStart2 = new ADTAliases.OptionalUInt(NoneType.None);
        }
    }

    public int local_sloc_entry_size() {
        assert (this.LocalSLocEntryTable.size() == this.local_sloc_entry_size);
        return this.local_sloc_entry_size;
    }

    public int getLocalSLocEntry_performance(int Index) {
        assert (Unsigned.$less_uint((int)Index, (int)this.local_sloc_entry_size)) : "Invalid index";
        return Index;
    }

    public SrcMgr.SLocEntry getLocalSLocEntry(int Index) {
        return this.getLocalSLocEntry(Index, null);
    }

    public SrcMgr.SLocEntry getLocalSLocEntry(int Index, bool.ptr Invalid) {
        assert (Unsigned.$less_uint((int)Index, (int)this.LocalSLocEntryTable.size())) : "Invalid index";
        return this.LocalSLocEntryTable.$at(Index);
    }

    public int loaded_sloc_entry_size() {
        return this.LoadedSLocEntryTable.size();
    }

    public int getLoadedSLocEntry(int Index) {
        assert (Unsigned.$less_uint((int)Index, (int)this.LoadedSLocEntryTable.size())) : "Invalid index";
        if (!this.SLocEntryLoaded.$at(Index) && this.loadSLocEntry(Index)) {
            return 0;
        }
        return SourceManager.maskValidLoadedIndex(Index);
    }

    public SrcMgr.SLocEntry getSLocEntry(FileID FID) {
        return this.getSLocEntry(FID.ID, (bool.ptr)null);
    }

    public SrcMgr.SLocEntry getSLocEntry(FileID FID, bool.ptr Invalid) {
        return this.getSLocEntry(FID.ID, Invalid);
    }

    public SrcMgr.SLocEntry getSLocEntry(int FID) {
        return this.getSLocEntry(FID, (bool.ptr)null);
    }

    public SrcMgr.SLocEntry getSLocEntry(int FID, bool.ptr Invalid) {
        if (FID == 0 || FID == -1) {
            if (Invalid != null) {
                Invalid.$set(true);
            }
            return this.LocalSLocEntryTable.$at(0);
        }
        assert (FID != -1) : "Using FileID sentinel value";
        int SLocEntryIndex = FID < 0 ? this.getLoadedSLocEntryByID(FID) : this.getLocalSLocEntry_performance(FID);
        if (Invalid != null) {
            Invalid.$set(SLocEntryIndex == 0);
        }
        return this.$getSLocEntry(SLocEntryIndex);
    }

    public int getNextLocalOffset() {
        return this.NextLocalOffset;
    }

    public void setExternalSLocEntrySource(ExternalSLocEntrySource Source) {
        assert (this.LoadedSLocEntryTable.empty()) : "Invalidating existing loaded entries";
        this.ExternalSLocEntries = Source;
    }

    public std_pair.pairIntUInt AllocateLoadedSLocEntries(int NumSLocEntries, int TotalSize) {
        assert (this.ExternalSLocEntries != null) : "Don't have an external sloc source";
        if (Unsigned.$less_uint((int)(this.CurrentLoadedOffset - TotalSize), (int)this.NextLocalOffset)) {
            return std.make_pair_int_uint((int)0, (int)0);
        }
        this.LoadedSLocEntryTable = this.LoadedSLocEntryTable.resize(this.LoadedSLocEntryTable.size() + NumSLocEntries);
        this.LoadedSLocTableIsSliced = this.LoadedSLocEntryTable.isSlicedByOffsets();
        this.SLocEntryLoaded.resize(this.LoadedSLocEntryTable.size(), false);
        this.CurrentLoadedOffset -= TotalSize;
        int ID2 = this.LoadedSLocEntryTable.size();
        return std.make_pair_int_uint((int)(-ID2 - 1), (int)this.CurrentLoadedOffset);
    }

    public boolean isLoadedSourceLocation(SourceLocation Loc) {
        return Unsigned.$greatereq_uint((int)Loc.getOffset(), (int)this.CurrentLoadedOffset);
    }

    public boolean isLocalSourceLocation(SourceLocation Loc) {
        return Unsigned.$less_uint((int)Loc.getOffset(), (int)this.NextLocalOffset);
    }

    public boolean isLoadedFileID(FileID FID) {
        assert (FID.ID != -1) : "Using FileID sentinel value";
        return FID.ID < 0;
    }

    public boolean isLocalFileID(FileID FID) {
        return !this.isLoadedFileID(FID);
    }

    public SourceLocation getImmediateMacroCallerLoc(SourceLocation Loc) {
        return SourceLocation.getFromRawEncoding(this.getImmediateMacroCallerLoc(Loc.getRawEncoding()));
    }

    public int getImmediateMacroCallerLoc(int Loc) {
        if (!SourceLocation.isMacroID(Loc)) {
            return Loc;
        }
        if (this.isMacroArgExpansion(Loc)) {
            return this.getImmediateSpellingLoc(Loc);
        }
        return std_pair.$first_int((long)this.getImmediateExpansionRange(Loc));
    }

    private MemoryBuffer getFakeBufferForRecovery() {
        if (!this.FakeBufferForRecovery.$bool()) {
            this.FakeBufferForRecovery.$assignMove(MemoryBuffer.getMemBuffer((StringRef)INVALID_BUFFER_STRING_REF));
            ((MemoryBuffer)this.FakeBufferForRecovery.get()).setInvalid();
        }
        return (MemoryBuffer)this.FakeBufferForRecovery.get();
    }

    private SrcMgr.ContentCache getFakeContentCacheForRecovery() {
        if (!this.FakeContentCacheForRecovery.$bool()) {
            this.FakeContentCacheForRecovery.$assignMove(llvm.make_unique((Object)new SrcMgr.ContentCache(0)));
            ((SrcMgr.ContentCache)this.FakeContentCacheForRecovery.$arrow()).replaceBuffer(this.getFakeBufferForRecovery(), true);
        }
        return (SrcMgr.ContentCache)this.FakeContentCacheForRecovery.get();
    }

    private boolean loadSLocEntry(int Index) {
        assert (!this.SLocEntryLoaded.$at(Index));
        boolean Error2 = false;
        if (this.ExternalSLocEntries.ReadSLocEntry(-(Index + 2))) {
            Error2 = true;
            if (!this.SLocEntryLoaded.$at(Index)) {
                this.LoadedSLocEntryTable.$setFile(Index, 0, SourceLocation.getInvalid(), this.getFakeContentCacheForRecovery(), SrcMgr.CharacteristicKind.C_User);
            }
        }
        return Error2;
    }

    private SrcMgr.SLocEntry getSLocEntryByID(int ID2) {
        return this.getSLocEntryByID(ID2, null);
    }

    private SrcMgr.SLocEntry getSLocEntryByID(int ID2, bool.ptr Invalid) {
        throw new UnsupportedOperationException("use getSLocEntryByID_LoadEntryIfAbsent");
    }

    private static int unmaskLoadedIndex(int maskedIndex) {
        assert (maskedIndex < 0);
        return maskedIndex == Integer.MIN_VALUE ? 0 : -maskedIndex;
    }

    private static int maskValidLoadedIndex(int rawLoadedIndex) {
        int out;
        int n = out = rawLoadedIndex == 0 ? Integer.MIN_VALUE : -rawLoadedIndex;
        assert (out < 0) : "we must return negative index " + out;
        return out;
    }

    public int getSLocEntryByID_LoadEntryIfAbsent(int FID) {
        if (FID == 0 || FID == -1) {
            return 0;
        }
        assert (FID != -1) : "Using FileID sentinel value";
        if (FID > 0) {
            return FID;
        }
        int TableIdx = -FID - 2;
        assert (TableIdx < this.LoadedSLocEntryTable.size()) : "Invalid index";
        if (!this.SLocEntryLoaded.$at(TableIdx) && this.loadSLocEntry(TableIdx)) {
            return 0;
        }
        return SourceManager.maskValidLoadedIndex(TableIdx);
    }

    public int getFileSLocEntryByID_LoadEntryIfAbsent(int FID) {
        if (FID == 0 || FID == -1) {
            return 0;
        }
        assert (FID != -1) : "Using FileID sentinel value";
        if (FID > 0) {
            return this.LocalSLocEntryTable.isFile_$at(FID) ? FID : 0;
        }
        int TableIdx = -FID - 2;
        assert (TableIdx < this.LoadedSLocEntryTable.size()) : "Invalid index";
        if (!this.SLocEntryLoaded.$at(TableIdx) && this.loadSLocEntry(TableIdx)) {
            return 0;
        }
        return this.LoadedSLocEntryTable.isFile_$at(TableIdx) ? SourceManager.maskValidLoadedIndex(TableIdx) : 0;
    }

    public int getExpansionSLocEntryByID_LoadEntryIfAbsent(int FID) {
        if (FID == 0 || FID == -1) {
            return 0;
        }
        assert (FID != -1) : "Using FileID sentinel value";
        if (FID > 0) {
            return this.LocalSLocEntryTable.isExpansion_$at(FID) ? FID : 0;
        }
        int TableIdx = -FID - 2;
        assert (TableIdx < this.LoadedSLocEntryTable.size()) : "Invalid index";
        if (!this.SLocEntryLoaded.$at(TableIdx) && this.loadSLocEntry(TableIdx)) {
            return 0;
        }
        return this.LoadedSLocEntryTable.isExpansion_$at(TableIdx) ? SourceManager.maskValidLoadedIndex(TableIdx) : 0;
    }

    public int getLoadedSLocEntryByID(int ID2) {
        return this.getLoadedSLocEntry(-ID2 - 2);
    }

    private int createExpansionLocImpl(int SpellingLoc, int ExpansionLocStart, int ExpansionLocEnd, int TokLength, int LoadedID, int LoadedOffset) {
        if (LoadedID < 0) {
            assert (LoadedID != -1) : "Loading sentinel FileID";
            int Index = -LoadedID - 2;
            assert (Unsigned.$less_uint((int)Index, (int)this.LoadedSLocEntryTable.size())) : "FileID out of range";
            assert (!this.SLocEntryLoaded.$at(Index)) : "FileID already loaded";
            this.LoadedSLocEntryTable.$setExpansion(Index, LoadedOffset, SpellingLoc, ExpansionLocStart, ExpansionLocEnd);
            this.SLocEntryLoaded.$set(Index, true);
            return SourceLocation.$getMacroLoc(LoadedOffset);
        }
        this.LastMacroIDLookup = this.LastMacroIDLookupLocalSLocEntryIndex = this.LocalSLocEntryTable.size();
        this.LastMacroIDLookupLocalOffset = this.NextLocalOffset;
        this.LocalSLocEntryTable = this.LocalSLocEntryTable.push_back_Expansion(this.NextLocalOffset, SpellingLoc, ExpansionLocStart, ExpansionLocEnd);
        this.updateLocalSLocConstants();
        assert (Unsigned.$greater_uint((int)(this.NextLocalOffset + TokLength + 1), (int)this.NextLocalOffset) && Unsigned.$lesseq_uint((int)(this.NextLocalOffset + TokLength + 1), (int)this.CurrentLoadedOffset)) : "Ran out of source locations!";
        this.NextLocalOffset += TokLength + 1;
        return SourceLocation.$getMacroLoc(this.NextLocalOffset - (TokLength + 1));
    }

    private boolean isOffsetInFileID(int ID2, int SLocOffset) {
        if (ID2 >= -1) {
            if (this.LocalSLocTableIsSliced) {
                return this.isOffsetInFileIDLocalFromSlicedOffsets(ID2, SLocOffset);
            }
            return this.isOffsetInFileIDLocalFromRawOffsets(ID2, SLocOffset);
        }
        assert (ID2 < 0);
        int EntryOffset = this.$getOffset(this.getLoadedSLocEntryByID(ID2));
        if (Unsigned.$less_uint((int)SLocOffset, (int)EntryOffset)) {
            return false;
        }
        if (ID2 == -2) {
            return true;
        }
        int NextID = ID2 + 1;
        assert (NextID < 0);
        return Unsigned.$less_uint((int)SLocOffset, (int)this.$getOffset(this.getLoadedSLocEntryByID(NextID)));
    }

    private boolean isOffsetInFileIDLocalFromRawOffsets(int ID2, int SLocOffset) {
        int EntryOffset;
        assert (ID2 == -1 || ID2 < this.local_sloc_entry_size()) : "Invalid index";
        int n = EntryOffset = ID2 == -1 ? this.LocalSLocEntryTable.offset_$at(0) : this.LocalSLocEntryTable.offset_$at(ID2);
        if (SLocOffset < EntryOffset) {
            return false;
        }
        int NextID = ID2 + 1;
        assert (NextID <= this.local_sloc_entry_size()) : "Invalid index";
        if (NextID == this.local_sloc_entry_size()) {
            return SLocOffset < this.NextLocalOffset;
        }
        return SLocOffset < this.LocalSLocEntryTable.offset_$at(NextID);
    }

    private boolean isOffsetInFileIDLocalFromSlicedOffsets(int ID2, int SLocOffset) {
        int EntryOffset;
        int index;
        int[] offsets;
        int slice;
        assert (this.LocalSLocTableIsSliced);
        assert (ID2 == -1 || ID2 < this.local_sloc_entry_size()) : "Invalid index";
        if (ID2 == this.LastFileIDLookupLocalSLocEntryIndex) {
            slice = this.LastFileIDLookupLocalSlice;
            offsets = this.LastFileIDLookupLocalSliceArray;
            index = this.LastFileIDLookupLocalIndexInSlice;
            EntryOffset = this.LastFileIDLookupLocalOffset;
            assert (EntryOffset == offsets[index]) : EntryOffset + " vs. " + offsets[index];
        } else if (ID2 == this.LastMacroIDLookupLocalSLocEntryIndex) {
            slice = this.LastMacroIDLookupLocalSlice;
            offsets = this.LastMacroIDLookupLocalSliceArray;
            index = this.LastMacroIDLookupLocalIndexInSlice;
            EntryOffset = this.LastMacroIDLookupLocalOffset;
            assert (EntryOffset == SrcMgr.SLocEntry.toOffset(offsets[index])) : EntryOffset + " vs. " + SrcMgr.SLocEntry.toOffset(offsets[index]);
        } else if (ID2 == -1) {
            slice = 0;
            offsets = this.LocalSLocEntryTable.$OffsetsSliceByIndex(0);
            index = 0;
            EntryOffset = 0;
            assert (EntryOffset == SrcMgr.SLocEntry.toOffset(offsets[index]));
        } else {
            slice = ID2 / this.LocalSliceSize;
            index = ID2 & this.LocalSliceMaskForIndex;
            offsets = slice == this.LastFileIDLookupLocalSlice ? this.LastFileIDLookupLocalSliceArray : (slice == this.LastMacroIDLookupLocalSlice ? this.LastMacroIDLookupLocalSliceArray : this.LocalSLocEntryTable.$OffsetsSliceByIndex(slice));
            EntryOffset = SrcMgr.SLocEntry.toOffset(offsets[index]);
        }
        if (SLocOffset < EntryOffset) {
            return false;
        }
        int NextID = ID2 + 1;
        assert (NextID <= this.local_sloc_entry_size()) : "Invalid index";
        if (NextID == this.local_sloc_entry_size()) {
            return SLocOffset < this.NextLocalOffset;
        }
        int nextEntryOffset = ++index < this.LocalSliceSize ? offsets[index] : this.LocalSLocEntryTable.$OffsetsSliceByIndex(slice + 1)[0];
        nextEntryOffset = SrcMgr.SLocEntry.toOffset(nextEntryOffset);
        return SLocOffset < nextEntryOffset;
    }

    private int getPreviousFileID(int FID) {
        if (FileID.isInvalid(FID)) {
            return FileID.getInvalidID();
        }
        int ID2 = FID;
        if (ID2 == -1) {
            return FileID.getInvalidID();
        }
        if (ID2 > 0 ? ID2 - 1 == 0 : Unsigned.$greatereq_uint((int)(-(ID2 - 1) - 2), (int)this.LoadedSLocEntryTable.size())) {
            return FileID.getInvalidID();
        }
        return ID2 - 1;
    }

    private int getNextFileID(int FID) {
        if (FileID.isInvalid(FID)) {
            return FileID.getInvalidID();
        }
        int ID2 = FID;
        if (ID2 > 0 ? Unsigned.$greatereq_uint((int)(ID2 + 1), (int)this.local_sloc_entry_size()) : ID2 + 1 >= -1) {
            return FileID.getInvalidID();
        }
        return ID2 + 1;
    }

    private int createFileID(SrcMgr.ContentCache File2, int IncludePos, SrcMgr.CharacteristicKind FileCharacter, int LoadedID, int LoadedOffset) {
        if (LoadedID < 0) {
            assert (LoadedID != -1) : "Loading sentinel FileID";
            int Index = -LoadedID - 2;
            assert (Unsigned.$less_uint((int)Index, (int)this.LoadedSLocEntryTable.size())) : "FileID out of range";
            assert (!this.SLocEntryLoaded.$at(Index)) : "FileID already loaded";
            this.LoadedSLocEntryTable.$setFile(Index, LoadedOffset, IncludePos, File2, FileCharacter);
            this.SLocEntryLoaded.$set(Index, true);
            return LoadedID;
        }
        this.LastFileIDLookup = this.LastFileIDLookupLocalSLocEntryIndex = this.LocalSLocEntryTable.size();
        this.LastFileIDLookupLocalOffset = this.NextLocalOffset;
        this.LocalSLocEntryTable = this.LocalSLocEntryTable.push_back_File(this.NextLocalOffset, IncludePos, File2, FileCharacter);
        int FileSize = File2.getSize();
        assert (Unsigned.$greater_uint((int)(this.NextLocalOffset + FileSize + 1), (int)this.NextLocalOffset) && Unsigned.$lesseq_uint((int)(this.NextLocalOffset + FileSize + 1), (int)this.CurrentLoadedOffset)) : "Ran out of source locations!";
        this.NextLocalOffset += FileSize + 1;
        this.updateLocalSLocConstants();
        int FID = this.LastFileIDLookup;
        return FID;
    }

    public SrcMgr.ContentCache getOrCreateContentCache(FileEntry FileEnt) {
        return this.getOrCreateContentCache(FileEnt, false);
    }

    public SrcMgr.ContentCache getOrCreateContentCache(FileEntry FileEnt, boolean isSystemFile) {
        DenseMapIterator overI;
        assert (FileEnt != null) : "Didn't specify a file entry to use?";
        assert (this.FileInfos.size() + this.MemBufferInfos.size() == this.AllContentCaches.size()) : this.FileInfos.size() + " + " + this.MemBufferInfos.size() + " vs. " + this.AllContentCaches.size();
        std_pair.pair Entry2 = this.FileInfos.FindAndConstruct((Object)FileEnt);
        if (Entry2.second != null) {
            assert (this.getContentCacheByCacheIndex(((SrcMgr.ContentCache)Entry2.second).$index()) == Entry2.second);
            return (SrcMgr.ContentCache)Entry2.second;
        }
        int NextContentCacheIndex = this.AllContentCaches.size();
        Entry2.second = this.OverriddenFilesInfo.$bool() ? ((overI = ((OverriddenFilesInfoTy)this.OverriddenFilesInfo.$arrow()).OverriddenFiles.find((Object)FileEnt)).$eq(((OverriddenFilesInfoTy)this.OverriddenFilesInfo.$arrow()).OverriddenFiles.end()) ? new SrcMgr.ContentCache(NextContentCacheIndex, FileEnt) : new SrcMgr.ContentCache(NextContentCacheIndex, this.OverridenFilesKeepOriginalName ? FileEnt : (FileEntry)overI.$star().second, (FileEntry)overI.$star().second)) : new SrcMgr.ContentCache(NextContentCacheIndex, FileEnt);
        this.AllContentCaches.push_back((Object)((SrcMgr.ContentCache)Entry2.second));
        ((SrcMgr.ContentCache)Entry2.second).IsSystemFile = isSystemFile;
        ((SrcMgr.ContentCache)Entry2.second).IsTransient = this.FilesAreTransient;
        assert (this.getContentCacheByCacheIndex(((SrcMgr.ContentCache)Entry2.second).$index()) == Entry2.second);
        assert (this.FileInfos.size() + this.MemBufferInfos.size() == this.AllContentCaches.size()) : this.FileInfos.size() + " + " + this.MemBufferInfos.size() + " vs. " + this.AllContentCaches.size();
        return (SrcMgr.ContentCache)Entry2.second;
    }

    private SrcMgr.ContentCache createMemBufferContentCache(std_ptr.unique_ptr<MemoryBuffer> Buffer2) {
        assert (this.FileInfos.size() + this.MemBufferInfos.size() == this.AllContentCaches.size()) : this.FileInfos.size() + " + " + this.MemBufferInfos.size() + " vs. " + this.AllContentCaches.size();
        int NextMemoryBufferContextCacheIndex = this.AllContentCaches.size();
        SrcMgr.ContentCache Entry2 = new SrcMgr.ContentCache(NextMemoryBufferContextCacheIndex);
        this.MemBufferInfos.push_back((Object)Entry2);
        this.AllContentCaches.push_back((Object)Entry2);
        Entry2.setBuffer(Buffer2);
        assert (this.getContentCacheByCacheIndex(Entry2.$index()) == Entry2);
        assert (this.FileInfos.size() + this.MemBufferInfos.size() == this.AllContentCaches.size()) : this.FileInfos.size() + " + " + this.MemBufferInfos.size() + " vs. " + this.AllContentCaches.size();
        return Entry2;
    }

    private int getFileIDSlow(int SLocOffset) {
        if (SLocOffset == 0) {
            return FileID.getInvalidID();
        }
        if (Unsigned.$less_uint((int)SLocOffset, (int)this.NextLocalOffset)) {
            return this.getFileIDLocal(SLocOffset);
        }
        return this.getFileIDLoaded(SLocOffset);
    }

    private int getFileIDLocal(int SLocOffset) {
        if (this.LocalSLocTableIsSliced) {
            return this.getFileIDLocalFromSlicedOffsets(SLocOffset);
        }
        return this.getFileIDLocalFromRawOffsets(SLocOffset);
    }

    private int getFileIDLocalFromRawOffsets(int SLocOffset) {
        int I;
        assert (Unsigned.$less_uint((int)SLocOffset, (int)this.NextLocalOffset)) : "Bad function choice";
        assert (SLocOffset >= 0) : "Must be non negative";
        int SLocTableSize = this.local_sloc_entry_size();
        if (this.LastFileIDLookup < 0 || this.LastFileIDLookupLocalOffset < SLocOffset) {
            if (!USE_LAST_MACRO_ID || this.LastMacroIDLookup < 0 || this.LastMacroIDLookupLocalOffset < SLocOffset) {
                I = SLocTableSize;
            } else {
                assert (this.LastMacroIDLookup == this.LastMacroIDLookupLocalSLocEntryIndex) : this.LastMacroIDLookup + " vs. " + this.LastMacroIDLookupLocalSLocEntryIndex;
                assert (this.LastMacroIDLookupLocalOffset == this.LocalSLocEntryTable.offset_$at(this.LastMacroIDLookupLocalSLocEntryIndex));
                I = this.LastMacroIDLookupLocalSLocEntryIndex;
            }
        } else {
            assert (this.LastFileIDLookup == this.LastFileIDLookupLocalSLocEntryIndex) : this.LastFileIDLookup + " vs " + this.LastFileIDLookupLocalSLocEntryIndex;
            assert (this.LastFileIDLookupLocalOffset == this.LocalSLocEntryTable.offset_$at(this.LastFileIDLookupLocalSLocEntryIndex));
            I = USE_LAST_MACRO_ID && this.LastMacroIDLookupLocalOffset < this.LastFileIDLookupLocalOffset && SLocOffset < this.LastMacroIDLookupLocalOffset ? this.LastMacroIDLookupLocalSLocEntryIndex : this.LastFileIDLookupLocalSLocEntryIndex;
        }
        int NumProbes = 0;
        do {
            int Raw_Offset_at_I;
            int Offset_at_I;
            if ((Offset_at_I = SrcMgr.SLocEntry.toOffset(Raw_Offset_at_I = this.LocalSLocEntryTable.rawOffset_$at(--I))) > SLocOffset) continue;
            int Res = I;
            if (SrcMgr.SLocEntry.isNotExpansion(Raw_Offset_at_I)) {
                this.updateLastIDForFileLookup(true, Res, Offset_at_I, 0, null, I);
                this.NumLinearScans += NumProbes + 1;
            } else {
                this.updateLastIDForMacroLookup(true, Res, Offset_at_I, 0, null, I);
                this.NumLinearMacroScans += NumProbes + 1;
            }
            return Res;
        } while (++NumProbes != 8);
        int GreaterIndex = I;
        int LessIndex = 0;
        NumProbes = 0;
        while (true) {
            int MiddleIndex = (GreaterIndex - LessIndex) / 2 + LessIndex;
            int Raw_Offset_at_Mid = this.LocalSLocEntryTable.rawOffset_$at(MiddleIndex);
            int Offset_at_Mid = SrcMgr.SLocEntry.toOffset(Raw_Offset_at_Mid);
            ++NumProbes;
            if (Offset_at_Mid > SLocOffset) {
                GreaterIndex = MiddleIndex;
                continue;
            }
            int FID = MiddleIndex + 1;
            int nextOffset = FID == SLocTableSize ? this.NextLocalOffset : this.LocalSLocEntryTable.offset_$at(FID);
            if (SLocOffset < nextOffset) {
                int Res = MiddleIndex;
                if (SrcMgr.SLocEntry.isNotExpansion(Raw_Offset_at_Mid)) {
                    this.updateLastIDForFileLookup(true, Res, Offset_at_Mid, 0, null, MiddleIndex);
                    this.NumBinaryProbes += NumProbes;
                } else {
                    this.updateLastIDForMacroLookup(true, Res, Offset_at_Mid, 0, null, MiddleIndex);
                    this.NumBinaryMacroProbes += NumProbes;
                }
                return Res;
            }
            LessIndex = MiddleIndex;
        }
    }

    private int getFileIDLocal_UseZeroSlice(int SLocOffset) {
        int I;
        assert (SLocOffset < this.NextLocalOffset) : "Bad function choice";
        assert (SLocOffset >= 0) : "Must be non negative";
        int SLocTableSize = this.local_sloc_entry_size();
        if (this.LastFileIDLookup < 0) {
            I = SLocTableSize;
        } else {
            int offset_$at = this.LocalSLocEntryTable.offset_$at(this.LastFileIDLookup);
            assert (offset_$at != SLocOffset) : "they can not be equal, see getFileID impl";
            I = offset_$at < SLocOffset ? SLocTableSize : this.LastFileIDLookup;
        }
        int[] offsets = this.LocalSLocEntryTable.$OffsetsSliceByIndex(0);
        return this.lookupIndexInOffsetsRangeArrayImpl(SLocOffset, offsets, I, 0, SLocTableSize, 0, true);
    }

    private int getFileIDLocalFromSlicedOffsets(int SLocOffset) {
        int[] $OffsetsSlice;
        int I;
        int Slice_for_I;
        assert (this.LocalSLocTableIsSliced);
        assert (SLocOffset < this.NextLocalOffset) : "Bad function choice";
        assert (SLocOffset >= 0) : "Must be non negative";
        assert (this.LastFileIDLookupLocalSliceArray == this.LocalSLocEntryTable.$OffsetsSliceByIndex(this.LastFileIDLookupLocalSlice));
        assert (this.LastMacroIDLookupLocalSliceArray == this.LocalSLocEntryTable.$OffsetsSliceByIndex(this.LastMacroIDLookupLocalSlice));
        int MaxSlicesIndex = this.LocalMaxSliceIndex;
        assert (this.LocalSLocEntryTable.$OffsetsMaxSliceIndex() == MaxSlicesIndex);
        int sliceSize = this.LocalSliceSize;
        int IndexInSliceMask = this.LocalSliceMaskForIndex;
        assert (this.LastFileIDLookupLocalSliceArray.length == sliceSize);
        int MaxIndex = this.MaxIndexInLastLocalSlice;
        assert (MaxIndex == (this.local_sloc_entry_size - 1 & this.LocalSliceMaskForIndex) + 1);
        if (this.LastFileIDLookup < 0) {
            Slice_for_I = MaxSlicesIndex;
            I = MaxIndex;
            $OffsetsSlice = this.LocalSLocEntryTable.$OffsetsSliceByIndex(Slice_for_I);
        } else {
            assert (this.LastFileIDLookupLocalOffset == this.LastFileIDLookupLocalSliceArray[this.LastFileIDLookupLocalIndexInSlice]);
            assert (this.LastFileIDLookupLocalOffset != SLocOffset) : SLocOffset + " must be checked before getFileIDSlow ";
            assert (this.LastMacroIDLookupLocalOffset != SLocOffset) : SLocOffset + " must be checked before getFileIDSlow ";
            assert (this.LastFileIDLookupLocalOffset == SrcMgr.SLocEntry.toOffset(this.LastFileIDLookupLocalOffset)) : "FileID has te same offset as the raw value";
            if (this.LastFileIDLookupLocalOffset < SLocOffset) {
                if (!USE_LAST_MACRO_ID || this.LastMacroIDLookup < 0 || this.LastMacroIDLookupLocalOffset < SLocOffset) {
                    I = MaxIndex;
                    Slice_for_I = MaxSlicesIndex;
                    $OffsetsSlice = this.LocalSLocEntryTable.$OffsetsSliceByIndex(Slice_for_I);
                } else {
                    Slice_for_I = this.LastMacroIDLookupLocalSlice;
                    I = this.LastMacroIDLookupLocalIndexInSlice;
                    $OffsetsSlice = this.LastMacroIDLookupLocalSliceArray;
                    if (Slice_for_I < MaxSlicesIndex) {
                        MaxIndex = sliceSize;
                    }
                }
            } else {
                if (USE_LAST_MACRO_ID && this.LastMacroIDLookupLocalOffset < this.LastFileIDLookupLocalOffset && SLocOffset < this.LastMacroIDLookupLocalOffset) {
                    Slice_for_I = this.LastMacroIDLookupLocalSlice;
                    I = this.LastMacroIDLookupLocalIndexInSlice;
                    $OffsetsSlice = this.LastMacroIDLookupLocalSliceArray;
                } else {
                    $OffsetsSlice = this.LastFileIDLookupLocalSliceArray;
                    I = this.LastFileIDLookupLocalIndexInSlice;
                    Slice_for_I = this.LastFileIDLookupLocalSlice;
                }
                if (Slice_for_I < MaxSlicesIndex) {
                    MaxIndex = sliceSize;
                }
            }
        }
        int SliceStartAbsoluteIndex = 0;
        assert ((I & IndexInSliceMask) == I || I == sliceSize) : I + " vs " + sliceSize;
        if (Slice_for_I > 0) {
            int NumProbes = 0;
            boolean found = false;
            while (true) {
                if (SrcMgr.SLocEntry.toOffset($OffsetsSlice[0]) <= SLocOffset) {
                    SliceStartAbsoluteIndex = Slice_for_I * sliceSize;
                    if (NumProbes == 0) {
                        ++this.NumImmediateSliceScans;
                    } else {
                        this.NumLinearSliceScans += NumProbes + 1;
                    }
                    found = true;
                    break;
                }
                if (NumProbes++ == 8) break;
                assert (Slice_for_I > 0);
                assert (Slice_for_I <= MaxSlicesIndex);
                $OffsetsSlice = this.LocalSLocEntryTable.$OffsetsSliceByIndex(--Slice_for_I);
                I = sliceSize;
                MaxIndex = sliceSize;
            }
            if (!found) {
                int GreaterSliceIndex = Slice_for_I;
                int LessSliceIndex = 0;
                NumProbes = 0;
                while (true) {
                    assert (GreaterSliceIndex >= 0);
                    assert (LessSliceIndex >= 0);
                    assert (GreaterSliceIndex >= LessSliceIndex);
                    assert (GreaterSliceIndex < MaxSlicesIndex) : GreaterSliceIndex + " vs. " + MaxSlicesIndex;
                    Slice_for_I = (GreaterSliceIndex - LessSliceIndex) / 2 + LessSliceIndex;
                    $OffsetsSlice = this.LocalSLocEntryTable.$OffsetsSliceByIndex(Slice_for_I);
                    int FirstOffset_At_MidSlice = SrcMgr.SLocEntry.toOffset($OffsetsSlice[0]);
                    ++NumProbes;
                    if (FirstOffset_At_MidSlice > SLocOffset) {
                        GreaterSliceIndex = Slice_for_I;
                        continue;
                    }
                    int NextSlice = Slice_for_I + 1;
                    int nextOffset = NextSlice == MaxSlicesIndex ? this.NextLocalOffset : SrcMgr.SLocEntry.toOffset(this.LocalSLocEntryTable.$OffsetsSliceByIndex(NextSlice)[0]);
                    if (SLocOffset < nextOffset) {
                        SliceStartAbsoluteIndex = Slice_for_I * sliceSize;
                        this.NumBinarySliceProbes += NumProbes;
                        break;
                    }
                    LessSliceIndex = Slice_for_I;
                }
                assert (I == sliceSize) : I + " vs. " + sliceSize;
                assert (MaxIndex == sliceSize) : MaxIndex + " vs. " + sliceSize;
            }
        }
        return this.lookupIndexInOffsetsRangeArrayImpl(SLocOffset, $OffsetsSlice, I, Slice_for_I, MaxIndex, SliceStartAbsoluteIndex, true);
    }

    private int lookupIndexInOffsetsRangeArrayImpl(int SLocOffset, int[] offsets, int I, int Slice_for_I, int MaxIndex, int SliceStartAbsoluteIndex, boolean forLocalTable) {
        assert (SrcMgr.SLocEntry.toOffset(offsets[0]) <= SLocOffset);
        assert (MaxIndex <= offsets.length);
        int NumProbes = 0;
        do {
            int Raw_Offset_at_I;
            int Offset_at_I;
            assert (I > 0);
            assert (I <= MaxIndex);
            if ((Offset_at_I = SrcMgr.SLocEntry.toOffset(Raw_Offset_at_I = offsets[--I])) > SLocOffset) continue;
            int Res = I + SliceStartAbsoluteIndex;
            if (SrcMgr.SLocEntry.isNotExpansion(Raw_Offset_at_I)) {
                this.updateLastIDForFileLookup(forLocalTable, Res, Offset_at_I, Slice_for_I, offsets, I);
                this.NumLinearScans += NumProbes + 1;
            } else {
                this.updateLastIDForMacroLookup(forLocalTable, Res, Offset_at_I, Slice_for_I, offsets, I);
                this.NumLinearMacroScans += NumProbes + 1;
            }
            return Res;
        } while (++NumProbes != 8);
        int GreaterIndex = I;
        int LessIndex = 0;
        NumProbes = 0;
        while (true) {
            assert (GreaterIndex >= 0);
            assert (LessIndex >= 0);
            assert (GreaterIndex >= LessIndex);
            assert (GreaterIndex < MaxIndex) : GreaterIndex + " vs. " + MaxIndex;
            int MiddleIndex = (GreaterIndex - LessIndex) / 2 + LessIndex;
            int Raw_Offset_at_Mid = offsets[MiddleIndex];
            int Offset_at_Mid = SrcMgr.SLocEntry.toOffset(Raw_Offset_at_Mid);
            ++NumProbes;
            if (Offset_at_Mid > SLocOffset) {
                GreaterIndex = MiddleIndex;
                continue;
            }
            int FID = MiddleIndex + 1;
            int nextOffset = FID == MaxIndex ? this.NextLocalOffset : SrcMgr.SLocEntry.toOffset(offsets[FID]);
            if (SLocOffset < nextOffset) {
                int Res = MiddleIndex + SliceStartAbsoluteIndex;
                if (SrcMgr.SLocEntry.isNotExpansion(Raw_Offset_at_Mid)) {
                    this.updateLastIDForFileLookup(forLocalTable, Res, Offset_at_Mid, Slice_for_I, offsets, MiddleIndex);
                    this.NumBinaryProbes += NumProbes;
                } else {
                    this.updateLastIDForMacroLookup(forLocalTable, Res, Offset_at_Mid, Slice_for_I, offsets, MiddleIndex);
                    this.NumBinaryMacroProbes += NumProbes;
                }
                return Res;
            }
            LessIndex = MiddleIndex;
        }
    }

    private void updateLastIDForFileLookup(boolean LocalTable, int lastFileID, int lastFileIDOffset, int Slice, int[] sliceArray, int IndexInSlice) {
        this.LastFileIDLookup = lastFileID;
        if (LocalTable) {
            this.LastFileIDLookupLocalSLocEntryIndex = lastFileID;
            this.LastFileIDLookupLocalOffset = lastFileIDOffset;
            this.LastFileIDLookupLocalSlice = Slice;
            this.LastFileIDLookupLocalSliceArray = sliceArray;
            this.LastFileIDLookupLocalIndexInSlice = IndexInSlice;
        } else {
            this.LastFileIDLookupLoadedSlice = Slice;
        }
    }

    private void updateLastIDForMacroLookup(boolean LocalTable, int lastMacroID, int lastMacroIDOffset, int Slice, int[] sliceArray, int IndexInSlice) {
        this.LastMacroIDLookup = lastMacroID;
        if (LocalTable) {
            this.LastMacroIDLookupLocalSLocEntryIndex = lastMacroID;
            this.LastMacroIDLookupLocalOffset = lastMacroIDOffset;
            this.LastMacroIDLookupLocalSlice = Slice;
            this.LastMacroIDLookupLocalSliceArray = sliceArray;
            this.LastMacroIDLookupLocalIndexInSlice = IndexInSlice;
        } else {
            this.LastMacroIDLookupLoadedSlice = Slice;
        }
    }

    private int getFileIDLoaded(int SLocOffset) {
        if (Unsigned.$less_uint((int)SLocOffset, (int)this.CurrentLoadedOffset)) {
            NativeTrace.assertTrueInConsole((boolean)false, (String)"Invalid SLocOffset or bad function choice ", (Object)SLocOffset);
            return FileID.getInvalidID();
        }
        int LastID = this.LastFileIDLookup;
        int I = LastID >= 0 || Unsigned.$less_uint((int)this.$getOffset(this.getLoadedSLocEntryByID(LastID)), (int)SLocOffset) ? 0 : -LastID - 2 + 1;
        assert (I >= 0);
        int NumProbes = 0;
        while (NumProbes < 8) {
            int E = this.getLoadedSLocEntry(I);
            assert (E != 0);
            int Offset_at_I = this.$getOffset(E);
            if (Unsigned.$lesseq_uint((int)Offset_at_I, (int)SLocOffset)) {
                int Res = -I - 2;
                if (this.$isFile(E)) {
                    this.updateLastIDForFileLookup(false, Res, Offset_at_I, 0, null, I);
                    this.NumLinearScans += NumProbes + 1;
                } else {
                    this.updateLastIDForMacroLookup(false, Res, Offset_at_I, 0, null, I);
                    this.NumLinearMacroScans += NumProbes + 1;
                }
                assert (Res < 0) : "Expected negative FileID for loaded: " + Res;
                return Res;
            }
            ++NumProbes;
            ++I;
        }
        int GreaterIndex = I;
        int LessIndex = this.LoadedSLocEntryTable.size();
        NumProbes = 0;
        while (true) {
            ++NumProbes;
            int MiddleIndex = (LessIndex - GreaterIndex) / 2 + GreaterIndex;
            int E = this.getLoadedSLocEntry(MiddleIndex);
            assert (E != 0);
            int Offset_at_I = this.$getOffset(E);
            if (Offset_at_I == 0) {
                return FileID.getInvalidID();
            }
            ++NumProbes;
            if (Offset_at_I > SLocOffset) {
                if (GreaterIndex == MiddleIndex) {
                    assert (false) : "binary search missed the entry";
                    return FileID.getInvalidID();
                }
                GreaterIndex = MiddleIndex;
                continue;
            }
            int Index = -MiddleIndex - 2;
            if (this.isOffsetInFileID(Index, SLocOffset)) {
                int Res = Index;
                if (this.$isFile(E)) {
                    this.updateLastIDForFileLookup(false, Res, Offset_at_I, 0, null, MiddleIndex);
                    this.NumLinearScans += NumProbes + 1;
                } else {
                    this.updateLastIDForMacroLookup(false, Res, Offset_at_I, 0, null, MiddleIndex);
                    this.NumLinearMacroScans += NumProbes + 1;
                }
                assert (Res < 0) : "Expected negative FileID for loaded: " + Res;
                return Res;
            }
            if (LessIndex == MiddleIndex) {
                assert (false) : "binary search missed the entry";
                return FileID.getInvalidID();
            }
            LessIndex = MiddleIndex;
        }
    }

    private int getExpansionLocSlowCase(int Loc) {
        int ExpInfo;
        while (SourceLocation.isMacroID(Loc = this.$getExpansionLocStart(ExpInfo = this.getExpansionSLocEntryByID_LoadEntryIfAbsent(this.getFileID(Loc))))) {
        }
        return Loc;
    }

    private int getSpellingLocSlowCase(int Loc) {
        int Offs;
        do {
            assert (SourceLocation.isMacroID(Loc)) : "Not a macro " + SourceLocation.getFromRawEncoding(Loc);
            int SLocOffset = SourceLocation.getOffset(Loc);
            assert (!this.isOffsetInFileID(this.LastFileIDLookup, SLocOffset)) : "how macro Loc could it be in file? " + this.LastFileIDLookup + ": " + SourceLocation.getFromRawEncoding(Loc);
            int FID = this.isOffsetInFileID(this.LastMacroIDLookup, SLocOffset) ? this.LastMacroIDLookup : this.getFileIDSlow(SLocOffset);
            int Expansion = this.getSLocEntryByID_LoadEntryIfAbsent(FID);
            assert (Expansion != 0);
            assert (this.$isExpansion(Expansion));
            Offs = SLocOffset - this.$getOffset(Expansion);
            Loc = this.$getSpellingLoc(Expansion);
        } while (SourceLocation.isMacroID(Loc = SourceLocation.$getLocWithOffset(Loc, Offs)));
        return Loc;
    }

    private int getFileLocSlowCase(int Loc) {
        while (SourceLocation.isMacroID(Loc = this.isMacroArgExpansion(Loc) ? this.getImmediateSpellingLoc(Loc) : std_pair.$first_int((long)this.getImmediateExpansionRange(Loc)))) {
        }
        return Loc;
    }

    private long getDecomposedExpansionLocSlowCase(int E) {
        int Offset;
        int FID = FileID.getInvalidID();
        int Loc = SourceLocation.getInvalid();
        do {
            Loc = this.$getExpansionLocStart(E);
            FID = this.getFileID(Loc);
            E = Native.$AddrOf((int)this.getSLocEntryByID_LoadEntryIfAbsent(FID));
            Offset = SourceLocation.getOffset(Loc) - this.$getOffset(E);
        } while (SourceLocation.isMacroID(Loc));
        return BasicClangGlobals.wrap_FileID_Offset(FID, Offset);
    }

    private long getDecomposedSpellingLocSlowCase(int SLocEntryIndex, int Offset) {
        int FID = FileID.getInvalidID();
        int Loc = SourceLocation.getInvalid();
        do {
            Loc = this.$getSpellingLoc(SLocEntryIndex);
            Loc = SourceLocation.$getLocWithOffset(Loc, Offset);
            FID = this.getFileID(Loc);
            SLocEntryIndex = Native.$AddrOf((int)this.getSLocEntryByID_LoadEntryIfAbsent(FID));
            Offset = SourceLocation.getOffset(Loc) - this.$getOffset(SLocEntryIndex);
            assert (Offset >= 0);
        } while (!SourceLocation.isFileID(Loc));
        return BasicClangGlobals.wrap_FileID_Offset(FID, Offset);
    }

    private void computeMacroArgsCache(std_map.mapUIntType<SourceLocation> CachePtr, int FID) {
        assert (FileID.isValid(FID));
        assert (CachePtr.empty());
        std_map.mapUIntType MacroArgsCache = (std_map.mapUIntType)Native.$Deref(CachePtr);
        MacroArgsCache.insert(std.make_pair_uint_T((int)0, (Object)new SourceLocation()));
        int ID2 = FID;
        while (!(++ID2 > 0 ? Unsigned.$greatereq_uint((int)ID2, (int)this.local_sloc_entry_size()) : ID2 == -1)) {
            int SLocEntryIndex = this.getSLocEntryByID_LoadEntryIfAbsent(ID2);
            if (SLocEntryIndex == 0) {
                return;
            }
            if (this.$isFile(SLocEntryIndex)) {
                int IncludeLoc = this.$getIncludeLoc(SLocEntryIndex);
                if (SourceLocation.isInvalid(IncludeLoc)) continue;
                if (!this.isInFileID(IncludeLoc, FID)) {
                    return;
                }
                int NumCreatedFIDs = this.$getNumCreatedFIDs(SLocEntryIndex);
                if (NumCreatedFIDs == 0) continue;
                ID2 += NumCreatedFIDs - 1;
                continue;
            }
            int ExpansionLocStart = this.$getExpansionLocStart(SLocEntryIndex);
            if (SourceLocation.isFileID(ExpansionLocStart) && !this.isInFileID(ExpansionLocStart, FID)) {
                return;
            }
            if (!this.$isMacroArgExpansion(SLocEntryIndex)) continue;
            this.associateFileChunkWithMacroArgExp((std_map.mapUIntType<SourceLocation>)MacroArgsCache, FID, this.$getSpellingLoc(SLocEntryIndex), SourceLocation.$getMacroLoc(this.$getOffset(SLocEntryIndex)), this.getFileIDSize(ID2));
        }
        return;
    }

    private void associateFileChunkWithMacroArgExp(std_map.mapUIntType<SourceLocation> MacroArgsCache, int FID, int SpellLoc, int ExpansionLoc, int ExpansionLength) {
        if (!SourceLocation.isFileID(SpellLoc)) {
            int SpellBeginOffs = SourceLocation.getOffset(SpellLoc);
            int SpellEndOffs = SpellBeginOffs + ExpansionLength;
            long decomposedLoc = this.getDecomposedLoc(SpellLoc);
            int SpellFID = BasicClangGlobals.$first_FileID(decomposedLoc);
            int SpellRelativeOffs = BasicClangGlobals.$second_offset(decomposedLoc);
            while (true) {
                int Entry2 = this.getSLocEntryByID_LoadEntryIfAbsent(SpellFID);
                int SpellFIDBeginOffs = this.$getOffset(Entry2);
                int SpellFIDSize = this.getFileIDSize(SpellFID);
                int SpellFIDEndOffs = SpellFIDBeginOffs + SpellFIDSize;
                int Info2 = Entry2;
                if (this.$isMacroArgExpansion(Info2)) {
                    int CurrSpellLength = Unsigned.$less_uint((int)SpellFIDEndOffs, (int)SpellEndOffs) ? SpellFIDSize - SpellRelativeOffs : ExpansionLength;
                    this.associateFileChunkWithMacroArgExp(MacroArgsCache, FID, SourceLocation.$getLocWithOffset(this.$getSpellingLoc(Info2), SpellRelativeOffs), ExpansionLoc, CurrSpellLength);
                }
                if (Unsigned.$greatereq_uint((int)SpellFIDEndOffs, (int)SpellEndOffs)) {
                    return;
                }
                int advance = SpellFIDSize - SpellRelativeOffs + 1;
                ExpansionLoc = SourceLocation.$getLocWithOffset(ExpansionLoc, advance);
                ExpansionLength -= advance;
                ++SpellFID;
                SpellRelativeOffs = 0;
            }
        }
        assert (SourceLocation.isFileID(SpellLoc));
        uint.ptr BeginOffsRef = NativePointer.create_uint$ptr();
        if (!this.isInFileID(SpellLoc, FID, (uint.ptr)Native.$AddrOf((Object)BeginOffsRef))) {
            return;
        }
        int BeginOffs = BeginOffsRef.$star();
        int EndOffs = BeginOffs + ExpansionLength;
        StdMapUIntType.iterator I = MacroArgsCache.upper_bound(Integer.valueOf(EndOffs));
        I.$preDec();
        SourceLocation EndOffsMappedLoc = (SourceLocation)I.$arrow().second;
        ((SourceLocation)MacroArgsCache.ref$at(Integer.valueOf(BeginOffs)).$deref()).$assign(ExpansionLoc);
        ((SourceLocation)MacroArgsCache.ref$at(Integer.valueOf(EndOffs)).$deref()).$assign(EndOffsMappedLoc);
    }

    public char.ptr.array $CharacterDataPtr() {
        assert (!this.$CharacterDataPtrInUse);
        if (!$assertionsDisabled) {
            this.$CharacterDataPtrInUse = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        return this.$CharacterDataPtr;
    }

    public void $releaseCharacterDataPtr(char.ptr.array Ptr2) {
        assert (Ptr2 == this.$CharacterDataPtr);
        assert (this.$CharacterDataPtrInUse);
        if (!$assertionsDisabled) {
            this.$CharacterDataPtrInUse = false;
            if (!false) {
                // empty if block
            }
        }
        NativePointer.clear_char$ptr$array((char.ptr.array)Ptr2);
    }

    public int.ptr $getOffsetPtr() {
        assert (!this.$OffsetPtrInUse);
        if (!$assertionsDisabled) {
            this.$OffsetPtrInUse = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        return this.$OffsetPtr;
    }

    public void $releaseOffsetPtr(int.ptr Ptr2) {
        assert (Ptr2 == this.$OffsetPtr);
        assert (this.$OffsetPtrInUse);
        if (!$assertionsDisabled) {
            this.$OffsetPtrInUse = false;
            if (!false) {
                // empty if block
            }
        }
    }

    public String toString() {
        return ", ContentCacheAlloc=" + this.ContentCacheAlloc + ", FileInfos=" + this.FileInfos + ", OverridenFilesKeepOriginalName=" + this.OverridenFilesKeepOriginalName + ", UserFilesAreVolatile=" + this.UserFilesAreVolatile + ", FilesAreTransient=" + this.FilesAreTransient + ", OverriddenFilesInfo=" + this.OverriddenFilesInfo + ", MemBufferInfos=" + this.MemBufferInfos + ", LocalSLocEntryTable=" + this.LocalSLocEntryTable + ", LoadedSLocEntryTable=" + this.LoadedSLocEntryTable + ", NextLocalOffset=" + this.NextLocalOffset + ", CurrentLoadedOffset=" + this.CurrentLoadedOffset + ", SLocEntryLoaded=" + this.SLocEntryLoaded + ", ExternalSLocEntries=" + this.ExternalSLocEntries + ", LastFileIDLookup=" + this.LastFileIDLookup + ", LineTable=" + this.LineTable + ", LastLineNoFileIDQuery=" + this.LastLineNoFileIDQuery + ", LastLineNoContentCache=" + this.LastLineNoContentCache + ", LastLineNoFilePos=" + this.LastLineNoFilePos + ", LastLineNoResult=" + this.LastLineNoResult + ", MainFileID=" + this.MainFileID + ", PreambleFileID=" + this.PreambleFileID + ", NumLinearScans=" + this.NumLinearScans + ", NumBinaryProbes=" + this.NumBinaryProbes + ", IncludedLocMap=" + this.IncludedLocMap + ", IBTUCache=" + (Object)((Object)this.IBTUCache) + ", IBTUCacheOverflow=" + this.IBTUCacheOverflow + ", FakeBufferForRecovery=" + this.FakeBufferForRecovery + ", FakeContentCacheForRecovery=" + this.FakeContentCacheForRecovery + ", MacroArgsCacheMap=" + this.MacroArgsCacheMap + ", StoredModuleBuildStack=" + this.StoredModuleBuildStack + super.toString();
    }

    @FunctionalInterface
    private static interface DumpSLocEntry {
        public void $call(int var1, SrcMgr.SLocEntry var2, ADTAliases.OptionalUInt var3);
    }

    public static class MemoryBufferSizes {
        public int malloc_bytes;
        public int mmap_bytes;

        public MemoryBufferSizes(int malloc_bytes, int mmap_bytes) {
            this.malloc_bytes = malloc_bytes;
            this.mmap_bytes = mmap_bytes;
        }

        public MemoryBufferSizes(JavaDifferentiators.JD.Move _dparam, MemoryBufferSizes $Prm0) {
            this.malloc_bytes = $Prm0.malloc_bytes;
            this.mmap_bytes = $Prm0.mmap_bytes;
        }

        public String toString() {
            return "malloc_bytes=" + this.malloc_bytes + ", mmap_bytes=" + this.mmap_bytes;
        }
    }

    public final class InBeforeInTUCache
    extends DenseMapULongType<InBeforeInTUCacheEntry> {
        public InBeforeInTUCache() {
            super((DenseMapInfoULong)new DenseMapInfoIsBeforeInTUCacheKey(), (Object)new InBeforeInTUCacheEntry());
        }
    }

    private static final class DenseMapInfoIsBeforeInTUCacheKey
    extends DenseMapInfoULong {
        private static final long emptyKey = std_pair.wrap_int_int_pair((int)FileID.getInvalidID(), (int)FileID.getInvalidID());
        private static final long tombstoneKey = std_pair.wrap_int_int_pair((int)FileID.getSentinelID(), (int)FileID.getSentinelID());

        public DenseMapInfoIsBeforeInTUCacheKey() {
            super(emptyKey, tombstoneKey);
        }

        public int getHashValue(long key) {
            assert (key != emptyKey) : "must not be called for emptyKey";
            assert (key != tombstoneKey) : "must not be called for tombstoneKey";
            key += key << 32 ^ 0xFFFFFFFFFFFFFFFFL;
            key ^= key >>> 22;
            key += key << 13 ^ 0xFFFFFFFFFFFFFFFFL;
            key ^= key >>> 8;
            key += key << 3;
            key ^= key >>> 15;
            key += key << 27 ^ 0xFFFFFFFFFFFFFFFFL;
            key ^= key >>> 31;
            return (int)key;
        }
    }

    private static class OverriddenFilesInfoTy
    implements Destructors.ClassWithDestructor {
        public DenseMap<FileEntry, FileEntry> OverriddenFiles = new DenseMap(FileEntry.DMI$FileEntryPtr, null);
        public DenseSet<FileEntry> OverriddenFilesWithBuffer = new DenseSet(FileEntry.DMI$FileEntryPtr);

        public void $destroy() {
            this.OverriddenFilesWithBuffer.$destroy();
            this.OverriddenFiles.$destroy();
        }

        public String toString() {
            return "OverriddenFiles=" + this.OverriddenFiles + ", OverriddenFilesWithBuffer=" + this.OverriddenFilesWithBuffer;
        }
    }
}

