/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic;

import org.clang.basic.CharSourceRange;
import org.clang.basic.Diagnostic;
import org.clang.basic.DiagnosticBuilder;
import org.clang.basic.DiagnosticsEngine;
import org.clang.basic.FixItHint;
import org.clang.basic.IdentifierInfo;
import org.clang.basic.SourceRange;
import org.clang.basic.declcontext.DeclContextImplementation;
import org.clang.basic.java.diagJava;
import org.clank.java.std;
import org.clank.support.Casts;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativeMoveable;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.support.CrashRecoveryContext;

public class PartialDiagnostic
implements NativeMoveable<PartialDiagnostic>,
NativeCloneable<PartialDiagnostic>,
Destructors.ClassWithDestructor {
    public static final int MaxArguments = 10;
    private int DiagID;
    private Storage DiagStorage;
    private StorageAllocator Allocator;

    private Storage getStorage() {
        if (this.DiagStorage != null) {
            return this.DiagStorage;
        }
        if (this.Allocator != null) {
            assert (this.Allocator != StorageAllocator.JAVA_UNUSED_ALLOC);
            this.DiagStorage = this.Allocator.Allocate();
        } else {
            assert (this.Allocator != StorageAllocator.JAVA_UNUSED_ALLOC);
            this.DiagStorage = new Storage();
        }
        return this.DiagStorage;
    }

    private void freeStorage() {
        if (this.DiagStorage == null) {
            return;
        }
        this.freeStorageSlow();
    }

    private void freeStorageSlow() {
        if (this.Allocator != StorageAllocator.JAVA_UNUSED_ALLOC) {
            if (this.Allocator != null) {
                this.Allocator.Deallocate(this.DiagStorage);
            } else if (this.DiagStorage != null) {
                this.DiagStorage.$destroy();
            }
        }
        this.DiagStorage = null;
    }

    private void AddSourceRange(CharSourceRange R) {
        if (this.DiagStorage == null) {
            this.DiagStorage = this.getStorage();
        }
        this.DiagStorage.DiagRanges.push_back((Object)R);
    }

    private void AddFixItHint(FixItHint Hint) {
        if (Hint.isNull()) {
            return;
        }
        if (this.DiagStorage == null) {
            this.DiagStorage = this.getStorage();
        }
        this.DiagStorage.FixItHints.push_back((Object)Hint);
    }

    public PartialDiagnostic(NullDiagnostic $Prm0) {
        this.DiagID = 0;
        this.DiagStorage = null;
        this.Allocator = null;
    }

    public PartialDiagnostic(int DiagID, StorageAllocator Allocator2) {
        this.DiagID = DiagID;
        this.DiagStorage = null;
        this.Allocator = (StorageAllocator)Native.$AddrOf((Object)Allocator2);
    }

    public PartialDiagnostic(PartialDiagnostic Other) {
        this.DiagID = Other.DiagID;
        this.DiagStorage = null;
        this.Allocator = Other.Allocator;
        if (Other.DiagStorage != null) {
            this.DiagStorage = this.getStorage();
            this.DiagStorage.$assign((Storage)Native.$Deref((Object)Other.DiagStorage));
        }
    }

    public PartialDiagnostic(JavaDifferentiators.JD.Move _dparam, PartialDiagnostic Other) {
        this.DiagID = Other.DiagID;
        this.DiagStorage = Other.DiagStorage;
        this.Allocator = Other.Allocator;
        Other.DiagStorage = null;
    }

    public PartialDiagnostic(PartialDiagnostic Other, Storage DiagStorage) {
        this.DiagID = Other.DiagID;
        this.DiagStorage = DiagStorage;
        this.Allocator = StorageAllocator.JAVA_UNUSED_ALLOC;
        if (Other.DiagStorage != null) {
            this.DiagStorage.$assign((Storage)Native.$Deref((Object)Other.DiagStorage));
        }
    }

    public PartialDiagnostic(Diagnostic Other, StorageAllocator Allocator2) {
        int I;
        this.DiagID = Other.getID();
        this.DiagStorage = null;
        this.Allocator = (StorageAllocator)Native.$AddrOf((Object)Allocator2);
        int N = Other.getNumArgs();
        for (I = 0; I != N; ++I) {
            if (Other.getArgKind(I) == DiagnosticsEngine.ArgumentKind.ak_std_string) {
                this.AddString(new StringRef(Other.getArgStdStr(I)));
                continue;
            }
            this.AddTaggedVal(Other.getRawArg(I), Other.getArgKind(I));
        }
        N = Other.getNumRanges();
        for (I = 0; I != N; ++I) {
            this.AddSourceRange(Other.getRange(I));
        }
        N = Other.getNumFixItHints();
        for (I = 0; I != N; ++I) {
            this.AddFixItHint(Other.getFixItHint(I));
        }
    }

    public PartialDiagnostic $assign(PartialDiagnostic Other) {
        this.DiagID = Other.DiagID;
        if (Other.DiagStorage != null) {
            if (this.DiagStorage == null) {
                this.DiagStorage = this.getStorage();
            }
            this.DiagStorage.$assign((Storage)Native.$Deref((Object)Other.DiagStorage));
        } else {
            this.freeStorage();
        }
        return this;
    }

    public PartialDiagnostic $assignMove(PartialDiagnostic Other) {
        this.freeStorage();
        this.DiagID = Other.DiagID;
        this.DiagStorage = Other.DiagStorage;
        this.Allocator = Other.Allocator;
        Other.DiagStorage = null;
        return this;
    }

    public void $destroy() {
        this.freeStorage();
    }

    public void swap(PartialDiagnostic PD) {
        int DiagIDPrev = this.DiagID;
        this.DiagID = PD.DiagID;
        PD.DiagID = DiagIDPrev;
        Storage DiagStoragePrev = this.DiagStorage;
        this.DiagStorage = PD.DiagStorage;
        PD.DiagStorage = DiagStoragePrev;
        StorageAllocator AllocatorPrev = this.Allocator;
        this.Allocator = PD.Allocator;
        PD.Allocator = AllocatorPrev;
    }

    public int getDiagID() {
        return this.DiagID;
    }

    public void AddTaggedVal(Object V, DiagnosticsEngine.ArgumentKind Kind2) {
        if (this.DiagStorage == null) {
            this.DiagStorage = this.getStorage();
        }
        assert (Unsigned.$uchar2int((byte)this.DiagStorage.NumDiagArgs) < 10) : "Too many arguments to diagnostic!";
        this.DiagStorage.DiagArgumentsKind[this.DiagStorage.NumDiagArgs] = Kind2;
        byte by = this.DiagStorage.NumDiagArgs;
        this.DiagStorage.NumDiagArgs = (byte)(by + 1);
        this.DiagStorage.DiagArgumentsVal[by] = V;
    }

    public void AddString(StringRef V) {
        if (this.DiagStorage == null) {
            this.DiagStorage = this.getStorage();
        }
        assert (Unsigned.$uchar2int((byte)this.DiagStorage.NumDiagArgs) < 10) : "Too many arguments to diagnostic!";
        this.DiagStorage.DiagArgumentsKind[this.DiagStorage.NumDiagArgs] = DiagnosticsEngine.ArgumentKind.ak_std_string;
        byte by = this.DiagStorage.NumDiagArgs;
        this.DiagStorage.NumDiagArgs = (byte)(by + 1);
        this.DiagStorage.DiagArgumentsStr[by].$assignMove(V.$string());
    }

    public void Emit(DiagnosticBuilder DB) {
        if (this.DiagStorage == null) {
            return;
        }
        int e = Unsigned.$uchar2uint((byte)this.DiagStorage.NumDiagArgs);
        for (int i = 0; i != e; ++i) {
            if (this.DiagStorage.DiagArgumentsKind[i] == DiagnosticsEngine.ArgumentKind.ak_std_string) {
                DB.AddString(new StringRef(this.DiagStorage.DiagArgumentsStr[i]));
                continue;
            }
            DB.AddTaggedVal(this.DiagStorage.DiagArgumentsVal[i], this.DiagStorage.DiagArgumentsKind[i]);
        }
        for (CharSourceRange Range : this.DiagStorage.DiagRanges) {
            DB.AddSourceRange(Range);
        }
        for (FixItHint Fix : this.DiagStorage.FixItHints) {
            DB.AddFixItHint(Fix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void EmitToString(DiagnosticsEngine Diags, SmallString Buf) {
        DiagnosticBuilder DB = null;
        try {
            DB = Diags.Report(this.getDiagID());
            this.Emit(DB);
            DB.FlushCounts();
            new Diagnostic((DiagnosticsEngine)((Object)Native.$AddrOf((Object)((Object)Diags)))).FormatDiagnostic(Buf);
            DB.Clear();
            Diags.Clear();
        }
        finally {
            if (DB != null) {
                DB.$destroy();
            }
        }
    }

    public void Reset() {
        this.Reset(0);
    }

    public void Reset(int DiagID) {
        this.DiagID = DiagID;
        this.freeStorage();
    }

    public boolean hasStorage() {
        return this.DiagStorage != null;
    }

    public static PartialDiagnostic $out_PartialDiagnostic$C_uint(PartialDiagnostic PD, int I) {
        PD.AddTaggedVal(I, DiagnosticsEngine.ArgumentKind.ak_uint);
        return PD;
    }

    public static PartialDiagnostic $out_PartialDiagnostic$C_int(PartialDiagnostic PD, int I) {
        PD.AddTaggedVal(I, DiagnosticsEngine.ArgumentKind.ak_sint);
        return PD;
    }

    public static PartialDiagnostic $out_PartialDiagnostic$C_char$ptr$C(PartialDiagnostic PD, char.ptr S) {
        PD.AddTaggedVal(Casts.reinterpret_cast_Object((Object)S), DiagnosticsEngine.ArgumentKind.ak_c_string);
        return PD;
    }

    public static PartialDiagnostic $out_PartialDiagnostic$C_StringRef(PartialDiagnostic PD, StringRef S) {
        PD.AddString(new StringRef(S));
        return PD;
    }

    public static PartialDiagnostic $out_PartialDiagnostic$C_IdentifierInfo$C$P(PartialDiagnostic PD, IdentifierInfo II) {
        PD.AddTaggedVal(Casts.reinterpret_cast_Object((Object)((Object)II)), DiagnosticsEngine.ArgumentKind.ak_identifierinfo);
        return PD;
    }

    public static PartialDiagnostic $out$Same2DeclContext(PartialDiagnostic PD, DeclContextImplementation DC) {
        PD.AddTaggedVal(Casts.reinterpret_cast_Object((Object)DC), DiagnosticsEngine.ArgumentKind.ak_declcontext);
        return PD;
    }

    public static PartialDiagnostic $out_PartialDiagnostic$C_SourceRange(PartialDiagnostic PD, SourceRange R) {
        PD.AddSourceRange(CharSourceRange.getTokenRange(R));
        return PD;
    }

    public static PartialDiagnostic $out_PartialDiagnostic$C_CharSourceRange$C(PartialDiagnostic PD, CharSourceRange R) {
        PD.AddSourceRange(R);
        return PD;
    }

    public static PartialDiagnostic $out_PartialDiagnostic$C_FixItHint$C(PartialDiagnostic PD, FixItHint Hint) {
        PD.AddFixItHint(Hint);
        return PD;
    }

    public PartialDiagnostic clone() {
        return new PartialDiagnostic(this);
    }

    public PartialDiagnostic move() {
        return new PartialDiagnostic(JavaDifferentiators.JD.Move.INSTANCE, this);
    }

    public void $MemoryCopy(PartialDiagnostic Other) {
        this.DiagID = Other.DiagID;
        this.DiagStorage = Other.DiagStorage;
        this.Allocator = Other.Allocator;
    }

    public String toString() {
        return "DiagID=[" + diagJava.$name(this.DiagID) + "]" + this.DiagID + ", DiagStorage=" + this.DiagStorage + ", Allocator=" + this.Allocator;
    }

    public static class NullDiagnostic {
        public NullDiagnostic(JavaDifferentiators.JD.Move _dparam, NullDiagnostic $Prm0) {
        }

        public NullDiagnostic() {
        }

        public void $destroy() {
        }

        public String toString() {
            return "";
        }
    }

    public static class StorageAllocator
    implements Destructors.ClassWithDestructor {
        private static final int NumCached = 16;
        private Storage[] Cached;
        private Storage[] FreeList;
        private int NumFreeListEntries;
        private static final StorageAllocator JAVA_UNUSED_ALLOC = new StorageAllocator(JavaDifferentiators.JD.Misc.INSTANCE);

        public StorageAllocator() {
            this.Cached = (Storage[])NativePointer.new$T((Object[])new Storage[16], () -> new Storage());
            this.FreeList = new Storage[16];
            for (int I = 0; I != 16; ++I) {
                this.FreeList[I] = this.Cached[I];
            }
            this.NumFreeListEntries = 16;
        }

        public void $destroy() {
            assert (CrashRecoveryContext.isRecoveringFromCrash() || this.checkAllStoragesReleased()) : "A partial is on the lamb: " + this.NumFreeListEntries + " vs. " + 16;
            Destructors.$destroyArray((Object)this.Cached);
        }

        public Storage Allocate() {
            if (this.NumFreeListEntries == 0) {
                return new Storage();
            }
            Storage Result = this.FreeList[--this.NumFreeListEntries];
            Result.NumDiagArgs = Unsigned.$int2uchar((int)0);
            Result.DiagRanges.clear();
            Result.FixItHints.clear();
            std.memset((type.ptr)NativePointer.create_type$ptr((Object[])Result.DiagArgumentsVal), null, (int)Result.DiagArgumentsVal.length);
            assert (this.markCachedStorageAllocate(Result));
            return Result;
        }

        public void Deallocate(Storage S) {
            for (Storage storage : this.Cached) {
                if (storage != S) continue;
                assert (this.markCachedStorageDeallocate(S));
                this.FreeList[this.NumFreeListEntries++] = S;
                return;
            }
            if (S != null) {
                S.$destroy();
            }
        }

        private StorageAllocator(JavaDifferentiators.JD.Misc _param) {
        }

        private boolean markCachedStorageAllocate(Storage s) {
            if (NativeTrace.CHECK_STD_PTR_ACCESS_DESTROYED) {
                s.DebugAllocStack = new Exception("Not released [" + (this.NumFreeListEntries + 1) + "] Storage from Cache");
            }
            return true;
        }

        private boolean markCachedStorageDeallocate(Storage s) {
            s.DebugAllocStack = null;
            return true;
        }

        private boolean checkAllStoragesReleased() {
            boolean allFreed;
            boolean bl = allFreed = this.NumFreeListEntries == 16;
            assert (allFreed) : "not all storages were released: " + this.NumFreeListEntries + " vs. " + 16;
            if (NativeTrace.CHECK_STD_PTR_ACCESS_DESTROYED) {
                block0: for (int i = 0; i < this.Cached.length; ++i) {
                    Storage storage = this.Cached[i];
                    for (int j = 0; j < this.NumFreeListEntries; ++j) {
                        if (storage != this.FreeList[j]) continue;
                        if (storage.DebugAllocStack == null) continue block0;
                        NativeTrace.printStackTraceOnce((Throwable)storage.DebugAllocStack);
                        assert (false) : "how could it be storage in free list but with alloc stack?";
                        continue block0;
                    }
                    assert (storage.DebugAllocStack != null) : "how could it be storage not found in free list but without alloc stack?";
                    NativeTrace.printStackTraceOnce((Throwable)storage.DebugAllocStack);
                }
            }
            return allFreed;
        }

        public String toString() {
            return "Cached=" + this.Cached + ", FreeList=" + this.FreeList + ", NumFreeListEntries=" + this.NumFreeListEntries;
        }
    }

    public static class Storage
    implements Destructors.ClassWithDestructor {
        public static final int MaxArguments = 10;
        public byte NumDiagArgs = 0;
        public DiagnosticsEngine.ArgumentKind[] DiagArgumentsKind = (DiagnosticsEngine.ArgumentKind[])NativePointer.new$T((Object[])new DiagnosticsEngine.ArgumentKind[10], () -> DiagnosticsEngine.ArgumentKind.ak_std_string);
        public Object[] DiagArgumentsVal = new Object[10];
        public std.string[] DiagArgumentsStr = (std.string[])NativePointer.new$T((Object[])new std.string[10], () -> new std.string());
        public SmallVector<CharSourceRange> DiagRanges = new SmallVector(8, (Object)new CharSourceRange());
        public SmallVector<FixItHint> FixItHints = new SmallVector(6, (Object)new FixItHint());
        private Exception DebugAllocStack;

        public Storage $assign(Storage $Prm0) {
            this.NumDiagArgs = $Prm0.NumDiagArgs;
            std.__builtin_memcpy((Object[])((DiagnosticsEngine.ArgumentKind[])Native.$AddrOf((Object)this.DiagArgumentsKind)), (Object[])((DiagnosticsEngine.ArgumentKind[])Native.$AddrOf((Object)$Prm0.DiagArgumentsKind)), (boolean)true);
            std.__builtin_memcpy((Object[])((Object[])Native.$AddrOf((Object)this.DiagArgumentsVal)), (Object[])((Object[])Native.$AddrOf((Object)$Prm0.DiagArgumentsVal)), (boolean)true);
            for (int __i0 = 0; __i0 != $Prm0.DiagArgumentsStr.length; ++__i0) {
                this.DiagArgumentsStr[__i0].$assign($Prm0.DiagArgumentsStr[__i0]);
            }
            this.DiagRanges.$assign($Prm0.DiagRanges);
            this.FixItHints.$assign($Prm0.FixItHints);
            return this;
        }

        public void $destroy() {
        }

        public String toString() {
            return "NumDiagArgs=" + this.NumDiagArgs + ", DiagArgumentsKind=" + this.DiagArgumentsKind + ", DiagArgumentsVal=" + this.DiagArgumentsVal + ", DiagArgumentsStr=" + this.DiagArgumentsStr + ", DiagRanges=" + this.DiagRanges + ", FixItHints=" + this.FixItHints;
        }
    }
}

