/*
 * Decompiled with CFR 0.152.
 */
package fleet.frontend.filetree;

import androidx.compose.runtime.Composable;
import fleet.api.FileAddress;
import fleet.common.fs.FsdKt;
import fleet.common.fs.RelativePath;
import fleet.compose.theme.components.ContextMenuKt;
import fleet.compose.theme.components.MenuItem;
import fleet.frontend.clipboard.FileClipboardActionsKt;
import fleet.frontend.filetree.WorkspaceTreeActionId;
import fleet.frontend.filetree.WorkspaceTreeActionIds;
import fleet.frontend.filetree.WorkspaceTreeKt;
import fleet.frontend.filetree.fsentry.internal.FSDKt;
import fleet.frontend.filetree.fsentry.internal.FSDirectory;
import fleet.frontend.filetree.fsentry.internal.FSEntry;
import fleet.frontend.navigation.NavigationActionId;
import fleet.frontend.places.SearchViewKeys;
import fleet.frontend.ui.components.ContextMenuUtilsKt;
import fleet.frontend.ui.gotoPanel.FindInPathKt;
import fleet.frontend.ui.gotoPanel.RevealInGotoProviderKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import noria.ReadScope;
import noria.model.Action;
import noria.model.ActionContext;
import noria.model.CommonTrigger;
import noria.model.FleetActionIds;
import noria.model.FocusDataKey;
import noria.model.Trigger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J'\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0001\u00a2\u0006\u0002\b\u000bJ\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004*\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0007J\u001e\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0003J\"\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004*\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0007J$\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004*\u00020\u00062\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\t\u001a\u00020\nH\u0007J\u0014\u0010\u0016\u001a\u00020\u0017*\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0003\u00a8\u0006\u0018"}, d2={"Lfleet/frontend/filetree/WorkspaceTreeActions;", "", "()V", "addRemoveFolderMenuItems", "", "Lfleet/compose/theme/components/MenuItem;", "Lnoria/ReadScope;", "isRoot", "", "actionContext", "Lnoria/model/ActionContext;", "addRemoveFolderMenuItems$fleet_filetree_frontend", "copyPasteContextMenuItems", "findInFiles", "Lfleet/compose/theme/components/MenuItem$Action;", "relativePath", "", "modificationContextMenuItems", "newContextMenuItems", "openContextMenuItems", "entry", "Lfleet/frontend/filetree/fsentry/internal/FSEntry;", "showInGroup", "Lfleet/compose/theme/components/MenuItem$Group;", "fleet.filetree.frontend"})
@SourceDebugExtension(value={"SMAP\nWorkspaceTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkspaceTree.kt\nfleet/frontend/filetree/WorkspaceTreeActions\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,1262:1\n1#2:1263\n766#3:1264\n857#3,2:1265\n1549#3:1267\n1620#3,3:1268\n37#4,2:1271\n*S KotlinDebug\n*F\n+ 1 WorkspaceTree.kt\nfleet/frontend/filetree/WorkspaceTreeActions\n*L\n147#1:1264\n147#1:1265,2\n149#1:1267\n149#1:1268,3\n149#1:1271,2\n*E\n"})
public final class WorkspaceTreeActions {
    @NotNull
    public static final WorkspaceTreeActions INSTANCE = new WorkspaceTreeActions();

    private WorkspaceTreeActions() {
    }

    @Composable
    @NotNull
    public final List<MenuItem> newContextMenuItems(@NotNull ReadScope $this$newContextMenuItems, @NotNull ActionContext actionContext2) {
        Intrinsics.checkNotNullParameter((Object)$this$newContextMenuItems, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)actionContext2, (String)"actionContext");
        Object[] objectArray = new MenuItem.Action[]{ContextMenuUtilsKt.ActionMenuItem$default((ReadScope)$this$newContextMenuItems, (Trigger)((Trigger)CommonTrigger.NewFile), (ActionContext)actionContext2, null, null, (boolean)false, (boolean)false, null, (boolean)false, (int)252, null), ContextMenuUtilsKt.ActionMenuItem$default((ReadScope)$this$newContextMenuItems, (Trigger)((Trigger)CommonTrigger.NewFolder), (ActionContext)actionContext2, null, null, (boolean)false, (boolean)false, null, (boolean)false, (int)252, null)};
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    /*
     * WARNING - void declaration
     */
    @Composable
    @NotNull
    public final List<MenuItem> openContextMenuItems(@NotNull ReadScope $this$openContextMenuItems, @Nullable FSEntry entry, @NotNull ActionContext actionContext2) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$openContextMenuItems, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)actionContext2, (String)"actionContext");
        if (entry instanceof FSDirectory) {
            MenuItem.Action action;
            Object[] objectArray;
            RelativePath relativePath = FsdKt.relativePath$default((FileAddress)FSDKt.fileAddress(entry), (boolean)false, (boolean)true, (boolean)false, (int)10, null);
            String pathString = relativePath != null ? RelativePath.joinToString$default((RelativePath)relativePath, (boolean)false, (int)1, null) : null;
            Object[] objectArray2 = objectArray = new MenuItem[2];
            int n = 0;
            String string = pathString;
            if (string != null) {
                void it;
                String string2 = string;
                int n2 = n;
                Object[] objectArray3 = objectArray2;
                boolean bl = false;
                MenuItem.Action action2 = INSTANCE.findInFiles($this$openContextMenuItems, (String)it, actionContext2);
                objectArray2 = objectArray3;
                n = n2;
                action = action2;
            } else {
                action = null;
            }
            objectArray2[n] = action;
            objectArray[1] = this.showInGroup($this$openContextMenuItems, actionContext2);
            list = CollectionsKt.listOfNotNull((Object[])objectArray);
        } else {
            Object[] objectArray = new MenuItem[]{ContextMenuUtilsKt.ActionMenuItem$default((ReadScope)$this$openContextMenuItems, (Trigger)((Trigger)NavigationActionId.NavigateInSplit.getId()), (ActionContext)actionContext2, (String)"Open in Split", null, (boolean)false, (boolean)false, null, (boolean)false, (int)248, null), this.showInGroup($this$openContextMenuItems, actionContext2)};
            list = CollectionsKt.listOfNotNull((Object[])objectArray);
        }
        return list;
    }

    @Composable
    private final MenuItem.Action findInFiles(ReadScope $this$findInFiles, String relativePath, ActionContext actionContext2) {
        return ContextMenuKt.ActionMenuItem$default((ReadScope)$this$findInFiles, (Action)FindInPathKt.getFindInFilesAction(), (ActionContext)actionContext2.put(SearchViewKeys.INSTANCE.getPath(), (Object)relativePath), null, null, (boolean)false, (boolean)false, null, (boolean)false, (int)252, null);
    }

    /*
     * WARNING - void declaration
     */
    @Composable
    private final MenuItem.Group showInGroup(ReadScope $this$showInGroup, ActionContext actionContext2) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        Triple it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable iterable = RevealInGotoProviderKt.collectRevealInActions((ActionContext)actionContext2);
        String string = "Open In";
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Triple)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)((Action)it.getFirst()).getIdentifier(), (Object)WorkspaceTreeActionId.ShowInFiles.getId()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Triple)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = (String)it.getThird();
            collection.add(ContextMenuKt.ActionMenuItem$default((ReadScope)$this$showInGroup, (Action)((Action)it.getFirst()), (ActionContext)actionContext2, (String)string2, null, (boolean)false, (boolean)false, null, (boolean)false, (int)248, null));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        MenuItem.Action[] actionArray = thisCollection$iv.toArray(new MenuItem.Action[0]);
        MenuItem[] menuItemArray = (MenuItem[])Arrays.copyOf(actionArray, actionArray.length);
        String string3 = string;
        return new MenuItem.Group(string3, menuItemArray);
    }

    @Composable
    @NotNull
    public final List<MenuItem> addRemoveFolderMenuItems$fleet_filetree_frontend(@NotNull ReadScope $this$addRemoveFolderMenuItems, boolean isRoot, @NotNull ActionContext actionContext2) {
        MenuItem.Action action;
        Intrinsics.checkNotNullParameter((Object)$this$addRemoveFolderMenuItems, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)actionContext2, (String)"actionContext");
        boolean inEmptySpace = actionContext2.get((FocusDataKey)WorkspaceTreeKt.access$getIN_EMPTY_SPACE$p()) != null;
        Object[] objectArray = new MenuItem.Action[2];
        MenuItem.Action action2 = action = ContextMenuUtilsKt.ActionMenuItem$default((ReadScope)$this$addRemoveFolderMenuItems, (Trigger)((Trigger)FleetActionIds.AddFolderToWorkspace.getId()), (ActionContext)actionContext2, null, null, (boolean)false, (boolean)false, null, (boolean)false, (int)252, null);
        int n = 0;
        Object[] objectArray2 = objectArray;
        boolean bl = false;
        boolean bl2 = isRoot || inEmptySpace;
        objectArray2[n] = bl2 ? action : null;
        MenuItem.Action it = action = ContextMenuUtilsKt.ActionMenuItem$default((ReadScope)$this$addRemoveFolderMenuItems, (Trigger)((Trigger)WorkspaceTreeActionId.RemoveFile.getId()), (ActionContext)actionContext2, null, null, (boolean)false, (boolean)false, null, (boolean)false, (int)252, null);
        n = 1;
        objectArray2 = objectArray;
        boolean bl3 = false;
        bl2 = isRoot && !inEmptySpace;
        objectArray2[n] = bl2 ? action : null;
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    @Composable
    @NotNull
    public final List<MenuItem> modificationContextMenuItems(@NotNull ReadScope $this$modificationContextMenuItems, boolean isRoot, @NotNull ActionContext actionContext2) {
        MenuItem.Action action;
        Intrinsics.checkNotNullParameter((Object)$this$modificationContextMenuItems, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)actionContext2, (String)"actionContext");
        Object[] objectArray = new MenuItem.Action[2];
        MenuItem.Action action2 = action = ContextMenuUtilsKt.ActionMenuItem$default((ReadScope)$this$modificationContextMenuItems, (Trigger)((Trigger)WorkspaceTreeActionIds.InitRename.getId()), (ActionContext)actionContext2, null, null, (boolean)false, (boolean)false, null, (boolean)false, (int)252, null);
        int n = 0;
        Object[] objectArray2 = objectArray;
        boolean bl = false;
        boolean bl2 = !isRoot;
        objectArray2[n] = bl2 ? action : null;
        MenuItem.Action it = action = ContextMenuUtilsKt.ActionMenuItem$default((ReadScope)$this$modificationContextMenuItems, (Trigger)((Trigger)WorkspaceTreeActionId.DeleteFileOrFolder.getId()), (ActionContext)actionContext2, null, null, (boolean)false, (boolean)false, null, (boolean)false, (int)252, null);
        n = 1;
        objectArray2 = objectArray;
        boolean bl3 = false;
        bl2 = !isRoot;
        objectArray2[n] = bl2 ? action : null;
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    @Composable
    @NotNull
    public final List<MenuItem> copyPasteContextMenuItems(@NotNull ReadScope $this$copyPasteContextMenuItems, @NotNull ActionContext actionContext2) {
        Intrinsics.checkNotNullParameter((Object)$this$copyPasteContextMenuItems, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)actionContext2, (String)"actionContext");
        Object[] objectArray = new MenuItem.Action[]{ContextMenuKt.ActionMenuItem$default((ReadScope)$this$copyPasteContextMenuItems, (Action)FileClipboardActionsKt.getCutFileAction(), (ActionContext)actionContext2, null, null, (boolean)false, (boolean)false, null, (boolean)false, (int)252, null), ContextMenuKt.ActionMenuItem$default((ReadScope)$this$copyPasteContextMenuItems, (Action)FileClipboardActionsKt.getCopyFileAction(), (ActionContext)actionContext2, null, null, (boolean)false, (boolean)false, null, (boolean)false, (int)252, null), ContextMenuKt.ActionMenuItem$default((ReadScope)$this$copyPasteContextMenuItems, (Action)FileClipboardActionsKt.copyPathAction(), (ActionContext)actionContext2, null, null, (boolean)false, (boolean)false, null, (boolean)false, (int)252, null), ContextMenuKt.ActionMenuItem$default((ReadScope)$this$copyPasteContextMenuItems, (Action)FileClipboardActionsKt.copyRelativePathAction(), (ActionContext)actionContext2, null, null, (boolean)false, (boolean)false, null, (boolean)false, (int)252, null), ContextMenuKt.ActionMenuItem$default((ReadScope)$this$copyPasteContextMenuItems, (Action)FileClipboardActionsKt.pasteFileAction(), (ActionContext)actionContext2, null, null, (boolean)false, (boolean)false, null, (boolean)false, (int)252, null)};
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }
}

