/*
 * Decompiled with CFR 0.152.
 */
package fleet.frontend.filetree;

import androidx.compose.runtime.Composable;
import com.jetbrains.rhizomedb.ChangeScope;
import com.jetbrains.rhizomedb.DbContext;
import com.jetbrains.rhizomedb.EntitiesKt;
import com.jetbrains.rhizomedb.Entity;
import com.jetbrains.rhizomedb.Q;
import com.jetbrains.rhizomedb.impl.EntitiesImplKt;
import fleet.api.FileAddress;
import fleet.common.FleetCommonSettingsKeysKt;
import fleet.common.FsService;
import fleet.common.fs.FsdKt;
import fleet.common.settings.SettingsEntityKt;
import fleet.compose.theme.components.ContextMenuKt;
import fleet.compose.theme.components.MenuItem;
import fleet.frontend.clipboard.FileClipboardActionsKt;
import fleet.frontend.filetree.CombinedFolderWorkspaceTreeItem;
import fleet.frontend.filetree.ExternalLibraryTreeItem;
import fleet.frontend.filetree.FSWorkspaceTreeRoot;
import fleet.frontend.filetree.FileWorkspaceTreeItem;
import fleet.frontend.filetree.NewFileInTreeEntity;
import fleet.frontend.filetree.NewFileWorkspaceTreeItem;
import fleet.frontend.filetree.WorkspaceRootTreeItem;
import fleet.frontend.filetree.WorkspaceTreeActions;
import fleet.frontend.filetree.WorkspaceTreeCellHighlighting;
import fleet.frontend.filetree.WorkspaceTreeItem;
import fleet.frontend.filetree.WorkspaceTreeRoot;
import fleet.frontend.filetree.WorkspaceTreeSettingsKeys;
import fleet.frontend.filetree.WorkspaceTreeTabEntity;
import fleet.frontend.filetree.extension.internal.FilesTreeMenuExtenderKt;
import fleet.frontend.filetree.fsentry.internal.FSDKt;
import fleet.frontend.filetree.fsentry.internal.FSDirectory;
import fleet.frontend.filetree.fsentry.internal.FSEntry;
import fleet.frontend.filetree.fsentry.internal.FetchRequest;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KMutableProperty1;
import kotlin.reflect.KProperty1;
import noria.ReadScope;
import noria.model.Action;
import noria.model.ActionContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0080\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010!\u001a\u00020\n2\b\u0010\"\u001a\u0004\u0018\u00010#H\u00d6\u0003J\t\u0010$\u001a\u00020%H\u00d6\u0001J\t\u0010&\u001a\u00020'H\u00d6\u0001J\"\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)*\u00020+2\u0006\u0010,\u001a\u00020\u00172\u0006\u0010-\u001a\u00020.H\u0017J\u001e\u0010/\u001a\u0004\u0018\u00010\u0017*\u0002002\u0006\u00101\u001a\u00020\u00172\u0006\u00102\u001a\u00020\nH\u0016J\u0014\u00103\u001a\u000204*\u0002002\u0006\u00105\u001a\u00020\u0017H\u0016J\u0014\u00106\u001a\u000204*\u0002002\u0006\u00105\u001a\u00020\u0017H\u0016J\u0014\u00107\u001a\u000204*\u0002002\u0006\u00105\u001a\u00020\u0017H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\fR\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\fR\u0014\u0010\u001c\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u000f\u00a8\u00068"}, d2={"Lfleet/frontend/filetree/FSWorkspaceTreeRoot;", "Lfleet/frontend/filetree/WorkspaceTreeRoot;", "workspaceTreeTabEntity", "Lfleet/frontend/filetree/WorkspaceTreeTabEntity;", "(Lfleet/frontend/filetree/WorkspaceTreeTabEntity;)V", "cellHighlighting", "Lfleet/frontend/filetree/WorkspaceTreeCellHighlighting;", "getCellHighlighting", "()Lfleet/frontend/filetree/WorkspaceTreeCellHighlighting;", "combineFolders", "", "getCombineFolders", "()Z", "entity", "getEntity", "()Lfleet/frontend/filetree/WorkspaceTreeTabEntity;", "fetchRequest", "Lfleet/frontend/filetree/fsentry/internal/FetchRequest;", "getFetchRequest", "()Lfleet/frontend/filetree/fsentry/internal/FetchRequest;", "openEditorForNewFile", "getOpenEditorForNewFile", "renamedItem", "Lfleet/frontend/filetree/WorkspaceTreeItem;", "getRenamedItem", "()Lfleet/frontend/filetree/WorkspaceTreeItem;", "showHiddenFiles", "getShowHiddenFiles", "showRootsStatus", "getShowRootsStatus", "getWorkspaceTreeTabEntity", "component1", "copy", "equals", "other", "", "hashCode", "", "toString", "", "menuItems", "", "Lfleet/compose/theme/components/MenuItem;", "Lnoria/ReadScope;", "child", "actionContext", "Lnoria/model/ActionContext;", "newFile", "Lcom/jetbrains/rhizomedb/ChangeScope;", "parent", "directory", "revealEntry", "", "item", "startRenaming", "stopRenaming", "fleet.filetree.frontend"})
@SourceDebugExtension(value={"SMAP\nFSWorkspaceTreeRoot.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FSWorkspaceTreeRoot.kt\nfleet/frontend/filetree/FSWorkspaceTreeRoot\n+ 2 Entities.kt\ncom/jetbrains/rhizomedb/EntitiesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,115:1\n235#2:116\n1855#3,2:117\n*S KotlinDebug\n*F\n+ 1 FSWorkspaceTreeRoot.kt\nfleet/frontend/filetree/FSWorkspaceTreeRoot\n*L\n61#1:116\n61#1:117,2\n*E\n"})
public final class FSWorkspaceTreeRoot
implements WorkspaceTreeRoot {
    @NotNull
    private final WorkspaceTreeTabEntity workspaceTreeTabEntity;
    @NotNull
    private final WorkspaceTreeTabEntity entity;
    @NotNull
    private final FetchRequest fetchRequest;
    private final boolean showRootsStatus;
    private final boolean openEditorForNewFile;
    private final boolean showHiddenFiles;
    @NotNull
    private final WorkspaceTreeCellHighlighting cellHighlighting;

    public FSWorkspaceTreeRoot(@NotNull WorkspaceTreeTabEntity workspaceTreeTabEntity) {
        Intrinsics.checkNotNullParameter((Object)workspaceTreeTabEntity, (String)"workspaceTreeTabEntity");
        this.entity = this.workspaceTreeTabEntity = workspaceTreeTabEntity;
        this.fetchRequest = FetchRequest.FETCH_WHILE_SINGLE_CHILD;
        this.showRootsStatus = FleetCommonSettingsKeysKt.isInternalMode();
        this.openEditorForNewFile = true;
        this.showHiddenFiles = true;
        this.cellHighlighting = WorkspaceTreeCellHighlighting.DEFAULT;
    }

    @NotNull
    public final WorkspaceTreeTabEntity getWorkspaceTreeTabEntity() {
        return this.workspaceTreeTabEntity;
    }

    @NotNull
    public WorkspaceTreeTabEntity getEntity() {
        return this.entity;
    }

    @Override
    public boolean getCombineFolders() {
        return (Boolean)SettingsEntityKt.querySettingsKey$default(WorkspaceTreeSettingsKeys.INSTANCE.getCompactDirectories(), null, null, (int)6, null);
    }

    @Override
    @NotNull
    public FetchRequest getFetchRequest() {
        return this.fetchRequest;
    }

    @Override
    public boolean getShowRootsStatus() {
        return this.showRootsStatus;
    }

    @Override
    public boolean getOpenEditorForNewFile() {
        return this.openEditorForNewFile;
    }

    @Override
    public boolean getShowHiddenFiles() {
        return this.showHiddenFiles;
    }

    @Override
    @NotNull
    public WorkspaceTreeCellHighlighting getCellHighlighting() {
        return this.cellHighlighting;
    }

    @Override
    @Composable
    @NotNull
    public List<MenuItem> menuItems(@NotNull ReadScope $this$menuItems, @NotNull WorkspaceTreeItem child, @NotNull ActionContext actionContext2) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$menuItems, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        Intrinsics.checkNotNullParameter((Object)actionContext2, (String)"actionContext");
        WorkspaceTreeItem workspaceTreeItem = child;
        if (workspaceTreeItem instanceof FileWorkspaceTreeItem) {
            WorkspaceTreeActions $this$menuItems_u24lambda_u240 = WorkspaceTreeActions.INSTANCE;
            boolean bl = false;
            list = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)$this$menuItems_u24lambda_u240.newContextMenuItems($this$menuItems, actionContext2), (Object)MenuItem.Separator.INSTANCE), (Iterable)$this$menuItems_u24lambda_u240.addRemoveFolderMenuItems$fleet_filetree_frontend($this$menuItems, child instanceof WorkspaceRootTreeItem, actionContext2)), (Object)MenuItem.Separator.INSTANCE), (Iterable)$this$menuItems_u24lambda_u240.openContextMenuItems($this$menuItems, ((FileWorkspaceTreeItem)child).getDeepestEntry(), actionContext2)), (Object)MenuItem.Separator.INSTANCE), (Iterable)$this$menuItems_u24lambda_u240.modificationContextMenuItems($this$menuItems, child instanceof WorkspaceRootTreeItem, actionContext2)), (Object)MenuItem.Separator.INSTANCE), (Iterable)$this$menuItems_u24lambda_u240.copyPasteContextMenuItems($this$menuItems, actionContext2)), (Object)MenuItem.Separator.INSTANCE), (Iterable)FilesTreeMenuExtenderKt.filesTreeExtensionMenuItems($this$menuItems, actionContext2));
        } else {
            list = workspaceTreeItem instanceof ExternalLibraryTreeItem ? CollectionsKt.listOfNotNull((Object)ContextMenuKt.ActionMenuItem$default((ReadScope)$this$menuItems, (Action)FileClipboardActionsKt.getCopyFileAction(), (ActionContext)actionContext2, null, null, (boolean)false, (boolean)false, null, (boolean)false, (int)252, null)) : CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public WorkspaceTreeItem newFile(@NotNull ChangeScope $this$newFile, @NotNull WorkspaceTreeItem parent, boolean directory) {
        WorkspaceTreeItem workspaceTreeItem;
        WorkspaceTreeItem adjustedParent;
        Intrinsics.checkNotNullParameter((Object)$this$newFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        WorkspaceTreeItem workspaceTreeItem2 = adjustedParent = parent instanceof FileWorkspaceTreeItem && !(((FileWorkspaceTreeItem)parent).getDeepestEntry() instanceof FSDirectory) ? parent.getParent() : parent;
        if (adjustedParent instanceof FileWorkspaceTreeItem) {
            NewFileWorkspaceTreeItem newFileWorkspaceTreeItem;
            FSEntry parentFsEntry = ((FileWorkspaceTreeItem)adjustedParent).getDeepestEntry();
            if (parentFsEntry != null) {
                FsService fsService2 = FsdKt.fsService((FileAddress)FSDKt.fileAddress(parentFsEntry));
                if (fsService2 != null && parentFsEntry instanceof FSDirectory) {
                    void $this$forEach$iv;
                    WorkspaceTreeRoot root2 = ((FileWorkspaceTreeItem)adjustedParent).getRoot();
                    Object property$iv = (KMutableProperty1)newFile.1.INSTANCE;
                    boolean $i$f$lookup = false;
                    property$iv = EntitiesImplKt.lookupImpl((Q)DbContext.Companion.getThreadBound().getImpl(), (KProperty1)((KProperty1)property$iv), (Object)root2, (KClass)Reflection.getOrCreateKotlinClass(NewFileInTreeEntity.class));
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        NewFileInTreeEntity it = (NewFileInTreeEntity)element$iv;
                        boolean bl = false;
                        $this$newFile.delete((Entity)it);
                    }
                    NewFileInTreeEntity newFileInTreeEntity2 = (NewFileInTreeEntity)ChangeScope.DefaultImpls.new$default((ChangeScope)$this$newFile, (KClass)Reflection.getOrCreateKotlinClass(NewFileInTreeEntity.class), (int)0, (Function1)((Function1)new Function1<NewFileInTreeEntity, Unit>(fsService2, parentFsEntry, root2, directory){
                        final /* synthetic */ FsService $fsService;
                        final /* synthetic */ FSEntry $parentFsEntry;
                        final /* synthetic */ WorkspaceTreeRoot $root;
                        final /* synthetic */ boolean $directory;
                        {
                            this.$fsService = $fsService;
                            this.$parentFsEntry = $parentFsEntry;
                            this.$root = $root;
                            this.$directory = $directory;
                            super(1);
                        }

                        public final void invoke(@NotNull NewFileInTreeEntity $this$new) {
                            Intrinsics.checkNotNullParameter((Object)$this$new, (String)"$this$new");
                            $this$new.setFsService(this.$fsService);
                            $this$new.setParent((FSDirectory)this.$parentFsEntry);
                            $this$new.setRoot(this.$root);
                            $this$new.setDirectory(this.$directory);
                        }
                    }), (int)2, null);
                    NewFileWorkspaceTreeItem renamingItem = new NewFileWorkspaceTreeItem(newFileInTreeEntity2, directory, adjustedParent instanceof CombinedFolderWorkspaceTreeItem ? ((CombinedFolderWorkspaceTreeItem)adjustedParent).getDelegate() : (FileWorkspaceTreeItem)adjustedParent, root2);
                    this.workspaceTreeTabEntity.setRenamingItem(renamingItem);
                    newFileWorkspaceTreeItem = renamingItem;
                } else {
                    newFileWorkspaceTreeItem = null;
                }
            } else {
                newFileWorkspaceTreeItem = null;
            }
            workspaceTreeItem = newFileWorkspaceTreeItem;
        } else {
            workspaceTreeItem = null;
        }
        return workspaceTreeItem;
    }

    @Override
    public void startRenaming(@NotNull ChangeScope $this$startRenaming, @NotNull WorkspaceTreeItem item) {
        Intrinsics.checkNotNullParameter((Object)$this$startRenaming, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        if (EntitiesKt.exists((Entity)((Entity)this.workspaceTreeTabEntity))) {
            this.workspaceTreeTabEntity.setRenamingItem(item);
        }
    }

    @Override
    public void stopRenaming(@NotNull ChangeScope $this$stopRenaming, @NotNull WorkspaceTreeItem item) {
        Intrinsics.checkNotNullParameter((Object)$this$stopRenaming, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        if (EntitiesKt.exists((Entity)((Entity)this.workspaceTreeTabEntity))) {
            WorkspaceTreeItem workspaceTreeItem = this.workspaceTreeTabEntity.getRenamingItem();
            if (Intrinsics.areEqual((Object)item.getKey(), (Object)(workspaceTreeItem != null ? workspaceTreeItem.getKey() : null))) {
                this.workspaceTreeTabEntity.setRenamingItem(null);
            }
        }
    }

    @Override
    public void revealEntry(@NotNull ChangeScope $this$revealEntry, @NotNull WorkspaceTreeItem item) {
        Intrinsics.checkNotNullParameter((Object)$this$revealEntry, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        if (EntitiesKt.exists((Entity)((Entity)this.workspaceTreeTabEntity)) && item instanceof FileWorkspaceTreeItem) {
            this.workspaceTreeTabEntity.setTargetEntry(((FileWorkspaceTreeItem)item).getDeepestEntry());
        }
    }

    @Override
    @Nullable
    public WorkspaceTreeItem getRenamedItem() {
        return EntitiesKt.exists((Entity)((Entity)this.workspaceTreeTabEntity)) ? this.workspaceTreeTabEntity.getRenamingItem() : null;
    }

    @NotNull
    public final WorkspaceTreeTabEntity component1() {
        return this.workspaceTreeTabEntity;
    }

    @NotNull
    public final FSWorkspaceTreeRoot copy(@NotNull WorkspaceTreeTabEntity workspaceTreeTabEntity) {
        Intrinsics.checkNotNullParameter((Object)workspaceTreeTabEntity, (String)"workspaceTreeTabEntity");
        return new FSWorkspaceTreeRoot(workspaceTreeTabEntity);
    }

    public static /* synthetic */ FSWorkspaceTreeRoot copy$default(FSWorkspaceTreeRoot fSWorkspaceTreeRoot, WorkspaceTreeTabEntity workspaceTreeTabEntity, int n, Object object) {
        if ((n & 1) != 0) {
            workspaceTreeTabEntity = fSWorkspaceTreeRoot.workspaceTreeTabEntity;
        }
        return fSWorkspaceTreeRoot.copy(workspaceTreeTabEntity);
    }

    @NotNull
    public String toString() {
        return "FSWorkspaceTreeRoot(workspaceTreeTabEntity=" + this.workspaceTreeTabEntity + ")";
    }

    public int hashCode() {
        return this.workspaceTreeTabEntity.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FSWorkspaceTreeRoot)) {
            return false;
        }
        FSWorkspaceTreeRoot fSWorkspaceTreeRoot = (FSWorkspaceTreeRoot)other;
        return Intrinsics.areEqual((Object)this.workspaceTreeTabEntity, (Object)fSWorkspaceTreeRoot.workspaceTreeTabEntity);
    }
}

