/*
 * Decompiled with CFR 0.152.
 */
package fleet.lang.intellij.common;

import fleet.com.intellij.psi.ITokenSequence;
import fleet.com.intellij.psi.tree.IElementType;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00040\u00070\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0016\u001a\u00020\u0001H\u0016J\u0010\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004H\u0016J\u0010\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0004H\u0016J\u0010\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004H\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00040\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013\u00a8\u0006\u001e"}, d2={"Lfleet/lang/intellij/common/InjectTokenSequence;", "Lfleet/com/intellij/psi/ITokenSequence;", "original", "offset", "", "tokens", "", "Lkotlin/Pair;", "Lfleet/com/intellij/psi/tree/IElementType;", "<init>", "(Lfleet/com/intellij/psi/ITokenSequence;ILjava/util/List;)V", "totalLen", "insertedTokensRange", "Lkotlin/ranges/IntRange;", "discardedTokenLen", "mappings", "", "lexemeCount", "getLexemeCount", "()I", "textLength", "getTextLength", "fork", "lexStart", "index", "lexType", "lexemeIndexByChar", "remap", "", "type", "fleet.plugins.ij.parsing.common"})
@SourceDebugExtension(value={"SMAP\nLexerUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LexerUtil.kt\nfleet/lang/intellij/common/InjectTokenSequence\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,135:1\n1#2:136\n*E\n"})
final class InjectTokenSequence
implements ITokenSequence {
    @NotNull
    private final ITokenSequence original;
    private final int offset;
    @NotNull
    private final List<Pair<IElementType, Integer>> tokens;
    private final int totalLen;
    @NotNull
    private final IntRange insertedTokensRange;
    private final int discardedTokenLen;
    @NotNull
    private final Map<Integer, IElementType> mappings;

    /*
     * WARNING - void declaration
     */
    public InjectTokenSequence(@NotNull ITokenSequence original, int offset, @NotNull List<? extends Pair<? extends IElementType, Integer>> tokens) {
        int n;
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        Intrinsics.checkNotNullParameter(tokens, (String)"tokens");
        this.original = original;
        this.offset = offset;
        this.tokens = tokens;
        Iterable iterable = this.tokens;
        InjectTokenSequence injectTokenSequence = this;
        int n2 = 0;
        for (Object t : iterable) {
            void it;
            Pair pair = (Pair)t;
            n = n2;
            boolean bl = false;
            int n3 = ((Number)it.getSecond()).intValue();
            n2 = n + n3;
        }
        injectTokenSequence.totalLen = n = n2;
        this.mappings = new LinkedHashMap();
        int tokenIndex = this.original.lexemeIndexByChar(this.offset);
        int tokenStart = this.original.lexStart(tokenIndex);
        int insertedTokenIndex = this.offset == tokenStart ? tokenIndex : tokenIndex + 1;
        this.insertedTokensRange = RangesKt.until((int)insertedTokenIndex, (int)(insertedTokenIndex + this.tokens.size()));
        this.discardedTokenLen = this.offset == tokenStart ? 0 : (tokenIndex < this.original.getLexemeCount() - 1 ? this.original.lexStart(tokenIndex + 1) - this.offset : 0);
    }

    public int getLexemeCount() {
        return this.original.getLexemeCount() + this.tokens.size();
    }

    public int getTextLength() {
        return this.original.getTextLength();
    }

    @NotNull
    public ITokenSequence fork() {
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public int lexStart(int index) {
        int n;
        if (index < this.insertedTokensRange.getFirst()) {
            n = this.original.lexStart(index);
        } else {
            Object object = this.insertedTokensRange;
            int n2 = object.getFirst();
            boolean bl = index <= object.getLast() ? n2 <= index : false;
            if (bl) {
                int n3;
                object = this.tokens.subList(0, index - this.insertedTokensRange.getFirst());
                int n4 = this.offset;
                n2 = 0;
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    void it;
                    Object t = iterator.next();
                    Pair pair = (Pair)t;
                    n3 = n2;
                    boolean bl2 = false;
                    int n5 = ((Number)it.getSecond()).intValue();
                    n2 = n3 + n5;
                }
                n3 = n2;
                n = n4 + n3;
            } else {
                n = this.original.lexStart(index - this.tokens.size()) + this.totalLen - this.discardedTokenLen;
            }
        }
        return n;
    }

    @NotNull
    public IElementType lexType(int index) {
        IElementType iElementType = this.mappings.get(index);
        if (iElementType == null) {
            if (index < this.insertedTokensRange.getFirst()) {
                iElementType = this.original.lexType(index);
            } else {
                IntRange intRange = this.insertedTokensRange;
                int n = intRange.getFirst();
                iElementType = (index <= intRange.getLast() ? n <= index : false) ? (IElementType)this.tokens.get(index - this.insertedTokensRange.getFirst()).getFirst() : this.original.lexType(index - this.tokens.size());
            }
        }
        return iElementType;
    }

    public int lexemeIndexByChar(int index) {
        int n;
        if (index < this.offset) {
            n = this.original.lexemeIndexByChar(index);
        } else {
            int n2 = this.offset;
            boolean bl = index < this.offset + this.totalLen ? n2 <= index : false;
            if (bl) {
                int currentTokenStart = this.offset;
                int n3 = ((Collection)this.tokens).size();
                for (int i = 0; i < n3; ++i) {
                    int tokenLen = ((Number)this.tokens.get(i).getSecond()).intValue();
                    boolean bl2 = currentTokenStart <= index ? index < currentTokenStart + tokenLen : false;
                    if (bl2) {
                        return this.insertedTokensRange.getFirst() + i;
                    }
                    currentTokenStart += tokenLen;
                }
                return -1;
            }
            int originalIndex = this.original.lexemeIndexByChar(index - this.totalLen + this.discardedTokenLen);
            n = originalIndex == -1 ? originalIndex : originalIndex + this.tokens.size();
        }
        return n;
    }

    public void remap(int index, @NotNull IElementType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Integer n = index;
        this.mappings.put(n, type);
    }
}

