/*
 * Decompiled with CFR 0.152.
 */
package fleet.util.logging;

import fleet.util.logging.KLogger;
import fleet.util.logging.KLoggerFactory;
import fleet.util.logging.KLoggers;
import fleet.util.logging.KLoggersKt;
import fleet.util.logging.slf4j.Slf4jKLoggerFactory;
import java.util.ServiceLoader;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tJ\u0012\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\nJ\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fJ\t\u0010\u0006\u001a\u00020\u0007H\u0086\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lfleet/util/logging/KLoggers;", "", "<init>", "()V", "customFactory", "Lfleet/util/logging/KLoggerFactory;", "logger", "Lfleet/util/logging/KLogger;", "owner", "Lkotlin/reflect/KClass;", "Ljava/lang/Class;", "name", "", "fleet.util.logging.api"})
public final class KLoggers {
    @NotNull
    public static final KLoggers INSTANCE = new KLoggers();
    @NotNull
    private static final KLoggerFactory customFactory;

    private KLoggers() {
    }

    @NotNull
    public final KLogger logger(@NotNull KClass<?> owner) {
        Intrinsics.checkNotNullParameter(owner, (String)"owner");
        return customFactory.logger(owner);
    }

    @NotNull
    public final KLogger logger(@NotNull Class<?> owner) {
        Intrinsics.checkNotNullParameter(owner, (String)"owner");
        return customFactory.logger(owner);
    }

    @NotNull
    public final KLogger logger(@NotNull Object owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        return customFactory.logger(owner);
    }

    @NotNull
    public final KLogger logger(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return customFactory.logger(name);
    }

    @NotNull
    public final KLogger logger() {
        boolean $i$f$logger = false;
        Function0 nameSource2 = logger.nameSource.1.INSTANCE;
        return this.logger(KLoggersKt.loggerNameFromSource((Function0<Unit>)nameSource2));
    }

    static {
        ServiceLoader<KLoggerFactory> serviceLoader = ServiceLoader.load(KLoggerFactory.class, KLoggerFactory.class.getClassLoader());
        Intrinsics.checkNotNullExpressionValue(serviceLoader, (String)"load(...)");
        KLoggerFactory kLoggerFactory = (KLoggerFactory)CollectionsKt.firstOrNull((Iterable)serviceLoader);
        if (kLoggerFactory == null) {
            kLoggerFactory = new Slf4jKLoggerFactory();
        }
        customFactory = kLoggerFactory;
    }
}

