/*
 * Decompiled with CFR 0.152.
 */
package fleet.plugins.markdown.frontend.language;

import fleet.com.jetbrains.lang.syntax.SyntaxNode;
import fleet.com.jetbrains.lang.syntax.SyntaxNodeExtKt;
import fleet.frontend.icons.IconKeys;
import fleet.frontend.lang.PresentableNodeAspect;
import fleet.plugins.markdown.frontend.language.HeadersKt;
import fleet.plugins.markdown.frontend.language.MarkdownSyntaxNode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import noria.model.ThemeKey;
import org.intellij.markdown.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\f\u0012\u0004\u0012\u00020\u00050\u0004j\u0002`\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Lfleet/plugins/markdown/frontend/language/HeaderPresentableAspect;", "Lfleet/frontend/lang/PresentableNodeAspect;", "()V", "icon", "Lnoria/model/ThemeKey;", "", "Lnoria/model/IconKey;", "node", "Lfleet/com/jetbrains/lang/syntax/SyntaxNode;", "id", "presentation", "fleet.plugins.markdown.frontend"})
@SourceDebugExtension(value={"SMAP\nHeaderAspects.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HeaderAspects.kt\nfleet/plugins/markdown/frontend/language/HeaderPresentableAspect\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,47:1\n1#2:48\n179#3,2:49\n*S KotlinDebug\n*F\n+ 1 HeaderAspects.kt\nfleet/plugins/markdown/frontend/language/HeaderPresentableAspect\n*L\n27#1:49,2\n*E\n"})
final class HeaderPresentableAspect
implements PresentableNodeAspect {
    @NotNull
    public static final HeaderPresentableAspect INSTANCE = new HeaderPresentableAspect();

    private HeaderPresentableAspect() {
    }

    @NotNull
    public SyntaxNode id(@NotNull SyntaxNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return node;
    }

    @Nullable
    public String presentation(@NotNull SyntaxNode node) {
        Object v1;
        Integer level;
        block5: {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            MarkdownSyntaxNode markdownSyntaxNode = node instanceof MarkdownSyntaxNode ? (MarkdownSyntaxNode)node : null;
            if (markdownSyntaxNode == null) {
                return null;
            }
            MarkdownSyntaxNode element = markdownSyntaxNode;
            IElementType type = element.getType();
            if (!HeadersKt.isHeaderType(type)) {
                boolean $i$a$-check-HeaderPresentableAspect$presentation$22 = false;
                String $i$a$-check-HeaderPresentableAspect$presentation$22 = "Should be created only for header elements (was " + element + ")";
                throw new IllegalStateException($i$a$-check-HeaderPresentableAspect$presentation$22.toString());
            }
            level = HeadersKt.headerLevel(type);
            if (level == null) {
                String $i$a$-check-HeaderPresentableAspect$presentation$22 = "Required value was null.";
                throw new IllegalStateException($i$a$-check-HeaderPresentableAspect$presentation$22.toString());
            }
            Sequence $this$firstOrNull$iv = SyntaxNodeExtKt.children((SyntaxNode)node);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                SyntaxNode it = (SyntaxNode)element$iv;
                boolean bl = false;
                if (!CollectionsKt.contains((Iterable)HeadersKt.getHeaderContentHolderTypes(), (Object)it.getType())) continue;
                v1 = element$iv;
                break block5;
            }
            v1 = null;
        }
        SyntaxNode syntaxNode = v1;
        if (syntaxNode == null) {
            return null;
        }
        SyntaxNode content2 = syntaxNode;
        String prefix = StringsKt.repeat((CharSequence)"#", (int)level);
        return prefix + " " + content2.getText();
    }

    @NotNull
    public ThemeKey<String> icon(@NotNull SyntaxNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return IconKeys.Nodes.INSTANCE.getAnnotation();
    }

    public boolean canContainsPresentableChildren(@NotNull SyntaxNode node) {
        return PresentableNodeAspect.DefaultImpls.canContainsPresentableChildren((PresentableNodeAspect)this, (SyntaxNode)node);
    }

    public boolean isFileStructureElement(@NotNull SyntaxNode node) {
        return PresentableNodeAspect.DefaultImpls.isFileStructureElement((PresentableNodeAspect)this, (SyntaxNode)node);
    }

    @Nullable
    public String name(@NotNull SyntaxNode node) {
        return PresentableNodeAspect.DefaultImpls.name((PresentableNodeAspect)this, (SyntaxNode)node);
    }
}

