/*
 * Decompiled with CFR 0.152.
 */
package boringFormatter.indenter;

import boringFormatter.FormatterUtils;
import boringFormatter.FormatterUtilsKt;
import boringFormatter.TextContent;
import boringFormatter.indenter.IndentingRule;
import fleet.com.jetbrains.lang.syntax.SyntaxNode;
import fleet.com.jetbrains.lang.syntax.SyntaxNodeExtKt;
import fleet.util.CollectionsUtilKt;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongRange;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a2\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\nH\u0000\u001a(\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\u001f\u0010\f\u001a\u0004\u0018\u0001H\r\"\u0004\b\u0000\u0010\r*\b\u0012\u0004\u0012\u0002H\r0\u000eH\u0000\u00a2\u0006\u0002\u0010\u000f\u001a\u000e\u0010\u0010\u001a\u0004\u0018\u00010\u0007*\u00020\u0007H\u0000\u001a\u000e\u0010\u0011\u001a\u0004\u0018\u00010\u0007*\u00020\u0007H\u0000\u001a\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0007H\u0000\u001a\f\u0010\u0014\u001a\u00020\u0013*\u00020\u0007H\u0000\u001a\f\u0010\u0015\u001a\u00020\u0007*\u00020\u0007H\u0000\u00a8\u0006\u0016"}, d2={"getRegionLineRange", "Lkotlin/ranges/LongRange;", "rule", "LboringFormatter/indenter/IndentingRule;", "text", "LboringFormatter/TextContent;", "openNode", "Lfleet/com/jetbrains/lang/syntax/SyntaxNode;", "exitNode", "lastIndentedLine", "", "getFirstRuleLine", "peekOrNull", "T", "Ljava/util/Stack;", "(Ljava/util/Stack;)Ljava/lang/Object;", "nextToken", "prevToken", "isFirstNonWsNodeOnLine", "", "isLastNodeOnLine", "root", "fleet.boringFormatter"})
public final class IndentingSessionUtilsKt {
    @NotNull
    public static final LongRange getRegionLineRange(@NotNull IndentingRule rule, @NotNull TextContent text, @NotNull SyntaxNode openNode, @Nullable SyntaxNode exitNode, long lastIndentedLine) {
        Intrinsics.checkNotNullParameter((Object)rule, (String)"rule");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)openNode, (String)"openNode");
        long firstLine = IndentingSessionUtilsKt.getFirstRuleLine(rule, text, openNode, lastIndentedLine);
        long lastLine = FormatterUtils.INSTANCE.lastApplyingLineOfRegion(rule.getEndsInclusive(), text, openNode, exitNode);
        return new LongRange(firstLine, lastLine);
    }

    public static final long getFirstRuleLine(@NotNull IndentingRule rule, @NotNull TextContent text, @NotNull SyntaxNode openNode, long lastIndentedLine) {
        Intrinsics.checkNotNullParameter((Object)rule, (String)"rule");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)openNode, (String)"openNode");
        long firstLineOfRegion = FormatterUtils.INSTANCE.firstApplyingLineOfRegion(rule.getStartsInclusive(), text, openNode);
        return ((Number)((Object)CollectionsUtilKt.max((Comparable)Long.valueOf(firstLineOfRegion), (Comparable)Long.valueOf(lastIndentedLine + 1L)))).longValue();
    }

    @Nullable
    public static final <T> T peekOrNull(@NotNull Stack<T> $this$peekOrNull) {
        Intrinsics.checkNotNullParameter($this$peekOrNull, (String)"<this>");
        return $this$peekOrNull.isEmpty() ? null : (T)$this$peekOrNull.peek();
    }

    @Nullable
    public static final SyntaxNode nextToken(@NotNull SyntaxNode $this$nextToken) {
        Intrinsics.checkNotNullParameter((Object)$this$nextToken, (String)"<this>");
        SyntaxNode cursor = SyntaxNodeExtKt.next((SyntaxNode)$this$nextToken);
        while (cursor != null && !FormatterUtilsKt.isToken(cursor)) {
            cursor = SyntaxNodeExtKt.next((SyntaxNode)cursor);
        }
        return cursor;
    }

    @Nullable
    public static final SyntaxNode prevToken(@NotNull SyntaxNode $this$prevToken) {
        Intrinsics.checkNotNullParameter((Object)$this$prevToken, (String)"<this>");
        SyntaxNode cursor = SyntaxNodeExtKt.leafLeft((SyntaxNode)$this$prevToken);
        while (cursor != null && !FormatterUtilsKt.isToken(cursor)) {
            cursor = SyntaxNodeExtKt.leafLeft((SyntaxNode)cursor);
        }
        return cursor;
    }

    public static final boolean isFirstNonWsNodeOnLine(@NotNull SyntaxNode $this$isFirstNonWsNodeOnLine) {
        Intrinsics.checkNotNullParameter((Object)$this$isFirstNonWsNodeOnLine, (String)"<this>");
        SyntaxNode prev = $this$isFirstNonWsNodeOnLine;
        block0: while (SyntaxNodeExtKt.leafLeft((SyntaxNode)prev) != null) {
            CharSequence charSequence = StringsKt.reversed((CharSequence)prev.getText());
            int n = 0;
            while (true) {
                if (n >= charSequence.length()) continue block0;
                char c = charSequence.charAt(n);
                if (c == '\n') {
                    return true;
                }
                if (!CharsKt.isWhitespace((char)c)) {
                    return false;
                }
                ++n;
            }
            break;
        }
        return true;
    }

    public static final boolean isLastNodeOnLine(@NotNull SyntaxNode $this$isLastNodeOnLine) {
        Intrinsics.checkNotNullParameter((Object)$this$isLastNodeOnLine, (String)"<this>");
        SyntaxNode prev = $this$isLastNodeOnLine;
        block0: while (SyntaxNodeExtKt.leafRight((SyntaxNode)prev) != null) {
            CharSequence charSequence = prev.getText();
            int n = 0;
            while (true) {
                if (n >= charSequence.length()) continue block0;
                char c = charSequence.charAt(n);
                if (c == '\n') {
                    return true;
                }
                if (!CharsKt.isWhitespace((char)c)) {
                    return false;
                }
                ++n;
            }
            break;
        }
        return true;
    }

    @NotNull
    public static final SyntaxNode root(@NotNull SyntaxNode $this$root) {
        Intrinsics.checkNotNullParameter((Object)$this$root, (String)"<this>");
        SyntaxNode parent = $this$root;
        while (true) {
            if (parent.parent() != null) continue;
            return parent;
        }
    }
}

