/*
 * Decompiled with CFR 0.152.
 */
package boringFormatter.indenter;

import boringFormatter.TextContent;
import boringFormatter.indenter.IndentingRule;
import boringFormatter.indenter.RegionIndents;
import fleet.com.jetbrains.lang.syntax.SyntaxNode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0005J\u0018\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020)H\u0002J&\u0010*\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010(\u001a\u00020)J\b\u0010-\u001a\u00020.H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\f\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0018R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u001e\"\u0004\b!\u0010\"\u00a8\u0006/"}, d2={"LboringFormatter/indenter/ActiveIndentRegion;", "", "rule", "LboringFormatter/indenter/IndentingRule;", "startLineNumber", "", "initialRegionIndent", "indentBeforeOpening", "id", "", "enterNode", "Lfleet/com/jetbrains/lang/syntax/SyntaxNode;", "endNode", "isGreedy", "", "<init>", "(LboringFormatter/indenter/IndentingRule;JJJILfleet/com/jetbrains/lang/syntax/SyntaxNode;Lfleet/com/jetbrains/lang/syntax/SyntaxNode;Z)V", "getRule", "()LboringFormatter/indenter/IndentingRule;", "getStartLineNumber", "()J", "getId", "()I", "getEnterNode", "()Lfleet/com/jetbrains/lang/syntax/SyntaxNode;", "getEndNode", "()Z", "originIndent", "LboringFormatter/indenter/RegionIndents;", "getOriginIndent", "()LboringFormatter/indenter/RegionIndents;", "adjustedIndent", "getAdjustedIndent", "setAdjustedIndent", "(LboringFormatter/indenter/RegionIndents;)V", "adjustDelta", "", "delta", "getEndLine", "region", "text", "LboringFormatter/TextContent;", "isCollapsesWith", "currentNode", "currentNodeStartLine", "toString", "", "fleet.boringFormatter"})
public final class ActiveIndentRegion {
    @NotNull
    private final IndentingRule rule;
    private final long startLineNumber;
    private final int id;
    @NotNull
    private final SyntaxNode enterNode;
    @Nullable
    private final SyntaxNode endNode;
    private final boolean isGreedy;
    @NotNull
    private final RegionIndents originIndent;
    @NotNull
    private RegionIndents adjustedIndent;

    public ActiveIndentRegion(@NotNull IndentingRule rule, long startLineNumber, long initialRegionIndent, long indentBeforeOpening, int id, @NotNull SyntaxNode enterNode, @Nullable SyntaxNode endNode, boolean isGreedy) {
        Intrinsics.checkNotNullParameter((Object)rule, (String)"rule");
        Intrinsics.checkNotNullParameter((Object)enterNode, (String)"enterNode");
        this.rule = rule;
        this.startLineNumber = startLineNumber;
        this.id = id;
        this.enterNode = enterNode;
        this.endNode = endNode;
        this.isGreedy = isGreedy;
        this.adjustedIndent = this.originIndent = new RegionIndents(initialRegionIndent, indentBeforeOpening);
    }

    @NotNull
    public final IndentingRule getRule() {
        return this.rule;
    }

    public final long getStartLineNumber() {
        return this.startLineNumber;
    }

    public final int getId() {
        return this.id;
    }

    @NotNull
    public final SyntaxNode getEnterNode() {
        return this.enterNode;
    }

    @Nullable
    public final SyntaxNode getEndNode() {
        return this.endNode;
    }

    public final boolean isGreedy() {
        return this.isGreedy;
    }

    @NotNull
    public final RegionIndents getOriginIndent() {
        return this.originIndent;
    }

    @NotNull
    public final RegionIndents getAdjustedIndent() {
        return this.adjustedIndent;
    }

    public final void setAdjustedIndent(@NotNull RegionIndents regionIndents) {
        Intrinsics.checkNotNullParameter((Object)regionIndents, (String)"<set-?>");
        this.adjustedIndent = regionIndents;
    }

    public final void adjustDelta(long delta) {
        this.adjustedIndent = RegionIndents.copy$default(this.adjustedIndent, this.adjustedIndent.getIndentBefore() + delta, 0L, 2, null);
    }

    private final long getEndLine(ActiveIndentRegion region, TextContent text) {
        return region.endNode == null ? text.linesCount() - 1L : text.lineNumber(region.endNode.getEndOffset());
    }

    public final boolean isCollapsesWith(@NotNull SyntaxNode currentNode, long currentNodeStartLine, @NotNull IndentingRule rule, @NotNull TextContent text) {
        long otherEndLine;
        Intrinsics.checkNotNullParameter((Object)currentNode, (String)"currentNode");
        Intrinsics.checkNotNullParameter((Object)rule, (String)"rule");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        ActiveIndentRegion newActiveRegion = new ActiveIndentRegion(rule, currentNodeStartLine, 0L, 0L, 0, currentNode, (SyntaxNode)rule.getEndLocator().invoke((Object)currentNode), false);
        if (this.startLineNumber != newActiveRegion.startLineNumber) {
            return false;
        }
        if (this.rule.getIndentType() != newActiveRegion.rule.getIndentType()) {
            return false;
        }
        long thisEndLine = this.getEndLine(this, text);
        return thisEndLine == (otherEndLine = this.getEndLine(newActiveRegion, text));
    }

    @NotNull
    public String toString() {
        SyntaxNode syntaxNode = this.endNode;
        return "'" + this.rule.getName() + "':" + this.startLineNumber + " " + this.rule.getIndentType() + " [" + this.enterNode.getType() + ".." + (syntaxNode != null ? syntaxNode.getType() : null) + "]";
    }
}

