/*
 * Decompiled with CFR 0.152.
 */
package fleet.plugins.lightweightIndexer.workspace;

import ai.grazie.code.files.model.FileSystemProvider;
import fleet.api.FileAddress;
import fleet.api.FileAddressKt;
import fleet.api.FileDescriptor;
import fleet.api.HostId;
import fleet.api.LocationInFile;
import fleet.api.ProtocolPath;
import fleet.api.Root;
import fleet.common.util.LocationUtilKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lfleet/plugins/lightweightIndexer/workspace/FleetFileSystemSerialization;", "Lai/grazie/code/files/model/FileSystemProvider$Serialization;", "Lfleet/api/FileDescriptor;", "host", "Lfleet/api/HostId;", "root", "Lfleet/api/Root;", "(Lfleet/api/HostId;Lfleet/api/Root;)V", "fromAbsoluteString", "path", "", "fromRelativeString", "base", "toPathString", "fleet.plugins.lightweightIndexer.workspace"})
public final class FleetFileSystemSerialization
implements FileSystemProvider.Serialization<FileDescriptor> {
    @NotNull
    private final HostId host;
    @NotNull
    private final Root root;

    public FleetFileSystemSerialization(@NotNull HostId host, @NotNull Root root) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.host = host;
        this.root = root;
    }

    @NotNull
    public FileDescriptor fromAbsoluteString(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        FileAddress fileAddress = new FileAddress(this.host, new ProtocolPath(this.root, CollectionsKt.listOf((Object)path)));
        return (FileDescriptor)new FileDescriptor.Address(fileAddress);
    }

    @NotNull
    public String toPathString(@NotNull FileDescriptor path) {
        String string;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        FileAddress fileAddress = LocationUtilKt.getFileAddress((LocationInFile)((LocationInFile)path));
        if ((fileAddress != null && (fileAddress = fileAddress.getPath()) != null ? fileAddress.joinToString() : (string = null)) == null) {
            string = "";
        }
        return string;
    }

    @NotNull
    public FileDescriptor fromRelativeString(@NotNull FileDescriptor base, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        FileAddress fileAddress = LocationUtilKt.getFileAddress((LocationInFile)((LocationInFile)base));
        if (fileAddress == null || (fileAddress = FileAddressKt.resolveChild((FileAddress)fileAddress, (String)path)) == null) {
            fileAddress = FileAddress.Companion.getINVALID();
        }
        return (FileDescriptor)new FileDescriptor.Address(fileAddress);
    }
}

