/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.doctor.compatibility;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.doctor.compatibility.CompatibilityReport;
import org.jetbrains.kotlin.doctor.entity.Compatibility;
import org.jetbrains.kotlin.doctor.entity.CompatibilityProblem;
import org.jetbrains.kotlin.doctor.entity.DiagnosisResult;
import org.jetbrains.kotlin.doctor.entity.EnvironmentPiece;
import org.jetbrains.kotlin.doctor.entity.EnvironmentRange;
import org.jetbrains.kotlin.doctor.entity.System;
import org.jetbrains.kotlin.doctor.entity.Version;
import org.jetbrains.kotlin.doctor.logging.KdoctorLogger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\"\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\f2\u0006\u0010\u000f\u001a\u00020\u0007R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/doctor/compatibility/CompatibilityAnalyse;", "", "system", "Lorg/jetbrains/kotlin/doctor/entity/System;", "compatibility", "Lorg/jetbrains/kotlin/doctor/entity/Compatibility;", "checkKdoctorVersion", "", "(Lorg/jetbrains/kotlin/doctor/entity/System;Lorg/jetbrains/kotlin/doctor/entity/Compatibility;Z)V", "check", "Lorg/jetbrains/kotlin/doctor/compatibility/CompatibilityReport;", "environments", "", "", "Lorg/jetbrains/kotlin/doctor/entity/EnvironmentPiece;", "verbose", "kdoctor-checks"})
@SourceDebugExtension(value={"SMAP\nCompatibilityAnalyse.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompatibilityAnalyse.kt\norg/jetbrains/kotlin/doctor/compatibility/CompatibilityAnalyse\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,60:1\n1855#2:61\n766#2:62\n857#2:63\n1726#2,2:64\n288#2,2:66\n1728#2:69\n858#2:70\n1856#2:71\n766#2:72\n857#2,2:73\n1855#2:75\n1864#2,3:76\n1856#2:79\n1#3:68\n*S KotlinDebug\n*F\n+ 1 CompatibilityAnalyse.kt\norg/jetbrains/kotlin/doctor/compatibility/CompatibilityAnalyse\n*L\n12#1:61\n13#1:62\n13#1:63\n15#1:64,2\n17#1:66,2\n15#1:69\n13#1:70\n12#1:71\n37#1:72\n37#1:73,2\n38#1:75\n39#1:76,3\n38#1:79\n*E\n"})
public final class CompatibilityAnalyse {
    @NotNull
    private final System system;
    @NotNull
    private final Compatibility compatibility;
    private final boolean checkKdoctorVersion;

    public CompatibilityAnalyse(@NotNull System system, @NotNull Compatibility compatibility, boolean checkKdoctorVersion) {
        Intrinsics.checkNotNullParameter((Object)system, (String)"system");
        Intrinsics.checkNotNullParameter((Object)compatibility, (String)"compatibility");
        this.system = system;
        this.compatibility = compatibility;
        this.checkKdoctorVersion = checkKdoctorVersion;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CompatibilityReport check(@NotNull List<? extends Set<EnvironmentPiece>> environments, boolean verbose) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        StringBuilder stringBuilder;
        Iterable $this$filter$iv2;
        Iterable environment;
        Intrinsics.checkNotNullParameter(environments, (String)"environments");
        Set userProblems = new LinkedHashSet();
        Iterable $this$forEach$iv2 = environments;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv2) {
            void $this$filterTo$iv$iv2;
            environment = (Set)element$iv;
            boolean bl = false;
            $this$filter$iv2 = this.compatibility.getProblems();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv2;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                boolean bl2;
                block22: {
                    CompatibilityProblem problem = (CompatibilityProblem)element$iv$iv;
                    boolean bl3 = false;
                    KdoctorLogger.DefaultImpls.d$default(this.system.getLogger(), null, (Function0)new Function0<String>(problem){
                        final /* synthetic */ CompatibilityProblem $problem;
                        {
                            this.$problem = $problem;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            String string = this.$problem.getUrl();
                            if (string == null) {
                                string = this.$problem.getText();
                            }
                            return "Analyze problem: " + string;
                        }
                    }, 1, null);
                    Iterable $this$all$iv = problem.getMatrix();
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl2 = true;
                    } else {
                        for (Object element$iv2 : $this$all$iv) {
                            boolean bl4;
                            Object object;
                            Object v1;
                            EnvironmentRange app;
                            block21: {
                                app = (EnvironmentRange)element$iv2;
                                boolean bl5 = false;
                                KdoctorLogger.DefaultImpls.d$default(this.system.getLogger(), null, (Function0)new Function0<String>(app){
                                    final /* synthetic */ EnvironmentRange $app;
                                    {
                                        this.$app = $app;
                                        super(0);
                                    }

                                    @NotNull
                                    public final String invoke() {
                                        return "Find app: " + this.$app.getName();
                                    }
                                }, 1, null);
                                Iterable $this$firstOrNull$iv = environment;
                                boolean $i$f$firstOrNull = false;
                                for (Object element$iv3 : $this$firstOrNull$iv) {
                                    EnvironmentPiece it = (EnvironmentPiece)element$iv3;
                                    boolean bl6 = false;
                                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)app.getName())) continue;
                                    v1 = element$iv3;
                                    break block21;
                                }
                                v1 = null;
                            }
                            if ((object = (EnvironmentPiece)v1) == null || (object = ((EnvironmentPiece)object).getVersion()) == null) {
                                bl4 = false;
                            } else {
                                boolean bl7;
                                boolean beforeProblem;
                                boolean bl8;
                                Object userAppVersion = object;
                                KdoctorLogger.DefaultImpls.d$default(this.system.getLogger(), null, (Function0)new Function0<String>(app, (Version)userAppVersion){
                                    final /* synthetic */ EnvironmentRange $app;
                                    final /* synthetic */ Version $userAppVersion;
                                    {
                                        this.$app = $app;
                                        this.$userAppVersion = $userAppVersion;
                                        super(0);
                                    }

                                    @NotNull
                                    public final String invoke() {
                                        return "User app (" + this.$app.getName() + "): " + this.$userAppVersion.getSemVersion();
                                    }
                                }, 1, null);
                                if (app.getFrom() != null) {
                                    String it;
                                    boolean bl9 = false;
                                    bl8 = ((Version)userAppVersion).compareTo(new Version(it)) < 0;
                                } else {
                                    bl8 = beforeProblem = false;
                                }
                                if (app.getFixedIn() != null) {
                                    String it;
                                    boolean bl10 = false;
                                    bl7 = ((Version)userAppVersion).compareTo(new Version(it)) >= 0;
                                } else {
                                    bl7 = false;
                                }
                                boolean fixedAlready = bl7;
                                boolean result = !beforeProblem && !fixedAlready;
                                KdoctorLogger.DefaultImpls.d$default(this.system.getLogger(), null, (Function0)new Function0<String>(result){
                                    final /* synthetic */ boolean $result;
                                    {
                                        this.$result = $result;
                                        super(0);
                                    }

                                    @NotNull
                                    public final String invoke() {
                                        return "App has problem: " + this.$result;
                                    }
                                }, 1, null);
                                bl4 = result;
                            }
                            if (bl4) continue;
                            bl2 = false;
                            break block22;
                        }
                        bl2 = true;
                    }
                }
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List problems2 = (List)destination$iv$iv;
            userProblems.addAll(problems2);
        }
        StringBuilder $this$check_u24lambda_u2410 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (this.checkKdoctorVersion && new Version("1.1.0").compareTo(new Version(this.compatibility.getLatestKdoctor())) < 0) {
            StringBuilder stringBuilder2 = $this$check_u24lambda_u2410.append("  \u27a4 Update the kdoctor to the latest version: " + this.compatibility.getLatestKdoctor());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
            StringBuilder stringBuilder3 = $this$check_u24lambda_u2410.append("    brew upgrade kdoctor");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)$this$check_u24lambda_u2410.append('\n'), (String)"append(...)");
        }
        environment = userProblems;
        boolean $i$f$filter = false;
        $this$filter$iv2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CompatibilityProblem it = (CompatibilityProblem)element$iv$iv;
            boolean bl11 = false;
            if (!(verbose ? true : it.isCritical())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            StringBuilder stringBuilder4;
            CompatibilityProblem problem = (CompatibilityProblem)element$iv;
            boolean bl12 = false;
            Iterable $this$forEachIndexed$iv = StringsKt.lines((CharSequence)problem.getText());
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void s;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String $i$f$all = (String)item$iv;
                int index = n;
                boolean bl13 = false;
                if (index == 0) {
                    if (problem.isCritical()) {
                        StringBuilder stringBuilder5 = $this$check_u24lambda_u2410.append("\u001b[31m  ! \u001b[0m" + (String)s);
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append(...)");
                        continue;
                    }
                    StringBuilder stringBuilder6 = $this$check_u24lambda_u2410.append("  \u27a4 " + (String)s);
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6.append('\n'), (String)"append(...)");
                    continue;
                }
                StringBuilder stringBuilder7 = $this$check_u24lambda_u2410.append("    " + (String)s);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7.append('\n'), (String)"append(...)");
            }
            if (problem.getUrl() != null) {
                String it;
                boolean bl14 = false;
                StringBuilder stringBuilder8 = $this$check_u24lambda_u2410.append("    More details: " + it);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(...)");
                StringBuilder stringBuilder9 = stringBuilder8.append('\n');
                stringBuilder4 = stringBuilder9;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9, (String)"append(...)");
            } else {
                stringBuilder4 = null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)$this$check_u24lambda_u2410.append('\n'), (String)"append(...)");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String result = string;
        return !StringsKt.isBlank((CharSequence)result) ? new CompatibilityReport(DiagnosisResult.Warning, "Recommendations:\n" + result) : new CompatibilityReport(DiagnosisResult.Success, "");
    }
}

