/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.util.containers;

import fleet.com.intellij.util.containers.CanonicalHashingStrategy;
import fleet.com.intellij.util.containers.CaseInsensitiveStringHashingStrategy;
import fleet.com.intellij.util.containers.CharSequenceHashingStrategy;
import fleet.com.intellij.util.containers.IdentityHashingStrategy;
import org.jetbrains.annotations.NotNull;

public interface HashingStrategy<T> {
    public int hashCode(T var1);

    public boolean equals(T var1, T var2);

    @NotNull
    public static <T> HashingStrategy<T> canonical() {
        return CanonicalHashingStrategy.INSTANCE;
    }

    @NotNull
    public static <T> HashingStrategy<T> identity() {
        return IdentityHashingStrategy.INSTANCE;
    }

    @NotNull
    public static HashingStrategy<String> caseInsensitive() {
        return CaseInsensitiveStringHashingStrategy.INSTANCE;
    }

    @NotNull
    public static HashingStrategy<CharSequence> caseInsensitiveCharSequence() {
        return CharSequenceHashingStrategy.CASE_INSENSITIVE_INSTANCE;
    }

    @NotNull
    public static HashingStrategy<CharSequence> caseSensitiveCharSequence() {
        return CharSequenceHashingStrategy.CASE_SENSITIVE_INSTANCE;
    }
}

