/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.util;

import org.jetbrains.annotations.NotNull;

public enum ThreeState {
    YES,
    NO,
    UNSURE;


    @NotNull
    public static ThreeState fromBoolean(boolean value) {
        return value ? YES : NO;
    }

    @NotNull
    public ThreeState merge(ThreeState other) {
        return this == other ? this : UNSURE;
    }

    public boolean toBoolean() {
        if (this == UNSURE) {
            throw new IllegalStateException("Must be or YES, or NO");
        }
        return this == YES;
    }

    public boolean isAtLeast(@NotNull ThreeState other) {
        switch (other) {
            case YES: {
                return this == YES;
            }
            case UNSURE: {
                return this != NO;
            }
            case NO: {
                return true;
            }
        }
        throw new IllegalStateException("Unexpected value: " + other);
    }

    @NotNull
    public static ThreeState mostPositive(@NotNull Iterable<? extends ThreeState> states) {
        ThreeState result = NO;
        for (ThreeState threeState : states) {
            switch (threeState) {
                case YES: {
                    return YES;
                }
                case UNSURE: {
                    result = UNSURE;
                }
            }
        }
        return result;
    }

    @NotNull
    public static ThreeState merge(@NotNull Iterable<? extends ThreeState> states) {
        ThreeState result = null;
        for (ThreeState threeState : states) {
            if (threeState == UNSURE) {
                return UNSURE;
            }
            if (result == null) {
                result = threeState;
                continue;
            }
            if (result == threeState) continue;
            return UNSURE;
        }
        if (result == null) {
            throw new IllegalArgumentException("Argument should not be empty");
        }
        return result;
    }
}

