/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.openapi.util;

import fleet.com.intellij.openapi.util.UserDataHolder;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Key<T> {
    private static final AtomicInteger ourKeysCounter = new AtomicInteger();
    private final int myIndex = ourKeysCounter.getAndIncrement();
    private final String myName;

    public Key(@NotNull String name) {
        this.myName = name;
    }

    public final int hashCode() {
        return this.myIndex;
    }

    public final boolean equals(Object obj) {
        return obj == this;
    }

    public String toString() {
        return this.myName;
    }

    @NotNull
    public static <T> Key<T> create(@NotNull String name) {
        return new Key<T>(name);
    }

    public T get(@Nullable UserDataHolder holder) {
        return holder == null ? null : (T)holder.getUserData(this);
    }

    public T get(@Nullable Map<Key, ?> holder) {
        return holder == null ? null : (T)holder.get(this);
    }

    public T get(@Nullable UserDataHolder holder, T defaultValue) {
        T t = this.get(holder);
        return t == null ? defaultValue : t;
    }

    public void set(@Nullable UserDataHolder holder, @Nullable T value) {
        if (holder != null) {
            holder.putUserData(this, value);
        }
    }

    public void set(@Nullable Map<Key, Object> holder, T value) {
        if (holder != null) {
            holder.put(this, value);
        }
    }
}

