/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.lexer;

import fleet.com.intellij.lexer.DelegateLexer;
import fleet.com.intellij.lexer.Lexer;
import fleet.com.intellij.lexer.LexerPosition;
import fleet.com.intellij.lexer.MergeFunction;
import fleet.com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public abstract class MergingLexerAdapterBase
extends DelegateLexer {
    private IElementType myTokenType;
    private int myState;
    private int myTokenStart;

    public MergingLexerAdapterBase(Lexer original) {
        super(original);
    }

    public abstract MergeFunction getMergeFunction();

    @Override
    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        super.start(buffer, startOffset, endOffset, initialState);
        this.myTokenType = null;
        this.myState = 0;
        this.myTokenStart = 0;
    }

    @Override
    public int getState() {
        if (this.myTokenType == null) {
            this.locateToken();
        }
        return this.myState;
    }

    @Override
    public IElementType getTokenType() {
        if (this.myTokenType == null) {
            this.locateToken();
        }
        return this.myTokenType;
    }

    @Override
    public int getTokenStart() {
        if (this.myTokenType == null) {
            this.locateToken();
        }
        return this.myTokenStart;
    }

    @Override
    public int getTokenEnd() {
        if (this.myTokenType == null) {
            this.locateToken();
        }
        return super.getTokenStart();
    }

    @Override
    public void advance() {
        this.myTokenType = null;
        this.myState = 0;
        this.myTokenStart = 0;
    }

    private void locateToken() {
        if (this.myTokenType == null) {
            Lexer orig = this.getDelegate();
            this.myTokenType = orig.getTokenType();
            this.myTokenStart = orig.getTokenStart();
            this.myState = orig.getState();
            if (this.myTokenType == null) {
                return;
            }
            orig.advance();
            this.myTokenType = this.getMergeFunction().merge(this.myTokenType, orig);
        }
    }

    public Lexer getOriginal() {
        return this.getDelegate();
    }

    @Override
    public void restore(@NotNull LexerPosition position) {
        MyLexerPosition pos = (MyLexerPosition)position;
        this.getDelegate().restore(pos.getOriginalPosition());
        this.myTokenType = pos.getType();
        this.myTokenStart = pos.getOffset();
        this.myState = pos.getOldState();
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getDelegate() + "]";
    }

    @Override
    @NotNull
    public LexerPosition getCurrentPosition() {
        return new MyLexerPosition(this.myTokenStart, this.myTokenType, this.getDelegate().getCurrentPosition(), this.myState);
    }

    private static class MyLexerPosition
    implements LexerPosition {
        private final int myOffset;
        private final IElementType myTokenType;
        private final LexerPosition myOriginalPosition;
        private final int myOldState;

        MyLexerPosition(int offset, IElementType tokenType, LexerPosition originalPosition, int oldState) {
            this.myOffset = offset;
            this.myTokenType = tokenType;
            this.myOriginalPosition = originalPosition;
            this.myOldState = oldState;
        }

        @Override
        public int getOffset() {
            return this.myOffset;
        }

        @Override
        public int getState() {
            return this.myOriginalPosition.getState();
        }

        public IElementType getType() {
            return this.myTokenType;
        }

        public LexerPosition getOriginalPosition() {
            return this.myOriginalPosition;
        }

        public int getOldState() {
            return this.myOldState;
        }
    }
}

