/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.formatting;

import fleet.com.intellij.formatting.Indent;
import org.jetbrains.annotations.NonNls;

public class IndentImpl
extends Indent {
    private final boolean myIsAbsolute;
    private final boolean myRelativeToDirectParent;
    private final Indent.Type myType;
    private final int mySpaces;
    private final boolean myEnforceIndentToChildren;

    public IndentImpl(Indent.Type type, boolean absolute, boolean relativeToDirectParent) {
        this(type, absolute, 0, relativeToDirectParent, false);
    }

    public IndentImpl(Indent.Type type, boolean absolute, int spaces, boolean relativeToDirectParent, boolean enforceIndentToChildren) {
        this.myType = type;
        this.myIsAbsolute = absolute;
        this.mySpaces = spaces;
        this.myRelativeToDirectParent = relativeToDirectParent;
        this.myEnforceIndentToChildren = enforceIndentToChildren;
    }

    @Override
    public Indent.Type getType() {
        return this.myType;
    }

    public int getSpaces() {
        return this.mySpaces;
    }

    public boolean isAbsolute() {
        return this.myIsAbsolute;
    }

    public boolean isRelativeToDirectParent() {
        return this.myRelativeToDirectParent;
    }

    public boolean isEnforceIndentToChildren() {
        return this.myEnforceIndentToChildren;
    }

    @NonNls
    public String toString() {
        if (this.myType == Indent.Type.SPACES) {
            return "<Indent: SPACES(" + this.mySpaces + ")>";
        }
        return "<Indent: " + this.myType + (this.myIsAbsolute ? ":ABSOLUTE " : "") + (this.myRelativeToDirectParent ? " relative to direct parent " : "") + (this.myEnforceIndentToChildren ? " enforce indent to children" : "") + ">";
    }
}

