/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.formatting;

import fleet.com.intellij.formatting.Formatter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class Indent {
    public abstract Type getType();

    public static Indent getNormalIndent() {
        return Formatter.getInstance().getNormalIndent(false);
    }

    public static Indent getNormalIndent(boolean relativeToDirectParent) {
        return Formatter.getInstance().getNormalIndent(relativeToDirectParent);
    }

    public static Indent getNoneIndent() {
        return Formatter.getInstance().getNoneIndent();
    }

    public static Indent getAbsoluteNoneIndent() {
        return Formatter.getInstance().getAbsoluteNoneIndent();
    }

    public static Indent getAbsoluteLabelIndent() {
        return Formatter.getInstance().getAbsoluteLabelIndent();
    }

    public static Indent getLabelIndent() {
        return Formatter.getInstance().getLabelIndent();
    }

    public static Indent getContinuationIndent() {
        return Formatter.getInstance().getContinuationIndent(false);
    }

    public static Indent getContinuationIndent(boolean relativeToDirectParent) {
        return Formatter.getInstance().getContinuationIndent(relativeToDirectParent);
    }

    public static Indent getContinuationWithoutFirstIndent() {
        return Formatter.getInstance().getContinuationWithoutFirstIndent(false);
    }

    public static Indent getContinuationWithoutFirstIndent(boolean relativeToDirectParent) {
        return Formatter.getInstance().getContinuationWithoutFirstIndent(relativeToDirectParent);
    }

    public static Indent getSpaceIndent(int spaces) {
        return Formatter.getInstance().getSpaceIndent(spaces, false);
    }

    public static Indent getSpaceIndent(int spaces, boolean relativeToDirectParent) {
        return Formatter.getInstance().getSpaceIndent(spaces, relativeToDirectParent);
    }

    public static Indent getIndent(@NotNull Type type, boolean relativeToDirectParent, boolean enforceIndentToChildren) {
        return Formatter.getInstance().getIndent(type, relativeToDirectParent, enforceIndentToChildren);
    }

    public static Indent getIndent(@NotNull Type type, int spaces, boolean relativeToDirectParent, boolean enforceIndentToChildren) {
        return Formatter.getInstance().getIndent(type, spaces, relativeToDirectParent, enforceIndentToChildren);
    }

    public static Indent getSmartIndent(Type type) {
        return Formatter.getInstance().getSmartIndent(type);
    }

    public static final class Type {
        private final String myName;
        public static final Type SPACES = new Type("SPACES");
        public static final Type NONE = new Type("NONE");
        public static final Type LABEL = new Type("LABEL");
        public static final Type NORMAL = new Type("NORMAL");
        public static final Type CONTINUATION = new Type("CONTINUATION");
        public static final Type CONTINUATION_WITHOUT_FIRST = new Type("CONTINUATION_WITHOUT_FIRST");

        private Type(@NonNls String name) {
            this.myName = name;
        }

        public String toString() {
            return this.myName;
        }
    }
}

