/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.doctor.entity;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.doctor.entity.VersionSerializer;

@Serializable(with=VersionSerializer.class)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u001a\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0007\u0018\u0000 &2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001&B;\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\tB\u000f\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bJ\u0011\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u0000H\u0096\u0002J\u0013\u0010!\u001a\u00020\"2\b\u0010 \u001a\u0004\u0018\u00010#H\u0096\u0002J\b\u0010$\u001a\u00020\u0003H\u0016J\b\u0010%\u001a\u00020\u0007H\u0016R\u0015\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\u0011\u0010\rR\u0011\u0010\u0012\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0015\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\u0015\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010R\u0011\u0010\u0017\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0014R\u0011\u0010\u0019\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0010R\u0013\u0010\u001b\u001a\u0004\u0018\u00010\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0010R\u0013\u0010\u001d\u001a\u0004\u0018\u00010\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0010\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/doctor/entity/Version;", "", "major", "", "minor", "patch", "prerelease", "", "meta", "(IILjava/lang/Integer;Ljava/lang/String;Ljava/lang/String;)V", "version", "(Ljava/lang/String;)V", "getMajor", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getMeta", "()Ljava/lang/String;", "getMinor", "nextMinorVersion", "getNextMinorVersion", "()Lorg/jetbrains/kotlin/doctor/entity/Version;", "getPatch", "getPrerelease", "prevMinorVersion", "getPrevMinorVersion", "rawString", "getRawString", "semVersion", "getSemVersion", "semVersionShort", "getSemVersionShort", "compareTo", "other", "equals", "", "", "hashCode", "toString", "Companion", "kdoctor-checks"})
public final class Version
implements Comparable<Version> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String rawString;
    @Nullable
    private final Integer major;
    @Nullable
    private final Integer minor;
    @Nullable
    private final Integer patch;
    @Nullable
    private final String prerelease;
    @Nullable
    private final String meta;
    @NotNull
    private static final Regex regex = new Regex("(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.?(0|[1-9]\\d*)*(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?");
    private static final int less = -1;
    private static final int greater = 1;
    private static final int equal = 0;
    @NotNull
    private static final Version unknown = new Version("?");

    @NotNull
    public final String getRawString() {
        return this.rawString;
    }

    @Nullable
    public final Integer getMajor() {
        return this.major;
    }

    @Nullable
    public final Integer getMinor() {
        return this.minor;
    }

    @Nullable
    public final Integer getPatch() {
        return this.patch;
    }

    @Nullable
    public final String getPrerelease() {
        return this.prerelease;
    }

    @Nullable
    public final String getMeta() {
        return this.meta;
    }

    public Version(int major, int minor, @Nullable Integer patch, @Nullable String prerelease, @Nullable String meta) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.prerelease = prerelease;
        this.meta = meta;
        String version = major + "." + minor;
        Integer n = patch;
        version = version + (String)(n != null ? "." + n : "");
        String string = prerelease;
        version = version + (String)(string != null ? "-" + string : "");
        String string2 = meta;
        version = version + (String)(string2 != null ? "+" + string2 : "");
        this.rawString = version;
    }

    public /* synthetic */ Version(int n, int n2, Integer n3, String string, String string2, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 4) != 0) {
            n3 = null;
        }
        if ((n4 & 8) != 0) {
            string = null;
        }
        if ((n4 & 0x10) != 0) {
            string2 = null;
        }
        this(n, n2, n3, string, string2);
    }

    public Version(@NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        this.rawString = version;
        MatchResult match = Regex.find$default((Regex)regex, (CharSequence)this.rawString, (int)0, (int)2, null);
        Object object = match;
        this.major = object != null && (object = object.getGroups()) != null && (object = object.get(1)) != null && (object = object.getValue()) != null ? StringsKt.toIntOrNull((String)object) : null;
        Object object2 = match;
        this.minor = object2 != null && (object2 = object2.getGroups()) != null && (object2 = object2.get(2)) != null && (object2 = object2.getValue()) != null ? StringsKt.toIntOrNull((String)object2) : null;
        Object object3 = match;
        this.patch = object3 != null && (object3 = object3.getGroups()) != null && (object3 = object3.get(3)) != null && (object3 = object3.getValue()) != null ? StringsKt.toIntOrNull((String)object3) : null;
        MatchResult matchResult = match;
        this.prerelease = matchResult != null && (matchResult = matchResult.getGroups()) != null && (matchResult = matchResult.get(4)) != null ? matchResult.getValue() : null;
        MatchResult matchResult2 = match;
        this.meta = matchResult2 != null && (matchResult2 = matchResult2.getGroups()) != null && (matchResult2 = matchResult2.get(5)) != null ? matchResult2.getValue() : null;
    }

    @NotNull
    public final Version getPrevMinorVersion() {
        if (this.major == null || this.minor == null) {
            return unknown;
        }
        return new Version(this.major, Math.max(this.minor - 1, 0), 0, null, null, 24, null);
    }

    @NotNull
    public final Version getNextMinorVersion() {
        if (this.major == null || this.minor == null) {
            return unknown;
        }
        return new Version(this.major, this.minor + 1, 0, null, null, 24, null);
    }

    @Override
    public int compareTo(@NotNull Version other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (this.getSemVersion() == null && other.getSemVersion() != null) {
            return -1;
        }
        if (this.getSemVersion() != null && other.getSemVersion() == null) {
            return 1;
        }
        if (Intrinsics.areEqual((Object)this.getSemVersion(), (Object)other.getSemVersion())) {
            return 0;
        }
        if (this.major != null && other.major != null && !Intrinsics.areEqual((Object)this.major, (Object)other.major)) {
            return Intrinsics.compare((int)this.major, (int)other.major);
        }
        if (this.minor != null && other.minor != null && !Intrinsics.areEqual((Object)this.minor, (Object)other.minor)) {
            return Intrinsics.compare((int)this.minor, (int)other.minor);
        }
        if (this.patch != null && other.patch == null) {
            return 1;
        }
        if (this.patch == null && other.patch != null) {
            return -1;
        }
        if (this.patch != null && other.patch != null && !Intrinsics.areEqual((Object)this.patch, (Object)other.patch)) {
            return Intrinsics.compare((int)this.patch, (int)other.patch);
        }
        if (this.prerelease != null && other.prerelease == null) {
            return -1;
        }
        if (this.prerelease == null && other.prerelease != null) {
            return 1;
        }
        if (this.prerelease != null && other.prerelease != null && !Intrinsics.areEqual((Object)this.prerelease, (Object)other.prerelease)) {
            return this.prerelease.compareTo(other.prerelease);
        }
        return 0;
    }

    public boolean equals(@Nullable Object other) {
        if (other instanceof Version) {
            return Intrinsics.areEqual((Object)this.rawString, (Object)((Version)other).rawString);
        }
        return false;
    }

    public int hashCode() {
        return this.rawString.hashCode();
    }

    @NotNull
    public String toString() {
        return this.rawString;
    }

    @Nullable
    public final String getSemVersionShort() {
        if (this.major == null || this.minor == null) {
            return null;
        }
        String semVersionShort = this.major + "." + this.minor;
        if (this.patch != null) {
            semVersionShort = semVersionShort + "." + this.patch;
        }
        return semVersionShort;
    }

    @Nullable
    public final String getSemVersion() {
        String string = this.getSemVersionShort();
        if (string == null) {
            return null;
        }
        Object semVersion = string;
        if (this.prerelease != null) {
            semVersion = (String)semVersion + "-" + this.prerelease;
        }
        if (this.meta != null) {
            semVersion = (String)semVersion + "+" + this.meta;
        }
        return semVersion;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eH\u00c6\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/doctor/entity/Version$Companion;", "", "()V", "equal", "", "greater", "less", "regex", "Lkotlin/text/Regex;", "unknown", "Lorg/jetbrains/kotlin/doctor/entity/Version;", "getUnknown", "()Lorg/jetbrains/kotlin/doctor/entity/Version;", "serializer", "Lkotlinx/serialization/KSerializer;", "kdoctor-checks"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Version getUnknown() {
            return unknown;
        }

        @NotNull
        public final KSerializer<Version> serializer() {
            return new VersionSerializer();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

