/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.doctor.diagnostics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.doctor.diagnostics.Diagnostic;
import org.jetbrains.kotlin.doctor.diagnostics.GradleProjectDiagnostic;
import org.jetbrains.kotlin.doctor.diagnostics.SuggestFixKt;
import org.jetbrains.kotlin.doctor.entity.BinApplication;
import org.jetbrains.kotlin.doctor.entity.Diagnosis;
import org.jetbrains.kotlin.doctor.entity.EnvironmentPiece;
import org.jetbrains.kotlin.doctor.entity.ProcessResult;
import org.jetbrains.kotlin.doctor.entity.System;
import org.jetbrains.kotlin.doctor.entity.Version;
import org.jetbrains.kotlin.doctor.logging.KdoctorLogger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\u00020\fH\u0096@\u00a2\u0006\u0002\u0010\rJ0\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000fH\u0002J\b\u0010\u0015\u001a\u00020\u0005H\u0002R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/doctor/diagnostics/GradleProjectDiagnostic;", "Lorg/jetbrains/kotlin/doctor/diagnostics/Diagnostic;", "system", "Lorg/jetbrains/kotlin/doctor/entity/System;", "path", "", "(Lorg/jetbrains/kotlin/doctor/entity/System;Ljava/lang/String;)V", "projectPath", "title", "getTitle", "()Ljava/lang/String;", "diagnose", "Lorg/jetbrains/kotlin/doctor/entity/Diagnosis;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findPluginVersions", "", "Lorg/jetbrains/kotlin/doctor/entity/BinApplication;", "plugins", "", "artifacts", "Lorg/jetbrains/kotlin/doctor/diagnostics/GradleProjectDiagnostic$PluginArtifact;", "printPluginsInitScript", "PluginArtifact", "kdoctor-checks"})
@SourceDebugExtension(value={"SMAP\nGradleProjectDiagnostic.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleProjectDiagnostic.kt\norg/jetbrains/kotlin/doctor/diagnostics/GradleProjectDiagnostic\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,226:1\n1#2:227\n288#3,2:228\n1045#3:232\n1549#3:233\n1620#3,3:234\n1549#3:239\n1620#3,3:240\n288#3,2:248\n288#3,2:250\n288#3,2:252\n1313#4,2:230\n37#5,2:237\n37#5,2:243\n125#6:245\n152#6,2:246\n154#6:254\n*S KotlinDebug\n*F\n+ 1 GradleProjectDiagnostic.kt\norg/jetbrains/kotlin/doctor/diagnostics/GradleProjectDiagnostic\n*L\n65#1:228,2\n148#1:232\n152#1:233\n152#1:234,3\n162#1:239\n162#1:240,3\n206#1:248,2\n208#1:250,2\n215#1:252,2\n131#1:230,2\n152#1:237,2\n162#1:243,2\n204#1:245\n204#1:246,2\n204#1:254\n*E\n"})
public final class GradleProjectDiagnostic
extends Diagnostic {
    @NotNull
    private final System system;
    @NotNull
    private final String projectPath;
    @NotNull
    private final String title;

    public GradleProjectDiagnostic(@NotNull System system, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)system, (String)"system");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.system = system;
        this.projectPath = StringsKt.removeSuffix((String)path, (CharSequence)"/");
        this.title = "Project: " + this.projectPath;
    }

    @Override
    @NotNull
    public String getTitle() {
        return this.title;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    @Nullable
    public Object diagnose(@NotNull Continuation<? super Diagnosis> var1_1) {
        if (!(var1_1 instanceof diagnose.1)) ** GOTO lbl-1000
        var29_2 = var1_1;
        if ((var29_2.label & -2147483648) != 0) {
            var29_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                /* synthetic */ Object result;
                final /* synthetic */ GradleProjectDiagnostic this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.diagnose((Continuation<? super Diagnosis>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var30_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                result = new Diagnosis.Builder(this.getTitle());
                $continuation.L$0 = this;
                $continuation.L$1 = result;
                $continuation.label = 1;
                v0 = this.system.list(this.projectPath, (Continuation<? super List<String>>)$continuation);
                if (v0 == var30_4) {
                    return var30_4;
                }
                ** GOTO lbl25
            }
            case 1: {
                result = (Diagnosis.Builder)$continuation.L$1;
                this = (GradleProjectDiagnostic)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl25:
                // 2 sources

                if ((projectPathFiles = (List)v0) == null) {
                    var4_7 = new String[]{"Path is not found"};
                    result.addFailure(var4_7);
                    return result.build();
                }
                if (!projectPathFiles.contains("settings.gradle") && !projectPathFiles.contains("settings.gradle.kts")) {
                    var4_8 = new String[]{this.projectPath + "/settings.gradle[.kts] is not found!", "Check project directory path"};
                    result.addFailure(var4_8);
                    return result.build();
                }
                gradleBin = new Ref.ObjectRef();
                gradleBin.element = this.projectPath + "/gradlew";
                $this$diagnose_u24lambda_u240 = this.system;
                $i$a$-run-GradleProjectDiagnostic$diagnose$2 = false;
                $continuation.L$0 = this;
                $continuation.L$1 = result;
                $continuation.L$2 = gradleBin;
                $continuation.L$3 = $this$diagnose_u24lambda_u240;
                $continuation.label = 2;
                v1 = $this$diagnose_u24lambda_u240.fileExists((String)gradleBin.element, (Continuation<? super Boolean>)$continuation);
                if (v1 == var30_4) {
                    return var30_4;
                }
                ** GOTO lbl54
            }
            case 2: {
                $i$a$-run-GradleProjectDiagnostic$diagnose$2 = false;
                $this$diagnose_u24lambda_u240 = (String[])$continuation.L$3;
                gradleBin = (Ref.ObjectRef)$continuation.L$2;
                result = (Diagnosis.Builder)$continuation.L$1;
                this = (GradleProjectDiagnostic)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl54:
                // 2 sources

                if (!((Boolean)v1).booleanValue()) ** GOTO lbl-1000
                $continuation.L$0 = this;
                $continuation.L$1 = result;
                $continuation.L$2 = gradleBin;
                $continuation.L$3 = null;
                $continuation.label = 3;
                v2 = $this$diagnose_u24lambda_u240.isExecutable((String)gradleBin.element, (Continuation<? super Boolean>)$continuation);
                if (v2 == var30_4) {
                    return var30_4;
                }
                ** GOTO lbl71
            }
            case 3: {
                $i$a$-run-GradleProjectDiagnostic$diagnose$2 = false;
                gradleBin = (Ref.ObjectRef)$continuation.L$2;
                result = (Diagnosis.Builder)$continuation.L$1;
                this = (GradleProjectDiagnostic)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl71:
                // 2 sources

                if (!((Boolean)v2).booleanValue()) {
                    v3 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v3 = false;
                }
                if (v3) {
                    var5_13 = new String[]{"Gradle wrapper is not executable", "Fix permissions of gradlew file with:", SuggestFixKt.suggestCommand("cd " + SuggestFixKt.escapePath(this.projectPath) + " && chmod +x ./gradlew")};
                    result.addFailure(var5_13);
                    return result.build();
                }
                gradleVersion = new Ref.ObjectRef();
                var25_15 = gradleVersion;
                $this$diagnose_u24lambda_u240 = new String[]{"-v"};
                $continuation.L$0 = this;
                $continuation.L$1 = result;
                $continuation.L$2 = gradleBin;
                $continuation.L$3 = gradleVersion;
                $continuation.L$4 = var25_15;
                $continuation.label = 4;
                v4 = this.system.execute((String)gradleBin.element, $this$diagnose_u24lambda_u240, (Continuation<? super ProcessResult>)$continuation);
                if (v4 == var30_4) {
                    return var30_4;
                }
                ** GOTO lbl101
            }
            case 4: {
                var25_15 = (Ref.ObjectRef)$continuation.L$4;
                gradleVersion = (Ref.ObjectRef)$continuation.L$3;
                gradleBin = (Ref.ObjectRef)$continuation.L$2;
                result = (Diagnosis.Builder)$continuation.L$1;
                this = (GradleProjectDiagnostic)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = var25_15.element = $result;
lbl101:
                // 2 sources

                if (((ProcessResult)gradleVersion.element).getCode() == 0) ** GOTO lbl132
                KdoctorLogger.DefaultImpls.d$default(this.system.getLogger(), null, (Function0)new Function0<String>((Ref.ObjectRef<ProcessResult>)gradleVersion){
                    final /* synthetic */ Ref.ObjectRef<ProcessResult> $gradleVersion;
                    {
                        this.$gradleVersion = $gradleVersion;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Gradlew version failed with " + ((ProcessResult)this.$gradleVersion.element).getCode() + " code and output:\n" + ((ProcessResult)this.$gradleVersion.element).getFullOutput();
                    }
                }, 1, null);
                gradleBin.element = "gradle";
                var25_15 = gradleVersion;
                $this$diagnose_u24lambda_u240 = new String[]{"-v"};
                $continuation.L$0 = this;
                $continuation.L$1 = result;
                $continuation.L$2 = gradleBin;
                $continuation.L$3 = gradleVersion;
                $continuation.L$4 = var25_15;
                $continuation.label = 5;
                v5 = this.system.execute((String)gradleBin.element, $this$diagnose_u24lambda_u240, (Continuation<? super ProcessResult>)$continuation);
                if (v5 == var30_4) {
                    return var30_4;
                }
                ** GOTO lbl124
            }
            case 5: {
                var25_15 = (Ref.ObjectRef)$continuation.L$4;
                gradleVersion = (Ref.ObjectRef)$continuation.L$3;
                gradleBin = (Ref.ObjectRef)$continuation.L$2;
                result = (Diagnosis.Builder)$continuation.L$1;
                this = (GradleProjectDiagnostic)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v5 = var25_15.element = $result;
lbl124:
                // 2 sources

                if (((ProcessResult)gradleVersion.element).getCode() != 0) {
                    KdoctorLogger.DefaultImpls.d$default(this.system.getLogger(), null, (Function0)new Function0<String>((Ref.ObjectRef<ProcessResult>)gradleVersion){
                        final /* synthetic */ Ref.ObjectRef<ProcessResult> $gradleVersion;
                        {
                            this.$gradleVersion = $gradleVersion;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return "Gradle version failed with " + ((ProcessResult)this.$gradleVersion.element).getCode() + " code and output:\n" + ((ProcessResult)this.$gradleVersion.element).getFullOutput();
                        }
                    }, 1, null);
                    $this$diagnose_u24lambda_u240 = new String[]{"Gradle is not found", "For better experience we recommend to use a Gradle wrapper"};
                    result.addFailure($this$diagnose_u24lambda_u240);
                    return result.build();
                }
                $this$diagnose_u24lambda_u240 = new String[]{"Project doesn't use a Gradle wrapper", "System Gradle was used for the analysis", "For better experience we recommend to use a Gradle wrapper"};
                result.addInfo($this$diagnose_u24lambda_u240);
lbl132:
                // 2 sources

                if ((v6 = ((ProcessResult)gradleVersion.element).getOutput()) == null) {
                    v6 = "";
                }
                $this$firstOrNull$iv = StringsKt.lines((CharSequence)v6);
                $i$f$firstOrNull = false;
                var10_22 = $this$firstOrNull$iv.iterator();
                while (var10_22.hasNext()) {
                    element$iv = var10_22.next();
                    it = (String)element$iv;
                    $i$a$-firstOrNull-GradleProjectDiagnostic$diagnose$gradle$1 = false;
                    if (!StringsKt.startsWith$default((String)it, (String)"Gradle ", (boolean)false, (int)2, null)) continue;
                    v7 = element$iv;
                    ** GOTO lbl145
                }
                v7 = null;
lbl145:
                // 2 sources

                $i$a$-run-GradleProjectDiagnostic$diagnose$2 = v7;
                if ($i$a$-run-GradleProjectDiagnostic$diagnose$2 != null) {
                    it = $i$a$-run-GradleProjectDiagnostic$diagnose$2;
                    $i$a$-let-GradleProjectDiagnostic$diagnose$gradle$2 = false;
                    v8 = new BinApplication("Gradle", new Version(StringsKt.substringAfter$default((String)it, (String)"Gradle ", null, (int)2, null)), null, 4, null);
                } else {
                    v8 = gradle = null;
                }
                if (gradle == null) {
                    $i$a$-run-GradleProjectDiagnostic$diagnose$2 = new String[]{"Gradle is not found", "For better experience we recommend to use a Gradle wrapper"};
                    result.addFailure($i$a$-run-GradleProjectDiagnostic$diagnose$2);
                    return result.build();
                }
                $i$a$-run-GradleProjectDiagnostic$diagnose$2 = new String[]{gradle.getName() + " (" + gradle.getVersion() + ")"};
                result.addSuccess($i$a$-run-GradleProjectDiagnostic$diagnose$2);
                $continuation.L$0 = this;
                $continuation.L$1 = result;
                $continuation.L$2 = gradleBin;
                $continuation.L$3 = gradle;
                $continuation.L$4 = null;
                $continuation.label = 6;
                v9 = this.system.writeTempFile(this.printPluginsInitScript(), (Continuation<? super String>)$continuation);
                ** if (v9 != var30_4) goto lbl170
lbl169:
                // 1 sources

                return var30_4;
lbl170:
                // 1 sources

                ** GOTO lbl180
            }
            case 6: {
                gradle = (BinApplication)$continuation.L$3;
                gradleBin = (Ref.ObjectRef)$continuation.L$2;
                result = (Diagnosis.Builder)$continuation.L$1;
                this = (GradleProjectDiagnostic)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v9 = $result;
lbl180:
                    // 2 sources

                    $this$firstOrNull$iv = (String)v9;
                }
                catch (CancellationException e) {
                    throw e;
                }
                catch (Exception e) {
                    $i$a$-let-GradleProjectDiagnostic$diagnose$gradle$2 = new String[]{"Error: impossible to create temporary file", "Check your file system write permissions", "'" + e.getMessage() + "'"};
                    result.addFailure($i$a$-let-GradleProjectDiagnostic$diagnose$gradle$2);
                    return result.build();
                }
                tempFile = $this$firstOrNull$iv;
                initScript = StringsKt.substringBeforeLast$default((String)tempFile, (String)"/", null, (int)2, null) + "/init.gradle.kts";
                $continuation.L$0 = this;
                $continuation.L$1 = result;
                $continuation.L$2 = gradleBin;
                $continuation.L$3 = gradle;
                $continuation.L$4 = tempFile;
                $continuation.L$5 = initScript;
                $continuation.label = 7;
                v10 = this.system.rm((String)initScript, (Continuation<? super Boolean>)$continuation);
                if (v10 == var30_4) {
                    return var30_4;
                }
                ** GOTO lbl210
            }
            case 7: {
                initScript = (String)$continuation.L$5;
                tempFile = (String)$continuation.L$4;
                gradle = (BinApplication)$continuation.L$3;
                gradleBin = (Ref.ObjectRef)$continuation.L$2;
                result = (Diagnosis.Builder)$continuation.L$1;
                this = (GradleProjectDiagnostic)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v10 = $result;
lbl210:
                // 2 sources

                $continuation.L$0 = this;
                $continuation.L$1 = result;
                $continuation.L$2 = gradleBin;
                $continuation.L$3 = gradle;
                $continuation.L$4 = initScript;
                $continuation.L$5 = null;
                $continuation.label = 8;
                v11 = this.system.mv(tempFile, (String)initScript, (Continuation<? super Boolean>)$continuation);
                if (v11 == var30_4) {
                    return var30_4;
                }
                ** GOTO lbl229
            }
            case 8: {
                initScript = (String)$continuation.L$4;
                gradle = (BinApplication)$continuation.L$3;
                gradleBin = (Ref.ObjectRef)$continuation.L$2;
                result = (Diagnosis.Builder)$continuation.L$1;
                this = (GradleProjectDiagnostic)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v11 = $result;
lbl229:
                // 2 sources

                if (!(initScriptRenamed = ((Boolean)v11).booleanValue())) {
                    $i$a$-let-GradleProjectDiagnostic$diagnose$gradle$2 = new String[]{"Error: impossible to prepare " + (String)initScript + " file", "Check your file system write permissions"};
                    result.addFailure($i$a$-let-GradleProjectDiagnostic$diagnose$gradle$2);
                    return result.build();
                }
                KdoctorLogger.DefaultImpls.d$default(this.system.getLogger(), "Created " + (String)initScript, null, 2, null);
                element$iv = new String[]{"-p", this.projectPath, "-I", initScript, "--no-configuration-cache"};
                $continuation.L$0 = this;
                $continuation.L$1 = result;
                $continuation.L$2 = gradleBin;
                $continuation.L$3 = gradle;
                $continuation.L$4 = initScript;
                $continuation.label = 9;
                v12 = this.system.execute((String)gradleBin.element, element$iv, (Continuation<? super ProcessResult>)$continuation);
                if (v12 == var30_4) {
                    return var30_4;
                }
                ** GOTO lbl253
            }
            case 9: {
                initScript = (String)$continuation.L$4;
                gradle = (BinApplication)$continuation.L$3;
                gradleBin = (Ref.ObjectRef)$continuation.L$2;
                result = (Diagnosis.Builder)$continuation.L$1;
                this = (GradleProjectDiagnostic)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v12 = $result;
lbl253:
                // 2 sources

                if ((runGradle = (ProcessResult)v12).getCode() != 0) {
                    KdoctorLogger.DefaultImpls.d$default(this.system.getLogger(), null, (Function0)new Function0<String>(runGradle){
                        final /* synthetic */ ProcessResult $runGradle;
                        {
                            this.$runGradle = $runGradle;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return "Gradle init script failed with " + this.$runGradle.getCode() + " code and output:\n" + this.$runGradle.getFullOutput();
                        }
                    }, 1, null);
                    if (StringsKt.startsWith$default((String)((String)gradleBin.element), (String)this.projectPath, (boolean)false, (int)2, null)) {
                        shorterGradleBin = "." + StringsKt.removePrefix((String)((String)gradleBin.element), (CharSequence)this.projectPath);
                        v13 = "cd " + SuggestFixKt.escapePath(this.projectPath) + " && " + SuggestFixKt.escapePath(shorterGradleBin) + " --info";
                    } else {
                        v13 = SuggestFixKt.escapePath((String)gradleBin.element) + " -p " + SuggestFixKt.escapePath(this.projectPath) + " --info";
                    }
                    gradleInfo = v13;
                    shorterGradleBin = new String[]{"Gradle error", "Run in terminal:", SuggestFixKt.suggestCommand(gradleInfo)};
                    result.addFailure((String[])shorterGradleBin);
                    return result.build();
                }
                v14 = runGradle.getOutput();
                if (v14 == null) {
                    v14 = "";
                }
                gradleOutput = v14;
                pluginArtifacts = new ArrayList<E>();
                appliedPluginsMap = new LinkedHashMap<K, V>();
                $this$forEach$iv = StringsKt.lineSequence((CharSequence)gradleOutput);
                $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    l = (String)element$iv;
                    $i$a$-forEach-GradleProjectDiagnostic$diagnose$6 = false;
                    if (!StringsKt.contains$default((CharSequence)l, (CharSequence)"kdoctor >>> ", (boolean)false, (int)2, null)) continue;
                    line = StringsKt.substringAfter$default((String)l, (String)"kdoctor >>> ", null, (int)2, null);
                    if (StringsKt.startsWith$default((String)line, (String)"DEP ", (boolean)false, (int)2, null)) {
                        var21_48 = new String[]{":"};
                        var22_49 = StringsKt.split$default((CharSequence)StringsKt.substringAfter$default((String)line, (String)"DEP ", null, (int)2, null), (String[])var21_48, (boolean)false, (int)0, (int)6, null);
                        group /* !! */  = (String)var22_49.get(0);
                        name = (String)var22_49.get(1);
                        version = (String)var22_49.get(2);
                        pluginArtifacts.add(new PluginArtifact((String)group /* !! */ , name, version));
                        continue;
                    }
                    group /* !! */  = new String[]{"="};
                    var22_49 = StringsKt.split$default((CharSequence)line, (String[])group /* !! */ , (boolean)false, (int)0, (int)6, null);
                    pluginId = (String)var22_49.get(0);
                    pluginVersion = (String)var22_49.get(1);
                    if (appliedPluginsMap.containsKey(pluginId) && Intrinsics.areEqual((Object)pluginVersion, (Object)"null")) continue;
                    appliedPluginsMap.put(pluginId, pluginVersion);
                }
                $this$sortedBy$iv = this.findPluginVersions(appliedPluginsMap, pluginArtifacts);
                $i$f$sortedBy = false;
                appliedPlugins = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        BinApplication it = (BinApplication)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)it.getName());
                        it = (BinApplication)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
                    }
                });
                if (((Collection)appliedPlugins).isEmpty() == false) {
                    var15_33 = new SpreadBuilder(2);
                    var15_33.add((Object)"Gradle plugins:");
                    $i$f$sortedBy = appliedPlugins;
                    var26_54 = var15_33;
                    var25_15 = result;
                    $i$f$map = false;
                    l = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (E item$iv$iv : $this$mapTo$iv$iv) {
                        pluginVersion = (BinApplication)item$iv$iv;
                        var27_55 = destination$iv$iv;
                        $i$a$-map-GradleProjectDiagnostic$diagnose$7 = false;
                        var27_55.add((EnvironmentPiece)(it.getName() + ":" + it.getVersion()));
                    }
                    var27_55 = (List)destination$iv$iv;
                    $this$toTypedArray$iv = var27_55;
                    $i$f$toTypedArray = false;
                    thisCollection$iv = $this$toTypedArray$iv;
                    var26_54.addSpread((Object)thisCollection$iv.toArray(new String[0]));
                    var25_15.addSuccess((String[])var15_33.toArray((Object[])new String[var15_33.size()]));
                } else {
                    var15_33 = new SpreadBuilder[]{"Gradle plugins are not found"};
                    result.addWarning((String[])var15_33);
                }
                var15_33 = new SpreadBuilder(2);
                var15_33.add((Object)EnvironmentPiece.Companion.Gradle(gradle.getVersion()));
                $this$toTypedArray$iv = appliedPlugins;
                var26_54 = var15_33;
                var25_15 = result;
                $i$f$map = false;
                thisCollection$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (E item$iv$iv : $this$mapTo$iv$iv) {
                    it = (BinApplication)item$iv$iv;
                    var27_55 = destination$iv$iv;
                    $i$a$-map-GradleProjectDiagnostic$diagnose$8 = false;
                    var27_55.add(EnvironmentPiece.Companion.GradlePlugin(it.getName(), it.getVersion()));
                }
                $this$toTypedArray$iv = var27_55 = (List)destination$iv$iv;
                $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                var26_54.addSpread((Object)thisCollection$iv.toArray(new EnvironmentPiece[0]));
                var25_15.addEnvironment((EnvironmentPiece[])var15_33.toArray((Object[])new EnvironmentPiece[var15_33.size()]));
                $continuation.L$0 = result;
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.L$3 = null;
                $continuation.L$4 = null;
                $continuation.label = 10;
                v15 = this.system.rm((String)initScript, (Continuation<? super Boolean>)$continuation);
                if (v15 == var30_4) {
                    return var30_4;
                }
                ** GOTO lbl360
            }
            case 10: {
                result = (Diagnosis.Builder)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v15 = $result;
lbl360:
                // 2 sources

                return result.build();
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final String printPluginsInitScript() {
        return "fun ScriptHandler.printDependenciesOnConfigure() {\n    configurations.configureEach {\n        dependencies.configureEach {\n            println(\"kdoctor >>> DEP ${group}:${name}:${version}\")\n        }\n    }\n}\n\ngradle.beforeSettings {\n    settings.buildscript.printDependenciesOnConfigure()\n}\n\ngradle.settingsEvaluated {\n    settings.pluginManagement.resolutionStrategy.eachPlugin {\n        println(\"kdoctor >>> ${requested.id}=${requested.version}\")\n    }\n    val possibleSettingsPlugins = arrayOf(\n        \"org.jetbrains.amper.settings.plugin\",\n    )\n    for (pluginId in possibleSettingsPlugins) {\n        if (!settings.pluginManager.hasPlugin(pluginId)) continue\n        println(\"kdoctor >>> ${pluginId}=null\")\n    }\n}\n\nallprojects {\n    project.buildscript.printDependenciesOnConfigure()\n}";
    }

    /*
     * WARNING - void declaration
     */
    private final List<BinApplication> findPluginVersions(Map<String, String> plugins, List<PluginArtifact> artifacts) {
        void $this$mapTo$iv$iv;
        Map<String, String> $this$map$iv = plugins;
        boolean $i$f$map = false;
        Map<String, String> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            BinApplication binApplication;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String id = (String)entry.getKey();
            String version = (String)entry.getValue();
            if (Intrinsics.areEqual((Object)version, (Object)"null")) {
                PluginArtifact pluginArtifact;
                Object object;
                PluginArtifact pluginArtifact2;
                Object v0;
                PluginArtifact it;
                boolean $i$f$firstOrNull;
                Iterable $this$firstOrNull$iv;
                block12: {
                    $this$firstOrNull$iv = artifacts;
                    $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        it = (PluginArtifact)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)(id + ".gradle.plugin"))) continue;
                        v0 = element$iv;
                        break block12;
                    }
                    v0 = null;
                }
                if ((pluginArtifact2 = (PluginArtifact)v0) == null) {
                    if (StringsKt.startsWith$default((String)id, (String)"org.jetbrains.kotlin.", (boolean)false, (int)2, null)) {
                        Object v3;
                        block13: {
                            $this$firstOrNull$iv = artifacts;
                            $i$f$firstOrNull = false;
                            for (Object element$iv : $this$firstOrNull$iv) {
                                it = (PluginArtifact)element$iv;
                                boolean bl3 = false;
                                boolean bl4 = Intrinsics.areEqual((Object)it.getGroup(), (Object)"org.jetbrains.kotlin") && Intrinsics.areEqual((Object)it.getName(), (Object)"kotlin-gradle-plugin") || Intrinsics.areEqual((Object)it.getName(), (Object)"org.jetbrains.kotlin.multiplatform.gradle.plugin");
                                if (!bl4) continue;
                                v3 = element$iv;
                                break block13;
                            }
                            v3 = null;
                        }
                        pluginArtifact2 = v3;
                    } else if (Intrinsics.areEqual((Object)id, (Object)"com.android.application") || Intrinsics.areEqual((Object)id, (Object)"com.android.library")) {
                        Object v4;
                        block14: {
                            $this$firstOrNull$iv = artifacts;
                            $i$f$firstOrNull = false;
                            for (Object element$iv : $this$firstOrNull$iv) {
                                it = (PluginArtifact)element$iv;
                                boolean bl5 = false;
                                if (!(Intrinsics.areEqual((Object)it.getGroup(), (Object)"com.android.tools.build") && Intrinsics.areEqual((Object)it.getName(), (Object)"gradle"))) continue;
                                v4 = element$iv;
                                break block14;
                            }
                            v4 = null;
                        }
                        pluginArtifact2 = v4;
                    } else {
                        KdoctorLogger.DefaultImpls.d$default(this.system.getLogger(), "Unknown plugin " + id, null, 2, null);
                        pluginArtifact2 = null;
                    }
                }
                if ((object = (pluginArtifact = pluginArtifact2)) == null || (object = ((PluginArtifact)object).getVersion()) == null) {
                    object = "null";
                }
                binApplication = new BinApplication(id, new Version((String)object), null, 4, null);
            } else {
                binApplication = new BinApplication(id, new Version(version), null, 4, null);
            }
            collection.add(binApplication);
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/doctor/diagnostics/GradleProjectDiagnostic$PluginArtifact;", "", "group", "", "name", "version", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getGroup", "()Ljava/lang/String;", "getName", "getVersion", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "kdoctor-checks"})
    public static final class PluginArtifact {
        @NotNull
        private final String group;
        @NotNull
        private final String name;
        @NotNull
        private final String version;

        public PluginArtifact(@NotNull String group, @NotNull String name, @NotNull String version) {
            Intrinsics.checkNotNullParameter((Object)group, (String)"group");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            this.group = group;
            this.name = name;
            this.version = version;
        }

        @NotNull
        public final String getGroup() {
            return this.group;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getVersion() {
            return this.version;
        }

        @NotNull
        public final String component1() {
            return this.group;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @NotNull
        public final String component3() {
            return this.version;
        }

        @NotNull
        public final PluginArtifact copy(@NotNull String group, @NotNull String name, @NotNull String version) {
            Intrinsics.checkNotNullParameter((Object)group, (String)"group");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            return new PluginArtifact(group, name, version);
        }

        public static /* synthetic */ PluginArtifact copy$default(PluginArtifact pluginArtifact, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = pluginArtifact.group;
            }
            if ((n & 2) != 0) {
                string2 = pluginArtifact.name;
            }
            if ((n & 4) != 0) {
                string3 = pluginArtifact.version;
            }
            return pluginArtifact.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "PluginArtifact(group=" + this.group + ", name=" + this.name + ", version=" + this.version + ")";
        }

        public int hashCode() {
            int result = this.group.hashCode();
            result = result * 31 + this.name.hashCode();
            result = result * 31 + this.version.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PluginArtifact)) {
                return false;
            }
            PluginArtifact pluginArtifact = (PluginArtifact)other;
            if (!Intrinsics.areEqual((Object)this.group, (Object)pluginArtifact.group)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)pluginArtifact.name)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.version, (Object)pluginArtifact.version);
        }
    }
}

