/*
 * Decompiled with CFR 0.152.
 */
package fleet.reporting.opentelemetry.exporters.jaeger;

import fleet.reporting.opentelemetry.TelemetrySeparationKt;
import fleet.reporting.opentelemetry.exporters.jaeger.JSpanData;
import fleet.reporting.opentelemetry.exporters.jaeger.JTraceData;
import fleet.reporting.opentelemetry.exporters.jaeger.JTraceDati;
import fleet.reporting.opentelemetry.exporters.jaeger.JaegerJsonFileSpanExporterKt;
import fleet.reporting.opentelemetry.exporters.jaeger.JaegerProtoKt;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.io.Closeable;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JvmStreamsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0010\u001a\u00020\rH\u0002J\u0016\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0012H\u0016J\u0012\u0010\u0015\u001a\u00020\u00122\b\u0010\u0016\u001a\u0004\u0018\u00010\u000fH\u0002J\b\u0010\u0017\u001a\u00020\u0012H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0007\u001a&\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0018\u00010\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lfleet/reporting/opentelemetry/exporters/jaeger/JaegerJsonFileSpanExporter;", "Lio/opentelemetry/sdk/trace/export/SpanExporter;", "resource", "Lio/opentelemetry/sdk/resources/Resource;", "basePath", "Ljava/nio/file/Path;", "(Lio/opentelemetry/sdk/resources/Resource;Ljava/nio/file/Path;)V", "collectedSpans", "", "Lio/opentelemetry/sdk/trace/data/SpanData;", "kotlin.jvm.PlatformType", "", "dataHolder", "Lfleet/reporting/opentelemetry/exporters/jaeger/JTraceDati;", "lastDir", "", "emptyData", "export", "Lio/opentelemetry/sdk/common/CompletableResultCode;", "spans", "", "flush", "subDir", "shutdown", "fleet.reporting.opentelemetry"})
@SourceDebugExtension(value={"SMAP\nJaegerJsonFileSpanExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JaegerJsonFileSpanExporter.kt\nfleet/reporting/opentelemetry/exporters/jaeger/JaegerJsonFileSpanExporter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 JvmStreams.kt\nkotlinx/serialization/json/JvmStreamsKt\n*L\n1#1,93:1\n1549#2:94\n1620#2,2:95\n1549#2:97\n1620#2,3:98\n1622#2:101\n1#3:102\n42#4:103\n*S KotlinDebug\n*F\n+ 1 JaegerJsonFileSpanExporter.kt\nfleet/reporting/opentelemetry/exporters/jaeger/JaegerJsonFileSpanExporter\n*L\n72#1:94\n72#1:95,2\n73#1:97\n73#1:98,3\n72#1:101\n85#1:103\n*E\n"})
public final class JaegerJsonFileSpanExporter
implements SpanExporter {
    @NotNull
    private final Resource resource;
    @NotNull
    private final Path basePath;
    @Nullable
    private volatile String lastDir;
    @NotNull
    private JTraceDati dataHolder;
    private final List<SpanData> collectedSpans;

    public JaegerJsonFileSpanExporter(@NotNull Resource resource, @NotNull Path basePath) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        this.resource = resource;
        this.basePath = basePath;
        JaegerJsonFileSpanExporterKt.access$getExporterRegistry$p().add(this);
        this.dataHolder = this.emptyData();
        this.collectedSpans = Collections.synchronizedList(new ArrayList());
    }

    @NotNull
    public CompletableResultCode export(@NotNull Collection<? extends SpanData> spans) {
        Intrinsics.checkNotNullParameter(spans, (String)"spans");
        String subDir = (String)TelemetrySeparationKt.getTelemetrySubdir().get();
        if (!Intrinsics.areEqual((Object)subDir, (Object)this.lastDir)) {
            this.flush(this.lastDir);
            this.lastDir = subDir;
        }
        List<SpanData> list = this.collectedSpans;
        Intrinsics.checkNotNullExpressionValue(list, (String)"collectedSpans");
        CollectionsKt.addAll((Collection)list, (Iterable)spans);
        CompletableResultCode completableResultCode = CompletableResultCode.ofSuccess();
        Intrinsics.checkNotNullExpressionValue((Object)completableResultCode, (String)"ofSuccess(...)");
        return completableResultCode;
    }

    @NotNull
    public CompletableResultCode flush() {
        return this.flush(this.lastDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public CompletableResultCode shutdown() {
        try {
            CompletableResultCode completableResultCode = this.flush();
            return completableResultCode;
        }
        finally {
            JaegerJsonFileSpanExporterKt.access$getExporterRegistry$p().remove(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final CompletableResultCode flush(String subDir) {
        Path path;
        Path path2;
        Json $this$mapTo$iv$iv;
        void $this$map$iv;
        ArrayList spansToFlush = new ArrayList(this.collectedSpans);
        this.collectedSpans.clear();
        JTraceDati $this$flush_u24lambda_u242 = this.dataHolder;
        boolean bl = false;
        Object object = $this$flush_u24lambda_u242.getData();
        JTraceDati jTraceDati = $this$flush_u24lambda_u242;
        boolean $i$f$map = false;
        void var10_13 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Collection<JSpanData> collection;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            void data1;
            JTraceData jTraceData = (JTraceData)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl2 = false;
            Iterable iterable = spansToFlush;
            String string = null;
            void var20_23 = data1;
            boolean $i$f$map2 = false;
            void var22_25 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it;
                SpanData spanData = (SpanData)item$iv$iv2;
                collection = destination$iv$iv2;
                boolean bl3 = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(JaegerProtoKt.wrapData((SpanData)it));
            }
            collection = (List)destination$iv$iv2;
            collection2.add(JTraceData.copy$default((JTraceData)var20_23, string, (List)collection, null, 5, null));
        }
        JTraceDati dataToFlush = jTraceDati.copy((List)destination$iv$iv);
        this.dataHolder = this.emptyData();
        if (spansToFlush.isEmpty()) {
            CompletableResultCode completableResultCode = CompletableResultCode.ofSuccess();
            Intrinsics.checkNotNullExpressionValue((Object)completableResultCode, (String)"ofSuccess(...)");
            return completableResultCode;
        }
        String string = subDir;
        if (string != null) {
            String it = string;
            boolean bl4 = false;
            path2 = this.basePath.resolve(it);
        } else {
            path2 = path = null;
        }
        if (path2 == null) {
            path = this.basePath;
        }
        Path subDirAwarePath = path;
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Path path3 = Files.createDirectories(subDirAwarePath, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"createDirectories(...)");
        Path spansFile = path3.resolve("spans.json");
        Object object2 = new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE};
        object2 = Files.newOutputStream(spansFile, object2);
        object = null;
        try {
            void $this$encodeToStream$iv;
            OutputStream os = (OutputStream)object2;
            boolean bl5 = false;
            $this$mapTo$iv$iv = JaegerProtoKt.getJaegerJson();
            Intrinsics.checkNotNull((Object)os);
            OutputStream stream$iv = os;
            boolean $i$f$encodeToStream = false;
            $this$encodeToStream$iv.getSerializersModule();
            JvmStreamsKt.encodeToStream((Json)$this$encodeToStream$iv, (SerializationStrategy)((SerializationStrategy)JTraceDati.Companion.serializer()), (Object)dataToFlush, (OutputStream)stream$iv);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)object);
        }
        CompletableResultCode completableResultCode = CompletableResultCode.ofSuccess();
        Intrinsics.checkNotNullExpressionValue((Object)completableResultCode, (String)"ofSuccess(...)");
        return completableResultCode;
    }

    private final JTraceDati emptyData() {
        Object object = this.resource.getAttribute(AttributeKey.stringKey((String)"service.name"));
        Intrinsics.checkNotNull((Object)object);
        return JaegerProtoKt.initEmptyData((String)object, (String)this.resource.getAttribute(AttributeKey.stringKey((String)"service.version")), (String)this.resource.getAttribute(AttributeKey.stringKey((String)"service.namespace")));
    }
}

