/*
 * Decompiled with CFR 0.152.
 */
package fleet.reporting.opentelemetry.exporters.fahrplan;

import fleet.reporting.opentelemetry.exporters.fahrplan.RecordingSession;
import fleet.reporting.shared.fahrplan.FahrplanEvent;
import fleet.tracing.DynamicTraceRecording;
import fleet.tracing.runtime.SpanKt;
import fleet.util.AtomicExtensionsKt;
import fleet.util.AtomicRef;
import fleet.util.AtomicRefKt;
import fleet.util.logging.BaseLogger;
import fleet.util.logging.KLogger;
import fleet.util.logging.KLoggers;
import fleet.util.serialization.SerializationKt;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributeType;
import io.opentelemetry.api.trace.SpanId;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.sdk.trace.data.LinkData;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.io.Closeable;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JvmStreamsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\bH\u0002J\"\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u000b2\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u0002J\u0014\u0010\u0016\u001a\u00020\u00102\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u0018J\u0016\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001bH\u0096@\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001bH\u0096@\u00a2\u0006\u0002\u0010\u001eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lfleet/reporting/opentelemetry/exporters/fahrplan/FahrplanSessionManager;", "Lfleet/tracing/DynamicTraceRecording;", "()V", "NO_TS", "", "activeSpans", "", "", "Lio/opentelemetry/sdk/trace/data/SpanData;", "currentSession", "Lfleet/util/AtomicRef;", "Lfleet/reporting/opentelemetry/exporters/fahrplan/RecordingSession;", "idGen", "logger", "Lfleet/util/logging/KLogger;", "reportSpanEnd", "", "session", "span", "reportSpanStartAndParents", "isParent", "", "spansArrived", "spans", "", "start", "output", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "stop", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fleet.reporting.opentelemetry"})
@SourceDebugExtension(value={"SMAP\nFahrplanTracing.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FahrplanTracing.kt\nfleet/reporting/opentelemetry/exporters/fahrplan/FahrplanSessionManager\n+ 2 KLoggers.kt\nfleet/util/logging/KLoggersKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 KLogger.kt\nfleet/util/logging/KLogger\n*L\n1#1,180:1\n22#2:181\n766#3:182\n857#3,2:183\n1855#3,2:188\n1855#3,2:190\n1#4:185\n13#5,2:186\n*S KotlinDebug\n*F\n+ 1 FahrplanTracing.kt\nfleet/reporting/opentelemetry/exporters/fahrplan/FahrplanSessionManager\n*L\n38#1:181\n53#1:182\n53#1:183,2\n68#1:188,2\n86#1:190,2\n59#1:186,2\n*E\n"})
public final class FahrplanSessionManager
implements DynamicTraceRecording {
    private final long NO_TS;
    @NotNull
    private final KLogger logger;
    @NotNull
    private final AtomicRef<RecordingSession> currentSession;
    @NotNull
    private final AtomicRef<Long> idGen;
    @NotNull
    private final Map<String, SpanData> activeSpans;

    public FahrplanSessionManager() {
        this.NO_TS = -1L;
        boolean $i$f$logger = false;
        this.logger = KLoggers.INSTANCE.logger(Reflection.getOrCreateKotlinClass(FahrplanSessionManager.class));
        this.currentSession = AtomicRefKt.AtomicRef(null);
        this.idGen = AtomicRefKt.AtomicRef((Object)0L);
        this.activeSpans = new LinkedHashMap();
    }

    @Nullable
    public Object start(@NotNull Path output, @NotNull Continuation<? super Unit> $completion) {
        this.currentSession.set((Object)new RecordingSession(String.valueOf(AtomicExtensionsKt.incrementAndGet(this.idGen)), output, null, null, 12, null));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public Object stop(@NotNull Continuation<? super Path> $completion) {
        Path path;
        RecordingSession recordingSession = (RecordingSession)this.currentSession.getAndSet(null);
        if (recordingSession != null) {
            Object object;
            Object object2;
            void $this$filterTo$iv$iv;
            RecordingSession session = recordingSession;
            boolean bl = false;
            LinkedList<Object> events = new LinkedList<Object>((Collection)session.getEvents());
            Iterable $this$filter$iv = events;
            boolean $i$f$filter22 = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                FahrplanEvent it = (FahrplanEvent)element$iv$iv;
                boolean bl2 = false;
                if (!(it.getTs() != this.NO_TS)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterator $i$f$filter22 = ((Iterable)((List)destination$iv$iv)).iterator();
            if (!$i$f$filter22.hasNext()) {
                object2 = null;
            } else {
                Object it = (FahrplanEvent)$i$f$filter22.next();
                boolean bl3 = false;
                it = Boxing.boxLong((long)it.getTs());
                while ($i$f$filter22.hasNext()) {
                    Object it2 = (FahrplanEvent)$i$f$filter22.next();
                    $i$a$-minOfOrNull-FahrplanSessionManager$stop$2$minTime$2 = false;
                    if (it.compareTo(it2 = (Comparable)Boxing.boxLong((long)it2.getTs())) <= 0) continue;
                    it = it2;
                }
                object2 = it;
            }
            Long l = (Long)object2;
            long minTime = l != null ? l : 0L;
            Iterator it2 = ((Iterable)events).iterator();
            if (!it2.hasNext()) {
                object = null;
            } else {
                Object it = (FahrplanEvent)it2.next();
                boolean bl4 = false;
                it = Boxing.boxLong((long)it.getTs());
                while (it2.hasNext()) {
                    Object it3 = (FahrplanEvent)it2.next();
                    $i$a$-maxOfOrNull-FahrplanSessionManager$stop$2$maxTime$1 = false;
                    if (it.compareTo(it3 = (Comparable)Boxing.boxLong((long)it3.getTs())) >= 0) continue;
                    it = it3;
                }
                object = it;
            }
            Long l2 = (Long)object;
            long maxTime = l2 != null ? l2 : 0L;
            events.addFirst(new FahrplanEvent.RecordingStart(session.getRecordingId(), minTime));
            events.addLast(new FahrplanEvent.RecordingEnd(session.getRecordingId(), maxTime));
            KLogger this_$iv = this.logger;
            boolean $i$f$info = false;
            if (this_$iv.isInfoEnabled()) {
                KLogger kLogger = this_$iv;
                boolean bl5 = false;
                kLogger.info((Object)("trace recording started, output: " + session.getOutputPath()));
            }
            Object object3 = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE};
            object3 = Files.newOutputStream(session.getOutputPath(), object3);
            Throwable throwable = null;
            try {
                OutputStream outputStream = (OutputStream)object3;
                boolean bl6 = false;
                byte[] byArray = "[".getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                outputStream.write(byArray);
                byte[] byArray2 = ",".getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
                byte[] comma = byArray2;
                boolean first = false;
                first = true;
                Iterable $this$forEach$iv = events;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    FahrplanEvent event = (FahrplanEvent)element$iv;
                    boolean bl7 = false;
                    if (!first) {
                        outputStream.write(comma);
                    }
                    FahrplanEvent substituted = event.getTs() == this.NO_TS && event instanceof FahrplanEvent.StartSpan ? (FahrplanEvent)FahrplanEvent.StartSpan.copy$default((FahrplanEvent.StartSpan)((FahrplanEvent.StartSpan)event), null, (long)minTime, null, (int)0, null, null, null, (boolean)false, (int)253, null) : event;
                    Json json = SerializationKt.getDefaultJson();
                    SerializationStrategy serializationStrategy = (SerializationStrategy)FahrplanEvent.Companion.serializer();
                    Intrinsics.checkNotNull((Object)outputStream);
                    JvmStreamsKt.encodeToStream((Json)json, (SerializationStrategy)serializationStrategy, (Object)substituted, (OutputStream)outputStream);
                    first = false;
                }
                byte[] byArray3 = "]".getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"getBytes(...)");
                outputStream.write(byArray3);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object3, (Throwable)throwable);
            }
            this.logger.info((Object)("trace recording stopped, output: " + session.getOutputPath()));
            path = session.getOutputPath();
        } else {
            path = null;
        }
        return path;
    }

    public final void spansArrived(@NotNull Collection<? extends SpanData> spans) {
        Intrinsics.checkNotNullParameter(spans, (String)"spans");
        RecordingSession session = (RecordingSession)this.currentSession.get();
        Iterable $this$forEach$iv = spans;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SpanData span = (SpanData)element$iv;
            boolean bl = false;
            if (span.hasEnded()) {
                this.activeSpans.remove(span.getSpanId());
                if (session == null || !session.getReportedSpanStarts().contains(span.getSpanId())) continue;
                this.reportSpanEnd(session, span);
                continue;
            }
            Map<String, SpanData> map = this.activeSpans;
            String string = span.getSpanId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSpanId(...)");
            map.put(string, span);
            if (session == null) continue;
            FahrplanSessionManager.reportSpanStartAndParents$default(this, span, session, false, 4, null);
        }
    }

    private final void reportSpanEnd(RecordingSession session, SpanData span) {
        ConcurrentLinkedDeque<FahrplanEvent> concurrentLinkedDeque = session.getEvents();
        String string = span.getSpanId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSpanId(...)");
        long l = span.getEndEpochNanos();
        StatusCode statusCode = span.getStatus().getStatusCode();
        concurrentLinkedDeque.addLast((FahrplanEvent)new FahrplanEvent.EndSpan(string, l, switch (statusCode == null ? -1 : WhenMappings.$EnumSwitchMapping$0[statusCode.ordinal()]) {
            case 1 -> (FahrplanEvent.EndSpan.Status)new FahrplanEvent.EndSpan.Status.Failed(span.getStatus().getStatusCode() + ":" + span.getStatus().getDescription());
            case 2 -> {
                if (Intrinsics.areEqual((Object)span.getStatus().getDescription(), (Object)"Cancelled")) {
                    yield (FahrplanEvent.EndSpan.Status)FahrplanEvent.EndSpan.Status.Cancelled.INSTANCE;
                }
                yield (FahrplanEvent.EndSpan.Status)FahrplanEvent.EndSpan.Status.Success.INSTANCE;
            }
            default -> (FahrplanEvent.EndSpan.Status)FahrplanEvent.EndSpan.Status.Success.INSTANCE;
        }));
    }

    private final void reportSpanStartAndParents(SpanData span, RecordingSession session, boolean isParent) {
        boolean isRootSpan = Intrinsics.areEqual((Object)span.getParentSpanId(), (Object)SpanId.getInvalid());
        if (!isRootSpan && !session.getReportedSpanStarts().contains(span.getParentSpanId())) {
            SpanData parentSpan = this.activeSpans.get(span.getParentSpanId());
            if (parentSpan == null) {
                BaseLogger.warn$default((BaseLogger)((BaseLogger)this.logger), (Throwable)new Throwable("!!! Parent span not found and will not be reported !!! Span: " + span.getName() + "[" + span.getSpanId() + "]. Parent span: " + span.getParentSpanId() + ". This probably means some span was started before OTel init"), null, (int)2, null);
            } else {
                this.reportSpanStartAndParents(parentSpan, session, true);
            }
        }
        Map meta = new LinkedHashMap();
        span.getAttributes().forEach((arg_0, arg_1) -> FahrplanSessionManager.reportSpanStartAndParents$lambda$8((Function2)new Function2<AttributeKey<?>, Object, Unit>(meta){
            final /* synthetic */ Map<String, String> $meta;
            {
                this.$meta = $meta;
                super(2);
            }

            public final void invoke(AttributeKey<?> k, Object v) {
                if (k.getType() == AttributeType.STRING) {
                    Map<String, String> map = this.$meta;
                    String string = k.getKey();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKey(...)");
                    String string2 = string;
                    Intrinsics.checkNotNull((Object)v, (String)"null cannot be cast to non-null type kotlin.String");
                    String string3 = (String)v;
                    map.put(string2, string3);
                }
            }
        }, arg_0, arg_1));
        Set<String> set = session.getReportedSpanStarts();
        String string = span.getSpanId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSpanId(...)");
        set.add(string);
        ConcurrentLinkedDeque<FahrplanEvent> concurrentLinkedDeque = session.getEvents();
        String string2 = span.getSpanId();
        long l = isParent ? -1L : span.getStartEpochNanos();
        String string3 = span.getName();
        Long l2 = (Long)span.getAttributes().get(SpanKt.getTHREAD_ID_KEY());
        int n = l2 != null ? (int)l2.longValue() : 0;
        Boolean bl = (Boolean)span.getAttributes().get(SpanKt.getSCOPE_KEY());
        if (bl == null) {
            bl = false;
        }
        Boolean bl2 = bl;
        String string4 = isRootSpan ? null : span.getParentSpanId();
        List list = span.getLinks();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getLinks(...)");
        LinkData linkData = (LinkData)CollectionsKt.firstOrNull((List)list);
        String string5 = linkData != null && (linkData = linkData.getSpanContext()) != null ? linkData.getSpanId() : null;
        Intrinsics.checkNotNull((Object)string2);
        Intrinsics.checkNotNull((Object)string3);
        concurrentLinkedDeque.addLast((FahrplanEvent)new FahrplanEvent.StartSpan(string2, l, string3, n, string4, meta, string5, bl2.booleanValue()));
    }

    static /* synthetic */ void reportSpanStartAndParents$default(FahrplanSessionManager fahrplanSessionManager, SpanData spanData, RecordingSession recordingSession, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        fahrplanSessionManager.reportSpanStartAndParents(spanData, recordingSession, bl);
    }

    public <R> R fold(R initial, @NotNull Function2<? super R, ? super CoroutineContext.Element, ? extends R> operation) {
        return (R)DynamicTraceRecording.DefaultImpls.fold((DynamicTraceRecording)this, initial, operation);
    }

    @Nullable
    public <E extends CoroutineContext.Element> E get(@NotNull CoroutineContext.Key<E> key) {
        return (E)DynamicTraceRecording.DefaultImpls.get((DynamicTraceRecording)this, key);
    }

    @NotNull
    public CoroutineContext minusKey(@NotNull CoroutineContext.Key<?> key) {
        return DynamicTraceRecording.DefaultImpls.minusKey((DynamicTraceRecording)this, key);
    }

    @NotNull
    public CoroutineContext plus(@NotNull CoroutineContext context) {
        return DynamicTraceRecording.DefaultImpls.plus((DynamicTraceRecording)this, (CoroutineContext)context);
    }

    private static final void reportSpanStartAndParents$lambda$8(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[StatusCode.values().length];
            try {
                nArray[StatusCode.ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StatusCode.OK.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

