/*
 * Decompiled with CFR 0.152.
 */
package fleet.reporting.opentelemetry;

import fleet.reporting.opentelemetry.FileMetricExporter;
import fleet.reporting.opentelemetry.TelemetrySeparationKt;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.DoublePointData;
import io.opentelemetry.sdk.metrics.data.HistogramPointData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.data.MetricDataType;
import io.opentelemetry.sdk.metrics.data.SummaryPointData;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\b\u0010\n\u001a\u00020\u0006H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0003H\u0002J\b\u0010\u0010\u001a\u00020\u0006H\u0016J\f\u0010\u0011\u001a\u00020\u0003*\u00020\u0003H\u0002J\f\u0010\u0012\u001a\u00020\u0003*\u00020\u0003H\u0002J\f\u0010\u0013\u001a\u00020\u0003*\u00020\u0014H\u0002J\f\u0010\u0013\u001a\u00020\u0003*\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lfleet/reporting/opentelemetry/FileMetricExporter;", "Lio/opentelemetry/sdk/metrics/export/MetricExporter;", "dirPath", "", "(Ljava/lang/String;)V", "export", "Lio/opentelemetry/sdk/common/CompletableResultCode;", "metrics", "", "Lio/opentelemetry/sdk/metrics/data/MetricData;", "flush", "getAggregationTemporality", "Lio/opentelemetry/sdk/metrics/data/AggregationTemporality;", "instrumentType", "Lio/opentelemetry/sdk/metrics/InstrumentType;", "getPreambule", "shutdown", "addQuotesToKeys", "removeStructNames", "toJson", "Lio/opentelemetry/api/common/Attributes;", "Companion", "fleet.reporting.opentelemetry"})
@SourceDebugExtension(value={"SMAP\nFileMetricExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileMetricExporter.kt\nfleet/reporting/opentelemetry/FileMetricExporter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,126:1\n1#2:127\n1#2:148\n819#3:128\n847#3,2:129\n1477#3:131\n1502#3,3:132\n1505#3,3:142\n1864#3,3:149\n372#4,7:135\n215#5,2:145\n574#5:147\n*S KotlinDebug\n*F\n+ 1 FileMetricExporter.kt\nfleet/reporting/opentelemetry/FileMetricExporter\n*L\n81#1:148\n34#1:128\n34#1:129,2\n34#1:131\n34#1:132,3\n34#1:142,3\n81#1:149,3\n34#1:135,7\n34#1:145,2\n81#1:147\n*E\n"})
public final class FileMetricExporter
implements MetricExporter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String dirPath;
    @NotNull
    private static final Regex keyPattern = new Regex("[{,]\\s*([\\w.]+)=");
    @NotNull
    private static final Regex structPattern = new Regex("\\w+\\{");

    public FileMetricExporter(@NotNull String dirPath) {
        Intrinsics.checkNotNullParameter((Object)dirPath, (String)"dirPath");
        this.dirPath = dirPath;
    }

    @NotNull
    public AggregationTemporality getAggregationTemporality(@NotNull InstrumentType instrumentType) {
        Intrinsics.checkNotNullParameter((Object)instrumentType, (String)"instrumentType");
        return AggregationTemporality.DELTA;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public CompletableResultCode export(@NotNull Collection<? extends MetricData> metrics) {
        void $this$forEach$iv;
        OpenOption[] $this$getOrPut$iv$iv$iv2;
        void $this$groupByTo$iv$iv;
        OpenOption[] $this$groupBy$iv;
        MetricData it;
        void $this$filterNotTo$iv$iv;
        Object it2;
        Object object;
        block14: {
            block13: {
                Intrinsics.checkNotNullParameter(metrics, (String)"metrics");
                object = (String)TelemetrySeparationKt.getTelemetrySubdir().get();
                if (object == null) break block13;
                it2 = object;
                boolean bl = false;
                String[] stringArray = new String[]{it2};
                Path path = Path.of(this.dirPath, stringArray);
                object = path;
                if (path != null) break block14;
            }
            object = Path.of(this.dirPath, new String[0]);
        }
        Object subDirAwarePath = object;
        CompletableResultCode result = new CompletableResultCode();
        Iterable $this$filterNot$iv = metrics;
        boolean $i$f$filterNot = false;
        it2 = $this$filterNot$iv;
        OpenOption[] destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (MetricData)element$iv$iv;
            boolean bl = false;
            if (it.isEmpty()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$filterNotTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            it = (MetricData)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getName();
            $this$getOrPut$iv$iv$iv2 = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv2.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv2.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            boolean isFirstEntry;
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String name2 = (String)entry.getKey();
            List metricData = (List)entry.getValue();
            if (metricData.isEmpty()) continue;
            Path metricPath = subDirAwarePath.resolve(name2 + ".json");
            Intrinsics.checkNotNull((Object)metricPath);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            boolean bl3 = isFirstEntry = !Files.exists(metricPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
            if (isFirstEntry) {
                try {
                    $this$getOrPut$iv$iv$iv2 = new OpenOption[]{StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE};
                    PathsKt.writeText((Path)PathsKt.createParentDirectories((Path)metricPath, (FileAttribute[])new FileAttribute[0]), (CharSequence)this.getPreambule(), (Charset)Charsets.UTF_8, (OpenOption[])$this$getOrPut$iv$iv$iv2);
                }
                catch (Exception $this$getOrPut$iv$iv$iv2) {
                    // empty catch block
                }
            }
            try {
                String metricsText2 = (!isFirstEntry ? ",\n" : "") + CollectionsKt.joinToString$default((Iterable)metricData, (CharSequence)",\n", null, null, (int)0, null, (Function1)((Function1)new Function1<MetricData, CharSequence>(this){
                    final /* synthetic */ FileMetricExporter this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final CharSequence invoke(@NotNull MetricData it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return FileMetricExporter.access$removeStructNames(this.this$0, FileMetricExporter.access$addQuotesToKeys(this.this$0, FileMetricExporter.access$toJson(this.this$0, it)));
                    }
                }), (int)30, null);
                OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.APPEND};
                Files.writeString(metricPath, (CharSequence)metricsText2, openOptionArray);
            }
            catch (IOException e) {
                result.fail();
            }
        }
        CompletableResultCode completableResultCode = result.succeed();
        Intrinsics.checkNotNullExpressionValue((Object)completableResultCode, (String)"succeed(...)");
        return completableResultCode;
    }

    private final String toJson(MetricData $this$toJson) {
        MetricDataType metricDataType = $this$toJson.getType();
        return switch (metricDataType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[metricDataType.ordinal()]) {
            case 1 -> {
                Collection v1 = $this$toJson.getHistogramData().getPoints();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getPoints(...)");
                yield CollectionsKt.joinToString$default((Iterable)v1, (CharSequence)",\n", null, null, (int)0, null, (Function1)((Function1)new Function1<HistogramPointData, CharSequence>(this){
                    final /* synthetic */ FileMetricExporter this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final CharSequence invoke(HistogramPointData it) {
                        long l = it.getStartEpochNanos();
                        long l2 = it.getEpochNanos();
                        Attributes attributes = it.getAttributes();
                        Intrinsics.checkNotNullExpressionValue((Object)attributes, (String)"getAttributes(...)");
                        return "{startEpochNanos=" + l + ", epochNanos=" + l2 + ", labels=" + FileMetricExporter.access$toJson(this.this$0, attributes) + ", sum=" + it.getSum() + ", count=" + it.getCount() + ", boundaries=" + it.getBoundaries() + ", counts=" + it.getCounts() + "}";
                    }
                }), (int)30, null);
            }
            case 2 -> {
                Collection v3 = $this$toJson.getSummaryData().getPoints();
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getPoints(...)");
                yield CollectionsKt.joinToString$default((Iterable)v3, (CharSequence)",\n", null, null, (int)0, null, (Function1)((Function1)new Function1<SummaryPointData, CharSequence>(this){
                    final /* synthetic */ FileMetricExporter this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final CharSequence invoke(SummaryPointData it) {
                        long l = it.getStartEpochNanos();
                        long l2 = it.getEpochNanos();
                        Attributes attributes = it.getAttributes();
                        Intrinsics.checkNotNullExpressionValue((Object)attributes, (String)"getAttributes(...)");
                        return "{startEpochNanos=" + l + ", epochNanos=" + l2 + ", labels=" + FileMetricExporter.access$toJson(this.this$0, attributes) + ", count=" + it.getCount() + ", sum=" + it.getSum() + ", percentileValues=" + it.getValues() + "}";
                    }
                }), (int)30, null);
            }
            case 3 -> {
                Collection v4 = $this$toJson.getDoubleSumData().getPoints();
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getPoints(...)");
                yield CollectionsKt.joinToString$default((Iterable)v4, (CharSequence)",\n", null, null, (int)0, null, (Function1)((Function1)new Function1<DoublePointData, CharSequence>(this){
                    final /* synthetic */ FileMetricExporter this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final CharSequence invoke(DoublePointData it) {
                        long l = it.getStartEpochNanos();
                        long l2 = it.getEpochNanos();
                        Attributes attributes = it.getAttributes();
                        Intrinsics.checkNotNullExpressionValue((Object)attributes, (String)"getAttributes(...)");
                        return "{startEpochNanos=" + l + ", epochNanos=" + l2 + ", attributes=" + FileMetricExporter.access$toJson(this.this$0, attributes) + ", value=" + it.getValue() + "}";
                    }
                }), (int)30, null);
            }
            default -> $this$toJson.toString();
        };
    }

    private final String toJson(Attributes $this$toJson) {
        Map map;
        StringBuilder stringBuilder;
        StringBuilder $this$toJson_u24lambda_u245 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toJson_u24lambda_u245.append("{");
        Map $this$onEachIndexed$iv = $this$toJson.asMap();
        boolean $i$f$onEachIndexed = false;
        Map $this$onEachIndexed_u24lambda_u243$iv = map = $this$onEachIndexed$iv;
        boolean bl2 = false;
        Iterable $this$forEachIndexed$iv$iv = $this$onEachIndexed_u24lambda_u243$iv.entrySet();
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$forEachIndexed$iv$iv) {
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Map.Entry entry = (Map.Entry)item$iv$iv;
            int index = n;
            boolean bl3 = false;
            AttributeKey key = (AttributeKey)entry.getKey();
            Object value = entry.getValue();
            if (index != 0) {
                $this$toJson_u24lambda_u245.append(',');
            }
            $this$toJson_u24lambda_u245.append('\"');
            $this$toJson_u24lambda_u245.append(key.getKey());
            $this$toJson_u24lambda_u245.append("\": \"");
            $this$toJson_u24lambda_u245.append(value);
            $this$toJson_u24lambda_u245.append('\"');
        }
        $this$toJson_u24lambda_u245.append("}");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String getPreambule() {
        return "{\n\"data\": [\n";
    }

    private final String addQuotesToKeys(String $this$addQuotesToKeys) {
        CharSequence charSequence = $this$addQuotesToKeys;
        Regex regex = keyPattern;
        Function1 function1 = addQuotesToKeys.1.INSTANCE;
        return regex.replace(charSequence, function1);
    }

    private final String removeStructNames(String $this$removeStructNames) {
        CharSequence charSequence = $this$removeStructNames;
        Regex regex = structPattern;
        String string = "{";
        return regex.replace(charSequence, string);
    }

    @NotNull
    public CompletableResultCode flush() {
        CompletableResultCode completableResultCode = CompletableResultCode.ofSuccess();
        Intrinsics.checkNotNullExpressionValue((Object)completableResultCode, (String)"ofSuccess(...)");
        return completableResultCode;
    }

    @NotNull
    public CompletableResultCode shutdown() {
        this.flush();
        CompletableResultCode completableResultCode = CompletableResultCode.ofSuccess();
        Intrinsics.checkNotNullExpressionValue((Object)completableResultCode, (String)"ofSuccess(...)");
        return completableResultCode;
    }

    public static final /* synthetic */ String access$toJson(FileMetricExporter $this, Attributes $receiver) {
        return $this.toJson($receiver);
    }

    public static final /* synthetic */ String access$removeStructNames(FileMetricExporter $this, String $receiver) {
        return $this.removeStructNames($receiver);
    }

    public static final /* synthetic */ String access$addQuotesToKeys(FileMetricExporter $this, String $receiver) {
        return $this.addQuotesToKeys($receiver);
    }

    public static final /* synthetic */ String access$toJson(FileMetricExporter $this, MetricData $receiver) {
        return $this.toJson($receiver);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lfleet/reporting/opentelemetry/FileMetricExporter$Companion;", "", "()V", "keyPattern", "Lkotlin/text/Regex;", "structPattern", "fleet.reporting.opentelemetry"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MetricDataType.values().length];
            try {
                nArray[MetricDataType.HISTOGRAM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MetricDataType.SUMMARY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MetricDataType.DOUBLE_SUM.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

