/*
 * Decompiled with CFR 0.152.
 */
package runtime.reactive;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import libraries.basics.AssertKt;
import libraries.basics.DebugCommonKt;
import libraries.klogging.GroupsKt;
import libraries.klogging.KLogger;
import org.jetbrains.annotations.NotNull;
import runtime.DispatchJvmKt;
import runtime.reactive.CellTracker;
import runtime.reactive.Effect;
import runtime.reactive.ReactionsKt;
import runtime.reactive.ReactionsNotEmptyAtStartOfAction;
import runtime.reactive.TransactionalReactionsScheduler;
import runtime.reactive.XTrackable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006J\u001f\u0010\f\u001a\u0002H\r\"\u0004\b\u0000\u0010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u000f\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\nH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lruntime/reactive/TransactionalReactionsScheduler;", "", "<init>", "()V", "scheduledEffects", "", "Lruntime/reactive/Effect;", "isTransaction", "", "schedule", "", "effect", "transaction", "T", "actionHandler", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "invokeTriggeredReactions", "platform-ui"})
@SourceDebugExtension(value={"SMAP\nReactions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Reactions.kt\nruntime/reactive/TransactionalReactionsScheduler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 groupsCommon.kt\nlibraries/klogging/GroupsCommonKt\n+ 4 RichLogRecord.kt\nlibraries/klogging/RichLogRecordKt\n+ 5 KLogger.kt\nlibraries/klogging/KLogger\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,298:1\n1#2:299\n6#3,9:300\n16#3,4:317\n6#3,9:330\n16#3,4:347\n132#4,2:309\n135#4:316\n132#4,2:321\n135#4:328\n132#4,2:339\n135#4:346\n14#5,5:311\n14#5,5:323\n14#5,5:341\n70#5,5:351\n1863#6:329\n1864#6:356\n*S KotlinDebug\n*F\n+ 1 Reactions.kt\nruntime/reactive/TransactionalReactionsScheduler\n*L\n19#1:300,9\n19#1:317,4\n59#1:330,9\n59#1:347,4\n20#1:309,2\n20#1:316\n24#1:321,2\n24#1:328\n60#1:339,2\n60#1:346\n20#1:311,5\n24#1:323,5\n60#1:341,5\n64#1:351,5\n57#1:329\n57#1:356\n*E\n"})
public final class TransactionalReactionsScheduler {
    @NotNull
    public static final TransactionalReactionsScheduler INSTANCE = new TransactionalReactionsScheduler();
    @NotNull
    private static List<Effect> scheduledEffects = new ArrayList();
    private static boolean isTransaction;

    private TransactionalReactionsScheduler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void schedule(@NotNull Effect effect) {
        Intrinsics.checkNotNullParameter((Object)effect, (String)"effect");
        DispatchJvmKt.assertUIDispatcher();
        if (!isTransaction) {
            String string;
            String string2 = DebugCommonKt.getDbgName(effect);
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                string = "reaction(" + it + ") invoked immediately";
            } else {
                string = null;
            }
            String label$iv = string;
            boolean collapsed$iv = true;
            boolean $i$f$logGroup = false;
            boolean $i$f$logGroupInline = false;
            if (label$iv != null) {
                GroupsKt.logGroupStart(label$iv, collapsed$iv);
            }
            try {
                void dbgName$iv;
                boolean bl = false;
                KLogger kLogger = ReactionsKt.access$getLog$p();
                String string3 = DebugCommonKt.getDbgName(effect);
                Function1 msg$iv = schedule.2.1.INSTANCE;
                boolean $i$f$debug = false;
                if (dbgName$iv != null) {
                    void $this$debug$iv;
                    void this_$iv$iv = $this$debug$iv;
                    boolean $i$f$debug2 = false;
                    if (this_$iv$iv.isDebugEnabled()) {
                        boolean bl2 = false;
                        Object msgStr$iv$iv = msg$iv.invoke((Object)dbgName$iv);
                        this_$iv$iv.debug(msgStr$iv$iv);
                    }
                }
                effect.invalidate();
                Unit unit = Unit.INSTANCE;
            }
            finally {
                if (label$iv != null) {
                    GroupsKt.logGroupEnd(label$iv);
                }
            }
        } else {
            void dbgName$iv;
            KLogger label$iv = ReactionsKt.access$getLog$p();
            String collapsed$iv = DebugCommonKt.getDbgName(effect);
            Function1 msg$iv = TransactionalReactionsScheduler::schedule$lambda$2;
            boolean $i$f$debug = false;
            if (dbgName$iv != null) {
                void $this$debug$iv;
                void this_$iv$iv = $this$debug$iv;
                boolean $i$f$debug3 = false;
                if (this_$iv$iv.isDebugEnabled()) {
                    boolean bl = false;
                    Object msgStr$iv$iv = msg$iv.invoke((Object)dbgName$iv);
                    this_$iv$iv.debug(msgStr$iv$iv);
                }
            }
            if (!scheduledEffects.contains(effect)) {
                scheduledEffects.add(effect);
            } else {
                AssertKt.assert(!scheduledEffects.contains(effect), "reaction is already scheduled");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final <T> T transaction(@NotNull Function0<? extends T> actionHandler) {
        Object object;
        Intrinsics.checkNotNullParameter(actionHandler, (String)"actionHandler");
        DispatchJvmKt.assertUIDispatcher();
        if (!isTransaction) {
            void var2_2;
            if (!((Collection)scheduledEffects).isEmpty()) {
                throw new ReactionsNotEmptyAtStartOfAction();
            }
            isTransaction = true;
            Object result2 = null;
            try {
                result2 = CellTracker.INSTANCE.untrack(arg_0 -> TransactionalReactionsScheduler.transaction$lambda$3(actionHandler, arg_0));
            }
            finally {
                this.invokeTriggeredReactions();
                isTransaction = false;
            }
            object = var2_2;
        } else {
            object = actionHandler.invoke();
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void invokeTriggeredReactions() {
        while (!((Collection)scheduledEffects).isEmpty()) {
            List<Effect> invokingReactions = scheduledEffects;
            scheduledEffects = new ArrayList();
            Iterable $this$forEach$iv = invokingReactions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Effect it = (Effect)element$iv;
                boolean bl = false;
                try {
                    String string;
                    if (DebugCommonKt.getDbgName(it) != null) {
                        String it2;
                        boolean bl2 = false;
                        string = "reaction(" + it2 + ") invoked by scheduler";
                    } else {
                        string = null;
                    }
                    String label$iv = string;
                    boolean collapsed$iv = true;
                    boolean $i$f$logGroup = false;
                    boolean $i$f$logGroupInline = false;
                    if (label$iv != null) {
                        GroupsKt.logGroupStart(label$iv, collapsed$iv);
                    }
                    try {
                        void dbgName$iv;
                        boolean bl3 = false;
                        KLogger kLogger = ReactionsKt.access$getLog$p();
                        String string2 = DebugCommonKt.getDbgName(it);
                        Function1 msg$iv = invokeTriggeredReactions.1.2.1.INSTANCE;
                        boolean $i$f$debug = false;
                        if (dbgName$iv != null) {
                            void $this$debug$iv;
                            void this_$iv$iv = $this$debug$iv;
                            boolean $i$f$debug2 = false;
                            if (this_$iv$iv.isDebugEnabled()) {
                                boolean bl4 = false;
                                Object msgStr$iv$iv = msg$iv.invoke((Object)dbgName$iv);
                                this_$iv$iv.debug(msgStr$iv$iv);
                            }
                        }
                        it.invalidate();
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        if (label$iv == null) continue;
                        GroupsKt.logGroupEnd(label$iv);
                    }
                }
                catch (Throwable e) {
                    KLogger this_$iv = ReactionsKt.access$getLog$p();
                    boolean $i$f$error = false;
                    if (!this_$iv.isErrorEnabled()) continue;
                    boolean bl5 = false;
                    String msgStr$iv = "Failed to trigger reaction";
                    this_$iv.error(e, msgStr$iv);
                }
            }
        }
    }

    private static final Object schedule$lambda$2(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "reaction(" + it + ") scheduled";
    }

    private static final Object transaction$lambda$3(Function0 $actionHandler, XTrackable $this$untrack) {
        Intrinsics.checkNotNullParameter((Object)$actionHandler, (String)"$actionHandler");
        Intrinsics.checkNotNullParameter((Object)$this$untrack, (String)"$this$untrack");
        return $actionHandler.invoke();
    }
}

