/*
 * Decompiled with CFR 0.152.
 */
package runtime.logging;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxy;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import runtime.logging.ErrorInfo;
import runtime.logging.JsonLogEventsLayoutKt;
import runtime.logging.TextError;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006J\u000e\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tJ\u0011\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0000H\u0086\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u0014H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lruntime/logging/SuppressedConnectionErrors;", "", "<init>", "()V", "errors", "", "", "textErrors", "", "Lruntime/logging/TextError;", "addError", "", "error", "addTextError", "plusAssign", "that", "match", "", "event", "Lch/qos/logback/classic/spi/ILoggingEvent;", "Lruntime/logging/ErrorInfo;", "platform-runtime"})
@SourceDebugExtension(value={"SMAP\nJsonLogEventsLayout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonLogEventsLayout.kt\nruntime/logging/SuppressedConnectionErrors\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,339:1\n1251#2:340\n1251#2,2:341\n1252#2:343\n1755#3,2:344\n1734#3,3:346\n1757#3:349\n*S KotlinDebug\n*F\n+ 1 JsonLogEventsLayout.kt\nruntime/logging/SuppressedConnectionErrors\n*L\n294#1:340\n295#1:341,2\n294#1:343\n299#1:344,2\n299#1:346,3\n299#1:349\n*E\n"})
public final class SuppressedConnectionErrors {
    @NotNull
    private final Set<String> errors = new LinkedHashSet();
    @NotNull
    private final Map<String, TextError> textErrors = new LinkedHashMap();

    public final void addError(@NotNull String error2) {
        Intrinsics.checkNotNullParameter((Object)error2, (String)"error");
        ((Collection)this.errors).add(error2);
    }

    public final void addTextError(@NotNull TextError error2) {
        Intrinsics.checkNotNullParameter((Object)error2, (String)"error");
        String string = error2.getError();
        Intrinsics.checkNotNull((Object)string);
        this.textErrors.put(string, error2);
    }

    public final void plusAssign(@NotNull SuppressedConnectionErrors that) {
        Intrinsics.checkNotNullParameter((Object)that, (String)"that");
        CollectionsKt.addAll((Collection)this.errors, (Iterable)that.errors);
        this.textErrors.putAll(that.textErrors);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean match(@NotNull ILoggingEvent event) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!CollectionsKt.any((Iterable)this.errors)) {
            if (!MapsKt.any(this.textErrors)) return false;
        }
        Sequence $this$any$iv = JsonLogEventsLayoutKt.access$getAllCauses(event.getThrowableProxy());
        boolean $i$f$any = false;
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            IThrowableProxy it = (IThrowableProxy)element$iv;
            boolean bl2 = false;
            if (this.match(JsonLogEventsLayoutKt.access$getError(it))) return true;
            if (it instanceof ThrowableProxy) {
                Sequence $this$any$iv2 = JsonLogEventsLayoutKt.access$getSuperErrors((ThrowableProxy)it);
                boolean $i$f$any2 = false;
                for (Object element$iv2 : $this$any$iv2) {
                    ErrorInfo p0 = (ErrorInfo)element$iv2;
                    boolean bl3 = false;
                    if (!this.match(p0)) continue;
                    return true;
                }
                boolean bl4 = false;
                if (bl4) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean match(ErrorInfo error2) {
        boolean bl;
        if (this.errors.contains(error2.getClassName())) return true;
        if (error2.getMessage() == null) return false;
        TextError textError = this.textErrors.get(error2.getClassName());
        List list2 = textError != null ? textError.getTexts() : null;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        Iterable $this$any$iv = list2;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            String part;
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            List text2 = (List)element$iv;
            boolean bl2 = false;
            Iterable $this$all$iv = text2;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                return true;
            }
            Iterator iterator3 = $this$all$iv.iterator();
            do {
                if (!iterator3.hasNext()) return true;
                Object element$iv2 = iterator3.next();
                part = (String)element$iv2;
                boolean bl3 = false;
            } while (StringsKt.contains$default((CharSequence)error2.getMessage(), (CharSequence)part, (boolean)false, (int)2, null));
            bl = false;
        } while (!bl);
        return true;
    }
}

