/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rhizomedb.rql;

import com.jetbrains.rhizomedb.rql.LexerKt;
import com.jetbrains.rhizomedb.rql.Token;
import com.jetbrains.rhizomedb.rql.TokenType;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\b\u001a\u00020\tH\u0002J\b\u0010\n\u001a\u00020\u0003H\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003H\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u001c\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0002J\u0012\u0010\u0014\u001a\u00020\t2\b\b\u0002\u0010\u0015\u001a\u00020\u0006H\u0002J\b\u0010\u0016\u001a\u00020\fH\u0002J\b\u0010\u0017\u001a\u00020\fH\u0002J\b\u0010\u0018\u001a\u00020\fH\u0002J\u0006\u0010\u0019\u001a\u00020\fJ\b\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u001bH\u0002J\b\u0010\u001d\u001a\u00020\u001bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/rhizomedb/rql/Lexer;", "", "source", "", "(Ljava/lang/String;)V", "lexemeStart", "", "offset", "advance", "", "currentLexeme", "error", "Lcom/jetbrains/rhizomedb/rql/Token;", "message", "isAtEnd", "", "newToken", "type", "Lcom/jetbrains/rhizomedb/rql/TokenType;", "literal", "peek", "n", "scanIdentifierOrKeyword", "scanNumberLiteral", "scanString", "scanToken", "skipBlockComment", "", "skipLineComment", "skipWhiteSpace", "fleet.rhizomedb"})
public final class Lexer {
    @NotNull
    private final String source;
    private int lexemeStart;
    private int offset;

    public Lexer(@NotNull String source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.source = source;
    }

    @NotNull
    public final Token scanToken() {
        Token token;
        this.skipWhiteSpace();
        if (this.isAtEnd()) {
            return Lexer.newToken$default(this, TokenType.EOF, null, 2, null);
        }
        this.lexemeStart = this.offset;
        char c = this.advance();
        if (c == '(') {
            token = Lexer.newToken$default(this, TokenType.LPAREN, null, 2, null);
        } else if (c == ')') {
            token = Lexer.newToken$default(this, TokenType.RPAREN, null, 2, null);
        } else if (c == ',') {
            token = Lexer.newToken$default(this, TokenType.COMMA, null, 2, null);
        } else if (c == '+') {
            token = Lexer.newToken$default(this, TokenType.PLUS, null, 2, null);
        } else if (c == '-') {
            token = Lexer.newToken$default(this, TokenType.MINUS, null, 2, null);
        } else if (c == '*') {
            token = Lexer.newToken$default(this, TokenType.STAR, null, 2, null);
        } else if (c == '/') {
            token = Lexer.newToken$default(this, TokenType.SLASH, null, 2, null);
        } else if (c == '%') {
            token = Lexer.newToken$default(this, TokenType.PERCENT, null, 2, null);
        } else if (c == '=') {
            token = Lexer.newToken$default(this, TokenType.EQUAL, null, 2, null);
        } else if (c == '>') {
            if (Lexer.peek$default(this, 0, 1, null) == '=') {
                this.advance();
                token = Lexer.newToken$default(this, TokenType.GREATER_EQUAL, null, 2, null);
            } else {
                token = Lexer.newToken$default(this, TokenType.GREATER, null, 2, null);
            }
        } else if (c == '<') {
            char c2 = Lexer.peek$default(this, 0, 1, null);
            if (c2 == '=') {
                this.advance();
                token = Lexer.newToken$default(this, TokenType.LESS_EQUAL, null, 2, null);
            } else if (c2 == '>') {
                this.advance();
                token = Lexer.newToken$default(this, TokenType.NOT_EQUAL, null, 2, null);
            } else {
                token = Lexer.newToken$default(this, TokenType.LESS, null, 2, null);
            }
        } else if (c == '!') {
            if (Lexer.peek$default(this, 0, 1, null) == '=') {
                this.advance();
                token = Lexer.newToken$default(this, TokenType.NOT_EQUAL, null, 2, null);
            } else {
                token = this.error("Unexpected character '" + Lexer.peek$default(this, 0, 1, null) + "'");
            }
        } else {
            token = c == '\'' ? this.scanString() : (Character.isDigit(c) ? this.scanNumberLiteral() : (Character.isLetter(c) || c == '_' || c == '.' ? this.scanIdentifierOrKeyword() : this.error("Unexpected character '" + c + "'")));
        }
        return token;
    }

    private final Token scanString() {
        StringBuilder literal = new StringBuilder();
        Token badEscape = null;
        while (!this.isAtEnd() && Lexer.peek$default(this, 0, 1, null) != '\'') {
            if (Lexer.peek$default(this, 0, 1, null) == '\\') {
                char escape = this.peek(1);
                if (escape == '\'') {
                    literal.append('\'');
                } else if (escape == 'n') {
                    literal.append('\n');
                } else {
                    badEscape = this.error("Unknown string escape '\\" + escape + "'");
                }
                this.advance();
                this.advance();
                continue;
            }
            literal.append(Lexer.peek$default(this, 0, 1, null));
            this.advance();
        }
        if (this.isAtEnd()) {
            return this.error("Unterminated string");
        }
        this.advance();
        if (badEscape != null) {
            return badEscape;
        }
        return this.newToken(TokenType.STRING, literal.toString());
    }

    private final Token scanIdentifierOrKeyword() {
        while (Character.isLetterOrDigit(Lexer.peek$default(this, 0, 1, null)) || Lexer.peek$default(this, 0, 1, null) == '_' || Lexer.peek$default(this, 0, 1, null) == '.') {
            this.advance();
        }
        Map map2 = LexerKt.access$getKEYWORDS$p();
        String string = this.currentLexeme().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        TokenType tokenType = (TokenType)((Object)map2.get(string));
        if (tokenType == null) {
            tokenType = TokenType.IDENTIFIER;
        }
        TokenType tokenType2 = tokenType;
        Boolean literal = switch (WhenMappings.$EnumSwitchMapping$0[tokenType2.ordinal()]) {
            case 1 -> true;
            case 2 -> false;
            default -> null;
        };
        return this.newToken(tokenType2, literal);
    }

    private final void skipWhiteSpace() {
        while (!this.isAtEnd()) {
            if (Lexer.peek$default(this, 0, 1, null) == '-' && this.peek(1) == '-') {
                this.skipLineComment();
                continue;
            }
            if (Lexer.peek$default(this, 0, 1, null) == '/' && this.peek(1) == '*') {
                this.skipBlockComment();
                continue;
            }
            if (!CharsKt.isWhitespace((char)Lexer.peek$default(this, 0, 1, null))) break;
            this.advance();
        }
    }

    private final void skipLineComment() {
        do {
            this.advance();
        } while (!this.isAtEnd() && Lexer.peek$default(this, 0, 1, null) != '\n');
    }

    private final void skipBlockComment() {
        this.advance();
        this.advance();
        while (!(this.isAtEnd() || Lexer.peek$default(this, 0, 1, null) == '*' && this.peek(1) == '/')) {
            this.advance();
        }
        if (!this.isAtEnd()) {
            this.advance();
        }
        if (!this.isAtEnd()) {
            this.advance();
        }
    }

    private final Token scanNumberLiteral() {
        Token token;
        while (Character.isDigit(Lexer.peek$default(this, 0, 1, null))) {
            this.advance();
        }
        if (Lexer.peek$default(this, 0, 1, null) == '.') {
            this.advance();
            while (Character.isDigit(Lexer.peek$default(this, 0, 1, null))) {
                this.advance();
            }
            char c = Lexer.peek$default(this, 0, 1, null);
            if (c == 'f' ? true : c == 'F') {
                this.advance();
                token = this.newToken(TokenType.FLOAT, Float.valueOf(Float.parseFloat(this.currentLexeme())));
            } else if (c == 'd' ? true : c == 'D') {
                this.advance();
                token = this.newToken(TokenType.DOUBLE, Double.parseDouble(this.currentLexeme()));
            } else {
                token = this.newToken(TokenType.DOUBLE, Double.parseDouble(this.currentLexeme()));
            }
        } else {
            token = this.newToken(TokenType.INTEGER, Integer.parseInt(this.currentLexeme()));
        }
        return token;
    }

    private final Token newToken(TokenType type, Object literal) {
        return new Token(type, this.currentLexeme(), this.lexemeStart, this.offset, literal);
    }

    static /* synthetic */ Token newToken$default(Lexer lexer, TokenType tokenType, Object object, int n, Object object2) {
        if ((n & 2) != 0) {
            object = null;
        }
        return lexer.newToken(tokenType, object);
    }

    private final Token error(String message) {
        return this.newToken(TokenType.ERROR, message);
    }

    private final boolean isAtEnd() {
        return this.offset >= this.source.length();
    }

    private final String currentLexeme() {
        return StringsKt.slice((String)this.source, (IntRange)RangesKt.until((int)this.lexemeStart, (int)this.offset));
    }

    private final char advance() {
        int n = this.offset;
        this.offset = n + 1;
        return this.source.charAt(n);
    }

    private final char peek(int n) {
        int pos = this.offset + n;
        return pos >= this.source.length() ? (char)'\u0000' : this.source.charAt(pos);
    }

    static /* synthetic */ char peek$default(Lexer lexer, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return lexer.peek(n);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TokenType.values().length];
            try {
                nArray[TokenType.TRUE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TokenType.FALSE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

