/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSpliterator;
import it.unimi.dsi.fastutil.objects.r;
import it.unimi.dsi.fastutil.objects.s;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.function.Consumer;

public class ObjectOpenCustomHashSet<K>
extends AbstractObjectSet<K>
implements Hash,
Serializable,
Cloneable {
    private static final long serialVersionUID = 0L;
    protected transient K[] key;
    protected transient int mask;
    protected transient boolean containsNull;
    protected Hash.Strategy<? super K> strategy;
    protected transient int n;
    protected transient int maxFill;
    protected final transient int minN;
    protected int size;
    protected final float f;

    /*
     * WARNING - void declaration
     */
    public ObjectOpenCustomHashSet(int expected, float f2, Hash.Strategy<? super K> strategy) {
        void var2_2;
        void var1_1;
        void var3_3;
        this.strategy = var3_3;
        if (f2 <= 0.0f || f2 >= 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f2;
        ObjectOpenCustomHashSet objectOpenCustomHashSet = this;
        objectOpenCustomHashSet.minN = objectOpenCustomHashSet.n = HashCommon.arraySize((int)var1_1, f2);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, (float)var2_2);
        this.key = new Object[this.n + 1];
    }

    /*
     * WARNING - void declaration
     */
    public ObjectOpenCustomHashSet(int expected, Hash.Strategy<? super K> strategy) {
        this((int)var1_1, 0.75f, (Hash.Strategy<K>)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ObjectOpenCustomHashSet(Hash.Strategy<? super K> strategy) {
        this(16, 0.75f, (Hash.Strategy<K>)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ObjectOpenCustomHashSet(Collection<? extends K> c2, float f2, Hash.Strategy<? super K> strategy) {
        this(c2.size(), (float)var2_2, (Hash.Strategy<K>)var3_3);
        void var1_1;
        void var3_3;
        void var2_2;
        this.addAll((Collection<K>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public ObjectOpenCustomHashSet(Collection<? extends K> c2, Hash.Strategy<? super K> strategy) {
        this((Collection<K>)var1_1, 0.75f, (Hash.Strategy<K>)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ObjectOpenCustomHashSet(ObjectCollection<? extends K> c2, float f2, Hash.Strategy<? super K> strategy) {
        this(c2.size(), (float)var2_2, (Hash.Strategy<K>)var3_3);
        void var1_1;
        void var3_3;
        void var2_2;
        this.addAll((Collection<K>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public ObjectOpenCustomHashSet(ObjectCollection<? extends K> c2, Hash.Strategy<? super K> strategy) {
        this((ObjectCollection<K>)var1_1, 0.75f, (Hash.Strategy<K>)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ObjectOpenCustomHashSet(Iterator<? extends K> i2, float f2, Hash.Strategy<? super K> strategy) {
        this(16, (float)var2_2, (Hash.Strategy<K>)var3_3);
        void var3_3;
        void var2_2;
        while (i2.hasNext()) {
            this.add(i2.next());
        }
    }

    /*
     * WARNING - void declaration
     */
    public ObjectOpenCustomHashSet(Iterator<? extends K> i2, Hash.Strategy<? super K> strategy) {
        this((Iterator<K>)var1_1, 0.75f, (Hash.Strategy<K>)var2_2);
        void var2_2;
        void var1_1;
    }

    public ObjectOpenCustomHashSet(K[] a2, int offset, int length, float f2, Hash.Strategy<? super K> strategy) {
        this(length < 0 ? 0 : length, f2, strategy);
        ObjectArrays.ensureOffsetLength(a2, offset, length);
        for (int i2 = 0; i2 < length; ++i2) {
            this.add(a2[offset + i2]);
        }
    }

    /*
     * WARNING - void declaration
     */
    public ObjectOpenCustomHashSet(K[] a2, int offset, int length, Hash.Strategy<? super K> strategy) {
        this((K[])var1_1, (int)var2_2, (int)var3_3, 0.75f, strategy);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ObjectOpenCustomHashSet(K[] a2, float f2, Hash.Strategy<? super K> strategy) {
        this(a2, 0, ((void)var1_1).length, (float)var2_2, (Hash.Strategy<K>)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ObjectOpenCustomHashSet(K[] a2, Hash.Strategy<? super K> strategy) {
        this((K[])var1_1, 0.75f, (Hash.Strategy<K>)var2_2);
        void var2_2;
        void var1_1;
    }

    public Hash.Strategy<? super K> strategy() {
        return this.strategy;
    }

    private int a() {
        if (this.containsNull) {
            return this.size - 1;
        }
        return this.size;
    }

    public void ensureCapacity(int capacity) {
        int n2 = HashCommon.arraySize(capacity, this.f);
        if (n2 > this.n) {
            this.rehash(n2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean addAll(Collection<? extends K> c2) {
        void var1_1;
        if ((double)this.f <= 0.5) {
            this.ensureCapacity(c2.size());
        } else {
            ObjectOpenCustomHashSet objectOpenCustomHashSet = this;
            long l2 = objectOpenCustomHashSet.size() + c2.size();
            ObjectOpenCustomHashSet objectOpenCustomHashSet2 = objectOpenCustomHashSet;
            int n2 = (int)Math.min(0x40000000L, Math.max(2L, HashCommon.nextPowerOfTwo((long)Math.ceil((float)l2 / objectOpenCustomHashSet2.f))));
            if (n2 > objectOpenCustomHashSet2.n) {
                objectOpenCustomHashSet2.rehash(n2);
            }
        }
        return super.addAll(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean add(K k2) {
        if (this.strategy.equals(k2, null)) {
            if (this.containsNull) {
                return false;
            }
            this.containsNull = true;
            this.key[this.n] = k2;
        } else {
            void var1_1;
            K[] KArray = this.key;
            int n2 = HashCommon.mix(this.strategy.hashCode(k2)) & this.mask;
            K k3 = this.key[n2];
            if (k3 != null) {
                if (this.strategy.equals(k3, k2)) {
                    return false;
                }
                while ((k3 = KArray[n2 = n2 + 1 & this.mask]) != null) {
                    if (!this.strategy.equals(k3, k2)) continue;
                    return false;
                }
            }
            KArray[n2] = var1_1;
        }
        if (this.size++ >= this.maxFill) {
            ObjectOpenCustomHashSet objectOpenCustomHashSet = this;
            objectOpenCustomHashSet.rehash(HashCommon.arraySize(objectOpenCustomHashSet.size + 1, this.f));
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public K addOrGet(K k2) {
        void var1_1;
        if (this.strategy.equals(k2, null)) {
            if (this.containsNull) {
                return this.key[this.n];
            }
            this.containsNull = true;
            this.key[this.n] = k2;
        } else {
            K[] KArray = this.key;
            int n2 = HashCommon.mix(this.strategy.hashCode(k2)) & this.mask;
            K k3 = this.key[n2];
            if (k3 != null) {
                if (this.strategy.equals(k3, k2)) {
                    return k3;
                }
                while ((k3 = KArray[n2 = n2 + 1 & this.mask]) != null) {
                    if (!this.strategy.equals(k3, k2)) continue;
                    return k3;
                }
            }
            KArray[n2] = k2;
        }
        if (this.size++ >= this.maxFill) {
            ObjectOpenCustomHashSet objectOpenCustomHashSet = this;
            objectOpenCustomHashSet.rehash(HashCommon.arraySize(objectOpenCustomHashSet.size + 1, this.f));
        }
        return var1_1;
    }

    private boolean a(int n2) {
        --this.size;
        int n3 = n2;
        ObjectOpenCustomHashSet objectOpenCustomHashSet = this;
        K[] KArray = objectOpenCustomHashSet.key;
        block0: while (true) {
            K k2;
            int n4 = n3;
            n3 = n4 + 1 & objectOpenCustomHashSet.mask;
            while (true) {
                if ((k2 = KArray[n3]) == null) break block0;
                int n5 = HashCommon.mix(objectOpenCustomHashSet.strategy.hashCode(k2)) & objectOpenCustomHashSet.mask;
                if (n4 > n3 ? n4 >= n5 && n5 > n3 : n4 >= n5 || n5 > n3) break;
                n3 = n3 + 1 & objectOpenCustomHashSet.mask;
            }
            KArray[n4] = k2;
        }
        KArray[n4] = null;
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > 16) {
            ObjectOpenCustomHashSet objectOpenCustomHashSet2 = this;
            objectOpenCustomHashSet2.rehash(objectOpenCustomHashSet2.n / 2);
        }
        return true;
    }

    @Override
    public boolean remove(Object k2) {
        if (this.strategy.equals(k2, null)) {
            if (this.containsNull) {
                k2 = this;
                this.containsNull = false;
                ((ObjectOpenCustomHashSet)k2).key[((ObjectOpenCustomHashSet)k2).n] = null;
                --((ObjectOpenCustomHashSet)k2).size;
                if (((ObjectOpenCustomHashSet)k2).n > ((ObjectOpenCustomHashSet)k2).minN && ((ObjectOpenCustomHashSet)k2).size < ((ObjectOpenCustomHashSet)k2).maxFill / 4 && ((ObjectOpenCustomHashSet)k2).n > 16) {
                    Object object = k2;
                    ((ObjectOpenCustomHashSet)object).rehash(((ObjectOpenCustomHashSet)object).n / 2);
                }
                return true;
            }
            return false;
        }
        K[] KArray = this.key;
        int n2 = HashCommon.mix(this.strategy.hashCode(k2)) & this.mask;
        K k3 = this.key[n2];
        if (k3 == null) {
            return false;
        }
        if (this.strategy.equals(k2, k3)) {
            return this.a(n2);
        }
        do {
            if ((k3 = KArray[n2 = n2 + 1 & this.mask]) != null) continue;
            return false;
        } while (!this.strategy.equals(k2, k3));
        return this.a(n2);
    }

    @Override
    public boolean contains(Object k2) {
        if (this.strategy.equals(k2, null)) {
            return this.containsNull;
        }
        K[] KArray = this.key;
        int n2 = HashCommon.mix(this.strategy.hashCode(k2)) & this.mask;
        K k3 = this.key[n2];
        if (k3 == null) {
            return false;
        }
        if (this.strategy.equals(k2, k3)) {
            return true;
        }
        do {
            if ((k3 = KArray[n2 = n2 + 1 & this.mask]) != null) continue;
            return false;
        } while (!this.strategy.equals(k2, k3));
        return true;
    }

    public K get(Object k2) {
        if (this.strategy.equals(k2, null)) {
            return this.key[this.n];
        }
        K[] KArray = this.key;
        int n2 = HashCommon.mix(this.strategy.hashCode(k2)) & this.mask;
        K k3 = this.key[n2];
        if (k3 == null) {
            return null;
        }
        if (this.strategy.equals(k2, k3)) {
            return k3;
        }
        do {
            if ((k3 = KArray[n2 = n2 + 1 & this.mask]) != null) continue;
            return null;
        } while (!this.strategy.equals(k2, k3));
        return k3;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        this.containsNull = false;
        Arrays.fill(this.key, null);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public ObjectIterator<K> iterator() {
        return new a(this, 0);
    }

    @Override
    public ObjectSpliterator<K> spliterator() {
        return new b(this);
    }

    @Override
    public void forEach(Consumer<? super K> action) {
        if (this.containsNull) {
            action.accept(this.key[this.n]);
        }
        K[] KArray = this.key;
        int n2 = this.n;
        while (n2-- != 0) {
            if (KArray[n2] == null) continue;
            action.accept(KArray[n2]);
        }
    }

    public boolean trim() {
        ObjectOpenCustomHashSet objectOpenCustomHashSet = this;
        return objectOpenCustomHashSet.trim(objectOpenCustomHashSet.size);
    }

    public boolean trim(int n2) {
        int n3 = HashCommon.nextPowerOfTwo((int)Math.ceil((float)n2 / this.f));
        if (n3 >= this.n || this.size > HashCommon.maxFill(n3, this.f)) {
            return true;
        }
        try {
            this.rehash(n3);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected void rehash(int newN) {
        void var1_1;
        K[] KArray = this.key;
        int n2 = newN - 1;
        Object[] objectArray = new Object[newN + 1];
        int n3 = this.n;
        int n4 = this.a();
        while (n4-- != 0) {
            while (KArray[--n3] == null) {
            }
            int n5 = HashCommon.mix(this.strategy.hashCode(KArray[n3])) & n2;
            if (objectArray[n5] != null) {
                while (objectArray[n5 = n5 + 1 & n2] != null) {
                }
            }
            objectArray[n5] = KArray[n3];
        }
        this.n = var1_1;
        this.mask = n2;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = objectArray;
    }

    public ObjectOpenCustomHashSet<K> clone() {
        ObjectOpenCustomHashSet objectOpenCustomHashSet;
        try {
            objectOpenCustomHashSet = (ObjectOpenCustomHashSet)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        objectOpenCustomHashSet.key = (Object[])this.key.clone();
        objectOpenCustomHashSet.containsNull = this.containsNull;
        objectOpenCustomHashSet.strategy = this.strategy;
        return objectOpenCustomHashSet;
    }

    @Override
    public int hashCode() {
        int n2 = 0;
        int n3 = this.a();
        int n4 = 0;
        while (n3-- != 0) {
            while (this.key[n4] == null) {
                ++n4;
            }
            ObjectOpenCustomHashSet objectOpenCustomHashSet = this;
            if (objectOpenCustomHashSet != objectOpenCustomHashSet.key[n4]) {
                n2 += this.strategy.hashCode(this.key[n4]);
            }
            ++n4;
        }
        return n2;
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        Iterator iterator = ((r)this).iterator();
        s2.defaultWriteObject();
        int n2 = this.size;
        while (n2-- != 0) {
            s2.writeObject(iterator.next());
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.n = HashCommon.arraySize(this.size, this.f);
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.mask = this.n - 1;
        this.key = new Object[this.n + 1];
        Object[] objectArray = this.key;
        int n2 = this.size;
        while (n2-- != 0) {
            int n3;
            Object object = s2.readObject();
            if (this.strategy.equals(object, null)) {
                n3 = this.n;
                this.containsNull = true;
            } else {
                n3 = HashCommon.mix(this.strategy.hashCode(object)) & this.mask;
                if (objectArray[n3] != null) {
                    while (objectArray[n3 = n3 + 1 & this.mask] != null) {
                    }
                }
            }
            objectArray[n3] = object;
        }
    }

    private final class a
    implements ObjectIterator<K> {
        private int a;
        private int b;
        private int c;
        private boolean d;
        private ObjectArrayList<K> e;
        private /* synthetic */ ObjectOpenCustomHashSet f;

        private a(ObjectOpenCustomHashSet objectOpenCustomHashSet) {
            this.f = objectOpenCustomHashSet;
            this.a = this.f.n;
            this.b = -1;
            this.c = this.f.size;
            this.d = this.f.containsNull;
        }

        @Override
        public final boolean hasNext() {
            return this.c != 0;
        }

        @Override
        public final K next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            --this.c;
            if (this.d) {
                this.d = false;
                this.b = this.f.n;
                return this.f.key[this.f.n];
            }
            K[] KArray = this.f.key;
            do {
                if (--this.a >= 0) continue;
                this.b = Integer.MIN_VALUE;
                return this.e.get(-this.a - 1);
            } while (KArray[this.a] == null);
            this.b = this.a;
            return KArray[this.b];
        }

        @Override
        public final void remove() {
            block9: {
                if (this.b == -1) {
                    throw new IllegalStateException();
                }
                if (this.b == this.f.n) {
                    this.f.containsNull = false;
                    this.f.key[this.f.n] = null;
                } else {
                    if (this.a >= 0) {
                        a a2 = this;
                        int n2 = a2.b;
                        a a3 = a2;
                        K[] KArray = a2.f.key;
                        while (true) {
                            Object k2;
                            int n3 = n2;
                            n2 = n3 + 1 & a3.f.mask;
                            while (true) {
                                if ((k2 = KArray[n2]) == null) {
                                    KArray[n3] = null;
                                    break block9;
                                }
                                int n4 = HashCommon.mix(a3.f.strategy.hashCode(k2)) & a3.f.mask;
                                if (n3 > n2 ? n3 >= n4 && n4 > n2 : n3 >= n4 || n4 > n2) break;
                                n2 = n2 + 1 & a3.f.mask;
                            }
                            if (n2 < n3) {
                                if (a3.e == null) {
                                    a3.e = new ObjectArrayList(2);
                                }
                                ((s)a3.e).add(KArray[n2]);
                            }
                            KArray[n3] = k2;
                        }
                    }
                    this.f.remove(((s)this.e).set(-this.a - 1, null));
                    this.b = -1;
                    return;
                }
            }
            --this.f.size;
            this.b = -1;
        }

        @Override
        public final void forEachRemaining(Consumer<? super K> action) {
            K[] KArray = this.f.key;
            if (this.d) {
                this.d = false;
                this.b = this.f.n;
                action.accept(KArray[this.f.n]);
                --this.c;
            }
            while (this.c != 0) {
                if (--this.a < 0) {
                    this.b = Integer.MIN_VALUE;
                    action.accept(this.e.get(-this.a - 1));
                    --this.c;
                    continue;
                }
                if (KArray[this.a] == null) continue;
                this.b = this.a;
                action.accept(KArray[this.b]);
                --this.c;
            }
        }

        /* synthetic */ a(ObjectOpenCustomHashSet objectOpenCustomHashSet, byte by) {
            this(objectOpenCustomHashSet);
        }
    }

    private final class b
    implements ObjectSpliterator<K> {
        private int a = 0;
        private int b;
        private int c;
        private boolean d;
        private boolean e;
        private /* synthetic */ ObjectOpenCustomHashSet f;

        b(ObjectOpenCustomHashSet objectOpenCustomHashSet) {
            this.f = objectOpenCustomHashSet;
            this.b = this.f.n;
            this.c = 0;
            this.d = this.f.containsNull;
            this.e = false;
        }

        private b(ObjectOpenCustomHashSet objectOpenCustomHashSet, int n2, int n3, boolean bl2) {
            this.f = objectOpenCustomHashSet;
            this.b = this.f.n;
            this.c = 0;
            this.d = this.f.containsNull;
            this.e = false;
            this.a = n2;
            this.b = n3;
            this.d = bl2;
            this.e = true;
        }

        @Override
        public final boolean tryAdvance(Consumer<? super K> action) {
            if (this.d) {
                this.d = false;
                ++this.c;
                action.accept(this.f.key[this.f.n]);
                return true;
            }
            K[] KArray = this.f.key;
            while (this.a < this.b) {
                if (KArray[this.a] != null) {
                    ++this.c;
                    action.accept(KArray[this.a++]);
                    return true;
                }
                ++this.a;
            }
            return false;
        }

        @Override
        public final void forEachRemaining(Consumer<? super K> action) {
            K[] KArray = this.f.key;
            if (this.d) {
                this.d = false;
                action.accept(KArray[this.f.n]);
                ++this.c;
            }
            while (this.a < this.b) {
                if (KArray[this.a] != null) {
                    action.accept(KArray[this.a]);
                    ++this.c;
                }
                ++this.a;
            }
        }

        @Override
        public final int characteristics() {
            if (this.e) {
                return 1;
            }
            return 65;
        }

        @Override
        public final long estimateSize() {
            if (!this.e) {
                return this.f.size - this.c;
            }
            return Math.min((long)(this.f.size - this.c), (long)((double)this.f.a() / (double)this.f.n * (double)(this.b - this.a)) + (long)(this.d ? 1 : 0));
        }

        private b b() {
            if (this.a >= this.b - 1) {
                return null;
            }
            int n2 = this.b - this.a >> 1;
            if (n2 <= 1) {
                return null;
            }
            n2 = this.a + n2;
            int n3 = this.a;
            int n4 = n2;
            b b2 = new b(this.f, n3, n4, this.d);
            this.a = n2;
            this.d = false;
            this.e = true;
            return b2;
        }

        @Override
        public final /* synthetic */ ObjectSpliterator a() {
            return this.b();
        }

        @Override
        public final /* synthetic */ Spliterator trySplit() {
            return this.b();
        }
    }
}

