/*
 * Decompiled with CFR 0.152.
 */
package fleet.plugins.themeDesigner.frontend;

import andel.text.TextRange;
import androidx.compose.foundation.layout.Arrangement;
import androidx.compose.foundation.layout.ColumnKt;
import androidx.compose.foundation.layout.ColumnScope;
import androidx.compose.foundation.layout.PaddingKt;
import androidx.compose.foundation.layout.SizeKt;
import androidx.compose.foundation.layout.SpacerKt;
import androidx.compose.foundation.shape.RoundedCornerShapeKt;
import androidx.compose.runtime.Composable;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.Shape;
import androidx.compose.ui.unit.Dp;
import com.jetbrains.rhizomedb.DbContext;
import com.jetbrains.rhizomedb.Q;
import com.jetbrains.rhizomedb.impl.EntitiesImplKt;
import fleet.api.FileAddress;
import fleet.api.FileAddressKt;
import fleet.api.ProtocolPath;
import fleet.api.workspace.document.MediaType;
import fleet.ast.SyntexNodeExtKt;
import fleet.com.intellij.json.JsonElementTypes;
import fleet.com.jetbrains.lang.syntax.SyntaxNode;
import fleet.com.jetbrains.lang.syntax.SyntaxNodeExtKt;
import fleet.common.document.DocumentEntity;
import fleet.common.document.DocumentFileEntity;
import fleet.compose.theme.CompositionLocalsKt;
import fleet.compose.theme.SurfaceKt;
import fleet.compose.theme.components.Thickness;
import fleet.compose.theme.graphics.NoriaColorKt;
import fleet.compose.theme.keys.ThemeKeys;
import fleet.frontend.fsd.LocalFsdExtKt;
import fleet.plugins.themeDesigner.frontend.ColorInlay;
import fleet.plugins.themeDesigner.frontend.DetectedThemeDocument;
import fleet.plugins.themeDesigner.frontend.ThemeDesignerKt;
import fleet.schema.common.Schema;
import fleet.schema.common.SchemaKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KMutableProperty1;
import kotlin.reflect.KProperty1;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import noria.NoriaContext;
import noria.ReadScope;
import noria.impl.Runtime;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\b\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u001c\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u0012\u0010\u000f\u001a\u0004\u0018\u00010\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001\u001a\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0014\u0010\u0012\u001a\u00020\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0003\u001a:\u0010\u0017\u001a\u00020\u0013*\u00020\u000e2\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\f0\u000b2\u0018\u0010\u0019\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00160\u001b0\u001aH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"EDITABLE_THEMES_RELATIVE_PATH", "", "JsonMediaType", "Lfleet/api/workspace/document/MediaType;", "buildThemeSchema", "Lfleet/schema/common/Schema;", "isThemeFile", "", "fileAddress", "Lfleet/api/FileAddress;", "parsePalette", "", "Landroidx/compose/ui/graphics/Color;", "root", "Lfleet/com/jetbrains/lang/syntax/SyntaxNode;", "stringToColor", "colorString", "wasMarkedAsTheme", "ColorInlayView", "", "Lnoria/NoriaContext;", "inlay", "Lfleet/plugins/themeDesigner/frontend/ColorInlay;", "findAllColors", "palette", "result", "", "Lkotlin/Pair;", "Landel/text/TextRange;", "fleet.plugins.themeDesigner.frontend"})
@SourceDebugExtension(value={"SMAP\nThemeDesigner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThemeDesigner.kt\nfleet/plugins/themeDesigner/frontend/ThemeDesignerKt\n+ 2 Entities.kt\ncom/jetbrains/rhizomedb/EntitiesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 6 Dp.kt\nandroidx/compose/ui/unit/DpKt\n*L\n1#1,418:1\n235#2:419\n235#2:435\n1603#3,9:420\n1855#3:429\n1856#3:431\n1612#3:432\n1747#3,2:433\n1749#3:436\n1#4:430\n1#4:438\n1313#5:437\n1314#5:439\n1313#5,2:440\n155#6:442\n155#6:443\n*S KotlinDebug\n*F\n+ 1 ThemeDesigner.kt\nfleet/plugins/themeDesigner/frontend/ThemeDesignerKt\n*L\n76#1:419\n78#1:435\n77#1:420,9\n77#1:429\n77#1:431\n77#1:432\n77#1:433,2\n77#1:436\n77#1:430\n239#1:437\n239#1:439\n257#1:440,2\n409#1:442\n410#1:443\n*E\n"})
public final class ThemeDesignerKt {
    @NotNull
    private static final String EDITABLE_THEMES_RELATIVE_PATH = ".fleet/themes";
    @NotNull
    private static final MediaType JsonMediaType = new MediaType("text", "json", null, null, 12, null);

    public static final boolean isThemeFile(@NotNull FileAddress fileAddress) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)fileAddress, (String)"fileAddress");
        ProtocolPath protocolPath = LocalFsdExtKt.getLocalFs().getUserHome();
        if (protocolPath != null && (protocolPath = protocolPath.resolveChild(EDITABLE_THEMES_RELATIVE_PATH)) != null) {
            ProtocolPath themesDir = protocolPath;
            boolean bl2 = false;
            bl = fileAddress.getPath().startsWith(themesDir) && Intrinsics.areEqual((Object)FileAddressKt.getExtension((FileAddress)fileAddress), (Object)"json") || ThemeDesignerKt.wasMarkedAsTheme(fileAddress);
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean wasMarkedAsTheme(FileAddress fileAddress) {
        boolean bl;
        block4: {
            void $this$mapNotNullTo$iv$iv;
            KMutableProperty1 property$iv = (KMutableProperty1)wasMarkedAsTheme.1.INSTANCE;
            boolean $i$f$lookup = false;
            Iterable $this$mapNotNull$iv = EntitiesImplKt.lookupImpl((Q)DbContext.Companion.getThreadBound().getImpl(), (KProperty1)((KProperty1)property$iv), (Object)fileAddress, (KClass)Reflection.getOrCreateKotlinClass(DocumentFileEntity.class));
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                DocumentEntity it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                DocumentFileEntity documentFileEntity = (DocumentFileEntity)element$iv$iv;
                boolean bl3 = false;
                if (documentFileEntity.getDocument() == null) continue;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$any$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    DocumentEntity documentEntity = (DocumentEntity)element$iv;
                    boolean bl5 = false;
                    KMutableProperty1 property$iv2 = (KMutableProperty1)wasMarkedAsTheme.3.1.INSTANCE;
                    boolean $i$f$lookup2 = false;
                    boolean bl6 = !((Collection)EntitiesImplKt.lookupImpl((Q)DbContext.Companion.getThreadBound().getImpl(), (KProperty1)((KProperty1)property$iv2), (Object)documentEntity, (KClass)Reflection.getOrCreateKotlinClass(DetectedThemeDocument.class))).isEmpty();
                    if (!bl6) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<String, Color> parsePalette(SyntaxNode root) {
        SyntaxNode syntaxNode;
        Object v1;
        Object object;
        Iterator iterator;
        Sequence sequence;
        Map palette;
        block4: {
            palette = new LinkedHashMap();
            sequence = SequencesKt.filter((Sequence)SyntaxNodeExtKt.children((SyntaxNode)root), (Function1)parsePalette.paletteProperty.1.INSTANCE);
            iterator = sequence.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                SyntaxNode property = (SyntaxNode)object;
                boolean bl = false;
                SyntaxNode propertyKey = property.firstChild();
                SyntaxNode propertyValue = property.lastChild();
                SyntaxNode syntaxNode2 = propertyKey;
                if (!(Intrinsics.areEqual((Object)String.valueOf(syntaxNode2 != null ? syntaxNode2.getText() : null), (Object)"\"palette\"") && propertyValue != null)) continue;
                v1 = object;
                break block4;
            }
            v1 = null;
        }
        SyntaxNode paletteProperty2 = v1;
        if (paletteProperty2 != null && (syntaxNode = paletteProperty2.lastChild()) != null && (sequence = SyntaxNodeExtKt.children((SyntaxNode)syntaxNode)) != null && (iterator = SequencesKt.filter((Sequence)sequence, (Function1)parsePalette.1.INSTANCE)) != null) {
            void $this$forEach$iv;
            object = iterator;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SyntaxNode property = (SyntaxNode)element$iv;
                boolean bl = false;
                SyntaxNode propertyKey = property.firstChild();
                SyntaxNode propertyValue = property.lastChild();
                if (propertyKey == null || propertyValue == null || !Intrinsics.areEqual((Object)propertyValue.getType(), (Object)JsonElementTypes.STRING_LITERAL)) continue;
                CharSequence $this$parsePalette_u24lambda_u247_u24lambda_u244 = propertyKey.getText();
                boolean bl2 = false;
                String propertyKeyString = ((Object)$this$parsePalette_u24lambda_u247_u24lambda_u244.subSequence(1, $this$parsePalette_u24lambda_u247_u24lambda_u244.length() - 1)).toString();
                CharSequence $this$parsePalette_u24lambda_u247_u24lambda_u245 = propertyValue.getText();
                boolean bl3 = false;
                String propertyValueString = ((Object)$this$parsePalette_u24lambda_u247_u24lambda_u245.subSequence(1, $this$parsePalette_u24lambda_u247_u24lambda_u245.length() - 1)).toString();
                Color color = ThemeDesignerKt.stringToColor(propertyValueString);
                if (color != null) {
                    long color2 = color.unbox-impl();
                    boolean bl4 = false;
                    Color color3 = Color.box-impl((long)color2);
                    palette.put(propertyKeyString, color3);
                }
            }
        }
        return palette;
    }

    private static final void findAllColors(SyntaxNode $this$findAllColors, Map<String, Color> palette, List<Pair<TextRange, ColorInlay>> result) {
        Color color;
        Sequence $this$forEach$iv = SyntaxNodeExtKt.children((SyntaxNode)$this$findAllColors);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SyntaxNode it = (SyntaxNode)element$iv;
            boolean bl = false;
            ThemeDesignerKt.findAllColors(it, palette, result);
        }
        SyntaxNode propertyValue = $this$findAllColors.lastChild();
        if (!Intrinsics.areEqual((Object)$this$findAllColors.getType(), (Object)JsonElementTypes.PROPERTY) || propertyValue == null || !Intrinsics.areEqual((Object)propertyValue.getType(), (Object)JsonElementTypes.STRING_LITERAL)) {
            return;
        }
        CharSequence $this$findAllColors_u24lambda_u249 = propertyValue.getText();
        boolean bl = false;
        String valueString = ((Object)$this$findAllColors_u24lambda_u249.subSequence(1, $this$findAllColors_u24lambda_u249.length() - 1)).toString();
        Color color2 = palette.get(valueString);
        if (color2 == null) {
            color2 = ThemeDesignerKt.stringToColor(valueString);
        }
        if ((color = color2) != null) {
            result.add((Pair<TextRange, ColorInlay>)TuplesKt.to((Object)SyntexNodeExtKt.getTextRange((SyntaxNode)propertyValue), (Object)new ColorInlay(color.unbox-impl(), null)));
        }
    }

    @Nullable
    public static final Color stringToColor(@Nullable String colorString) {
        Color color;
        if (colorString == null) {
            return null;
        }
        try {
            long l;
            String string;
            if (StringsKt.startsWith$default((String)colorString, (String)"#", (boolean)false, (int)2, null)) {
                String string2 = colorString.substring(1);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            } else {
                string = colorString;
            }
            String color2 = string;
            if (StringsKt.endsWith$default((String)color2, (String)"%", (boolean)false, (int)2, null)) {
                String string3 = color2.substring(0, 6);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                String mainPart = string3;
                String string4 = color2.substring(6);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                char[] cArray = new char[]{'%'};
                String alpha = StringsKt.trimEnd((String)string4, (char[])cArray);
                l = Color.copy-wmQWz5c$default((long)NoriaColorKt.css((Color.Companion)Color.Companion, (String)mainPart), (float)(Float.parseFloat(alpha) / (float)100), (float)0.0f, (float)0.0f, (float)0.0f, (int)14, null);
            } else {
                l = NoriaColorKt.css((Color.Companion)Color.Companion, (String)color2);
            }
            color = Color.box-impl((long)l);
        }
        catch (Throwable ignore) {
            color = null;
        }
        return color;
    }

    private static final Schema buildThemeSchema() {
        return SchemaKt.schema((Function1)buildThemeSchema.1.INSTANCE);
    }

    @Composable
    private static final void ColorInlayView(NoriaContext $this$ColorInlayView, ColorInlay inlay) {
        float f;
        if (NoriaColorKt.contrast--OWjLjI((long)inlay.getColor-0d7_KjU(), (long)((Color)CompositionLocalsKt.getTheme((ReadScope)((ReadScope)$this$ColorInlayView)).get(ThemeKeys.INSTANCE.getEditorBackground())).unbox-impl()) >= 2.0) {
            boolean $this$dp$iv = false;
            boolean $i$f$getDp = false;
            f = Dp.constructor-impl((float)((float)$this$dp$iv));
        } else {
            f = Thickness.INSTANCE.getRegular-D9Ej5fM();
        }
        float thickness = f;
        Runtime.enterScope((NoriaContext)$this$ColorInlayView, (int)3);
        int $this$dp$iv = 4;
        boolean $i$f$getDp = false;
        Object[] objectArray = new Object[]{inlay, Dp.box-impl((float)thickness)};
        ColumnKt.Column$default((NoriaContext)$this$ColorInlayView, (Modifier)PaddingKt.padding-qDBjuR0$default((Modifier)SizeKt.fillMaxHeight$default((Modifier)((Modifier)Modifier.Companion), (float)0.0f, (int)1, null), (float)0.0f, (float)0.0f, (float)Dp.constructor-impl((float)$this$dp$iv), (float)0.0f, (int)11, null), (Arrangement.Vertical)((Arrangement.Vertical)Arrangement.INSTANCE.getCenter()), null, (boolean)false, (Function1)((Function1)Runtime.closure((Object[])objectArray, (Object)new Function1<ColumnScope, Unit>(inlay, thickness){
            final /* synthetic */ ColorInlay $inlay;
            final /* synthetic */ float $thickness;
            {
                this.$inlay = $inlay;
                this.$thickness = $thickness;
                super(1);
            }

            public final void invoke(@NotNull ColumnScope $this$Column) {
                Intrinsics.checkNotNullParameter((Object)$this$Column, (String)"$this$Column");
                Runtime.enterScope((NoriaContext)((NoriaContext)$this$Column), (int)2);
                int $this$dp$iv = 2;
                boolean $i$f$getDp = false;
                Modifier modifier = SurfaceKt.surface-qfw8r4Y$default((Modifier)((Modifier)Modifier.Companion), (long)this.$inlay.getColor-0d7_KjU(), (float)this.$thickness, (long)((Color)CompositionLocalsKt.getTheme((ReadScope)((ReadScope)$this$Column)).get(ThemeKeys.INSTANCE.getSeparatorDefault())).unbox-impl(), (Shape)((Shape)RoundedCornerShapeKt.RoundedCornerShape-0680j_4((float)Dp.constructor-impl((float)$this$dp$iv))), null, (int)16, null);
                $this$dp$iv = 12;
                $i$f$getDp = false;
                float f = Dp.constructor-impl((float)$this$dp$iv);
                $this$dp$iv = 12;
                $i$f$getDp = false;
                SpacerKt.Spacer((NoriaContext)((NoriaContext)$this$Column), (Modifier)SizeKt.size-VpY3zN4((Modifier)modifier, (float)f, (float)Dp.constructor-impl((float)$this$dp$iv)));
                Unit unit = Unit.INSTANCE;
                Runtime.exitScope((NoriaContext)((NoriaContext)$this$Column));
            }
        })), (int)12, null);
        Unit unit = Unit.INSTANCE;
        Runtime.exitScope((NoriaContext)$this$ColorInlayView);
    }

    public static final /* synthetic */ Schema access$buildThemeSchema() {
        return ThemeDesignerKt.buildThemeSchema();
    }

    public static final /* synthetic */ void access$ColorInlayView(NoriaContext $receiver, ColorInlay inlay) {
        ThemeDesignerKt.ColorInlayView($receiver, inlay);
    }

    public static final /* synthetic */ MediaType access$getJsonMediaType$p() {
        return JsonMediaType;
    }

    public static final /* synthetic */ Map access$parsePalette(SyntaxNode root) {
        return ThemeDesignerKt.parsePalette(root);
    }

    public static final /* synthetic */ void access$findAllColors(SyntaxNode $receiver, Map palette, List result) {
        ThemeDesignerKt.findAllColors($receiver, palette, result);
    }
}

