/*
 * Decompiled with CFR 0.152.
 */
package org.toml.lang.lexer;

import fleet.com.intellij.lexer.Lexer;
import fleet.com.intellij.psi.StringEscapesTokenTypes;
import fleet.com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.toml.lang.lexer.TomlEscapeLexer;
import org.toml.lang.psi.ElementTypesKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u001aA\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00012\n\u0010\b\u001a\u00060\tj\u0002`\n2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u000eH\u0082\b\u001a.\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00040\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\u00012\n\u0010\b\u001a\u00060\tj\u0002`\n\u001a,\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\u00012\n\u0010\b\u001a\u00060\tj\u0002`\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a&\u0010\u0014\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00010\u00100\u0015*\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0012\u0010\u0017\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0012\u00a8\u0006\u0018"}, d2={"decodeEscape", "", "esc", "parseStringCharacters", "", "lexer", "Lfleet/com/intellij/lexer/Lexer;", "chars", "outChars", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "sourceOffsets", "", "decoder", "Lkotlin/Function1;", "parseTomlStringCharacters", "Lkotlin/Pair;", "tokenType", "Lfleet/com/intellij/psi/tree/IElementType;", "Lorg/toml/lang/lexer/TomlEscapeLexer;", "tokenize", "Lkotlin/sequences/Sequence;", "", "unescapeToml", "toml-parser"})
@SourceDebugExtension(value={"SMAP\nTomlEscapeUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TomlEscapeUtils.kt\norg/toml/lang/lexer/TomlEscapeUtilsKt\n*L\n1#1,123:1\n78#1,33:124\n*S KotlinDebug\n*F\n+ 1 TomlEscapeUtils.kt\norg/toml/lang/lexer/TomlEscapeUtilsKt\n*L\n43#1:124,33\n*E\n"})
public final class TomlEscapeUtilsKt {
    @NotNull
    public static final String unescapeToml(@NotNull String $this$unescapeToml, @NotNull IElementType tokenType) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$unescapeToml, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
        if (!ElementTypesKt.getTOML_STRING_LITERALS().contains(tokenType)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        if (ElementTypesKt.getTOML_BASIC_STRINGS().contains(tokenType)) {
            StringBuilder outChars = new StringBuilder();
            boolean result = (Boolean)TomlEscapeUtilsKt.parseTomlStringCharacters(tokenType, $this$unescapeToml, outChars).getSecond();
            String string3 = result ? outChars.toString() : $this$unescapeToml;
            Intrinsics.checkNotNull((Object)string3);
            string = string3;
        } else {
            string = $this$unescapeToml;
        }
        return string;
    }

    @NotNull
    public static final Pair<int[], Boolean> parseTomlStringCharacters(@NotNull IElementType tokenType, @NotNull String chars, @NotNull StringBuilder outChars) {
        Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
        Intrinsics.checkNotNullParameter((Object)chars, (String)"chars");
        Intrinsics.checkNotNullParameter((Object)outChars, (String)"outChars");
        if (!ElementTypesKt.getTOML_BASIC_STRINGS().contains(tokenType)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int[] sourceOffsets = new int[chars.length() + 1];
        TomlEscapeLexer lexer = TomlEscapeLexer.Companion.of(tokenType);
        boolean result = TomlEscapeUtilsKt.parseTomlStringCharacters(lexer, chars, outChars, sourceOffsets);
        return TuplesKt.to((Object)sourceOffsets, (Object)result);
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean parseTomlStringCharacters(TomlEscapeLexer lexer, String chars, StringBuilder outChars, int[] sourceOffsets) {
        boolean bl;
        block4: {
            boolean $i$f$parseStringCharacters = false;
            int outOffset$iv = outChars.length();
            int index$iv = 0;
            block0: for (Pair pair : TomlEscapeUtilsKt.tokenize(chars, (Lexer)lexer)) {
                IElementType type$iv = (IElementType)pair.component1();
                String text$iv = (String)pair.component2();
                sourceOffsets[outChars.length() - outOffset$iv] = index$iv;
                sourceOffsets[outChars.length() - outOffset$iv + 1] = index$iv + 1;
                IElementType iElementType = type$iv;
                if (Intrinsics.areEqual((Object)iElementType, (Object)StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN)) {
                    void p0;
                    String string = text$iv;
                    StringBuilder stringBuilder = outChars;
                    boolean bl2 = false;
                    stringBuilder.append(TomlEscapeUtilsKt.decodeEscape((String)p0));
                    index$iv += text$iv.length();
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN) ? true : Intrinsics.areEqual((Object)iElementType, (Object)StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN)) {
                    bl = false;
                    break block4;
                }
                int first$iv = outChars.length() - outOffset$iv;
                outChars.append(text$iv);
                int i$iv = first$iv;
                int last$iv = outChars.length() - outOffset$iv - 1;
                if (i$iv > last$iv) continue;
                while (true) {
                    sourceOffsets[i$iv] = index$iv++;
                    if (i$iv == last$iv) continue block0;
                    ++i$iv;
                }
            }
            sourceOffsets[outChars.length() - outOffset$iv] = index$iv;
            bl = true;
        }
        return bl;
    }

    private static final String decodeEscape(String esc) {
        return switch (esc) {
            case "\\b" -> "\b";
            case "\\t" -> "\t";
            case "\\n" -> "\n";
            case "\\f" -> "\f";
            case "\\r" -> "\r";
            case "\\\"" -> "\"";
            case "\\\\" -> "\\";
            default -> {
                char var2_2;
                char v1 = var2_2 = esc.length() >= 2 ? (char)'\u0001' : '\u0000';
                if (_Assertions.ENABLED && var2_2 == '\u0000') {
                    String var3_3 = "Assertion failed";
                    throw new AssertionError((Object)var3_3);
                }
                char v2 = var2_2 = esc.charAt(0) == '\\' ? (char)'\u0001' : '\u0000';
                if (_Assertions.ENABLED && var2_2 == '\u0000') {
                    String var3_4 = "Assertion failed";
                    throw new AssertionError((Object)var3_4);
                }
                var2_2 = esc.charAt(1);
                if (var2_2 == 'u' ? true : var2_2 == 'U') {
                    String v3 = esc.substring(2, esc.length());
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"substring(...)");
                    yield String.valueOf((char)Integer.parseInt(v3, 16));
                }
                if (var2_2 == '\r' ? true : var2_2 == '\n') {
                    yield "";
                }
                throw new IllegalStateException("unreachable".toString());
            }
        };
    }

    private static final boolean parseStringCharacters(Lexer lexer, String chars, StringBuilder outChars, int[] sourceOffsets, Function1<? super String, String> decoder) {
        boolean $i$f$parseStringCharacters = false;
        int outOffset = outChars.length();
        int index = 0;
        block0: for (Pair pair : TomlEscapeUtilsKt.tokenize(chars, lexer)) {
            IElementType type = (IElementType)pair.component1();
            String text = (String)pair.component2();
            sourceOffsets[outChars.length() - outOffset] = index;
            sourceOffsets[outChars.length() - outOffset + 1] = index + 1;
            IElementType iElementType = type;
            if (Intrinsics.areEqual((Object)iElementType, (Object)StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN)) {
                outChars.append((String)decoder.invoke((Object)text));
                index += text.length();
                continue;
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN) ? true : Intrinsics.areEqual((Object)iElementType, (Object)StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN)) {
                return false;
            }
            int first = outChars.length() - outOffset;
            outChars.append(text);
            int i = first;
            int last = outChars.length() - outOffset - 1;
            if (i > last) continue;
            while (true) {
                sourceOffsets[i] = index++;
                if (i == last) continue block0;
                ++i;
            }
        }
        sourceOffsets[outChars.length() - outOffset] = index;
        return true;
    }

    private static final Sequence<Pair<IElementType, String>> tokenize(CharSequence $this$tokenize, Lexer lexer) {
        return SequencesKt.generateSequence((Function0)((Function0)new Function0<Pair<? extends IElementType, ? extends String>>(lexer, $this$tokenize){
            final /* synthetic */ Lexer $lexer;
            final /* synthetic */ CharSequence $this_tokenize;
            {
                this.$lexer = $lexer;
                this.$this_tokenize = $receiver;
                super(0);
            }

            @Nullable
            public final Pair<IElementType, String> invoke() {
                this.$lexer.start(this.$this_tokenize);
                IElementType iElementType = this.$lexer.getTokenType();
                return iElementType != null ? TuplesKt.to((Object)iElementType, (Object)this.$lexer.getTokenText()) : null;
            }
        }), (Function1)((Function1)new Function1<Pair<? extends IElementType, ? extends String>, Pair<? extends IElementType, ? extends String>>(lexer){
            final /* synthetic */ Lexer $lexer;
            {
                this.$lexer = $lexer;
                super(1);
            }

            @Nullable
            public final Pair<IElementType, String> invoke(@NotNull Pair<? extends IElementType, String> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                this.$lexer.advance();
                IElementType iElementType = this.$lexer.getTokenType();
                return iElementType != null ? TuplesKt.to((Object)iElementType, (Object)this.$lexer.getTokenText()) : null;
            }
        }));
    }
}

