/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.cidr.cpp.util;

import fleet.com.intellij.cidr.cpp.lexer.CidrRawStringLexerBase;
import fleet.com.intellij.cidr.cpp.util.CidrIntType;
import fleet.com.intellij.cidr.cpp.util.CidrStringCodec;
import fleet.com.intellij.cidr.cpp.util.CidrStringLiteral;
import fleet.com.intellij.openapi.diagnostic.Logger;
import fleet.com.intellij.openapi.util.text.StringUtil;
import fleet.com.intellij.openapi.vfs.CharsetToolkit;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrStringLiteralUtil {
    private static final Logger LOG = Logger.getInstance(CidrStringLiteralUtil.class);
    protected static final Map<String, CidrStringPrefix> STR_PREFIX_TYPE = new HashMap<String, CidrStringPrefix>(CidrStringPrefix.values().length, 1.0f);
    protected static final Map<String, CidrCharType> CHAR_PREFIX_TYPE = new HashMap<String, CidrCharType>(4, 1.0f);

    public static boolean isStringLiteralPrefix(@NotNull String prefix) {
        return STR_PREFIX_TYPE.containsKey(prefix);
    }

    @SafeVarargs
    @NotNull
    public static <T extends CidrStringLiteral> T concatStrings(CidrStringCodec<T> stringCodec, T ... stringLiterals) {
        CidrStringPrefix resultPrefix = CidrStringPrefix.PREFIX_EMPTY;
        StringBuilder resultContentsBuilder = new StringBuilder();
        for (T stringLiteral : stringLiterals) {
            String newContents;
            CidrStringPrefix newPrefix;
            if (resultPrefix.encoding == ((CidrStringLiteral)stringLiteral).prefix.encoding || resultPrefix.encoding == CidrEncoding.NONE || ((CidrStringLiteral)stringLiteral).prefix.encoding == CidrEncoding.NONE) {
                CidrStringPrefix cidrStringPrefix = newPrefix = resultPrefix.encoding != CidrEncoding.NONE ? resultPrefix : ((CidrStringLiteral)stringLiteral).prefix;
                if (resultPrefix.isRaw || ((CidrStringLiteral)stringLiteral).prefix.isRaw) {
                    newPrefix = CidrStringPrefix.setRaw(newPrefix, true);
                }
                if (resultPrefix.isRaw != newPrefix.isRaw) {
                    String resultContents = resultContentsBuilder.toString();
                    resultContentsBuilder = new StringBuilder(newPrefix.isRaw ? StringUtil.unescapeStringCharacters((String)resultContents) : StringUtil.escapeStringCharacters((String)resultContents));
                }
                newContents = ((CidrStringLiteral)stringLiteral).getContents(!newPrefix.isRaw);
            } else {
                newPrefix = CidrStringPrefix.setRaw(resultPrefix, false);
                String stringLiteralContents = newPrefix.encoding.getString(((CidrStringLiteral)stringLiteral).prefix.encoding.getBytes(((CidrStringLiteral)stringLiteral).getContents(false)));
                if (resultPrefix.isRaw != newPrefix.isRaw) {
                    resultContentsBuilder = new StringBuilder(StringUtil.escapeStringCharacters((String)resultContentsBuilder.toString()));
                }
                newContents = StringUtil.escapeStringCharacters((String)stringLiteralContents);
            }
            resultContentsBuilder.append(newContents);
            resultPrefix = newPrefix;
        }
        return stringCodec.createStringLiteral(resultPrefix, resultContentsBuilder.toString());
    }

    @NotNull
    public static <T extends CidrStringLiteral> T parseStringLiteral(@NotNull CidrStringCodec<T> stringCodec, @Nullable String literalText) {
        String contents;
        if (literalText == null) {
            return stringCodec.getBadLiteral();
        }
        int length = literalText.length();
        if (length == 0) {
            return stringCodec.getBadLiteral();
        }
        int quoteChar = 34;
        int firstQuotePos = literalText.indexOf(34);
        if (firstQuotePos == -1) {
            LOG.warn("String literal without quote (lexer problem?)");
            return stringCodec.getBadLiteral();
        }
        String prefixString = literalText.substring(0, firstQuotePos);
        CidrStringPrefix prefix = STR_PREFIX_TYPE.get(prefixString);
        if (prefix == null) {
            return stringCodec.getBadLiteral();
        }
        if (firstQuotePos == length - 1) {
            contents = "";
        } else {
            contents = literalText.substring(firstQuotePos + 1);
            if (prefix.isRaw) {
                CidrRawStringLexerBase lexer = stringCodec.createRawStringLexer();
                lexer.start(literalText, firstQuotePos, length);
                contents = lexer.getRawText();
            } else if (literalText.charAt(length - 1) == '\"') {
                contents = contents.substring(0, contents.length() - 1);
            }
        }
        return stringCodec.createStringLiteral(prefix, contents);
    }

    static {
        for (CidrStringPrefix prefix : CidrStringPrefix.values()) {
            STR_PREFIX_TYPE.put(prefix.prefix, prefix);
        }
        CHAR_PREFIX_TYPE.put("", CidrCharType.CHAR_LITERAL);
        CHAR_PREFIX_TYPE.put("L", CidrCharType.WCHAR_LITERAL);
        CHAR_PREFIX_TYPE.put("u", CidrCharType.CHAR16_LITERAL);
        CHAR_PREFIX_TYPE.put("U", CidrCharType.CHAR32_LITERAL);
    }

    public static enum CidrStringPrefix {
        PREFIX_EMPTY("", false, CidrEncoding.NONE, CidrIntType.CHAR, CidrIntType.CHAR_CONST),
        PREFIX_R("R", true, CidrEncoding.NONE, CidrIntType.CHAR, CidrIntType.CHAR_CONST),
        PREFIX_L("L", false, CidrEncoding.WCHAR, CidrIntType.WCHAR, CidrIntType.WCHAR_CONST),
        PREFIX_LR("LR", true, CidrEncoding.WCHAR, CidrIntType.WCHAR, CidrIntType.WCHAR_CONST),
        PREFIX_u8("u8", false, CidrEncoding.UTF8, CidrIntType.CHAR, CidrIntType.CHAR_CONST),
        PREFIX_u8R("u8R", true, CidrEncoding.UTF8, CidrIntType.CHAR, CidrIntType.CHAR_CONST),
        PREFIX_u("u", false, CidrEncoding.UTF16, CidrIntType.CHAR16, CidrIntType.CHAR16_CONST),
        PREFIX_uR("uR", true, CidrEncoding.UTF16, CidrIntType.CHAR16, CidrIntType.CHAR16_CONST),
        PREFIX_U("U", false, CidrEncoding.UTF32, CidrIntType.CHAR32, CidrIntType.CHAR32_CONST),
        PREFIX_UR("UR", true, CidrEncoding.UTF32, CidrIntType.CHAR32, CidrIntType.CHAR32_CONST);

        @NotNull
        public final String prefix;
        public final boolean isRaw;
        @NotNull
        public final CidrEncoding encoding;
        @NotNull
        public final CidrIntType charTypePlainC;
        @NotNull
        public final CidrIntType charTypeCpp;

        private CidrStringPrefix(@NotNull String prefix, @NotNull boolean isRaw, @NotNull CidrEncoding encoding, CidrIntType charTypePlainC, CidrIntType charTypeCpp) {
            this.prefix = prefix;
            this.isRaw = isRaw;
            this.encoding = encoding;
            this.charTypePlainC = charTypePlainC;
            this.charTypeCpp = charTypeCpp;
        }

        public static CidrStringPrefix setRaw(CidrStringPrefix prefix, boolean raw) {
            if (raw) {
                return switch (prefix) {
                    case PREFIX_EMPTY -> PREFIX_R;
                    case PREFIX_L -> PREFIX_LR;
                    case PREFIX_u8 -> PREFIX_u8R;
                    case PREFIX_u -> PREFIX_uR;
                    case PREFIX_U -> PREFIX_UR;
                    default -> prefix;
                };
            }
            return switch (prefix) {
                case PREFIX_R -> PREFIX_EMPTY;
                case PREFIX_LR -> PREFIX_L;
                case PREFIX_u8R -> PREFIX_u8;
                case PREFIX_uR -> PREFIX_u;
                case PREFIX_UR -> PREFIX_U;
                default -> prefix;
            };
        }
    }

    public static enum CidrEncoding {
        NONE(StandardCharsets.US_ASCII),
        WCHAR(StandardCharsets.UTF_16LE),
        UTF8(StandardCharsets.UTF_8),
        UTF16(StandardCharsets.UTF_16LE),
        UTF32(CharsetToolkit.UTF_32LE_CHARSET);

        @NotNull
        private final Charset charset;

        private CidrEncoding(Charset charset) {
            this.charset = charset;
        }

        @Contract(pure=true)
        public byte @NotNull [] getBytes(@NotNull String contents) {
            return contents.getBytes(this.charset);
        }

        @NotNull
        public String getString(byte[] bytes) {
            return this.charset.decode(ByteBuffer.wrap(bytes)).toString();
        }
    }

    public static enum CidrCharType {
        CHAR_LITERAL(CidrIntType.INT, CidrIntType.CHAR),
        MULTICHAR_LITERAL(CidrIntType.INT),
        WCHAR_LITERAL(CidrIntType.WCHAR),
        CHAR16_LITERAL(CidrIntType.CHAR16),
        CHAR32_LITERAL(CidrIntType.CHAR32);

        @NotNull
        public final CidrIntType typePlainC;
        @NotNull
        public final CidrIntType typeCpp;

        private CidrCharType(CidrIntType type) {
            this(type, type);
        }

        private CidrCharType(CidrIntType typePlainC, CidrIntType typeCpp) {
            this.typePlainC = typePlainC;
            this.typeCpp = typeCpp;
        }
    }
}

